/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.AbstractAutoTransFilterUI;
import com.kingdee.eas.fm.fs.client.AutoTransFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoTransFilterUI
extends AbstractAutoTransFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoTransFilterUI.class);
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    public boolean isAutoTransDown;
    public static final String srcPath = "com.kingdee.eas.fm.fs.TransBillResource";

    public AutoTransFilterUI() throws Exception {
    }

    public AutoTransFilterUI(boolean isAutoTransDown) throws Exception {
        this();
        this.isAutoTransDown = isAutoTransDown;
        if (!isAutoTransDown) {
            String title = this.getUITitle();
            title = title.replaceAll(EASResource.getString((String)srcPath, (String)"autoTransDown"), EASResource.getString((String)srcPath, (String)"autoTransUp"));
            this.setUITitle(title);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public Object getParam() {
        AutoTransFilterParam param = new AutoTransFilterParam();
        String[] companyIds = this.getCompanyIds();
        param.setCompanyIds(companyIds);
        param.setParentAcctIds(AccessHelper.getF7Ids((KDBizPromptBox)this.promtParentAcct));
        return param;
    }

    public void setParam(Object param) {
        AutoTransFilterParam aparam = (AutoTransFilterParam)((Object)param);
        String[] companyIds = aparam.getCompanyIds();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            try {
                if (aparam.getCompanyIds() != null) {
                    AccountBankCollection coll = null;
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                    ev.setFilter(filter);
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.promtParentAcct.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        } else {
            try {
                if (aparam.getCompanyIds() != null) {
                    Set set = FMHelper.asSet((String[])aparam.getCompanyIds());
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                    ev.setFilter(filter);
                    AccountBankCollection coll = null;
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.promtParentAcct.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
    }

    protected void init() throws Exception {
        super.init();
        this.initF7BankAccount();
    }

    private void initF7BankAccount() {
        this.promtParentAcct.setData(null);
        boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam("BE003", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        FilterInfo filterInfo = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId) && (val || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany))) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.promtParentAcct.setDisplayFormat("$number$ $name$");
        this.promtParentAcct.setCommitFormat("$number$");
        this.promtParentAcct.setEditFormat("$number$");
        this.promtParentAcct.setEnabledMultiSelection(true);
        this.promtParentAcct.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.promtParentAcct.setEntityViewInfo(evi);
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
        this.initF7BankAccount();
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"NoCompany"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected Class getParamClass() {
        return AutoTransFilterParam.class;
    }
}

