/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fs.AvgTypeEnum;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.client.AbstractAvgAnalysisHandler;
import com.kingdee.eas.fm.fs.client.AvgAnalysisFilterParam;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import java.sql.SQLException;

public class AvgAnalysisByPeriodHandler
extends AbstractAvgAnalysisHandler {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.AvgAnalysisResource";

    @Override
    public void fillData(AvgAnalysisFilterParam param, Object condition, KDTable tblMain, EntityViewInfo mainQuery) throws EASBizException, BOSException, SQLException {
        CurrencyInfo currency;
        CycleRangeInfo info = (CycleRangeInfo)condition;
        IInAcct inacct = InAcctFactory.getRemoteInstance();
        CompanyOrgUnitCollection companyCol = null;
        String[] companyIds = param.getCompanyIds();
        companyCol = FMClientHelper.getCompanyOrgUnitCollection((String[])companyIds);
        int companyColSize = companyCol.size();
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyCollection = new CurrencyCollection();
        if (param.getCurrencyId() != null) {
            currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrencyId()));
            currencyCollection.add(currency);
        } else {
            currencyCollection = iCurrency.getCurrencyCollection(true);
        }
        int currencyColSize = currencyCollection.size();
        PeriodInfo periodInfo = null;
        for (int j = 0; j < currencyColSize; ++j) {
            currency = currencyCollection.get(j);
            for (int i = 0; i < companyColSize; ++i) {
                CompanyOrgUnitInfo company = companyCol.get(i);
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company) || (periodInfo = SystemStatusCtrolFactory.getRemoteInstance().getStartPeriod(SystemEnum.CASHMANAGEMENT.getValue(), company.getId().toString())) == null) continue;
                this.fillEnumData(param, company, inacct, info, tblMain, currency, "company");
            }
        }
        this.setTotal(tblMain, param.getCurrencyId());
    }

    @Override
    public void initTable(AvgAnalysisFilterParam param, KDTable tblMain) throws BOSException {
        tblMain.checkParsed();
        FMClientHelper.clearTable((KDTable)tblMain);
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("company");
        headRow.getCell("company").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Company"));
        tblMain.addColumn().setKey("currency");
        headRow.getCell("currency").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Currency"));
        tblMain.addColumn().setKey(AvgTypeEnum.CASH.getName());
        headRow.getCell(AvgTypeEnum.CASH.getName()).setValue((Object)AvgTypeEnum.CASH.getAlias());
        tblMain.addColumn().setKey(AvgTypeEnum.DEPOSIT.getName());
        headRow.getCell(AvgTypeEnum.DEPOSIT.getName()).setValue((Object)AvgTypeEnum.DEPOSIT.getAlias());
    }

    @Override
    public void initTree(AvgAnalysisFilterParam param, KDTree treeList) throws BOSException {
        CycleTypeEnum cycleType;
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        if (param.getAvgRptType() == 0) {
            cycleType = CycleTypeEnum.MONTH;
        } else if (param.getAvgRptType() == 1) {
            cycleType = CycleTypeEnum.QUARTER;
            beginMonth *= 3;
            endMonth *= 3;
        } else {
            cycleType = CycleTypeEnum.YEAR;
        }
        FSClientHelper.fillPeriodTree(treeList, cycleType, beginYear, beginMonth, endYear, endMonth);
    }

    private void setTotal(KDTable tblMain, String currencyId) {
        for (int i = 0; i < tblMain.getColumnCount(); ++i) {
            tblMain.getColumn(i).setMergeable(false);
        }
        tblMain.getColumn("currency").setGroup(true);
        tblMain.getColumn("currency").setStat(true);
        tblMain.getGroupManager().setOrientation(1);
        IRow row0 = tblMain.getGroupManager().getStatRowTemplate(-1);
        row0.getStyleAttributes().setHided(true);
        IRow row1 = tblMain.getGroupManager().getStatRowTemplate(0);
        row1.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row1.getCell(0).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
        String numberFtm = currencyId == null ? "%r-[ ]{###,###,##0.00}15.2n" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        for (int i = 2; i < tblMain.getColumnCount(); ++i) {
            row1.getCell(i).setExpressions("SUM");
            row1.getCell(i).getStyleAttributes().setNumberFormat(numberFtm);
            row1.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        tblMain.getGroupManager().group();
    }
}

