/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InacctTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.client.CompanyReconcileFilterParam;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.ReconcileHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CompanyReconcileHandler
implements IRptHandler {
    private static Logger logger = Logger.getLogger(ReconcileHandler.class);
    private Vector innerAccountVec = null;
    private String resourcePath = "com.kingdee.eas.fm.fs.client.ReconcileResource";

    protected Date adjustDate(String cur, Date date) {
        try {
            Date openDate;
            BankInfo bank = BankFactory.getRemoteInstance().getClearingHouse(cur);
            if (bank == null) {
                MsgBox.showError((String)EASResource.getString((String)this.resourcePath, (String)"NoClearingHouse"));
                SysUtil.abort();
            }
            if (date.before(openDate = bank.getOpenDate())) {
                return openDate;
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return date;
    }

    public void fillData(CompanyReconcileFilterParam param, InnerAccountCollection condition, KDTable tblMain) throws EASBizException, BOSException {
        this.fillInnerAcctColumn2(tblMain, condition, param);
        this.fillGeneralLedgerColumn2(tblMain, condition, param);
        this.fillDifferenceColumn(tblMain, param);
    }

    public void fillDifferenceColumn(KDTable tblMain, CompanyReconcileFilterParam param) throws BOSException {
        BigDecimal tempAmount = null;
        BigDecimal generalLedger = null;
        for (int i = 0; i < 4; ++i) {
            BigDecimal difference = Constants.ZERO;
            for (int j = 1; j < tblMain.getColumnCount() - 2; ++j) {
                tempAmount = (BigDecimal)tblMain.getRow(i).getCell(j).getValue();
                if (tempAmount == null) {
                    tempAmount = Constants.ZERO;
                }
                difference = difference.add(tempAmount);
            }
            generalLedger = (BigDecimal)tblMain.getRow(i).getCell(tblMain.getColumnCount() - 2).getValue();
            if (generalLedger == null) {
                generalLedger = Constants.ZERO;
            }
            difference = difference.subtract(generalLedger);
            tblMain.getRow(i).getCell("Difference").setValue((Object)difference);
        }
    }

    public void fillGeneralLedgerColumn2(KDTable tblMain, InnerAccountCollection innerAcctCol, CompanyReconcileFilterParam param) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyInfo currencyInfo = null;
        currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)param.getCurrencyId())));
        if (logger.isDebugEnabled()) {
            for (int i = 0; i < innerAcctCol.size(); ++i) {
                logger.debug((Object)("innerCol: " + i + " " + innerAcctCol.get(i).getId()));
            }
        }
        ObjectUuidPK companyPk = new ObjectUuidPK(innerAcctCol.get(0).getApplyUnit().getId());
        String companyNumber = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)companyPk).getNumber();
        HashMap<BOSUuid, String> acctNumbeMap = new HashMap<BOSUuid, String>();
        HashMap<String, BalanceDirectionEnum> acctTypeMap = new HashMap<String, BalanceDirectionEnum>();
        for (int i = 0; i < innerAcctCol.size(); ++i) {
            InnerAccountInfo innerAcctInfo2 = innerAcctCol.get(i);
            String inerAcctId = innerAcctInfo2.getId().toString();
            AccountBankInfo bankAcct = CompanyReconcileHandler.getBankAccountByInnerAccount(inerAcctId);
            AccountViewInfo acctInfo = CompanyReconcileHandler.getAccountByAccountBanks(bankAcct);
            if (acctInfo != null) {
                String value = (String)acctNumbeMap.get(acctInfo.getId());
                value = value == null ? bankAcct.getNumber() : value + "," + bankAcct.getNumber();
                acctNumbeMap.put(acctInfo.getId(), value);
                continue;
            }
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"357_AcceptBatchUI"), bankAcct.getNumber());
            MsgBox.showError((String)msgStr);
            SysUtil.abort();
        }
        ArrayList<String> accountNumberlist = new ArrayList<String>();
        boolean idex = false;
        for (Map.Entry en : acctNumbeMap.entrySet()) {
            BOSUuid accid = (BOSUuid)en.getKey();
            String numbser = (String)en.getValue();
            AsstActTypeInfo info = new AsstActTypeInfo();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("asstHGAttribute", (Object)"bankAccount", CompareType.EQUALS));
            evi.setFilter(filterInfo);
            IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
            AsstActTypeCollection con = asstActType.getAsstActTypeCollection(evi);
            if (con != null && con.size() > 0) {
                info = con.get(0);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("accountTypeID.id");
            sic.add("accountTypeID.property");
            AccountViewInfo ac = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accid), sic);
            String number = ac.getNumber();
            if (FMHelper.hasAsstAccBank((SysContext)SysContext.getSysContext(), (String)ac.getId().toString())) {
                String[] ns = numbser.split(",");
                for (int j = 0; j < ns.length; ++j) {
                    number = ac.getNumber() + "|" + info.getNumber() + "|" + ns[j];
                    accountNumberlist.add(number);
                }
            } else {
                accountNumberlist.add(number);
            }
            if (ac == null || ac.getAccountTypeID() == null || ac.getAccountTypeID().getProperty() == null) continue;
            acctTypeMap.put(number, ac.getDC());
        }
        String[] accountNumber = accountNumberlist.toArray(new String[accountNumberlist.size()]);
        FPFormulaCollection paramColl = null;
        paramColl = param.isByPeriod() ? this.buildByPeriodFormualColl(param, currencyInfo, companyNumber, accountNumber) : this.buildByDateFormualColl(param, currencyInfo, companyNumber, accountNumber);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("account: " + accountNumber));
            logger.debug((Object)("beginYear: " + param.getBeginYear()));
            logger.debug((Object)("beginMonth: " + param.getBeginMonth()));
            logger.debug((Object)("endYear: " + param.getEndYear()));
            logger.debug((Object)("EndMonth: " + param.getEndMonth()));
        }
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        logger.info((Object)"ReconcileHandler.fillGeneralLedgerColumn2()begin");
        FPFormulaCollection resultcoll = iSummaryLedger.exec(InacctTypeEnum.MACCT_REPORT, paramColl);
        logger.info((Object)"ReconcileHandler.fillGeneralLedgerColumn2()end ");
        int colSize = resultcoll.size();
        for (int i = 0; i < colSize && i < tblMain.getRowCount(); ++i) {
            FPFormulaInfo paramCinfo = resultcoll.get(i);
            String accountkey = ((String[])paramCinfo.getParams()[2])[0];
            if (i == 1 && ((BalanceDirectionEnum)acctTypeMap.get(accountkey)).equals((Object)BalanceDirectionEnum.CREDIT)) {
                BigDecimal debitAmt = resultcoll.get(1).getResult();
                resultcoll.get(1).setResult(resultcoll.get(2).getResult());
                resultcoll.get(2).setResult(debitAmt);
            }
            tblMain.getRow(i).getCell("GeneralLedger").setValue((Object)paramCinfo.getResult());
        }
        BigDecimal yValue = resultcoll.get(0).getResult().add(resultcoll.get(1).getResult()).subtract(resultcoll.get(2).getResult());
        tblMain.getRow(3).getCell("GeneralLedger").setValue((Object)yValue);
    }

    private FPFormulaCollection buildByPeriodFormualColl(CompanyReconcileFilterParam param, CurrencyInfo currencyInfo, String companyNumber, String[] accountNumber) {
        FPFormulaCollection paramColl = new FPFormulaCollection();
        if (!param.isByPeriod()) {
            return paramColl;
        }
        FPFormulaInfo paramCinfo = new FPFormulaInfo();
        paramCinfo.setParams(new Object[]{param.isByPeriod(), companyNumber, accountNumber, BalanceTypeEnum.AC, new Integer(param.getBeginYear()), new Integer(param.getBeginMonth()), new Integer(param.getEndYear()), new Integer(param.getEndMonth()), currencyInfo.getNumber(), param.isIncludeUnPostVoucher()});
        paramColl.add(paramCinfo);
        FPFormulaInfo paramDFinfo = new FPFormulaInfo();
        paramDFinfo.setParams(new Object[]{param.isByPeriod(), companyNumber, accountNumber, BalanceTypeEnum.JF, new Integer(param.getBeginYear()), new Integer(param.getBeginMonth()), new Integer(param.getEndYear()), new Integer(param.getEndMonth()), currencyInfo.getNumber(), param.isIncludeUnPostVoucher()});
        paramColl.add(paramDFinfo);
        FPFormulaInfo paramJFinfo = new FPFormulaInfo();
        paramJFinfo.setParams(new Object[]{param.isByPeriod(), companyNumber, accountNumber, BalanceTypeEnum.DF, new Integer(param.getBeginYear()), new Integer(param.getBeginMonth()), new Integer(param.getEndYear()), new Integer(param.getEndMonth()), currencyInfo.getNumber(), param.isIncludeUnPostVoucher()});
        paramColl.add(paramJFinfo);
        return paramColl;
    }

    private FPFormulaCollection buildByDateFormualColl(CompanyReconcileFilterParam param, CurrencyInfo currencyInfo, String companyNumber, String[] accountNumber) {
        FPFormulaCollection paramColl = new FPFormulaCollection();
        if (param.isByPeriod()) {
            return paramColl;
        }
        FPFormulaInfo paramCinfo = new FPFormulaInfo();
        paramCinfo.setParams(new Object[]{param.isByPeriod(), companyNumber, accountNumber, VoucherGetTypeEnum.C, param.getBeginDate(), param.getEndDate(), currencyInfo.getNumber(), param.isIncludeUnPostVoucher()});
        paramColl.add(paramCinfo);
        FPFormulaInfo paramDFinfo = new FPFormulaInfo();
        paramDFinfo.setParams(new Object[]{param.isByPeriod(), companyNumber, accountNumber, VoucherGetTypeEnum.JF, param.getBeginDate(), param.getEndDate(), currencyInfo.getNumber(), param.isIncludeUnPostVoucher()});
        paramColl.add(paramDFinfo);
        FPFormulaInfo paramJFinfo = new FPFormulaInfo();
        paramJFinfo.setParams(new Object[]{param.isByPeriod(), companyNumber, accountNumber, VoucherGetTypeEnum.DF, param.getBeginDate(), param.getEndDate(), currencyInfo.getNumber(), param.isIncludeUnPostVoucher()});
        paramColl.add(paramJFinfo);
        return paramColl;
    }

    public static AccountViewInfo getAccountByAccountBanks(AccountBankInfo bankAcct) throws BOSException {
        if (bankAcct == null) {
            return null;
        }
        if (FMHelper.isEmpty((CoreBaseInfo)bankAcct.getAccount()) || !FMHelper.isEmpty((Object)bankAcct.getId())) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("account.*");
                bankAcct = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankAcct.getId()), sic);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return bankAcct.getAccount();
    }

    public static AccountBankInfo getBankAccountByInnerAccount(String inerAcctId) throws BOSException {
        EntityViewInfo ev2 = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("inneracct.id", (Object)inerAcctId));
        filter2.getFilterItems().add(new FilterItemInfo("bank.inGroup", (Object)new Boolean(true)));
        ev2.setFilter(filter2);
        AccountBankCollection accountBankColl = AccountBankFactory.getRemoteInstance().getAccountBankCollection(ev2);
        if (accountBankColl == null || accountBankColl.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"87_CompanyReconcileHandler"));
            SysUtil.abort();
        }
        AccountBankInfo bankAcct = accountBankColl.get(0);
        return bankAcct;
    }

    public void fillInnerAcctColumn2(KDTable tblMain, InnerAccountCollection inerAcctColl, CompanyReconcileFilterParam param) throws EASBizException, BOSException {
        Date beginDate = null;
        Date endDate = null;
        if (param.isByPeriod()) {
            GregorianCalendar from = new GregorianCalendar(param.getBeginYear(), param.getBeginMonth() - 1, 1);
            GregorianCalendar to = new GregorianCalendar(param.getEndYear(), param.getEndMonth(), 0, 23, 59, 59);
            beginDate = from.getTime();
            endDate = to.getTime();
        } else {
            beginDate = param.getBeginDate();
            endDate = param.getEndDate();
        }
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyInfo currencyInfo = null;
        currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)param.getCurrencyId())));
        BigDecimal beginBalanceSelf = Constants.ZERO;
        BigDecimal endBalance = Constants.ZERO;
        BigDecimal debitTotalSelf = Constants.ZERO;
        BigDecimal creditTotalSelf = Constants.ZERO;
        FPFormulaCollection paramColl = new FPFormulaCollection();
        FPFormulaInfo info = null;
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(inerAcctColl.get(0).getCompany().getId());
        String chCompanyNumber = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk).getNumber();
        String innerAccountNumber = inerAcctColl.get(0).getNumber();
        CompanyOrgUnitInfo cl = inerAcctColl.get(0).getCompany();
        String clNumber = cl.getNumber();
        String clId = cl.getId().toString();
        for (int i = 1; i < inerAcctColl.size(); ++i) {
            innerAccountNumber = innerAccountNumber + "," + inerAcctColl.get(i).getNumber();
        }
        info = new FPFormulaInfo();
        info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyInfo.getNumber(), this.adjustDate(clId, beginDate), endDate, InAcctDataTypeEnum.C});
        paramColl.add(info);
        info = new FPFormulaInfo();
        info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyInfo.getNumber(), this.adjustDate(clId, beginDate), endDate, InAcctDataTypeEnum.JF});
        paramColl.add(info);
        info = new FPFormulaInfo();
        info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyInfo.getNumber(), this.adjustDate(clId, beginDate), endDate, InAcctDataTypeEnum.DF});
        paramColl.add(info);
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        FPFormulaCollection resultcoll = iSummaryLedger.exec(InacctTypeEnum.INACCTExt, paramColl);
        beginBalanceSelf = resultcoll.get(0).getResult();
        tblMain.getRow(0).getCell(1).setValue((Object)beginBalanceSelf);
        debitTotalSelf = resultcoll.get(1).getResult();
        tblMain.getRow(1).getCell(1).setValue((Object)debitTotalSelf);
        creditTotalSelf = resultcoll.get(2).getResult();
        tblMain.getRow(2).getCell(1).setValue((Object)creditTotalSelf);
        endBalance = beginBalanceSelf.add(debitTotalSelf).subtract(creditTotalSelf);
        tblMain.getRow(3).getCell(1).setValue((Object)endBalance);
    }

    public void initTable(KDTable tblMain) throws BOSException, EASBizException {
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("Project");
        tblMain.getColumn("Project").setWidth(150);
        headRow.getCell("Project").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Project"));
        tblMain.addColumn().setKey("CapitalType");
        tblMain.getColumn("CapitalType").setWidth(150);
        headRow.getCell("CapitalType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"CapitalType2"));
        tblMain.addColumn().setKey("GeneralLedger");
        tblMain.getColumn("GeneralLedger").setWidth(150);
        headRow.getCell("GeneralLedger").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"GeneralLedger"));
        tblMain.addColumn().setKey("Difference");
        tblMain.getColumn("Difference").setWidth(150);
        headRow.getCell("Difference").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Difference"));
        tblMain.addRow().getCell("Project").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"BeginBalance"));
        tblMain.addRow().getCell("Project").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"DebitTotal"));
        tblMain.addRow().getCell("Project").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"CreditTotal"));
        tblMain.addRow().getCell("Project").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"EndBalance"));
    }

    public void initTree(CompanyReconcileFilterParam param, KDTree treeList) throws BOSException {
        String[] companyIds = param.getCompanyIds();
        FSClientHelper.fillCHBankAccount(treeList, companyIds[0], true);
    }

    public void setColumnFormat(KDTable tblMain, CompanyReconcileFilterParam param) {
        String strFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        for (int i = 1; i < tblMain.getColumnCount(); ++i) {
            tblMain.getColumn(i).getStyleAttributes().setNumberFormat(strFormat);
            tblMain.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

