/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.DepositContrastFilterParam;
import com.kingdee.eas.fm.fs.DepositContrastHelperFacadeFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;

public class DepositContrastHandler {
    private static final String COLUMN_COMPANY_NUMBER = "company.number";
    private static final String COLUMN_COMPANY_NAME = "company.name";
    private static final String COLUMN_INNERACCOUNT_NUMBER = "innerAccount.number";
    private static final String COLUMN_INNERACCOUNT_NAME = "innerAccount.name";
    private static final String COLUMN_CURRENT_DEPOSIT = "currentDeposit";
    private static final String COLUMN_FIXED_DEPOSIT = "fixedDeposit";
    private static final String COLUMN_SUM_DEPOSIT = "sumDeposit";
    private static final String COLUMN_COMPARE_TO_YESTERDAY = "compareToYesterday";
    private static final String COLUMN_COMPARE_TO_ULTIMO = "compareToUltimo";
    private static final String COLUMN_COMPARE_TO_LASTYEAR = "compareToLastYear";
    private static final int ROW_DATA_TYPE_ROW = 0;
    private static final int ROW_DATA_TYPE_TOTAL = 1;
    public static final String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    DecimalFormat df = new DecimalFormat("###0.##########");

    public void fillData(KDTable tblMain, FilterParam param) throws BOSException, EASBizException {
        if (tblMain == null || param == null) {
            return;
        }
        tblMain.getStyleAttributes().setLocked(true);
        tblMain.removeRows();
        DepositContrastFilterParam para = (DepositContrastFilterParam)param;
        IRow row = null;
        IRowSet rs = DepositContrastHelperFacadeFactory.getRemoteInstance().getSQLResult(param);
        try {
            while (rs.next()) {
                row = tblMain.addRow();
                this.setCellValue(rs, row, 0);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (para.isOrderByCompany()) {
            // empty if block
        }
    }

    public void fillCompanyTotalRow(KDTable tblMain, FilterParam param) throws BOSException, EASBizException {
    }

    private void setCellValue(IRowSet rs, IRow row, int type) throws SQLException {
        if (rs == null || row == null) {
            return;
        }
        if (type == 0) {
            row.getCell(COLUMN_COMPANY_NAME).setValue((Object)rs.getString("COMPANYNAME"));
            row.getCell(COLUMN_INNERACCOUNT_NUMBER).setValue((Object)rs.getString("INNCTNUMBER"));
            row.getCell(COLUMN_INNERACCOUNT_NAME).setValue((Object)rs.getString("INNCTNAME"));
            row.getCell(COLUMN_CURRENT_DEPOSIT).setValue((Object)rs.getBigDecimal("FCURRENTDEPOSIT"));
            row.getCell(COLUMN_FIXED_DEPOSIT).setValue((Object)rs.getBigDecimal("FFIXEDDEPOSIT"));
            row.getCell(COLUMN_SUM_DEPOSIT).setValue((Object)rs.getBigDecimal("SUMDEPOSIT"));
            row.getCell(COLUMN_COMPARE_TO_YESTERDAY).setValue((Object)rs.getBigDecimal(COLUMN_COMPARE_TO_YESTERDAY));
            row.getCell(COLUMN_COMPARE_TO_ULTIMO).setValue((Object)rs.getBigDecimal(COLUMN_COMPARE_TO_ULTIMO));
            row.getCell(COLUMN_COMPARE_TO_LASTYEAR).setValue((Object)rs.getBigDecimal(COLUMN_COMPARE_TO_LASTYEAR));
        } else if (type == 1) {
            row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
            row.getCell(COLUMN_COMPANY_NAME).setValue((Object)rs.getString("COMPANYNAME"));
            row.getCell(COLUMN_INNERACCOUNT_NUMBER).setValue((Object)EASResource.getString((String)resourcePath, (String)"Total"));
            row.getCell(COLUMN_CURRENT_DEPOSIT).setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("FCURRENTDEPOSIT") != null ? rs.getBigDecimal("FCURRENTDEPOSIT") : Constants.ZERO)));
            row.getCell(COLUMN_FIXED_DEPOSIT).setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("FFIXEDDEPOSIT") != null ? rs.getBigDecimal("FFIXEDDEPOSIT") : Constants.ZERO)));
            row.getCell(COLUMN_SUM_DEPOSIT).setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("SUMDEPOSIT") != null ? rs.getBigDecimal("SUMDEPOSIT") : Constants.ZERO)));
            row.getCell(COLUMN_COMPARE_TO_YESTERDAY).setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal(COLUMN_COMPARE_TO_YESTERDAY) != null ? rs.getBigDecimal(COLUMN_COMPARE_TO_YESTERDAY) : Constants.ZERO)));
            row.getCell(COLUMN_COMPARE_TO_ULTIMO).setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal(COLUMN_COMPARE_TO_ULTIMO) != null ? rs.getBigDecimal(COLUMN_COMPARE_TO_ULTIMO) : Constants.ZERO)));
            row.getCell(COLUMN_COMPARE_TO_LASTYEAR).setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal(COLUMN_COMPARE_TO_LASTYEAR) != null ? rs.getBigDecimal(COLUMN_COMPARE_TO_LASTYEAR) : Constants.ZERO)));
        }
    }

    public void initTalbe(KDTable table) {
        int i;
        String subTotalTxt = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"subTotal");
        String totalTxt = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"total");
        table.getSelectManager().setSelectMode(2);
        table.getDataRequestManager().setDataRequestMode(0);
        for (int i2 = 0; i2 < 3; ++i2) {
            table.getColumn(i2).setGroup(true);
            table.getColumn(i2).setMergeable(true);
        }
        table.getGroupManager().setTotalize(true);
        table.getColumn(0).setStat(true);
        IRow row0 = table.getGroupManager().getStatRowTemplate(-1);
        row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row0.getCell(0).setValue((Object)totalTxt);
        for (i = 3; i < table.getColumns().size(); ++i) {
            row0.getCell(i).setExpressions("SUM");
            row0.getCell(i).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)4));
            row0.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        IRow row1 = table.getGroupManager().getStatRowTemplate(0);
        row1.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row1.getCell(1).setValue((Object)subTotalTxt);
        for (i = 3; i < table.getColumns().size(); ++i) {
            row1.getCell(i).setExpressions("SUM");
            row1.getCell(i).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)4));
            row1.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        table.getStyleAttributes().setLocked(true);
        table.setEditable(false);
    }
}

