/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.base.core.fm.ClientHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.CollectionUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountPropertyCollection;
import com.kingdee.eas.basedata.assistant.AccountPropertyFactory;
import com.kingdee.eas.basedata.assistant.AccountPropertyInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IKACLlassficationType;
import com.kingdee.eas.basedata.assistant.KACLlassficationTypeCollection;
import com.kingdee.eas.basedata.assistant.KACLlassficationTypeFactory;
import com.kingdee.eas.basedata.assistant.KACLlassficationTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.client.ExcelFileFilter;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fs.FSSwitchFactory;
import com.kingdee.eas.fm.fs.IFSSwitch;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementBillRpcCacheInfo;
import com.kingdee.eas.fm.fs.client.Period;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public final class FSClientHelper {
    private static final Logger logger = CoreUIObject.getLogger(FSClientHelper.class);
    private static final Color SHUT_INNERACCT_COLOR = new Color(100, 100, 255);
    public static final String INNER_ACCOUNT_OBJECT_TYPE = "7ac99937-00fb-6000-e000-0002c0a81345B999CA39";
    public static final String PARAM_SAVE_ACCEPT = "TM004";
    public static final String RES = "com.kingdee.eas.fm.common.client.FMCommonClientResource";
    public static final String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    public static final String fsResourcePath = "com.kingdee.eas.fm.fs.client.FSDailySettleResource";

    public static boolean isSaveAccept() {
        boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam(PARAM_SAVE_ACCEPT, (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
        return val;
    }

    public static boolean isCHUser() {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            return BankFactory.getRemoteInstance().isClearinghouseCompany(companyInfo.getId().toString());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    private FSClientHelper() {
    }

    public static CompanyOrgUnitInfo getClearingHouseCompany() throws BOSException, EASBizException {
        BankInfo info = FSClientHelper.getClearingHouse();
        return info.getRelatedCompany();
    }

    public static BankInfo getClearingHouse() throws EASBizException, BOSException {
        CompanyOrgUnitInfo curent = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        BankInfo clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(curent.getId().toString());
        if (clearingHouse == null) {
            MsgBox.showError((String)EASResource.getString((String)resourcePath, (String)"NoClearingHouse"));
            SysUtil.abort();
        }
        return clearingHouse;
    }

    public static boolean clearingHouseIsUsed(String companyId) throws EASBizException, BOSException {
        String cur = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        if (BankFactory.getRemoteInstance().getClearingHouse(cur) == null) {
            return false;
        }
        BankInfo clearingHouse = FSClientHelper.getClearingHouse();
        return clearingHouse != null && clearingHouse.isUsed();
    }

    public static void initClassificationF7(KDBizPromptBox f7, String orgId) {
        if (orgId != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("currencyCompany.id", (Object)orgId));
            String classificationTypeId = ClientHelper.getInnerAccountClassificationType((String)INNER_ACCOUNT_OBJECT_TYPE);
            fi.getFilterItems().add(new FilterItemInfo("typelink.id", (Object)classificationTypeId));
            ev.setFilter(fi);
            f7.setEntityViewInfo(ev);
        } else {
            F7ContextInitializationHelper.clearF7((KDBizPromptBox)f7);
        }
    }

    public static String getInnerAccountClassificationType(String objectTypeId) {
        KACLlassficationTypeInfo info;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("objectType.id", (Object)objectTypeId));
        ev.setFilter(fi);
        KACLlassficationTypeCollection coll = null;
        try {
            IKACLlassficationType iKAClassficationType = KACLlassficationTypeFactory.getRemoteInstance();
            coll = iKAClassficationType.getKACLlassficationTypeCollection(ev);
        }
        catch (BOSException e) {
            MsgBox.showError((String)EASResource.getString((String)resourcePath, (String)"GetKACLlassficationTypeFail"));
            SysUtil.abort();
        }
        KACLlassficationTypeInfo kACLlassficationTypeInfo = info = null != coll ? coll.get(0) : null;
        if (info != null) {
            return info.getId().toString();
        }
        return null;
    }

    public static boolean clearingHouseIsOpen() throws EASBizException, BOSException {
        boolean isOpen = false;
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        IFSSwitch iFSSwitch = FSSwitchFactory.getRemoteInstance();
        return isOpen;
    }

    public static int clearingHouseIsOpenInt() throws EASBizException, BOSException {
        int isOpen = 0;
        try {
            IFSSwitch iFSSwitch = FSSwitchFactory.getRemoteInstance();
            if (iFSSwitch == null) {
                isOpen = 2;
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return isOpen;
    }

    public static boolean getClearingHouseState() throws EASBizException, BOSException {
        boolean state = false;
        try {
            IFSSwitch iFSSwitch = FSSwitchFactory.getRemoteInstance();
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return state;
    }

    public static void checkClearingHouseState() throws EASBizException, BOSException {
        try {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            IFSSwitch iFSSwitch = FSSwitchFactory.getRemoteInstance();
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    public static void checkClearingHouseCompany(SettlementBillRpcCacheInfo rpcCacheInfo) throws EASBizException, BOSException {
        boolean clearinghouseCompany = true;
        if (rpcCacheInfo != null) {
            clearinghouseCompany = rpcCacheInfo.isChCompany();
        } else {
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            clearinghouseCompany = BankFactory.getRemoteInstance().isClearinghouseCompany(currentCompany.getId().toString());
        }
        if (!clearinghouseCompany) {
            MsgBox.showError((String)EASResource.getString((String)resourcePath, (String)"mustToChCompany"));
            SysUtil.abort();
        }
    }

    public static void checkClearingHouseCompany() throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!BankFactory.getRemoteInstance().isClearinghouseCompany(currentCompany.getId().toString())) {
            MsgBox.showError((String)EASResource.getString((String)resourcePath, (String)"mustToChCompany"));
            SysUtil.abort();
        }
    }

    public static void checkClearingHouseCompany(boolean isChCompany) throws EASBizException, BOSException {
        if (!isChCompany) {
            MsgBox.showError((String)EASResource.getString((String)resourcePath, (String)"mustToChCompany"));
            SysUtil.abort();
        }
    }

    public static void checkClearingHouse(Component comp) throws BOSException, EASBizException {
        BankInfo clrHouseInfo = FSClientHelper.getClearingHouse();
        if (clrHouseInfo == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)RES, (String)"ClearingHouse_Null"));
            SysUtil.abort();
        }
        if (!clrHouseInfo.isUsed()) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)RES, (String)"ClearingHouseNotStarted"));
            SysUtil.abort();
        }
    }

    public static BigDecimal getRateValue(IObjectPK exTablePK, IObjectPK sourceCurrencyPK, IObjectPK targetCurrencyPK, Date date) throws EASBizException, BOSException {
        BigDecimal rateInfo = Constants.ONE;
        if (!sourceCurrencyPK.equals((Object)targetCurrencyPK)) {
            IExchangeRate iExchangeRate = ExchangeRateFactory.getRemoteInstance();
            rateInfo = iExchangeRate.getExchangeRateConvertValue(exTablePK, sourceCurrencyPK, targetCurrencyPK, date);
        }
        return rateInfo;
    }

    public static void fillInnerAcctByCompany(KDTree tree, String[] companyIds, boolean isDisUnused) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)resourcePath, (String)"Company"));
        if (EmptyUtil.isEmpty((Object[])companyIds)) {
            return;
        }
        for (int i = 0; i < companyIds.length; ++i) {
            OrgUnitInfo company = null;
            try {
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                company = iCompany.getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyIds[i])));
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            child.setUserObject(company);
            root.add((MutableTreeNode)child);
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            entity.setFilter(filter);
            entity.getFilter().getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)company.getId()));
            if (!isDisUnused) {
                entity.getFilter().getFilterItems().add(new FilterItemInfo("closed", (Object)new Integer(0)));
            }
            entity.getSelector().add("*");
            try {
                InnerAccountCollection account = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(entity);
                Iterator it = account.iterator();
                while (it.hasNext()) {
                    InnerAccountInfo acct = (InnerAccountInfo)it.next();
                    DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode((Object)acct);
                    if (acct.isClosed()) {
                        acctNode.setTextColor(SHUT_INNERACCT_COLOR);
                        acctNode.setTextBold(true);
                    }
                    child.add((MutableTreeNode)acctNode);
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    public static void fillInnerAcctByCompany(KDTree tree, CompanyOrgUnitCollection companyCol, boolean isDisUnused, Set usageIds) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        if (companyCol == null) {
            return;
        }
        DefaultKingdeeTreeNode parent = root;
        HashMap<BOSUuid, DefaultKingdeeTreeNode> companyC = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        root.setUserObject((Object)companyCol.get(0));
        companyC.put(companyCol.get(0).getId(), root);
        for (int i = 1; i < companyCol.size(); ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            child.setUserObject((Object)company);
            companyC.put(company.getId(), child);
            CompanyOrgUnitInfo p = company.getParent();
            if (p != null && companyC.get(p.getId()) != null) {
                parent = (DefaultKingdeeTreeNode)companyC.get(p.getId());
            }
            parent.add((MutableTreeNode)child);
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            entity.setFilter(filter);
            entity.getFilter().getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)company.getId()));
            String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            entity.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)curr));
            if (!isDisUnused) {
                entity.getFilter().getFilterItems().add(new FilterItemInfo("closed", (Object)new Integer(0)));
            }
            if (usageIds != null && usageIds.size() > 0) {
                entity.getFilter().getFilterItems().add(new FilterItemInfo("type.id", (Object)usageIds, CompareType.INCLUDE));
            }
            entity.getSelector().add("*");
            entity.getSelector().add("acctView.*");
            entity.getSorter().add(new SorterItemInfo("number"));
            try {
                InnerAccountCollection account = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(entity);
                Iterator it = account.iterator();
                while (it.hasNext()) {
                    InnerAccountInfo innerAcct = (InnerAccountInfo)it.next();
                    innerAcct.setDisplayFormat("$number$ - $name$");
                    DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode((Object)innerAcct);
                    if (innerAcct.isClosed()) {
                        acctNode.setTextColor(SHUT_INNERACCT_COLOR);
                        acctNode.setTextBold(true);
                    }
                    child.add((MutableTreeNode)acctNode);
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SysUtil.abort();
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    public static void fillInnerAcctByCompanySupportCache(KDTree tree, CompanyOrgUnitCollection companyCol, boolean isDisUnused, Set usageIds) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        if (companyCol == null) {
            return;
        }
        DefaultKingdeeTreeNode parent = root;
        HashMap<BOSUuid, DefaultKingdeeTreeNode> companyC = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        root.setUserObject((Object)companyCol.get(0));
        companyC.put(companyCol.get(0).getId(), root);
        Map hmCompany2InnerAccount = new HashMap();
        try {
            hmCompany2InnerAccount = FSClientHelper.putAllInnerAccount2Cache(companyCol, isDisUnused);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            MsgBox.showWarning((String)e1.getMessage());
            SysUtil.abort();
        }
        for (int i = 1; i < companyCol.size(); ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            child.setUserObject((Object)company);
            companyC.put(company.getId(), child);
            CompanyOrgUnitInfo p = company.getParent();
            if (p != null && companyC.get(p.getId()) != null) {
                parent = (DefaultKingdeeTreeNode)companyC.get(p.getId());
            }
            parent.add((MutableTreeNode)child);
            try {
                InnerAccountCollection account = FSClientHelper.getInnerAccountColFromCache(hmCompany2InnerAccount, company, companyCol, isDisUnused, usageIds);
                Iterator it = account.iterator();
                while (it.hasNext()) {
                    InnerAccountInfo innerAcct = (InnerAccountInfo)it.next();
                    innerAcct.setDisplayFormat("$number$ - $name$");
                    DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode((Object)innerAcct);
                    if (innerAcct.isClosed()) {
                        acctNode.setTextColor(SHUT_INNERACCT_COLOR);
                        acctNode.setTextBold(true);
                    }
                    child.add((MutableTreeNode)acctNode);
                }
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SysUtil.abort();
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    private static InnerAccountCollection getInnerAccountColFromCache(Map hmCompany2InnerAccount, CompanyOrgUnitInfo singleCompany, CompanyOrgUnitCollection companyCol, boolean isDisUnused, Set usageIds) throws Exception {
        String singleCompanyIDKey = FSClientHelper.genKey(singleCompany, isDisUnused);
        if (hmCompany2InnerAccount.get(singleCompanyIDKey) == null) {
            hmCompany2InnerAccount.put(singleCompanyIDKey, FSClientHelper.getInnerAccountColBySingleCompany(singleCompany, isDisUnused));
        }
        InnerAccountCollection all = (InnerAccountCollection)((Object)hmCompany2InnerAccount.get(singleCompanyIDKey));
        if (isDisUnused) {
            all = FSClientHelper.filterTypeID(all, usageIds);
            return all;
        }
        int size = all.size();
        InnerAccountCollection returnIac = new InnerAccountCollection();
        InnerAccountInfo tmpInnerAccountInfo = null;
        for (int i = 0; i < size; ++i) {
            tmpInnerAccountInfo = all.get(i);
            if (tmpInnerAccountInfo.isClosed()) continue;
            returnIac.add(tmpInnerAccountInfo);
        }
        returnIac = FSClientHelper.filterTypeID(returnIac, usageIds);
        return returnIac;
    }

    private static InnerAccountCollection filterTypeID(InnerAccountCollection returnIac, Set usageIds) {
        InnerAccountInfo tmp = null;
        InnerAccountCollection returnCol = new InnerAccountCollection();
        if (usageIds != null && usageIds.size() > 0) {
            int size = returnIac.size();
            for (int i = 0; i < size; ++i) {
                tmp = returnIac.get(i);
                if (!FSClientHelper.isTypeNotNull(tmp) || !FSClientHelper.includeInSet(tmp, usageIds)) continue;
                returnCol.add(tmp);
            }
        } else {
            returnCol = returnIac;
        }
        return returnCol;
    }

    private static boolean includeInSet(InnerAccountInfo tmp, Set usageIds) {
        String typeid = tmp.getType().getId().toString();
        return usageIds.contains(typeid);
    }

    private static boolean isTypeNotNull(InnerAccountInfo tmp) {
        return tmp.getType() != null;
    }

    public static void fillCHBankAccount(KDTree tree, String currCompanyId, boolean isDisUnused) {
        if (EmptyUtil.isEmpty((String)currCompanyId)) {
            return;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"96_FSClientHelper"));
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entity.setFilter(filter);
        entity.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompanyId));
        entity.getFilter().getFilterItems().add(new FilterItemInfo("bank.inGroup", (Object)Constants.TRUE));
        entity.getFilter().getFilterItems().add(new FilterItemInfo("InnerAcct.id", null, CompareType.NOTEQUALS));
        entity.getSorter().add(new SorterItemInfo("number"));
        if (!isDisUnused) {
            entity.getFilter().getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        entity.getSelector().add("*");
        entity.getSelector().add("acctView.*");
        entity.getSelector().add("company.id");
        entity.getSelector().add("company.number");
        entity.getSelector().add("InnerAcct.*");
        entity.getSelector().add("InnerAcct.company.id");
        entity.getSelector().add("InnerAcct.company.number");
        try {
            AccountBankCollection account = AccountBankFactory.getRemoteInstance().getAccountBankCollection(entity);
            for (AccountBankInfo innerAcct : account) {
                innerAcct.setDisplayFormat("$number$ - $name$");
                DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode((Object)innerAcct);
                if (innerAcct.isIsClosed()) {
                    acctNode.setTextColor(SHUT_INNERACCT_COLOR);
                    acctNode.setTextBold(true);
                }
                root.add((MutableTreeNode)acctNode);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort();
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    public static void fillInnerAcct4Unit(KDTree tree, String currCompanyId, boolean isDisUnused) {
        if (EmptyUtil.isEmpty((String)currCompanyId)) {
            return;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"96_FSClientHelper"));
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entity.setFilter(filter);
        entity.getFilter().getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)currCompanyId));
        entity.getSorter().add(new SorterItemInfo("number"));
        if (!isDisUnused) {
            entity.getFilter().getFilterItems().add(new FilterItemInfo("closed", (Object)new Integer(0)));
        }
        entity.getSelector().add("*");
        entity.getSelector().add("acctView.*");
        entity.getSelector().add("company.id");
        entity.getSelector().add("company.number");
        entity.getSelector().add("applyUnit.id");
        entity.getSelector().add("applyUnit.number");
        entity.getSorter().add(new SorterItemInfo("number"));
        try {
            InnerAccountCollection account = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(entity);
            Iterator it = account.iterator();
            while (it.hasNext()) {
                InnerAccountInfo innerAcct = (InnerAccountInfo)it.next();
                innerAcct.setDisplayFormat("$number$ - $name$");
                DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode((Object)innerAcct);
                if (innerAcct.isClosed()) {
                    acctNode.setTextColor(SHUT_INNERACCT_COLOR);
                    acctNode.setTextBold(true);
                }
                root.add((MutableTreeNode)acctNode);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort();
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    public static void fillBankAcctByCompany(KDTree tree, CompanyOrgUnitCollection companyCol) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)resourcePath, (String)"Company"));
        if (companyCol == null) {
            return;
        }
        for (int i = 0; i < companyCol.size(); ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            child.setUserObject((Object)company);
            root.add((MutableTreeNode)child);
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            entity.setFilter(filter);
            entity.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId()));
            entity.getFilter().getFilterItems().add(new FilterItemInfo("isCHControl", (Object)new Integer(1)));
            entity.getFilter().getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            entity.getSelector().add("*");
            try {
                AccountBankCollection account = AccountBankFactory.getRemoteInstance().getAccountBankCollection(entity);
                Iterator it = account.iterator();
                while (it.hasNext()) {
                    DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode(it.next());
                    child.add((MutableTreeNode)acctNode);
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SysUtil.abort();
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    public static void fillInnerAcctByType(KDTree tree, String[] applyUnitIds, boolean isDisUnused) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)resourcePath, (String)"accountProperty"));
        FSClientHelper.makeTreeByAccountProperty(root);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < applyUnitIds.length; ++i) {
            set.add(applyUnitIds[i]);
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entity.setFilter(filter);
        entity.getFilter().getFilterItems().add(new FilterItemInfo("applyUnit.id", set, CompareType.INCLUDE));
        String curC = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        entity.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)curC));
        if (!isDisUnused) {
            entity.getFilter().getFilterItems().add(new FilterItemInfo("closed", (Object)new Integer(0)));
        }
        entity.getSelector().add("*");
        entity.getSelector().add("type.property");
        entity.getSorter().add(new SorterItemInfo("number"));
        try {
            InnerAccountCollection accounts = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(entity);
            block3: for (int i = 0; i < accounts.size(); ++i) {
                InnerAccountInfo acct = accounts.get(i);
                acct.setDisplayFormat("$number$ - $name$");
                DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode((Object)acct);
                if (acct.isClosed()) {
                    acctNode.setTextColor(SHUT_INNERACCT_COLOR);
                    acctNode.setTextBold(true);
                }
                AccountPropertyInfo accountPropertyName = null;
                for (int j = 0; j < root.getChildCount(); ++j) {
                    Object ob = ((DefaultKingdeeTreeNode)root.getChildAt(j)).getUserObject();
                    if (ob == null || !(ob instanceof AccountPropertyInfo)) continue;
                    accountPropertyName = (AccountPropertyInfo)ob;
                    if (!acct.getType().getId().equals((Object)accountPropertyName.getId())) continue;
                    ((DefaultKingdeeTreeNode)root.getChildAt(j)).add((MutableTreeNode)acctNode);
                    continue block3;
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    private static void makeTreeByAccountProperty(DefaultKingdeeTreeNode root) {
        AccountPropertyCollection accountPropertyColl = null;
        try {
            accountPropertyColl = AccountPropertyFactory.getRemoteInstance().getAccountPropertyCollection();
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        for (int i = 0; i < accountPropertyColl.size(); ++i) {
            DefaultKingdeeTreeNode currentNode = new DefaultKingdeeTreeNode();
            currentNode.setUserObject((Object)accountPropertyColl.get(i));
            root.add((MutableTreeNode)currentNode);
        }
    }

    public static void fillPeriodTree(KDTree treeList, CycleTypeEnum cycleType, int beginYear, int beginMonth, int endYear, int endMonth) {
        CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)cycleType, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)cycleType.getAlias());
        for (int i = 0; i < coll.size(); ++i) {
            CycleRangeInfo info = coll.get(i);
            Date date = null;
            date = info.getBeginDate();
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            if (cycleType.getValue() == 30) {
                String period = FMConstants.FORMAT_MONTH.format(date);
                child.setUserObject((Object)period);
            }
            child.setUserObject((Object)info);
            root.add((MutableTreeNode)child);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        treeList.setModel((TreeModel)model);
    }

    public static void fillPeriodTree(KDTree treeList, int beginYear, int beginMonth, int endYear, int endMonth) {
        FSClientHelper.fillTree(treeList, beginYear, beginMonth, endYear, endMonth, 1);
    }

    public static void fillQuarterTree(KDTree treeList, int beginYear, int beginQuarter, int endYear, int endQuarter) {
        FSClientHelper.fillTree(treeList, beginYear, beginQuarter, endYear, endQuarter, 10);
    }

    public static void fillTree(KDTree treeList, int beginYear, int beginNumber, int endYear, int endNumber, int treeType) {
        int totalNumber = 0;
        String rootName = "";
        if (treeType == 1) {
            rootName = EASResource.getString((String)resourcePath, (String)"PeriodRoot");
            totalNumber = 12;
        } else if (treeType == 10) {
            rootName = EASResource.getString((String)resourcePath, (String)"QuarterRoot");
            totalNumber = 4;
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"ErrorTreeType"));
            SysUtil.abort();
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)rootName);
        if (beginYear == endYear) {
            for (int i = beginNumber; i <= endNumber; ++i) {
                DefaultKingdeeTreeNode newChild = new DefaultKingdeeTreeNode((Object)new Period(beginYear, i));
                root.add((MutableTreeNode)newChild);
            }
        } else {
            for (int y = beginYear; y <= endYear; ++y) {
                DefaultKingdeeTreeNode newChild;
                int i;
                if (y == beginYear) {
                    for (i = beginNumber; i <= totalNumber; ++i) {
                        newChild = new DefaultKingdeeTreeNode((Object)new Period(beginYear, i));
                        root.add((MutableTreeNode)newChild);
                    }
                    continue;
                }
                if (y == endYear) {
                    for (i = 1; i <= endNumber; ++i) {
                        newChild = new DefaultKingdeeTreeNode((Object)new Period(endYear, i));
                        root.add((MutableTreeNode)newChild);
                    }
                    continue;
                }
                for (i = 1; i <= totalNumber; ++i) {
                    newChild = new DefaultKingdeeTreeNode((Object)new Period(y, i));
                    root.add((MutableTreeNode)newChild);
                }
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        treeList.setModel((TreeModel)model);
    }

    public static Set getBankAccountIds(String[] companyIds) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < companyIds.length; ++i) {
            CompanyOrgUnitInfo company = FSClientHelper.getCompanyOrgUnit(companyIds[i]);
            AccountBankInfo abi = company.getAccountBank();
            if (abi == null) continue;
            set.add(abi.getId().toString());
        }
        return set;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnit(String id) {
        CompanyOrgUnitInfo company = null;
        try {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            SysUtil.abort();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return company;
    }

    public static IRowSet getRowSet(IMetaDataPK mainQueryPK, EntityViewInfo evi) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        exec.setObjectView(evi);
        IRowSet rowSet = null;
        try {
            rowSet = exec.executeQuery();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return rowSet;
    }

    public static InnerAccountCollection getInnerAccountCollection(String applyUnitID, Set usageIds, boolean isDispUnUsed) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)applyUnitID));
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)curr));
        if (!isDispUnUsed) {
            fi.getFilterItems().add(new FilterItemInfo("closed", (Object)new Integer(0)));
        }
        if (usageIds != null && usageIds.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("type.id", (Object)usageIds, CompareType.INCLUDE));
        }
        evi.setFilter(fi);
        return InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(evi);
    }

    public static InnerAccountCollection getInnerAccountColl(String companyId, Set applyUnitIdSet, Set typeIdSet, boolean isDispUnUsed) throws BOSException {
        if (applyUnitIdSet == null || applyUnitIdSet.isEmpty()) {
            return new InnerAccountCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)applyUnitIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        if (!isDispUnUsed) {
            filter.getFilterItems().add(new FilterItemInfo("closed", (Object)new Integer(0)));
        }
        if (typeIdSet != null && typeIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)typeIdSet, CompareType.INCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("applyUnit.name");
        return InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(evi);
    }

    public static InnerAccountCollection getInnerAccountCollection(String[] companyID) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)CollectionUtil.asSet((String[])companyID), CompareType.INCLUDE));
        evi.setFilter(fi);
        evi.getSorter().add(new SorterItemInfo("company.id"));
        return InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(evi);
    }

    public static void checkStatusForAccept(Component ui, String resourcePath) throws EASBizException, BOSException {
        boolean status = FSClientHelper.clearingHouseIsOpen();
        if (!status) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"CloseCanNotAccept"));
            SysUtil.abort();
        }
    }

    public static void checkStatusForSettle(Component ui, String resourcePath) throws EASBizException, BOSException {
        boolean status = FSClientHelper.clearingHouseIsOpen();
        if (!status) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"CloseCanNotSettle"));
            SysUtil.abort();
        }
    }

    public static boolean isShowAllCompany(String[] companyIds) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)CollectionUtil.asSet((String[])companyIds), CompareType.INCLUDE));
        return BankFactory.getRemoteInstance().exists(filter);
    }

    public static void setFirstInnerAcctNodeSelected(KDTree tree) {
        int height = tree.getRowCount();
        for (int i = 1; i < height; ++i) {
            DefaultKingdeeTreeNode tn;
            TreePath tp = tree.getPathForRow(i);
            if (tp == null || (tn = (DefaultKingdeeTreeNode)tp.getLastPathComponent()).getChildCount() <= 0) continue;
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)tree.getModel().getChild(tn, 0);
            tree.setSelectionNode(childNode);
            tree.expandAllNodes(true, (TreeNode)tn);
            return;
        }
    }

    public static void importFromExcel(Component ui, KDTable table) throws Exception {
        int i;
        int j;
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)RES, (String)"importFromExcel"));
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(ui) != 0) {
            return;
        }
        filePath = fileChooser.getSelectedFile().getPath();
        if (filePath == null) {
            return;
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("EXPORT_FORMULA", "true");
        KDSBook kdsBook = POIXlsReader.parse((String)filePath, hm);
        if (kdsBook == null) {
            throw new FMException(FMException.CHECKREADEXCEL);
        }
        String sheetName = kdsBook.getSheet((Object)new Integer(0)).getName();
        KDSSheet sheet = kdsBook.getSheet((Object)sheetName);
        int headerRowCount = table.getHeadRowCount();
        int colSize = sheet.getColumnCount() > table.getColumnCount() ? table.getColumnCount() : sheet.getColumnCount();
        for (int i2 = 0; i2 < headerRowCount; ++i2) {
            IRow row = table.getHeadRow(i2);
            int k = 0;
            for (j = 0; j < table.getColumnCount(); ++j) {
                if (table.getColumn(j).getStyleAttributes().isHided() || row.getCell(j).getValue().toString().equals(sheet.getCell(i2, k++, false).getText())) continue;
                throw new FMException(FMException.CHECKIMPORTMATCH);
            }
        }
        int sheetRowCount = sheet.getRowCount();
        boolean isEmpty = true;
        for (i = 0; i < sheet.getRowCount(); ++i) {
            for (j = 0; j < colSize; ++j) {
                KDSCell cell = sheet.getCell(i, j, false);
                Object cellValue = cell.getValue();
                if (cellValue == null || cellValue.toString().equals("")) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) continue;
            --sheetRowCount;
        }
        if (table.getRowCount() != sheetRowCount - headerRowCount) {
            throw new FMException(FMException.CHECKIMPORTMATCH);
        }
        for (i = 0; i < table.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            int k = 0;
            for (int j2 = 0; j2 < table.getColumnCount(); ++j2) {
                if (row.getCell(j2).getStyleAttributes().isHided()) continue;
                if (row.getCell(j2).getStyleAttributes().isLocked()) {
                    ++k;
                    continue;
                }
                row.getCell(j2).setValue((Object)FMHelper.getBigDecimal((Object)sheet.getCell(i + headerRowCount, k++, false).getValue()));
            }
        }
    }

    public static TreeModel getOrgTreeModelForCHUser() throws Exception {
        return NewOrgUtils.getTreeModel((OrgViewType)OrgViewType.COMPANY, null, (boolean)false, (boolean)false, null, (boolean)false, null, (int)0, null, null);
    }

    public static boolean isClearingHouseCompany(CompanyOrgUnitInfo company) {
        String companyId = null;
        if (company != null) {
            companyId = company.getId().toString();
        }
        return FSClientHelper.isClearingHouseCompanyId(companyId);
    }

    public static boolean isClearingHouseCompanyId(String companyId) {
        try {
            return BankFactory.getRemoteInstance().isClearinghouseCompany(companyId);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    public static MultiApproveCollection getMutiApprove(String billId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("IsPass", (Object)Boolean.TRUE, CompareType.EQUALS));
        IMultiApprove iMutiApprove = MultiApproveFactory.getRemoteInstance();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("creator.name"));
        SorterItemInfo dsf = new SorterItemInfo("CreateTime");
        dsf.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(dsf);
        MultiApproveCollection col = iMutiApprove.getMultiApproveCollection(viewInfo);
        return col;
    }

    public static void fillInnerAcctByCompany(KDTree tree, CompanyOrgUnitCollection companyCol, boolean isDisUnused) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        if (companyCol == null) {
            return;
        }
        DefaultKingdeeTreeNode parent = root;
        HashMap<BOSUuid, DefaultKingdeeTreeNode> companyC = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        root.setUserObject((Object)companyCol.get(0));
        companyC.put(companyCol.get(0).getId(), root);
        for (int i = 1; i < companyCol.size(); ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            child.setUserObject((Object)company);
            companyC.put(company.getId(), child);
            CompanyOrgUnitInfo p = company.getParent();
            if (p != null && companyC.get(p.getId()) != null) {
                parent = (DefaultKingdeeTreeNode)companyC.get(p.getId());
            }
            parent.add((MutableTreeNode)child);
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            entity.setFilter(filter);
            entity.getFilter().getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)company.getId()));
            String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            entity.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)curr));
            if (!isDisUnused) {
                entity.getFilter().getFilterItems().add(new FilterItemInfo("closed", (Object)new Integer(0)));
            }
            entity.getSelector().add("*");
            entity.getSelector().add("acctView.*");
            entity.getSorter().add(new SorterItemInfo("number"));
            try {
                InnerAccountCollection account = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(entity);
                Iterator it = account.iterator();
                while (it.hasNext()) {
                    InnerAccountInfo innerAcct = (InnerAccountInfo)it.next();
                    innerAcct.setDisplayFormat("$number$ - $name$");
                    DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode((Object)innerAcct);
                    if (innerAcct.isClosed()) {
                        acctNode.setTextColor(SHUT_INNERACCT_COLOR);
                        acctNode.setTextBold(true);
                    }
                    child.add((MutableTreeNode)acctNode);
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SysUtil.abort();
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    public static void fillCompanyTreeByCompany(KDTree tree, CompanyOrgUnitCollection companyCol, boolean isDisUnused) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        if (companyCol == null) {
            return;
        }
        DefaultKingdeeTreeNode parent = root;
        HashMap<BOSUuid, DefaultKingdeeTreeNode> companyC = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        CompanyOrgUnitInfo companyInfo = companyCol.get(0);
        OrgStructureInfo oneInfo = FSClientHelper.turnCompanyToOrgStructure(companyInfo);
        root.setUserObject((Object)oneInfo);
        companyC.put(companyCol.get(0).getId(), root);
        for (int i = 1; i < companyCol.size(); ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            OrgStructureInfo oneInfo1 = FSClientHelper.turnCompanyToOrgStructure(company);
            child.setUserObject((Object)oneInfo1);
            companyC.put(company.getId(), child);
            CompanyOrgUnitInfo p = company.getParent();
            if (p != null && companyC.get(p.getId()) != null) {
                parent = (DefaultKingdeeTreeNode)companyC.get(p.getId());
            }
            parent.add((MutableTreeNode)child);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    private static OrgStructureInfo turnCompanyToOrgStructure(CompanyOrgUnitInfo companyInfo) {
        OrgStructureInfo oneInfo = new OrgStructureInfo();
        oneInfo.setIsLeaf(companyInfo.isIsLeaf());
        oneInfo.setId(companyInfo.getId());
        oneInfo.setUnit(companyInfo.castToFullOrgUnitInfo());
        oneInfo.setLongNumber(companyInfo.getLongNumber());
        oneInfo.setIsValid(true);
        oneInfo.setParent(null);
        oneInfo.setTree(null);
        return oneInfo;
    }

    public static void fillInnerAcctByCompanySupportCache(KDTree tree, CompanyOrgUnitCollection companyCol, boolean isDisUnused) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        if (companyCol == null) {
            return;
        }
        DefaultKingdeeTreeNode parent = root;
        HashMap<BOSUuid, DefaultKingdeeTreeNode> companyC = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        root.setUserObject((Object)companyCol.get(0));
        companyC.put(companyCol.get(0).getId(), root);
        Map hmCompany2InnerAccount = new HashMap();
        try {
            hmCompany2InnerAccount = FSClientHelper.putAllInnerAccount2Cache(companyCol, isDisUnused);
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
            MsgBox.showWarning((String)e1.getMessage());
            SysUtil.abort();
        }
        for (int i = 0; i < companyCol.size(); ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            DefaultKingdeeTreeNode child = parent;
            if (!companyC.containsKey(company.getId())) {
                child = new DefaultKingdeeTreeNode();
                child.setUserObject((Object)company);
                companyC.put(company.getId(), child);
                CompanyOrgUnitInfo p = company.getParent();
                if (p != null && companyC.get(p.getId()) != null) {
                    parent = (DefaultKingdeeTreeNode)companyC.get(p.getId());
                }
                parent.add((MutableTreeNode)child);
            }
            try {
                InnerAccountCollection account = FSClientHelper.getInnerAccountColFromCache(hmCompany2InnerAccount, company, companyCol, isDisUnused);
                Iterator it = account.iterator();
                while (it.hasNext()) {
                    InnerAccountInfo innerAcct = (InnerAccountInfo)it.next();
                    innerAcct.setDisplayFormat("$number$ - $name$");
                    DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode((Object)innerAcct);
                    if (innerAcct.isClosed()) {
                        acctNode.setTextColor(SHUT_INNERACCT_COLOR);
                        acctNode.setTextBold(true);
                    }
                    child.add((MutableTreeNode)acctNode);
                }
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SysUtil.abort();
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    public static void fillCompanyByCompanySupportCache(KDTree tree, CompanyOrgUnitCollection companyCol) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        if (companyCol == null) {
            return;
        }
        DefaultKingdeeTreeNode parent = root;
        HashMap<BOSUuid, DefaultKingdeeTreeNode> companyC = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        root.setUserObject((Object)companyCol.get(0));
        companyC.put(companyCol.get(0).getId(), root);
        for (int i = 1; i < companyCol.size(); ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            child.setUserObject((Object)company);
            companyC.put(company.getId(), child);
            CompanyOrgUnitInfo p = company.getParent();
            if (p != null && companyC.get(p.getId()) != null) {
                parent = (DefaultKingdeeTreeNode)companyC.get(p.getId());
            }
            parent.add((MutableTreeNode)child);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    private static InnerAccountCollection getInnerAccountColFromCache(Map hmCompany2InnerAccount, CompanyOrgUnitInfo singleCompany, CompanyOrgUnitCollection companyCol, boolean isDisUnused) throws Exception {
        String singleCompanyIDKey = FSClientHelper.genKey(singleCompany, isDisUnused);
        if (hmCompany2InnerAccount.get(singleCompanyIDKey) == null) {
            hmCompany2InnerAccount.put(singleCompanyIDKey, FSClientHelper.getInnerAccountColBySingleCompany(singleCompany, isDisUnused));
        }
        InnerAccountCollection all = (InnerAccountCollection)((Object)hmCompany2InnerAccount.get(singleCompanyIDKey));
        if (isDisUnused) {
            return all;
        }
        int size = all.size();
        InnerAccountCollection returnIac = new InnerAccountCollection();
        InnerAccountInfo tmpInnerAccountInfo = null;
        for (int i = 0; i < size; ++i) {
            tmpInnerAccountInfo = all.get(i);
            if (tmpInnerAccountInfo.isClosed()) continue;
            returnIac.add(tmpInnerAccountInfo);
        }
        return returnIac;
    }

    private static InnerAccountCollection getInnerAccountColBySingleCompany(CompanyOrgUnitInfo singleCompany, boolean isDisUnused) throws Exception {
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entity.setFilter(filter);
        entity.getFilter().getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)singleCompany.getId().toString()));
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        entity.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)curr));
        if (!isDisUnused) {
            // empty if block
        }
        entity.getSelector().add("*");
        entity.getSelector().add("acctView.*");
        entity.getSorter().add(new SorterItemInfo("number"));
        return InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(entity);
    }

    private static Map putAllInnerAccount2Cache(CompanyOrgUnitCollection companyCol, boolean isDisUnused) throws BOSException {
        InnerAccountCollection allInnerAccount = FSClientHelper.getAllInnerAccount(FSClientHelper.fetchCompanyIDSet(companyCol), isDisUnused);
        return FSClientHelper.genCacheByCompany(allInnerAccount, companyCol, isDisUnused);
    }

    private static Map genCacheByCompany(InnerAccountCollection allInnerAccount, CompanyOrgUnitCollection companyCol, boolean isDisUnused) {
        HashMap<String, InnerAccountCollection> hmCompany2InnerAccount = new HashMap<String, InnerAccountCollection>();
        int sizeCompany = companyCol.size();
        int sizeInnerAccount = allInnerAccount.size();
        for (int i = 0; i < sizeCompany; ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            String companyIDAsKey = FSClientHelper.genKey(company, isDisUnused);
            if (hmCompany2InnerAccount.get(companyIDAsKey) == null) {
                hmCompany2InnerAccount.put(companyIDAsKey, new InnerAccountCollection());
            }
            for (int j = 0; j < sizeInnerAccount; ++j) {
                InnerAccountInfo innerAccount = allInnerAccount.get(j);
                if (!FSClientHelper.companyEquals(innerAccount, company)) continue;
                ((InnerAccountCollection)((Object)hmCompany2InnerAccount.get(companyIDAsKey))).add(innerAccount);
            }
        }
        return hmCompany2InnerAccount;
    }

    private static String genKey(CompanyOrgUnitInfo company, boolean isDisUnused) {
        StringBuffer sbKey = new StringBuffer();
        sbKey.append(company.getId().toString());
        return sbKey.toString();
    }

    private static boolean companyEquals(InnerAccountInfo innerAccount, CompanyOrgUnitInfo company) {
        boolean compareRs = false;
        if (innerAccount != null && company != null && innerAccount.getApplyUnit() != null && innerAccount.getApplyUnit().getId().toString().equals(company.getId().toString())) {
            compareRs = true;
        }
        return compareRs;
    }

    private static InnerAccountCollection getAllInnerAccount(Set companyIDSet, boolean isDisUnused) throws BOSException {
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entity.setFilter(filter);
        entity.getFilter().getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)companyIDSet, CompareType.INCLUDE));
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        entity.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)curr));
        if (!isDisUnused) {
            // empty if block
        }
        entity.getSelector().add("*");
        entity.getSelector().add("acctView.*");
        entity.getSorter().add(new SorterItemInfo("number"));
        return InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(entity);
    }

    private static Set fetchCompanyIDSet(CompanyOrgUnitCollection companyCol) {
        HashSet<String> idSet = new HashSet<String>();
        int size = companyCol.size();
        for (int i = 0; i < size; ++i) {
            CompanyOrgUnitInfo tmp = companyCol.get(i);
            idSet.add(tmp.getId().toString());
        }
        return idSet;
    }

    public static InnerAccountCollection getInnerAccountCollection(String applyUnitID) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)applyUnitID));
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)curr));
        evi.setFilter(fi);
        return InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(evi);
    }

    public static void fillDateTree(KDTree treeList, String nodeInfo) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"97_FSClientHelper"));
        DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
        child.setUserObject((Object)nodeInfo);
        root.add((MutableTreeNode)child);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        treeList.setModel((TreeModel)model);
    }

    public static void checkOpenAreaOrPrinceCity(SettlementBillInfo info) throws EASBizException {
        IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
        String value = contextHelper.getStringParam("BE009", (IObjectPK)new ObjectUuidPK(contextHelper.getCurrentCompany().getId()));
        if (value == null || "0".equals(value)) {
            FMVerifyHelper.checkBlank(null, (IObjectValue)info, (String)"recCityStr");
            FMVerifyHelper.checkBlank(null, (IObjectValue)info, (String)"recProvinceStr");
        } else {
            FMVerifyHelper.checkBlank(null, (IObjectValue)info, (String)"payeeArea");
        }
    }

    public static void showSubmitBeUI(Component comp, SettlementBillInfo info, boolean isCheckShow) throws Exception {
        String srcPath = "com.kingdee.eas.fm.fs.SettlementBillUI";
        LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
        value.put(EASResource.getString((String)srcPath, (String)"147_Settlement"), "");
        value.put(EASResource.getString((String)srcPath, (String)"136_Settlement"), info.getPayeeBankAcctNum());
        value.put(EASResource.getString((String)srcPath, (String)"137_Settlement"), info.getPayeeBank());
        if (!EmptyUtil.isEmpty((String)info.getBankAcctName())) {
            value.put(EASResource.getString((String)srcPath, (String)"138_Settlement"), info.getBankAcctName());
        } else {
            value.put(EASResource.getString((String)srcPath, (String)"138_Settlement"), info.getPayeeFullName());
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBankAcct())) {
            value.put(EASResource.getString((String)srcPath, (String)"139_Settlement"), info.getPayerBankAcct().getName());
        } else {
            value.put(EASResource.getString((String)srcPath, (String)"139_Settlement"), "");
        }
        value.put(EASResource.getString((String)srcPath, (String)"140_Settlement"), info.getCurrency().getName() + info.getAmount());
        value.put(EASResource.getString((String)srcPath, (String)"150_Settlement"), info.getUsage());
        IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
        String txt = contextHelper.getStringParam("BE009", (IObjectPK)new ObjectUuidPK(contextHelper.getCurrentCompany().getId()));
        if (txt == null || "0".equals(txt)) {
            value.put(EASResource.getString((String)srcPath, (String)"142_Settlement"), info.getRecProvinceStr());
            value.put(EASResource.getString((String)srcPath, (String)"143_Settlement"), info.getRecCityStr());
        } else if (!FMHelper.isEmpty((CoreBaseInfo)info.getPayeeArea())) {
            value.put(EASResource.getString((String)srcPath, (String)"146_Settlement"), info.getPayeeArea().getName());
        } else {
            value.put(EASResource.getString((String)srcPath, (String)"146_Settlement"), "");
        }
        value.put(EASResource.getString((String)srcPath, (String)"144_Settlement"), (String)info.getIsUrgent());
        value.put(EASResource.getString((String)srcPath, (String)"145_Settlement"), info.isIsForceManual() ? EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"267_FSClientHelper") : EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"268_FSClientHelper"));
        value.put(EASResource.getString((String)srcPath, (String)"166_Settlement"), (String)(info.getSettleType() == null ? null : (info.getSettleType().isPayThroughBE() ? info.getSettleType() : null)));
        HashMap<String, String> color = new HashMap<String, String>();
        LinkedHashMap<String, String> temp = value;
        for (String key : temp.keySet()) {
            if (!FMHelper.isEmpty(temp.get(key)) || key.equals(EASResource.getString((String)srcPath, (String)"147_Settlement"))) continue;
            color.put(key, "#FF0000");
        }
        if (color.size() <= 0 && isCheckShow) {
            return;
        }
        FMClientHelper.showMsgBox((Component)comp, value, color);
    }

    public static void showSubmitBeUINew(Component comp, String id, boolean isCheckShow) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payeeArea.name"));
        sic.add(new SelectorItemInfo("payerBankAcct.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("settleType.*"));
        SettlementBillInfo info = SettlementBillFactory.getRemoteInstance().getSettlementBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        FSClientHelper.showSubmitBeUI(comp, info, isCheckShow);
    }

    public static void fillCompanyTreeByCompany(KDTree tree, CompanyOrgUnitCollection companyCol) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        if (companyCol == null) {
            return;
        }
        DefaultKingdeeTreeNode parent = root;
        HashMap<BOSUuid, DefaultKingdeeTreeNode> companyC = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        CompanyOrgUnitInfo companyInfo = companyCol.get(0);
        int count = 1;
        if (!companyInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            try {
                count = 0;
                companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        OrgStructureInfo oneInfo = FSClientHelper.turnCompanyToOrgStructure(companyInfo);
        root.setUserObject((Object)oneInfo);
        companyC.put(companyInfo.getId(), root);
        for (int i = count; i < companyCol.size(); ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            OrgStructureInfo oneInfo1 = FSClientHelper.turnCompanyToOrgStructure(company);
            child.setUserObject((Object)oneInfo1);
            companyC.put(company.getId(), child);
            CompanyOrgUnitInfo p = company.getParent();
            if (p != null && companyC.get(p.getId()) != null) {
                parent = (DefaultKingdeeTreeNode)companyC.get(p.getId());
            } else if (p != null && companyC.get(p.getId()) == null) {
                parent = root;
            }
            parent.add((MutableTreeNode)child);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }
}

