/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.XTable;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettlementBillRpcCacheInfo;
import com.kingdee.eas.fm.fs.client.AbstractInAcctBalanceUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.InAcctBalanceFilterUI;
import com.kingdee.eas.fm.fs.client.InAcctBalanceRptHelper;
import com.kingdee.eas.fm.fs.client.InAcctBalanceparam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InAcctBalanceUI
extends AbstractInAcctBalanceUI {
    private static final String COL_APPLYUNIT = "company";
    public static final String resourcePath = "com.kingdee.eas.fm.fs.client.SummaryLedgerResource";
    private static final Logger logger = CoreUIObject.getLogger(InAcctBalanceUI.class);
    private XTable dataTable;
    private InAcctBalanceparam para;
    private BigDecimal balance_total;
    private BigDecimal frozenAmt_total;
    private BigDecimal useBalance_total;
    private InAcctBalanceFilterUI filterUI;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany((SettlementBillRpcCacheInfo)this.rpcCacheInfo);
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.removeRows();
        this.tblMain.getColumn("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("useBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("frozenAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.para = (InAcctBalanceparam)this.getFilterParam();
        try {
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.para.getCurrencyId())));
            DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
            this.txtRptDate.setText(dtformat.format(this.para.getRptDate()));
            this.txtCurrency.setText(currency.getName());
            this.txtCurrency.setUserObject((Object)currency);
            Date settleDate = ((SettlementBillRpcCacheInfo)this.rpcCacheInfo).getClearHouse().getSettleDate();
            this.dataTable = InAcctBalanceRptHelper.createDataTable(this.para.getCompanyIds(), this.para.getCurrencyId(), this.para.getRptDate(), settleDate);
            InnerAccountCollection innerAcctColl = InAcctBalanceRptHelper.getInnerAcctColl(this.para);
            this.tblMain.getColumn("balance").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currency.getId()));
            this.tblMain.getColumn("frozenAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currency.getId()));
            this.tblMain.getColumn("useBalance").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currency.getId()));
            this.balance_total = Constants.ZERO;
            this.frozenAmt_total = Constants.ZERO;
            this.useBalance_total = Constants.ZERO;
            for (int i = 0; i < innerAcctColl.size(); ++i) {
                this.fillOneRow(innerAcctColl.get(i), currency, this.para.isShowLargeZero());
            }
            if (this.para.isShowTotal()) {
                this.setTotal();
            }
            IRow row0 = this.tblMain.addRow();
            row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
            row0.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"269_InAcctBalanceUI"));
            row0.getCell("balance").setValue((Object)this.balance_total);
            row0.getCell("frozenAmt").setValue((Object)this.frozenAmt_total);
            row0.getCell("useBalance").setValue((Object)this.useBalance_total);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort();
        }
        this.tblMain.reLayoutAndPaint();
    }

    public void setTotal() {
        CurrencyInfo currency = (CurrencyInfo)this.txtCurrency.getUserObject();
        this.tblMain.getColumn("balance").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currency.getId()));
        this.tblMain.getColumn("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("frozenAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currency.getId()));
        this.tblMain.getColumn("frozenAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("useBalance").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currency.getId()));
        this.tblMain.getColumn("useBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(COL_APPLYUNIT).setGroup(true);
        this.tblMain.getColumn(COL_APPLYUNIT).setMergeable(true);
        this.tblMain.getColumn(COL_APPLYUNIT).setStat(true);
        IRow row = this.tblMain.getGroupManager().getStatRowTemplate(0);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell(COL_APPLYUNIT).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"270_InAcctBalanceUI"));
        row.getCell("balance").setExpressions("SUM");
        row.getCell("frozenAmt").setExpressions("SUM");
        row.getCell("useBalance").setExpressions("SUM");
        this.tblMain.getGroupManager().group();
    }

    public void fillOneRow(InnerAccountInfo innerAcct, CurrencyInfo currency, boolean isEnableOnlyShowLargeZero) {
        String rowKey = innerAcct.getApplyUnit().getId().toString() + currency.getId().toString() + innerAcct.getId().toString();
        Map dateRow = this.dataTable.getRow(rowKey);
        IRow row = this.tblMain.addRow();
        row.getCell(COL_APPLYUNIT).setValue((Object)innerAcct.getApplyUnit().getName());
        row.getCell("innerAcctNum").setValue((Object)innerAcct.getNumber());
        row.getCell("innerAcctName").setValue((Object)innerAcct.getName());
        row.getCell("type").setValue((Object)innerAcct.getType().getName());
        BigDecimal balance = Constants.ZERO;
        BigDecimal frozenAmt = Constants.ZERO;
        BigDecimal useBalance = Constants.ZERO;
        if (dateRow != null) {
            if (dateRow.get("balance") != null) {
                balance = (BigDecimal)dateRow.get("balance");
            }
            if (dateRow.get("frozenamt") != null) {
                frozenAmt = dateRow.get("frozenamt") instanceof Integer ? new BigDecimal((Integer)dateRow.get("frozenamt")) : (BigDecimal)dateRow.get("frozenamt");
            }
            if (dateRow.get("usebalance") != null) {
                useBalance = (BigDecimal)dateRow.get("usebalance");
            }
            row.getCell("balance").setValue((Object)balance);
            row.getCell("frozenAmt").setValue((Object)frozenAmt);
            row.getCell("useBalance").setValue((Object)useBalance);
            this.balance_total = this.balance_total.add(balance);
            this.frozenAmt_total = this.frozenAmt_total.add(frozenAmt);
            this.useBalance_total = this.useBalance_total.add(useBalance);
        } else {
            row.getCell("balance").setValue((Object)Constants.ZERO);
            row.getCell("frozenAmt").setValue((Object)Constants.ZERO);
            row.getCell("useBalance").setValue((Object)Constants.ZERO);
        }
        if (isEnableOnlyShowLargeZero && !FMBillBigDecimalUtil.isGtZero((Object)row.getCell("balance").getValue())) {
            this.balance_total = this.balance_total.subtract(balance);
            this.frozenAmt_total = this.frozenAmt_total.subtract(frozenAmt);
            this.useBalance_total = this.useBalance_total.subtract(useBalance);
            this.tblMain.removeRow(this.tblMain.getRowCount() - 1);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new InAcctBalanceFilterUI();
        }
        return this.filterUI;
    }

    protected void checkTableParsed() {
        this.tblMain.checkParsed();
        super.checkTableParsed();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.contRptDate.getBoundLabelText()).append("&[rptDate]&|").append(this.contCurrency.getBoundLabelText()).append("&[Currency]&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rptDate", this.txtRptDate.getText());
        map.put("Currency", this.txtCurrency.getText());
        return map;
    }

    protected FmRpcCacheInfo getRpcCacheParam() {
        SettlementBillRpcCacheInfo paramInfo = new SettlementBillRpcCacheInfo();
        paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
        return paramInfo;
    }

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fm.fs.app.SettlementBillBatchFetcher";
    }

    protected boolean isRpcCacheProcess() {
        return true;
    }
}

