/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.InnerAvgAnalysisUIFacadeFactory;
import com.kingdee.eas.fm.fs.client.AbstractInnerAvgAnalysisUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.InnerAvgAnalysisFilterUI;
import com.kingdee.eas.fm.fs.client.InnerAvgAnalysisHandler;
import com.kingdee.eas.fm.fs.client.InnerAvgAnalysisParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InnerAvgAnalysisUI
extends AbstractInnerAvgAnalysisUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerAvgAnalysisUI.class);
    private InnerAvgAnalysisFilterUI filterUI;
    private static final String resourcePath1 = "com.kingdee.eas.fm.fs.FSClientResource";
    private BankInfo clearingHouse;
    Map paramMap = new HashMap();

    private void checkClearHourse() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
    }

    public void onLoad() throws Exception {
        this.prepare();
        if (this.paramMap.get("isClearingHourse") == null) {
            this.checkClearHourse();
        } else {
            boolean isClearingHourse = (Boolean)this.paramMap.get("isClearingHourse");
            if (!isClearingHourse) {
                MsgBox.showError((String)EASResource.getString((String)resourcePath1, (String)"mustToChCompany"));
                SysUtil.abort();
            }
        }
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.setTitle();
        super.onLoad();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    private void setTitle() {
        BankInfo clearingHouse;
        CompanyOrgUnitInfo curC = (CompanyOrgUnitInfo)this.paramMap.get("currentCompany");
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curC)) {
            this.sysStatusBarTitle = "DeFault";
        }
        if ((clearingHouse = (BankInfo)this.paramMap.get("clearingHouse")) == null) {
            this.sysStatusBarTitle = "DeFault";
        }
        Date settleDate = null;
        if (clearingHouse != null) {
            settleDate = clearingHouse.getSettleDate();
        }
        if (settleDate == null) {
            this.sysStatusBarTitle = "DeFault";
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath1, (String)"ClearingHouseNotUsed"));
            SysUtil.abort();
        }
        this.sysStatusBarTitle = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"CHDateTile") + Constants.FORMAT_DAY.format(settleDate);
    }

    private void prepare() throws Exception {
        this.paramMap.put("isClearingHourse", null);
        this.paramMap.put("currencyCol", null);
        this.paramMap = InnerAvgAnalysisUIFacadeFactory.getRemoteInstance().fetchParam(this.paramMap);
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        InnerAvgAnalysisParam p = (InnerAvgAnalysisParam)this.getFilterParam();
        InnerAvgAnalysisHandler handler = new InnerAvgAnalysisHandler();
        handler.initTable(this.tblMain, p);
        handler.setCurrencyFormat(this.tblMain, p);
        try {
            handler.fillData(this.tblMain, p, this.mainQuery, this.paramMap);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new InnerAvgAnalysisFilterUI(this.paramMap);
        }
        return this.filterUI;
    }
}

