/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.InnerFrozenDepositFactory;
import com.kingdee.eas.fm.fs.InnerFrozenDepositInfo;
import com.kingdee.eas.fm.fs.client.AbstractInnerFrozenDepositListUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.InnerFrozenBillHandler;
import com.kingdee.eas.fm.fs.client.InnerFrozenQueryProcessor;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class InnerFrozenDepositListUI
extends AbstractInnerFrozenDepositListUI {
    private static String resourcePath = "com.kingdee.eas.fm.fs.InnerFrozenDepositResource";
    private static final Logger logger = CoreUIObject.getLogger(InnerFrozenDepositListUI.class);
    private InnerFrozenBillHandler handler = InnerFrozenBillHandler.create();
    private CompanyOrgUnitInfo companyInfo;
    FillListener fillListener = new FillListener();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        super.onLoad();
        if (this.getUIContext().get("id") != null) {
            String id = this.getUIContext().get("id").toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("innerAccount.id", (Object)id));
            this.mainQuery.getFilter().mergeFilter(filter, "AND");
            this.actionRefresh.setVisible(false);
            this.actionQuery.setVisible(false);
            this.actionAddNew.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionEdit.setVisible(false);
        }
        this.actionLocate.setVisible(false);
        this.execQuery();
    }

    private void showMsg(ActionEvent e) {
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int index = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(index);
        String id = row.getCell("id").getValue().toString();
        this.checkCanRemove(id);
        super.actionRemove_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    protected IObjectValue createNewData() {
        InnerFrozenDepositInfo objectValue = new InnerFrozenDepositInfo();
        return objectValue;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected void execQuery() {
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyInfo.getId().toString()));
        this.mainQuery.getSorter().add(new SorterItemInfo("innerAccount.number"));
        this.mainQuery.getSorter().add(new SorterItemInfo("currency.number"));
        this.mainQuery.getSorter().add(new SorterItemInfo("frozenNumber"));
        this.mainQuery.getSorter().remove(new SorterItemInfo("id"));
        try {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        super.execQuery();
    }

    public EntityViewInfo getMainQuery() {
        return super.getMainQuery();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    private void checkCanRemove(String id) {
        String reslut = "0";
        try {
            reslut = InnerFrozenDepositFactory.getRemoteInstance().checkCanRemove(id);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if ("1".equals(reslut)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"cannotremove"));
            SysUtil.abort();
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.getUIContext().get("id") != null) {
            uiContext.put((Object)"id", this.getUIContext().get("id"));
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDialog = super.initCommonQueryDialog();
        queryDialog.setProcessor(this.getQueryProcessor());
        return queryDialog;
    }

    private IProcessor getQueryProcessor() {
        return new InnerFrozenQueryProcessor((IUIObject)this);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(InnerFrozenDepositListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            String innerAcctId = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                BigDecimal frozenAmt = (BigDecimal)row.getCell("frozenAmt").getValue();
                if (frozenAmt.compareTo(Constants.ZERO) == -1) {
                    row.getCell("frozenAmt").setValue((Object)frozenAmt.abs());
                    row.getCell("frozenAmt").getStyleAttributes().setFontColor(Color.red);
                }
                currencyId = (String)row.getCell("currencyId").getValue();
                innerAcctId = (String)row.getCell("innerAcctId").getValue();
                try {
                    BigDecimal totalFrozenAmt = InnerFrozenDepositListUI.this.handler.getFrozenBalanceValue(currencyId, innerAcctId);
                    row.getCell("totalFrozenAmt").setValue((Object)totalFrozenAmt);
                }
                catch (EASBizException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                catch (BOSException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                if (currencyId == null) continue;
                FMClientHelper.setNumberFormat((IRow)row, (String)"frozenAmt", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"totalFrozenAmt", (String)currencyId);
            }
        }
    }
}

