/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.XTable;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.InnerPileOfMoneyFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class InnerPileOfMoneyHandler
implements IRptHandler {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.PileOfMoneyResource";
    public static final Color TOTAL_COLOR = new Color(0xD6D6AD);
    private String loc;

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, InnerPileOfMoneyFilterParam param) throws BOSException {
        StringBuffer sb = new StringBuffer(128);
        GregorianCalendar begincal = new GregorianCalendar();
        GregorianCalendar endcal = new GregorianCalendar();
        if (param.isByDay()) {
            begincal.setTime(param.getFromDate());
            endcal.setTime(DateUtil.getAfterDay((Date)param.getToDate()));
        } else {
            begincal.set(param.getBeginYear(), param.getBeginMonth() - 1, 1);
            endcal.set(param.getEndYear(), param.getEndMonth(), 1, 0, 0, 0);
        }
        sb.append(this.parseInSql());
        sb.append("  WHERE \"PAYEECOMPANY\".fid ");
        this.parseCompanyCondition(param.getCompanyIds(), sb);
        String curC = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        sb.append("  AND \"SETTLEMENTBILL\".FCompanyId= '" + curC + "'");
        sb.append("\t AND \"PAYEEINNERACCT\".FCompanyId= '" + curC + "'");
        if (!param.isIncludeNotSettled()) {
            sb.append("  AND ((\"SETTLEMENTBILL\".FCASHIERID IS NOT NULL ").append("\t AND \"SETTLEMENTBILL\".FType IN (1, 2)) OR \"SETTLEMENTBILL\".FType IN (3, 4))");
        }
        if (param.getCurrencyId() != null) {
            String payeeCurrencyFilter = "  AND \"PAYEECURRENCY\".fid='" + param.getCurrencyId() + "'";
            sb.append(payeeCurrencyFilter);
        }
        String inAuountFilter = " AND \"SETTLEMENTBILL\".FAMOUNT>=" + param.getInAmount();
        sb.append(inAuountFilter);
        sb.append("  AND \"SETTLEMENTBILL\".FIsAccepted=1 ");
        sb.append(" AND \"SETTLEMENTBILL\".\"FBIZDATE\" >= {" + TypeConversionUtils.objToDate((Object)begincal.getTime()) + "}");
        sb.append(" AND \"SETTLEMENTBILL\".\"FBIZDATE\" < {" + TypeConversionUtils.objToDate((Object)endcal.getTime()) + "}");
        sb.append("\n union \n ");
        sb.append(this.parseOutSql());
        sb.append("  WHERE \"PAYERCOMPANY\".fid ");
        this.parseCompanyCondition(param.getCompanyIds(), sb);
        sb.append("  AND \"SETTLEMENTBILL\".Fcompanyid= '" + curC + "'");
        sb.append("\t AND \"PAYERINNERACCT\".FCompanyId= '" + curC + "'");
        if (!param.isIncludeNotSettled()) {
            sb.append("  AND ((\"SETTLEMENTBILL\".FCASHIERID IS NOT NULL").append("\t AND \"SETTLEMENTBILL\".FType IN (1, 2)) OR \"SETTLEMENTBILL\".FType IN (3, 4))");
        }
        if (param.getCurrencyId() != null) {
            String payerCurrencyFilter = "  AND \"PAYERCURRENCY\".fid='" + param.getCurrencyId() + "'";
            sb.append(payerCurrencyFilter);
        }
        String outAuountFilter = " AND \"SETTLEMENTBILL\".FAMOUNT>=" + param.getOutAmount();
        sb.append(outAuountFilter);
        sb.append("  AND \"SETTLEMENTBILL\".FIsAccepted=1 ");
        sb.append(" AND \"SETTLEMENTBILL\".\"FBIZDATE\" >= {" + TypeConversionUtils.objToDate((Object)begincal.getTime()) + "}");
        sb.append(" AND \"SETTLEMENTBILL\".\"FBIZDATE\" < {" + TypeConversionUtils.objToDate((Object)endcal.getTime()) + "}");
        sb.append("  ORDER BY companyName, AcctNum,CURRENCYNAME");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }

    private StringBuffer parseInSql() {
        StringBuffer sb = new StringBuffer(128);
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sb.append("SELECT \"SETTLEMENTBILL\".FID AS ID,");
        sb.append("\"PAYEECOMPANY\".FName_").append(this.loc).append("  AS COMPANYNAME, ");
        sb.append("\"SETTLEMENTBILL\".FNumber AS \"Number\",");
        sb.append("\"SETTLEMENTBILL\".FbizDate AS bizDate,");
        sb.append("\"PAYEEINNERACCT\".FNumber AS AcctNum, ");
        sb.append("\"PAYEEINNERACCT\".FID AS AcctId, ");
        sb.append("\"SETTLEMENTBILL\".FDescription AS DESCRIPTION, ");
        sb.append("\"PAYEECURRENCY\".FName_").append(this.loc).append("  AS CURRENCYNAME, ");
        sb.append("\"SETTLEMENTBILL\".FAmount AS INAMOUNT, ");
        sb.append("0 AS OUTAMOUNT,");
        sb.append("\"CASHIER\".FID AS CASHIERID");
        sb.append(" FROM T_FS_SettlementBill AS \"SETTLEMENTBILL\"");
        sb.append(" INNER JOIN T_BD_Currency AS \"PAYEECURRENCY\" ON \"SETTLEMENTBILL\".FCurrencyID = \"PAYEECURRENCY\".FID");
        sb.append(" LEFT OUTER JOIN T_PM_User AS \"CASHIER\" ON \"SETTLEMENTBILL\".FCashierID =\"CASHIER\".FID");
        sb.append(" INNER JOIN T_FS_InnerAccount AS \"PAYEEINNERACCT\" ON \"SETTLEMENTBILL\".FPayeeInnerAcctID = \"PAYEEINNERACCT\".FID");
        sb.append(" INNER JOIN T_ORG_Company AS \"PAYEECOMPANY\" ON \"PAYEEINNERACCT\".FApplyUnitID = \"PAYEECOMPANY\".FID");
        return sb;
    }

    private StringBuffer parseOutSql() {
        StringBuffer sb = new StringBuffer(128);
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sb.append("SELECT \"SETTLEMENTBILL\".FID AS ID,");
        sb.append("\"PAYERCOMPANY\".FName_").append(this.loc).append("  AS COMPANYNAME, ");
        sb.append("\"SETTLEMENTBILL\".FNumber AS \"Number\",");
        sb.append("\"SETTLEMENTBILL\".FbizDate AS bizDate,");
        sb.append("\"PAYERINNERACCT\".FNumber AS AcctNum,");
        sb.append("\"PAYERINNERACCT\".FID AS AcctId, ");
        sb.append("\"SETTLEMENTBILL\".FDescription AS DESCRIPTION, ");
        sb.append("\"PAYERCURRENCY\".FName_").append(this.loc).append("  AS CURRENCYNAME, ");
        sb.append("0 AS INAMOUNT, ");
        sb.append("\"SETTLEMENTBILL\".FAmount AS OUTAMOUNT, ");
        sb.append("\"CASHIER\".FID AS CASHIERID ");
        sb.append(" FROM T_FS_SettlementBill AS \"SETTLEMENTBILL\"");
        sb.append(" INNER JOIN T_BD_Currency AS \"PAYERCURRENCY\" ON \"SETTLEMENTBILL\".FCurrencyID = \"PAYERCURRENCY\".FID");
        sb.append(" LEFT OUTER JOIN T_PM_User AS \"CASHIER\" ON \"SETTLEMENTBILL\".FCashierID =\"CASHIER\".FID");
        sb.append(" INNER JOIN T_FS_InnerAccount AS \"PAYERINNERACCT\" ON \"SETTLEMENTBILL\".FPayerInnerAcctID = \"PAYERINNERACCT\".FID");
        sb.append(" INNER JOIN T_ORG_Company AS \"PAYERCOMPANY\" ON \"PAYERINNERACCT\".FApplyUnitID = \"PAYERCOMPANY\".FID");
        return sb;
    }

    private void parseCompanyCondition(String[] company, StringBuffer sb) {
        if (company == null || company.length == 0) {
            sb.append("in('')");
            return;
        }
        sb.append("in(");
        boolean isFirst = true;
        int size = company.length;
        for (int i = 0; i < size; ++i) {
            if (isFirst) {
                sb.append("'").append(company[i]).append("'");
            } else {
                sb.append(",'").append(company[i]).append("'");
            }
            isFirst = false;
        }
        sb.append(")");
    }

    public void fillData(KDTable tblMain, IRowSet rs, InnerPileOfMoneyFilterParam param) throws SQLException {
        while (rs.next()) {
            IRow row = tblMain.addRow();
            row.getCell("companyName").setValue((Object)rs.getString("companyName"));
            row.getCell("number").setValue((Object)rs.getString("number"));
            row.getCell("bizDate").setValue((Object)rs.getDate("bizDate"));
            row.getCell("payeeBankAcct").setValue((Object)rs.getString("AcctNum"));
            row.getCell("currencyName").setValue((Object)rs.getString("CurrencyName"));
            row.getCell("description").setValue((Object)rs.getString("description"));
            row.getCell("inAmount").setValue((Object)rs.getBigDecimal("inAmount"));
            row.getCell("outAmount").setValue((Object)rs.getBigDecimal("outAmount"));
            String sett = rs.getString("cashierId") != null ? EASResource.getString((String)this.resourcePath, (String)"Yes") : EASResource.getString((String)this.resourcePath, (String)"No");
            row.getCell("isSett").setValue((Object)sett);
        }
    }

    public void fillDataAndGroup(KDTable tblMain, IRowSet rs, InnerPileOfMoneyFilterParam param) throws SQLException, BOSException {
        IRow row;
        Map dataRow;
        String[] rowKeys;
        if (rs == null || rs.size() == 0) {
            return;
        }
        boolean isDispTotal = param.isDispAcctSubTotal();
        boolean isDispCompanyTotal = param.isDispCompanyTotal();
        BigDecimal tmpOutAmtTotal = Constants.ZERO;
        BigDecimal tmpInAmtTotal = Constants.ZERO;
        String currencyName = "";
        String acctNum = "";
        String tmpCurrencyName = "";
        String companyName = "";
        String tmpAcctNum = "";
        String tmpCompanyName = "";
        XTable companyCurrencyTotal = new XTable();
        XTable acctCurrencyTotal = new XTable();
        XTable allTotal = new XTable();
        if (rs.next()) {
            tmpCurrencyName = rs.getString("CurrencyName");
            tmpCompanyName = rs.getString("companyName");
            tmpAcctNum = rs.getString("AcctNum");
            rs.beforeFirst();
        }
        if (tmpCurrencyName == null || tmpCompanyName == null) {
            return;
        }
        Map innerAcctMap = this.getInnerAcctMap(rs);
        while (rs.next()) {
            Map addRow;
            BigDecimal out;
            Map dataRow2;
            companyName = rs.getString("companyName");
            acctNum = rs.getString("AcctNum");
            currencyName = rs.getString("CurrencyName");
            tmpInAmtTotal = rs.getBigDecimal("inAmount");
            tmpOutAmtTotal = rs.getBigDecimal("outAmount");
            if (tmpInAmtTotal == null) {
                tmpInAmtTotal = Constants.ZERO;
            }
            if (tmpOutAmtTotal == null) {
                tmpOutAmtTotal = Constants.ZERO;
            }
            if (isDispTotal) {
                if (acctCurrencyTotal.getRow(acctNum + currencyName) != null) {
                    dataRow2 = acctCurrencyTotal.getRow(acctNum + currencyName);
                    BigDecimal in = (BigDecimal)dataRow2.get("in");
                    dataRow2.put("in", in.add(tmpInAmtTotal));
                    out = (BigDecimal)dataRow2.get("out");
                    dataRow2.put("out", out.add(tmpOutAmtTotal));
                } else {
                    addRow = acctCurrencyTotal.addRow(acctNum + currencyName);
                    addRow.put("AcctNum", acctNum);
                    addRow.put("CurrencyName", currencyName);
                    addRow.put("in", tmpInAmtTotal);
                    addRow.put("out", tmpOutAmtTotal);
                }
                if (!tmpAcctNum.equals(acctNum)) {
                    rowKeys = acctCurrencyTotal.getRowKeys();
                    for (int i = 0; i < rowKeys.length; ++i) {
                        dataRow = acctCurrencyTotal.getRow(rowKeys[i]);
                        if (!dataRow.get("AcctNum").equals(tmpAcctNum)) continue;
                        row = tblMain.addRow();
                        row.getCell("companyName").setValue((Object)tmpCompanyName);
                        row.getCell("payeeBankAcct").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"271_InnerPileOfMoneyHandler"));
                        row.getCell("currencyName").setValue(dataRow.get("CurrencyName"));
                        row.getCell("outAmount").setValue(dataRow.get("out"));
                        row.getCell("inAmount").setValue(dataRow.get("in"));
                        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                        acctCurrencyTotal.deleteRow(rowKeys[i]);
                    }
                }
            }
            if (isDispCompanyTotal) {
                if (companyCurrencyTotal.getRow(companyName + currencyName) != null) {
                    dataRow2 = companyCurrencyTotal.getRow(companyName + currencyName);
                    BigDecimal in = (BigDecimal)dataRow2.get("in");
                    dataRow2.put("in", in.add(tmpInAmtTotal));
                    out = (BigDecimal)dataRow2.get("out");
                    dataRow2.put("out", out.add(tmpOutAmtTotal));
                } else {
                    addRow = companyCurrencyTotal.addRow(companyName + currencyName);
                    addRow.put("companyName", companyName);
                    addRow.put("CurrencyName", currencyName);
                    addRow.put("in", tmpInAmtTotal);
                    addRow.put("out", tmpOutAmtTotal);
                }
                if (!companyName.equals(tmpCompanyName)) {
                    rowKeys = companyCurrencyTotal.getRowKeys();
                    for (int i = 0; i < rowKeys.length; ++i) {
                        dataRow = companyCurrencyTotal.getRow(rowKeys[i]);
                        if (!dataRow.get("companyName").equals(tmpCompanyName)) continue;
                        row = tblMain.addRow();
                        row.getCell("companyName").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"272_InnerPileOfMoneyHandler"));
                        row.getCell("currencyName").setValue(dataRow.get("CurrencyName"));
                        row.getCell("outAmount").setValue(dataRow.get("out"));
                        row.getCell("inAmount").setValue(dataRow.get("in"));
                        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
                        companyCurrencyTotal.deleteRow(rowKeys[i]);
                    }
                }
            }
            if (allTotal.getRow(currencyName) != null) {
                dataRow2 = allTotal.getRow(currencyName);
                BigDecimal in = (BigDecimal)dataRow2.get("in");
                dataRow2.put("in", in.add(tmpInAmtTotal));
                out = (BigDecimal)dataRow2.get("out");
                dataRow2.put("out", out.add(tmpOutAmtTotal));
            } else {
                addRow = allTotal.addRow(currencyName);
                addRow.put("CurrencyName", currencyName);
                addRow.put("in", tmpInAmtTotal);
                addRow.put("out", tmpOutAmtTotal);
            }
            row = tblMain.addRow();
            row.getCell("companyName").setValue((Object)rs.getString("companyName"));
            row.getCell("number").setValue((Object)rs.getString("number"));
            row.getCell("bizDate").setValue((Object)rs.getDate("bizDate"));
            String acctId = rs.getString("AcctId");
            InnerAccountInfo innerAccountInfo = (InnerAccountInfo)innerAcctMap.get(acctId);
            row.getCell("payeeBankAcct").setValue((Object)innerAccountInfo.getName());
            row.getCell("currencyName").setValue((Object)rs.getString("CurrencyName"));
            row.getCell("description").setValue((Object)rs.getString("description"));
            row.getCell("inAmount").setValue((Object)rs.getBigDecimal("inAmount"));
            row.getCell("outAmount").setValue((Object)rs.getBigDecimal("outAmount"));
            String sett = rs.getString("cashierId") != null ? EASResource.getString((String)this.resourcePath, (String)"Yes") : EASResource.getString((String)this.resourcePath, (String)"No");
            row.getCell("isSett").setValue((Object)sett);
            tmpCurrencyName = currencyName;
            tmpCompanyName = companyName;
            tmpAcctNum = acctNum;
        }
        if (isDispTotal) {
            rowKeys = acctCurrencyTotal.getRowKeys();
            for (int i = 0; i < rowKeys.length; ++i) {
                dataRow = acctCurrencyTotal.getRow(rowKeys[i]);
                if (!dataRow.get("AcctNum").equals(tmpAcctNum)) continue;
                row = tblMain.addRow();
                row.getCell("companyName").setValue((Object)tmpCompanyName);
                row.getCell("payeeBankAcct").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"271_InnerPileOfMoneyHandler"));
                row.getCell("currencyName").setValue(dataRow.get("CurrencyName"));
                row.getCell("outAmount").setValue(dataRow.get("out"));
                row.getCell("inAmount").setValue(dataRow.get("in"));
                row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                acctCurrencyTotal.deleteRow(rowKeys[i]);
            }
        }
        if (isDispCompanyTotal) {
            rowKeys = companyCurrencyTotal.getRowKeys();
            for (int i = 0; i < rowKeys.length; ++i) {
                dataRow = companyCurrencyTotal.getRow(rowKeys[i]);
                if (!dataRow.get("companyName").equals(tmpCompanyName)) continue;
                row = tblMain.addRow();
                row.getCell("companyName").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"272_InnerPileOfMoneyHandler"));
                row.getCell("currencyName").setValue(dataRow.get("CurrencyName"));
                row.getCell("outAmount").setValue(dataRow.get("out"));
                row.getCell("inAmount").setValue(dataRow.get("in"));
                row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
                companyCurrencyTotal.deleteRow(rowKeys[i]);
            }
        }
        rowKeys = allTotal.getRowKeys();
        for (int i = 0; i < rowKeys.length; ++i) {
            dataRow = allTotal.getRow(rowKeys[i]);
            row = tblMain.addRow();
            row.getCell("companyName").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"273_InnerPileOfMoneyHandler"));
            row.getCell("currencyName").setValue(dataRow.get("CurrencyName"));
            row.getCell("outAmount").setValue(dataRow.get("out"));
            row.getCell("inAmount").setValue(dataRow.get("in"));
            row.getStyleAttributes().setBackground(TOTAL_COLOR);
            allTotal.deleteRow(rowKeys[i]);
        }
    }

    private Map getInnerAcctMap(IRowSet rs) throws SQLException, BOSException {
        HashMap<String, InnerAccountInfo> map = new HashMap<String, InnerAccountInfo>();
        String innerAcctId = null;
        HashSet<String> idSet = new HashSet<String>();
        while (rs.next()) {
            innerAcctId = rs.getString("AcctId");
            idSet.add(innerAcctId);
        }
        rs.beforeFirst();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        InnerAccountCollection coll = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(evi);
        InnerAccountInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            map.put(info.getId().toString(), info);
        }
        return map;
    }

    public void setGroup(KDTable tblMain, boolean isDispTotal, boolean isDispCompanyTotal) {
        IRow row;
        tblMain.setRefresh(false);
        if (tblMain.getRowCount() == 0) {
            return;
        }
        if (!isDispTotal && !isDispCompanyTotal) {
            return;
        }
        BigDecimal outAmtTotal = Constants.ZERO;
        BigDecimal inAmtTotal = Constants.ZERO;
        BigDecimal tmpOutAmtTotal = Constants.ZERO;
        BigDecimal tmpInAmtTotal = Constants.ZERO;
        String currencyName = null;
        String tmpCurrencyName = (String)tblMain.getRow(0).getCell("companyName").getValue();
        String companyName = null;
        String tmpCompanyName = (String)tblMain.getRow(0).getCell("currencyName").getValue();
        int size = tblMain.getRowCount();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            row = tblMain.getRow(i + count);
            currencyName = (String)row.getCell("currencyName").getValue();
            companyName = (String)row.getCell("companyName").getValue();
            tmpInAmtTotal = (BigDecimal)row.getCell("inAmount").getValue();
            if (tmpInAmtTotal == null) {
                tmpInAmtTotal = Constants.ZERO;
            }
            if ((tmpOutAmtTotal = (BigDecimal)row.getCell("outAmount").getValue()) == null) {
                tmpOutAmtTotal = Constants.ZERO;
            }
            if (isDispTotal && !isDispCompanyTotal) {
                if (tmpCurrencyName.equals(currencyName)) {
                    outAmtTotal = outAmtTotal.add(tmpOutAmtTotal);
                    inAmtTotal = inAmtTotal.add(tmpInAmtTotal);
                } else {
                    row = tblMain.addRow(i + ++count);
                    row.getCell("inAmount").setValue((Object)outAmtTotal);
                    row.getCell("outAmount").setValue((Object)inAmtTotal);
                    row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                    row.getCell("companyName").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
                    outAmtTotal = Constants.ZERO;
                    inAmtTotal = Constants.ZERO;
                }
            } else if (tmpCompanyName.equals(companyName)) {
                if (tmpCurrencyName.equals(currencyName)) {
                    outAmtTotal = outAmtTotal.add(tmpOutAmtTotal);
                    inAmtTotal = inAmtTotal.add(tmpInAmtTotal);
                } else {
                    row = tblMain.addRow(i + ++count);
                    row.getCell("inAmount").setValue((Object)outAmtTotal);
                    row.getCell("outAmount").setValue((Object)inAmtTotal);
                    row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                    row.getCell("companyName").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
                    outAmtTotal = Constants.ZERO;
                    inAmtTotal = Constants.ZERO;
                }
            } else {
                row = tblMain.addRow(i + ++count);
                row.getCell("inAmount").setValue((Object)outAmtTotal);
                row.getCell("outAmount").setValue((Object)inAmtTotal);
                row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                row.getCell("companyName").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
                outAmtTotal = Constants.ZERO;
                inAmtTotal = Constants.ZERO;
            }
            tmpCompanyName = companyName;
            tmpCurrencyName = currencyName;
        }
        row = tblMain.addRow(size + ++count);
        row.getCell("inAmount").setValue((Object)outAmtTotal);
        row.getCell("outAmount").setValue((Object)inAmtTotal);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("companyName").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
    }

    public void initStatus(KDTable tblMain, boolean isDispTotal, boolean isDispCompanyTotal) {
        tblMain.setRefresh(false);
        if (tblMain.getRowCount() == 0) {
            return;
        }
        if (!isDispTotal && !isDispCompanyTotal) {
            return;
        }
        tblMain.getColumn("currencyName").setMergeable(false);
        tblMain.getColumn("companyName").setMergeable(false);
        tblMain.getColumn("companyName").setGroup(false);
        tblMain.getColumn("companyName").setStat(false);
        if (isDispCompanyTotal) {
            tblMain.getColumn("companyName").setGroup(true);
            tblMain.getColumn("companyName").setStat(true);
        }
        tblMain.getColumn("currencyName").setGroup(true);
        tblMain.getColumn("currencyName").setStat(true);
        tblMain.getGroupManager().setOrientation(1);
        int i = 0;
        if (isDispCompanyTotal) {
            i = 1;
            IRow row0 = tblMain.getGroupManager().getStatRowTemplate(i - 1);
            row0.getStyleAttributes().setHided(true);
        }
        IRow row1 = tblMain.getGroupManager().getStatRowTemplate(i);
        row1.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row1.getCell("companyName").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
        row1.getCell("inAmount").setExpressions("SUM");
        row1.getCell("outAmount").setExpressions("SUM");
        tblMain.getGroupManager().group();
        tblMain.setRefresh(true);
        tblMain.reLayoutAndPaint();
    }

    public void setCurrencyFormat(KDTable tblMain, InnerPileOfMoneyFilterParam param) {
        String numberFtm = param.getCurrencyId() == null ? "##,###,###,###,###,##0.00" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        tblMain.getColumn("inAmount").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("outAmount").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("inAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("outAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }
}

