/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.client.AbstractPileOfMoneyUI;
import com.kingdee.eas.fm.fs.client.FSAnalysisHandlerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.PileOfMoneyFilterParam;
import com.kingdee.eas.fm.fs.client.PileOfMoneyFilterUI;
import com.kingdee.eas.fm.fs.client.PileOfMoneyHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class PileOfMoneyUI
extends AbstractPileOfMoneyUI {
    private PileOfMoneyFilterUI filterUI;
    private PileOfMoneyHandler handler;
    private static String resourcePath = "com.kingdee.eas.fm.fs.client.PileOfMoneyResource";
    private BankInfo clearingHouse;

    protected void execQuery() throws BOSException {
        PileOfMoneyFilterParam p = (PileOfMoneyFilterParam)this.getFilterParam();
        this.handler = FSAnalysisHandlerFactory.getHandler(p);
        this.txtCurrency.setText(p.getCurrencyName());
        this.txtCurrency.setEditable(false);
        String datePeriod = "";
        datePeriod = p.isByDay() ? Constants.FORMAT_DAY.format(p.getFromDate()) + " - " + Constants.FORMAT_DAY.format(p.getToDate()) : p.getBeginYear() + "-" + p.getBeginMonth() + " - " + p.getEndYear() + "-" + p.getEndMonth();
        this.txtDate.setText(datePeriod);
        this.txtDate.setEditable(false);
        String tempAmount = EASResource.getString((String)resourcePath, (String)"AmountGreater") + p.getInAmount();
        this.txtInAmount.setText(tempAmount);
        this.txtInAmount.setEditable(false);
        tempAmount = EASResource.getString((String)resourcePath, (String)"AmountGreater") + p.getOutAmount();
        this.txtOutAmount.setText(tempAmount);
        this.txtOutAmount.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        IRowSet rs = this.handler.getRowset(this.mainQueryPK, p);
        this.handler.setCurrencyFormat(this.tblMain, p);
        try {
            this.handler.fillDataAndGroup(this.tblMain, rs, p);
        }
        catch (SQLException e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PileOfMoneyFilterUI();
        }
        return this.filterUI;
    }

    private void checkClearHourse(CompanyOrgUnitInfo company) throws Exception {
        if (!FSClientHelper.clearingHouseIsUsed(company.getId().toString())) {
            throw new FSException(FSException.CLEARINGHOUSENOTSETTED);
        }
    }

    private void checkClearHourse() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
    }

    public void onLoad() throws Exception {
        this.checkClearHourse();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        super.onLoad();
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.lblCurrency.getBoundLabelText()).append("&[Currency]&| ").append(this.lblDate.getBoundLabelText()).append("&[dateArea]&|").append(this.lblInAmount.getBoundLabelText()).append("&[inAmount]").append(this.lblOutAmount.getBoundLabelText()).append("&[outAmount]");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Currency", this.txtCurrency.getText());
        map.put("dateArea", this.txtDate.getText());
        map.put("inAmount", this.txtInAmount.getText());
        map.put("outAmount", this.txtOutAmount.getText());
        return map;
    }
}

