/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.IReceiveAccount;
import com.kingdee.eas.fm.fs.ReceiveAcctHelper;
import com.kingdee.eas.fm.fs.client.AbstractReceiveAccountEditUI;
import com.kingdee.eas.fm.fs.client.ReceiveAccountCheckUI;
import com.kingdee.eas.fm.fs.client.ReceiveAccountSettleUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ReceiveAccountEditUI
extends AbstractReceiveAccountEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveAccountEditUI.class);

    public void onLoad() throws Exception {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        super.onLoad();
        ItemAction[] actions = new ItemAction[]{this.actionCheck, this.actionAntiCheck, this.actionBitBack, this.actionSettle, this.actionAntiSettle, this.actionVoucher, this.actionDelVoucher};
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!company.getId().equals((Object)this.editData.getCompany().getId()) || this.getOprtState().equals("FINDVIEW")) {
            this.setActionVisible(actions, false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_review"));
        this.actionAntiCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unreview"));
        this.actionBitBack.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_redclash"));
        this.actionSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_payment"));
        this.actionAntiSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_restore"));
        this.actionViewBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.menuSubmitOption.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuTable1.setVisible(false);
        this.menuTool.setVisible(false);
        this.menuWorkflow.setVisible(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        ItemAction[] actions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionSave, this.actionSubmit, this.actionRemove, this.actionCopy, this.actionAttachment, this.actionCreateTo, this.actionCreateFrom, this.actionAddLine, this.actionInsertLine, this.actionRemoveLine, this.actionPrint, this.actionPrintPreview, this.actionFirst, this.actionPre, this.actionNext, this.actionLast, this.actionTraceUp, this.actionTraceDown, this.actionMultiapprove, this.actionNextPerson, this.actionWorkFlowG};
        boolean isVisible = false;
        this.setActionVisible(actions, isVisible);
        this.cbxIsBackBill.setEnabled(false);
    }

    private void setActionVisible(ItemAction[] actions, boolean isVisible) {
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setVisible(isVisible);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        int prec = this.editData.getCurrency().getPrecision();
        this.txtAmount.setPrecision(prec);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtAmount.setHorizontalAlignment(4);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("FiVouchered");
        sic.add("company.id");
        sic.add("currency.*");
        sic.add("srcSettlementBill.id");
        return sic;
    }

    protected boolean isVoucherVisible() {
        return true;
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        ReceiveAcctHelper.beforeCheck(null, idSet);
        IUIWindow uiWindow = ReceiveAccountCheckUI.showDialogWindows((IUIObject)this, idSet, 1);
    }

    @Override
    public void actionAntiCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        ((IReceiveAccount)this.getBizInterface()).antiCheck(idSet);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    @Override
    public void actionBitBack_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        ReceiveAcctHelper.beforeBackBill(null, idSet);
        IUIWindow uiWindow = ReceiveAccountCheckUI.showDialogWindows((IUIObject)this, idSet, 2);
    }

    @Override
    public void actionSettle_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        ReceiveAcctHelper.beforeSettle(null, idSet);
        IUIWindow uiWindow = ReceiveAccountSettleUI.showDialogWindows((IUIObject)this, idSet);
        ReceiveAccountSettleUI settleUI = (ReceiveAccountSettleUI)uiWindow.getUIObject();
        if (settleUI.getResultColl() != null && !settleUI.getResultColl().isEmpty()) {
            FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        }
    }

    @Override
    public void actionAntiSettle_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        ((IReceiveAccount)this.getBizInterface()).antiSettle(idSet);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        String srcId = this.editData.getSrcSettlementBill().getId().toString();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)srcId, (CompanyOrgUnitInfo)company);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        this.checkObjectExists();
        super.actionVoucher_actionPerformed(e);
        this.afterVoucher();
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        super.actionDelVoucher_actionPerformed(e);
        this.afterVoucher();
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.editData.getId() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    private void afterVoucher() throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
    }
}

