/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.IReceiveAccount;
import com.kingdee.eas.fm.fs.ReceiveAcctHelper;
import com.kingdee.eas.fm.fs.client.AbstractReceiveAccountListUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.ReceiveAccountCheckUI;
import com.kingdee.eas.fm.fs.client.ReceiveAccountFilterUI;
import com.kingdee.eas.fm.fs.client.ReceiveAccountSettleUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceiveAccountListUI
extends AbstractReceiveAccountListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveAccountListUI.class);
    ReceiveAccountFilterUI filterUI;
    private FillListener fillListener = new FillListener();

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void onLoad() throws Exception {
        this.checkEnter();
        super.onLoad();
        this.initDataStatus();
        String dformat = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("submitDate").getStyleAttributes().setNumberFormat(dformat);
    }

    private void checkEnter() throws EASBizException, BOSException {
        if (OprtState.VIEW.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            return;
        }
        FSClientHelper.checkClearingHouseCompany();
    }

    private void initDataStatus() {
        ItemAction[] actions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionAttachment, this.actionCreateTo, this.actionCopyTo, this.actionMultiapprove, this.actionNextPerson, this.actionWorkFlowG, this.actionAuditResult, this.actionViewDoProccess};
        boolean isVisible = false;
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setVisible(isVisible);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_review"));
        this.actionAntiCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unreview"));
        this.actionBitBack.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_redclash"));
        this.actionSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_payment"));
        this.actionAntiSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_restore"));
        this.menuWorkFlow.setVisible(false);
        this.menuTool.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if ("FINDVIEW".equals(this.getOprtState())) {
            return null;
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        return filter;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceiveAccountFilterUI();
        }
        return this.filterUI;
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        ReceiveAcctHelper.beforeCheck(null, idSet);
        IUIWindow uiWindow = ReceiveAccountCheckUI.showDialogWindows((IUIObject)this, idSet, 1);
        ReceiveAccountCheckUI checkUI = (ReceiveAccountCheckUI)uiWindow.getUIObject();
        if (checkUI.getResult() == 1) {
            this.refreshList();
        }
    }

    @Override
    public void actionAntiCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        ArrayList idList = this.getSelectedIdValues();
        ((IReceiveAccount)this.getBizInterface()).antiCheck(FMHelper.list2Set((List)idList));
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        this.refreshList();
    }

    @Override
    public void actionBitBack_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        ReceiveAcctHelper.beforeBackBill(null, idSet);
        IUIWindow uiWindow = ReceiveAccountCheckUI.showDialogWindows((IUIObject)this, FMHelper.list2Set((List)idList), 2);
        ReceiveAccountCheckUI checkUI = (ReceiveAccountCheckUI)uiWindow.getUIObject();
        if (checkUI.getResult() == 1) {
            this.refreshList();
        }
    }

    @Override
    public void actionSettle_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        ReceiveAcctHelper.beforeSettle(null, idSet);
        IUIWindow uiWindow = ReceiveAccountSettleUI.showDialogWindows((IUIObject)this, FMHelper.list2Set((List)idList));
        ReceiveAccountSettleUI settleUI = (ReceiveAccountSettleUI)uiWindow.getUIObject();
        if (settleUI.getResultColl() != null && !settleUI.getResultColl().isEmpty()) {
            FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
            this.refreshList();
        }
    }

    @Override
    public void actionAntiSettle_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        ArrayList idList = this.getSelectedIdValues();
        ((IReceiveAccount)this.getBizInterface()).antiSettle(FMHelper.list2Set((List)idList));
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        this.refreshList();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            ReceiveAcctHelper.setListUITable(ReceiveAccountListUI.this.tblMain, e);
        }
    }
}

