/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.DoForRecPayEnum;
import com.kingdee.eas.fm.fs.IReceiveAccount;
import com.kingdee.eas.fm.fs.ReceiveAccountCollection;
import com.kingdee.eas.fm.fs.ReceiveAccountFactory;
import com.kingdee.eas.fm.fs.ReceiveAccountInfo;
import com.kingdee.eas.fm.fs.SendRecAcctTypeEnum;
import com.kingdee.eas.fm.fs.client.AbstractReceiveAccountSettleUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettlementBillHandler;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ReceiveAccountSettleUI
extends AbstractReceiveAccountSettleUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveAccountSettleUI.class);
    private static final String ID_SET = "idSet";
    private static final String ID = "id";
    private static final String TYPE = "bizType";
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency.id";
    private static final String CURRENCY_NAME = "currency.name";
    private static final String AMOUNT = "amount";
    private static final String CHBANK_ACCT = "accountBank";
    private static final String BALANCE = "balance";
    private static final String SETTLE_TYPE = "settleType";
    private static final String SETTLE_NUM = "settleNumber";
    private SettlementBillHandler handler = SettlementBillHandler.create();
    private ReceiveAccountCollection coll = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIProp();
        Set idSet = (Set)this.getUIContext().get(ID_SET);
        this.fillData(idSet);
    }

    private void initUIProp() throws EASBizException, BOSException {
        this.btnSettle.setIcon(EASResource.getIcon((String)"imgTbtn_payment"));
        this.btnCommit2BE.setVisible(false);
        this.btnWriteOff.setVisible(false);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(CHBANK_ACCT).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(SETTLE_TYPE).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(SETTLE_NUM).getStyleAttributes().setLocked(false);
        KDBizPromptBox editor = new KDBizPromptBox();
        editor.setEditable(true);
        editor.setDisplayFormat("$name$");
        editor.setEditFormat("$number$");
        editor.setCommitFormat("$number$");
        editor.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)editor);
        this.tblMain.getColumn(CHBANK_ACCT).setEditor((ICellEditor)cellEditor);
        KDBizPromptBox editor2 = new KDBizPromptBox();
        editor2.setEditable(true);
        editor2.setDisplayFormat("$name$");
        editor2.setEditFormat("$number$");
        editor2.setCommitFormat("$number$");
        editor2.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7SettlementTypeQuery");
        KDTDefaultCellEditor cellEditor2 = new KDTDefaultCellEditor((IKDEditor)editor2);
        this.tblMain.getColumn(SETTLE_TYPE).setEditor((ICellEditor)cellEditor2);
        KDTextField editor3 = new KDTextField();
        editor3.setMaxLength(80);
        cellEditor = new KDTDefaultCellEditor((JTextField)editor3);
        this.tblMain.getColumn(SETTLE_NUM).setEditor((ICellEditor)cellEditor);
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        int bankAcctColIndex = this.tblMain.getColumn(CHBANK_ACCT).getColumnIndex();
        int settleTypeColIndex = this.tblMain.getColumn(SETTLE_TYPE).getColumnIndex();
        if (colIndex != bankAcctColIndex && colIndex != settleTypeColIndex) {
            return;
        }
        KDBizPromptBox prmtBox = (KDBizPromptBox)((KDTDefaultCellEditor)this.tblMain.getColumn(colIndex).getEditor()).getComponent();
        if (colIndex == bankAcctColIndex) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.tblMain.getRow(rowIndex).getCell(CURRENCY).getValue();
            ReceiveAccountInfo info = (ReceiveAccountInfo)this.tblMain.getRow(rowIndex).getUserObject();
            if (info != null && info.getType().equals((Object)SendRecAcctTypeEnum.OUTERSETTLE) && info.getDoForRecPay().equals((Object)DoForRecPayEnum.PAY)) {
                this.setBankAcctF7(prmtBox, currencyInfo, true);
            } else {
                this.setBankAcctF7(prmtBox, currencyInfo, false);
            }
        } else if (colIndex == settleTypeColIndex) {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            prmtBox.setEntityViewInfo(evi);
        }
    }

    public void setBankAcctF7(KDBizPromptBox f7BankAcct, CurrencyInfo currencyInfo, boolean filterAccount) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.*"));
        f7BankAcct.setSelectorCollection(sic);
        BankInfo clearingHouse = FSClientHelper.getClearingHouse();
        String chId = clearingHouse.getId().toString();
        String chCompanyId = clearingHouse.getRelatedCompany().getId().toString();
        FilterInfo filter = new FilterInfo();
        if (filterAccount) {
            filter.getFilterItems().add(new FilterItemInfo("notOutPay", (Object)Constants.FALSE));
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)chCompanyId));
        filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)chId, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        FilterInfo filterCurrency = new FilterInfo();
        filterCurrency.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)Boolean.FALSE));
        filterCurrency.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)Boolean.TRUE));
        filterCurrency.getFilterItems().add(new FilterItemInfo(CURRENCY, (Object)currencyInfo.getId().toString()));
        filterCurrency.setMaskString("#0 OR (#1 AND #2)");
        filter.mergeFilter(filterCurrency, "AND");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        f7BankAcct.setEntityViewInfo(evi);
    }

    protected void tblMain_editStarted(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex != this.tblMain.getColumn(CHBANK_ACCT).getColumnIndex() && colIndex != this.tblMain.getColumn(SETTLE_TYPE).getColumnIndex()) {
            return;
        }
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        CurrencyInfo currencyInfo = (CurrencyInfo)this.tblMain.getRow(rowIndex).getCell(CURRENCY).getValue();
        AccountBankInfo acctBankInfo = (AccountBankInfo)this.tblMain.getRow(rowIndex).getCell(CHBANK_ACCT).getValue();
        if (colIndex == this.tblMain.getColumn(CHBANK_ACCT).getColumnIndex()) {
            BigDecimal balance = this.handler.getBalanceValue(currencyInfo, acctBankInfo);
            this.tblMain.getRow(rowIndex).getCell(BALANCE).setValue((Object)balance);
        }
        if (rowIndex == 0) {
            IRow row = null;
            BigDecimal balance = (BigDecimal)this.tblMain.getRow(rowIndex).getCell(BALANCE).getValue();
            SettlementTypeInfo settleType = (SettlementTypeInfo)this.tblMain.getRow(rowIndex).getCell(SETTLE_TYPE).getValue();
            int count = this.tblMain.getRowCount();
            for (int i = rowIndex + 1; i < count; ++i) {
                row = this.tblMain.getRow(i);
                row.getCell(CHBANK_ACCT).setValue((Object)acctBankInfo);
                row.getCell(BALANCE).setValue((Object)balance);
                row.getCell(SETTLE_TYPE).setValue((Object)settleType);
            }
        }
    }

    private void fillData(Set idSet) throws BOSException, EASBizException {
        ReceiveAccountCollection coll = this.getColl(idSet);
        ReceiveAccountInfo info = null;
        String currencyID = null;
        AccountBankInfo acctBankInfo = null;
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            info = coll.get(i);
            acctBankInfo = info.getAccountBank();
            currencyID = info.getCurrency().getId().toString();
            FMClientHelper.setNumberFormat((IRow)row, (String)AMOUNT, (String)currencyID);
            FMClientHelper.setNumberFormat((IRow)row, (String)BALANCE, (String)currencyID);
            row.setUserObject((Object)info);
            row.getCell(ID).setValue((Object)info.getId().toString());
            row.getCell(TYPE).setValue((Object)info.getSrcSettlementBill().getType());
            row.getCell(NUMBER).setValue((Object)info.getNumber());
            row.getCell(CURRENCY).setValue((Object)info.getCurrency());
            row.getCell(CURRENCY_NAME).setValue((Object)info.getCurrency().getName());
            row.getCell(AMOUNT).setValue((Object)info.getAmount());
            row.getCell(CHBANK_ACCT).setValue((Object)info.getAccountBank());
            row.getCell(SETTLE_TYPE).setValue((Object)info.getSettlementType());
            row.getCell(SETTLE_NUM).setValue((Object)info.getSettleNumber());
            BigDecimal balance = this.handler.getBalanceValue(info.getCurrency(), acctBankInfo);
            row.getCell(BALANCE).setValue((Object)balance);
        }
    }

    private ReceiveAccountCollection getColl(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("srcSettlementBill.type"));
        evi.getSelector().add(new SelectorItemInfo("currency.*"));
        evi.getSelector().add(new SelectorItemInfo("accountBank.id"));
        evi.getSelector().add(new SelectorItemInfo("accountBank.number"));
        evi.getSelector().add(new SelectorItemInfo("accountBank.name"));
        evi.getSelector().add(new SelectorItemInfo("settlementType.id"));
        evi.getSelector().add(new SelectorItemInfo("settlementType.number"));
        evi.getSelector().add(new SelectorItemInfo("settlementType.name"));
        evi.getSelector().add(new SelectorItemInfo("accountBank.company.*"));
        IReceiveAccount iReceiveAcct = ReceiveAccountFactory.getRemoteInstance();
        return iReceiveAcct.getReceiveAccountCollection(evi);
    }

    @Override
    protected void btnSettle_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.coll = this.buildRecAcctColl(this.tblMain);
        IReceiveAccount iReceiveAcct = ReceiveAccountFactory.getRemoteInstance();
        iReceiveAcct.settle(this.coll, 30);
        FMClientHelper.showSuccessInfo((Component)((Object)this), (Component)((Component)e.getSource()));
        this.disposeUIWindow();
    }

    public ReceiveAccountCollection getResultColl() {
        return this.coll;
    }

    private void verify() {
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblMain, (String)CHBANK_ACCT);
    }

    private ReceiveAccountCollection buildRecAcctColl(KDTable table) {
        ReceiveAccountInfo info = null;
        ReceiveAccountCollection coll = new ReceiveAccountCollection();
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            info = new ReceiveAccountInfo();
            info.setId(BOSUuid.read((String)row.getCell(ID).getValue().toString()));
            info.setAccountBank((AccountBankInfo)row.getCell(CHBANK_ACCT).getValue());
            info.setSettlementType((SettlementTypeInfo)row.getCell(SETTLE_TYPE).getValue());
            info.setSettleNumber((String)row.getCell(SETTLE_NUM).getValue());
            coll.add(info);
        }
        return coll;
    }

    public static IUIWindow showDialogWindows(IUIObject ui, Set idSet) throws UIException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)ID_SET, (Object)idSet);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceiveAccountSettleUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        return uiWindow;
    }
}

