/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.AbstractSettleLedgerHandler;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettleLedgerFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class SettleLedgerByPeriodHandler
extends AbstractSettleLedgerHandler {
    private static final String PROJECT = "Project";
    private final String COL_TOTAL = "total";
    private final String COL_CURRENCY = "currency";
    private final String COL_ITEM = "item";
    private String resourcePath = "com.kingdee.eas.fm.fs.client.SettleLedgerResource";

    @Override
    public void initTree(KDTree treeList, SettleLedgerFilterParam param) {
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        FSClientHelper.fillPeriodTree(treeList, CycleTypeEnum.MONTH, beginYear, beginMonth, endYear, endMonth);
    }

    @Override
    public void initTable(KDTable tblMain, SettleLedgerFilterParam param) throws BOSException {
        super.initTable(tblMain, param);
        String column_project = EASResource.getString((String)this.resourcePath, (String)"InnerAcct");
        tblMain.getHead().getRow(0).getCell(1).setValue((Object)column_project);
    }

    public void _initTable(KDTable tblMain, SettleLedgerFilterParam param) throws BOSException {
        String column_item = EASResource.getString((String)this.resourcePath, (String)"Item");
        String column_currency = EASResource.getString((String)this.resourcePath, (String)"Currency");
        String column_total = EASResource.getString((String)this.resourcePath, (String)"Total");
        IRow headRow = tblMain.addHeadRow();
        IRow headRow2 = tblMain.addHeadRow();
        tblMain.addColumn().setKey("item");
        tblMain.addColumn().setKey("currency");
        headRow.getCell("item").setValue((Object)column_item);
        headRow2.getCell("item").setValue((Object)column_item);
        headRow.getCell("currency").setValue((Object)column_currency);
        headRow2.getCell("currency").setValue((Object)column_currency);
        CompanyOrgUnitCollection coll = null;
        coll = FMClientHelper.getCompanyOrgUnitCollection((String[])param.getCompanyIdAry());
        int left = 2;
        int right = 2;
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo company = coll.get(i);
            String companyID = company.getId().toString();
            InnerAccountCollection iac = FSClientHelper.getInnerAccountCollection(companyID);
            if (iac == null) continue;
            for (int j = 0; j < iac.size(); ++j) {
                InnerAccountInfo innerAccountInfo = iac.get(j);
                String innerAccountID = innerAccountInfo.getId().toString();
                IColumn column = tblMain.addColumn();
                column.setKey(innerAccountID);
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                headRow.getCell(innerAccountID).setValue((Object)company.getName());
                headRow2.getCell(innerAccountID).setValue((Object)innerAccountInfo.getName());
            }
            right = left + iac.size() - 1;
            tblMain.getHeadMergeManager().mergeBlock(0, left, 0, right);
            left += iac.size();
        }
        if (left == 2) {
            tblMain.removeColumns();
            tblMain.removeHeadRows();
            MsgBox.showInfo((String)EASResource.getString((String)this.resourcePath, (String)"NoneInnerAccount"));
            SysUtil.abort();
        }
        tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        tblMain.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        IColumn column = tblMain.addColumn();
        column.setKey("total");
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        headRow.getCell("total").setValue((Object)column_total);
        headRow2.getCell("total").setValue((Object)column_total);
        tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnCount() - 1, 1, tblMain.getColumnCount() - 1);
    }

    private void fillData(KDTable tblMain, SettleLedgerFilterParam param, CycleRangeInfo period, EntityViewInfo mainQuery, IMetaDataPK mainQueryPK) throws Exception {
        String column_settlementAmount = EASResource.getString((String)this.resourcePath, (String)"SettlementAmount");
        String column_settlementMoney = EASResource.getString((String)this.resourcePath, (String)"SettlementMoney");
        int year = period.getYear();
        int month = period.getMonth();
        String cid = param.getCurrencyId();
        IRow row = null;
        IRow row2 = null;
        HashMap currencyMap = new HashMap();
        HashMap<String, IRow> rowMap = new HashMap<String, IRow>();
        EntityViewInfo evi = (EntityViewInfo)mainQuery.clone();
        FilterInfo fi = evi.getFilter();
        fi.getFilterItems().add(new FilterItemInfo("fyear", (Object)new Integer(year)));
        fi.getFilterItems().add(new FilterItemInfo("fmonth", (Object)new Integer(month)));
        evi.setFilter(fi);
        IRowSet rowSet = this.getRowSet(mainQueryPK, evi);
        while (rowSet.next()) {
            String currencyID = rowSet.getString("CURRENCYID");
            if (!currencyMap.containsKey(currencyID)) {
                row = tblMain.addRow();
                row2 = tblMain.addRow();
                row.getCell("item").setValue((Object)column_settlementAmount);
                row2.getCell("item").setValue((Object)column_settlementMoney);
                row.getCell("currency").setValue((Object)this.getCurrencyName(currencyID));
                row2.getCell("currency").setValue((Object)this.getCurrencyName(currencyID));
                rowMap.put("AmountRow", row);
                rowMap.put("MoneyRow", row2);
                currencyMap.put(currencyID, rowMap);
            } else {
                row = (IRow)((Map)currencyMap.get(currencyID)).get("AmountRow");
                row2 = (IRow)((Map)currencyMap.get(currencyID)).get("MoneyRow");
            }
            if (row.getCell(rowSet.getString("INNERACCOUNTID")) == null) continue;
            BigDecimal settleAmount = rowSet.getBigDecimal("SETTLEMENTAMOUNT");
            row.getCell(rowSet.getString("INNERACCOUNTID")).setValue((Object)settleAmount);
            this.calculateTotal(row, settleAmount);
            this.setNumberFormat(row2, rowSet.getString("INNERACCOUNTID"), currencyID);
            this.setNumberFormat(row2, "total", currencyID);
            BigDecimal settleMoney = rowSet.getBigDecimal("SETTLEMENTMONEY");
            row2.getCell(rowSet.getString("INNERACCOUNTID")).setValue((Object)settleMoney);
            this.calculateTotal(row2, settleMoney);
        }
    }

    private void calculateTotal(IRow row, BigDecimal settleMoney) {
        BigDecimal currencyMoney = (BigDecimal)row.getCell("total").getValue();
        if (currencyMoney == null) {
            currencyMoney = Constants.ZERO;
        }
        if (settleMoney == null) {
            settleMoney = Constants.ZERO;
        }
        row.getCell("total").setValue((Object)currencyMoney.add(settleMoney));
    }

    @Override
    public void fillData(KDTable tblMain, SettleLedgerFilterParam param, Object condition, EntityViewInfo mainQuery, IMetaDataPK mainQueryPK) throws Exception {
        IRow row = null;
        EntityViewInfo evi = (EntityViewInfo)mainQuery.clone();
        FilterInfo fi = evi.getFilter();
        evi.getSorter().add(new SorterItemInfo("applyUnit.name"));
        evi.getSorter().add(new SorterItemInfo("innerAccount.name"));
        HashSet<Integer> settleSet = new HashSet<Integer>(4);
        settleSet.add(new Integer(1));
        settleSet.add(new Integer(2));
        settleSet.add(new Integer(3));
        settleSet.add(new Integer(4));
        fi.getFilterItems().add(new FilterItemInfo("bizType", settleSet, CompareType.INCLUDE));
        IMetaDataPK queryPK = mainQueryPK;
        if (condition instanceof CycleRangeInfo) {
            CycleRangeInfo period = (CycleRangeInfo)condition;
            int year = period.getYear();
            int month = period.getMonth();
            fi.getFilterItems().add(new FilterItemInfo("fyear", (Object)new Integer(year)));
            fi.getFilterItems().add(new FilterItemInfo("fmonth", (Object)new Integer(month)));
        } else {
            int beginYear = param.getBeginYear();
            int beginMonth = param.getBeginMonth();
            int endYear = param.getEndYear();
            int endMonth = param.getEndMonth();
            FilterInfo filter = new FilterInfo();
            String beginDate = "" + beginYear + "-" + beginMonth;
            String endDate = "" + endYear + "-" + endMonth;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date endDate1 = sdf.parse(endDate);
            filter.getFilterItems().add(new FilterItemInfo("date", (Object)sdf.parse(beginDate), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("date", (Object)DateUtil.getAfterDay((Date)DateUtil.getLastDayOfMonth((Date)endDate1)), CompareType.LESS));
            fi.mergeFilter(filter, "and");
            tblMain.getColumn("currency").setGroup(true);
            tblMain.getColumn("currency").setMergeable(true);
            tblMain.getColumn(PROJECT).setGroup(true);
            tblMain.getColumn(PROJECT).setMergeable(true);
            queryPK = new MetaDataPK("com.kingdee.eas.fm.fs", "SettleLedger1Query");
        }
        evi.setFilter(fi);
        IRowSet rowSet = this.getRowSet(queryPK, evi);
        int i = 0;
        HashMap map = new HashMap();
        HashMap sMap = new HashMap();
        String currentUnitName = null;
        String innerAccount = null;
        while (rowSet.next()) {
            innerAccount = rowSet.getString("innerAccount.name");
            String currencyID = rowSet.getString("CURRENCYID");
            String currencyName = rowSet.getString("CURRENCYNAME");
            if (!(condition instanceof CycleRangeInfo)) {
                if (currentUnitName != null && !currentUnitName.equals(rowSet.getString("applyUnit.name"))) {
                    i = this.addSmallRow(i, tblMain, sMap);
                    sMap = new HashMap();
                }
                this.calculateSmallTotal(tblMain, sMap, currencyID, currencyName, rowSet);
                currentUnitName = rowSet.getString("applyUnit.name");
            }
            row = tblMain.addRow(i);
            int settleAmount = rowSet.getInt("SETTLEMENTAMOUNT");
            BigDecimal settleMoney = rowSet.getBigDecimal("SETTLEMENTMONEY");
            row.getCell(PROJECT).setValue((Object)innerAccount);
            row.getCell("APPLYUNIT").setValue((Object)rowSet.getString("applyUnit.name"));
            row.getCell("currency").setValue((Object)currencyName);
            row.getCell("settlementAmount").setValue((Object)new Integer(settleAmount));
            row.getCell("settlementMoney").setValue((Object)settleMoney);
            settleAmount = rowSet.getInt("outterInSettlementAmount");
            row.getCell("outterInSettlementAmount").setValue((Object)new Integer(settleAmount));
            settleMoney = rowSet.getBigDecimal("outterInSettlementMoney");
            row.getCell("outterInSettlementMoney").setValue((Object)settleMoney);
            settleAmount = rowSet.getInt("outeroutSettlementAmount");
            row.getCell("outeroutSettlementAmount").setValue((Object)new Integer(settleAmount));
            settleMoney = rowSet.getBigDecimal("outteroutSettlementMoney");
            row.getCell("outeroutSettlementMoney").setValue((Object)settleMoney);
            settleAmount = rowSet.getInt("innerInSettlementAmount");
            row.getCell("innerInSettlementAmount").setValue((Object)new Integer(settleAmount));
            settleMoney = rowSet.getBigDecimal("innerInSettlementMoney");
            row.getCell("innerInSettlementMoney").setValue((Object)settleMoney);
            settleAmount = rowSet.getInt("innerOutSettlementAmount");
            row.getCell("innerOutSettlementAmount").setValue((Object)new Integer(settleAmount));
            settleMoney = rowSet.getBigDecimal("innerOutSettlementMoney");
            row.getCell("innerOutSettlementMoney").setValue((Object)settleMoney);
            this.setNumberFormat(row, "settlementMoney", currencyID);
            this.setNumberFormat(row, "outterInSettlementMoney", currencyID);
            this.setNumberFormat(row, "outeroutSettlementMoney", currencyID);
            this.setNumberFormat(row, "innerInSettlementMoney", currencyID);
            this.setNumberFormat(row, "innerOutSettlementMoney", currencyID);
            this.calculateTotal(tblMain, map, currencyID, currencyName, rowSet);
            ++i;
        }
        if (!(condition instanceof CycleRangeInfo)) {
            this.addSmallRow(i, tblMain, sMap);
        }
        tblMain.getColumn("APPLYUNIT").setGroup(true);
        tblMain.getColumn("APPLYUNIT").setMergeable(true);
    }

    private int addSmallRow(int i, KDTable tblMain, Map map) {
        for (String currencyID : map.keySet()) {
            LedgeBean tempBean = (LedgeBean)map.get(currencyID);
            IRow newRow = tblMain.addRow(i++);
            newRow.getCell("APPLYUNIT").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"SubTotal"));
            this.setNumberFormat(newRow, "settlementMoney", currencyID);
            this.setNumberFormat(newRow, "outterInSettlementMoney", currencyID);
            this.setNumberFormat(newRow, "outeroutSettlementMoney", currencyID);
            this.setNumberFormat(newRow, "innerInSettlementMoney", currencyID);
            this.setNumberFormat(newRow, "innerOutSettlementMoney", currencyID);
            newRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
            newRow.getCell("currency").setValue((Object)tempBean.getCurrency());
            newRow.getCell("settlementAmount").setValue((Object)new Integer(tempBean.getSettlementAmout()));
            newRow.getCell("settlementMoney").setValue((Object)tempBean.getSettlementMoney());
            newRow.getCell("outterInSettlementAmount").setValue((Object)new Integer(tempBean.getOutterInSettlementAmount()));
            newRow.getCell("outterInSettlementMoney").setValue((Object)tempBean.getOutterInSettlementMoney());
            newRow.getCell("outeroutSettlementAmount").setValue((Object)new Integer(tempBean.getOuteroutSettlementAmount()));
            newRow.getCell("outeroutSettlementMoney").setValue((Object)tempBean.getOuteroutSettlementMoney());
            newRow.getCell("innerInSettlementAmount").setValue((Object)new Integer(tempBean.getInnerInSettlementAmount()));
            newRow.getCell("innerInSettlementMoney").setValue((Object)tempBean.getInnerInSettlementMoney());
            newRow.getCell("innerOutSettlementAmount").setValue((Object)new Integer(tempBean.getInnerOutSettlementAmount()));
            newRow.getCell("innerOutSettlementMoney").setValue((Object)tempBean.getInnerOutSettlementMoney());
        }
        return i;
    }

    private void calculateSmallTotal(KDTable tblMain, Map map, String currencyID, String currencyName, IRowSet rowSet) throws SQLException {
        int settleAmount = rowSet.getInt("SETTLEMENTAMOUNT");
        BigDecimal settleMoney = rowSet.getBigDecimal("SETTLEMENTMONEY");
        settleMoney = settleMoney == null ? Constants.ZERO : settleMoney;
        int outterInSettlementAmount = rowSet.getInt("outterInSettlementAmount");
        BigDecimal outterInSettlementMoney = rowSet.getBigDecimal("outterInSettlementMoney");
        outterInSettlementMoney = outterInSettlementMoney == null ? Constants.ZERO : outterInSettlementMoney;
        int outeroutSettlementAmount = rowSet.getInt("outeroutSettlementAmount");
        BigDecimal outteroutSettlementMoney = rowSet.getBigDecimal("outteroutSettlementMoney");
        outteroutSettlementMoney = outteroutSettlementMoney == null ? Constants.ZERO : outteroutSettlementMoney;
        int innerInSettlementAmount = rowSet.getInt("innerInSettlementAmount");
        BigDecimal innerInSettlementMoney = rowSet.getBigDecimal("innerInSettlementMoney");
        innerInSettlementMoney = innerInSettlementMoney == null ? Constants.ZERO : innerInSettlementMoney;
        int innerOutSettlementAmount = rowSet.getInt("innerOutSettlementAmount");
        BigDecimal innerOutSettlementMoney = rowSet.getBigDecimal("innerOutSettlementMoney");
        innerOutSettlementMoney = innerOutSettlementMoney == null ? Constants.ZERO : innerOutSettlementMoney;
        String column_total = EASResource.getString((String)this.resourcePath, (String)"Total");
        LedgeBean bean = (LedgeBean)map.get(currencyID);
        if (bean == null) {
            bean = new LedgeBean();
            bean.setCurrency(currencyName);
            bean.setSettlementAmout(settleAmount);
            bean.setSettlementMoney(settleMoney);
            bean.setOutterInSettlementAmount(outterInSettlementAmount);
            bean.setOutterInSettlementMoney(outterInSettlementMoney);
            bean.setOuteroutSettlementAmount(outeroutSettlementAmount);
            bean.setOuteroutSettlementMoney(outteroutSettlementMoney);
            bean.setInnerInSettlementAmount(innerInSettlementAmount);
            bean.setInnerInSettlementMoney(innerInSettlementMoney);
            bean.setInnerOutSettlementAmount(innerOutSettlementAmount);
            bean.setInnerOutSettlementMoney(innerOutSettlementMoney);
            map.put(currencyID, bean);
        } else {
            bean.setSettlementAmout(bean.getSettlementAmout() + settleAmount);
            bean.setSettlementMoney(bean.getSettlementMoney().add(settleMoney));
            bean.setOutterInSettlementAmount(bean.getOutterInSettlementAmount() + outterInSettlementAmount);
            bean.setOutterInSettlementMoney(bean.getOutterInSettlementMoney().add(outterInSettlementMoney));
            bean.setOuteroutSettlementAmount(bean.getOuteroutSettlementAmount() + outeroutSettlementAmount);
            bean.setOuteroutSettlementMoney(bean.getOuteroutSettlementMoney().add(outteroutSettlementMoney));
            bean.setInnerInSettlementAmount(bean.getInnerInSettlementAmount() + innerInSettlementAmount);
            bean.setInnerInSettlementMoney(bean.getInnerInSettlementMoney().add(innerInSettlementMoney));
            bean.setInnerOutSettlementAmount(bean.getInnerOutSettlementAmount() + innerOutSettlementAmount);
            bean.setInnerOutSettlementMoney(bean.getInnerOutSettlementMoney().add(innerOutSettlementMoney));
        }
    }

    private void calculateTotal(KDTable tblMain, Map map, String currencyID, String currencyName, IRowSet rowSet) throws SQLException {
        int settleAmount = rowSet.getInt("SETTLEMENTAMOUNT");
        BigDecimal settleMoney = rowSet.getBigDecimal("SETTLEMENTMONEY");
        settleMoney = settleMoney == null ? Constants.ZERO : settleMoney;
        int outterInSettlementAmount = rowSet.getInt("outterInSettlementAmount");
        BigDecimal outterInSettlementMoney = rowSet.getBigDecimal("outterInSettlementMoney");
        outterInSettlementMoney = outterInSettlementMoney == null ? Constants.ZERO : outterInSettlementMoney;
        int outeroutSettlementAmount = rowSet.getInt("outeroutSettlementAmount");
        BigDecimal outteroutSettlementMoney = rowSet.getBigDecimal("outteroutSettlementMoney");
        outteroutSettlementMoney = outteroutSettlementMoney == null ? Constants.ZERO : outteroutSettlementMoney;
        int innerInSettlementAmount = rowSet.getInt("innerInSettlementAmount");
        BigDecimal innerInSettlementMoney = rowSet.getBigDecimal("innerInSettlementMoney");
        innerInSettlementMoney = innerInSettlementMoney == null ? Constants.ZERO : innerInSettlementMoney;
        int innerOutSettlementAmount = rowSet.getInt("innerOutSettlementAmount");
        BigDecimal innerOutSettlementMoney = rowSet.getBigDecimal("innerOutSettlementMoney");
        innerOutSettlementMoney = innerOutSettlementMoney == null ? Constants.ZERO : innerOutSettlementMoney;
        String column_total = EASResource.getString((String)this.resourcePath, (String)"Total");
        IRow row = (IRow)map.get(currencyID);
        if (row == null) {
            IRow newRow = tblMain.addRow();
            this.setNumberFormat(newRow, "settlementMoney", currencyID);
            this.setNumberFormat(newRow, "outterInSettlementMoney", currencyID);
            this.setNumberFormat(newRow, "outeroutSettlementMoney", currencyID);
            this.setNumberFormat(newRow, "innerInSettlementMoney", currencyID);
            this.setNumberFormat(newRow, "innerOutSettlementMoney", currencyID);
            newRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
            map.put(currencyID, newRow);
            if (map.size() == 1) {
                newRow.getCell("APPLYUNIT").setValue((Object)column_total);
            }
            newRow.getCell("currency").setValue((Object)currencyName);
            newRow.getCell("settlementAmount").setValue((Object)new Integer(settleAmount));
            newRow.getCell("settlementMoney").setValue((Object)settleMoney);
            newRow.getCell("outterInSettlementAmount").setValue((Object)new Integer(outterInSettlementAmount));
            newRow.getCell("outterInSettlementMoney").setValue((Object)outterInSettlementMoney);
            newRow.getCell("outeroutSettlementAmount").setValue((Object)new Integer(outeroutSettlementAmount));
            newRow.getCell("outeroutSettlementMoney").setValue((Object)outteroutSettlementMoney);
            newRow.getCell("innerInSettlementAmount").setValue((Object)new Integer(innerInSettlementAmount));
            newRow.getCell("innerInSettlementMoney").setValue((Object)innerInSettlementMoney);
            newRow.getCell("innerOutSettlementAmount").setValue((Object)new Integer(innerOutSettlementAmount));
            newRow.getCell("innerOutSettlementMoney").setValue((Object)innerOutSettlementMoney);
        } else {
            Integer currencyAmount = (Integer)row.getCell("settlementAmount").getValue();
            row.getCell("settlementAmount").setValue((Object)new Integer(currencyAmount + settleAmount));
            BigDecimal currencyMoney = (BigDecimal)row.getCell("settlementMoney").getValue();
            row.getCell("settlementMoney").setValue((Object)currencyMoney.add(settleMoney));
            currencyAmount = (Integer)row.getCell("outterInSettlementAmount").getValue();
            row.getCell("outterInSettlementAmount").setValue((Object)new Integer(currencyAmount + outterInSettlementAmount));
            currencyMoney = (BigDecimal)row.getCell("outterInSettlementMoney").getValue();
            row.getCell("outterInSettlementMoney").setValue((Object)currencyMoney.add(outterInSettlementMoney));
            currencyAmount = (Integer)row.getCell("outeroutSettlementAmount").getValue();
            row.getCell("outeroutSettlementAmount").setValue((Object)new Integer(currencyAmount + outeroutSettlementAmount));
            currencyMoney = (BigDecimal)row.getCell("outeroutSettlementMoney").getValue();
            row.getCell("outeroutSettlementMoney").setValue((Object)currencyMoney.add(outteroutSettlementMoney));
            currencyAmount = (Integer)row.getCell("innerInSettlementAmount").getValue();
            row.getCell("innerInSettlementAmount").setValue((Object)new Integer(currencyAmount + innerInSettlementAmount));
            currencyMoney = (BigDecimal)row.getCell("innerInSettlementMoney").getValue();
            row.getCell("innerInSettlementMoney").setValue((Object)currencyMoney.add(innerInSettlementMoney));
            currencyAmount = (Integer)row.getCell("innerOutSettlementAmount").getValue();
            row.getCell("innerOutSettlementAmount").setValue((Object)new Integer(currencyAmount + innerOutSettlementAmount));
            currencyMoney = (BigDecimal)row.getCell("innerOutSettlementMoney").getValue();
            row.getCell("innerOutSettlementMoney").setValue((Object)currencyMoney.add(innerOutSettlementMoney));
        }
    }

    protected IRowSet getInitRowSet(String currencyId) throws BOSException {
        Object acctInfo = null;
        Object companyInfo = null;
        StringBuffer sqlBuf = new StringBuffer(8);
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sqlBuf.append("select sum(isnull(a.FDebitCounts,0)+isnull(a.FCreditCounts,0)) as SETTLEMENTAMOUNT, ");
        sqlBuf.append(" sum(isnull(a.FDebitTotal,0)+isnull(a.FCreditTotal,0)) as SETTLEMENTMONEY, ");
        sqlBuf.append("year(a.FBizDate) as fyear,month(a.FBizDate) as fmonth,");
        sqlBuf.append(" b.FName_").append(this.loc).append("  as currencyName, b.fid as CURRENCYID, ");
        sqlBuf.append(" a.FInnerAccountId as INNERACCOUNTID");
        sqlBuf.append(" from t_fs_summaryLedger a ");
        sqlBuf.append("INNER JOIN T_BD_Currency AS b  on a.FCurrencyID = b.FID");
        sqlBuf.append(" where a.FBizDate<{");
        sqlBuf.append(this.getOpenDate());
        sqlBuf.append("}");
        if (currencyId != null) {
            sqlBuf.append(" and a.FCurrencyId='");
            sqlBuf.append(currencyId);
            sqlBuf.append("'");
        }
        sqlBuf.append(" and  FBizType in (1,2,3,4) ");
        sqlBuf.append("'");
        sqlBuf.append(" group by year(a.FBizDate),month(a.FBizDate),b.FName_").append(this.loc).append(" ,b.fid,a.FInnerAccountId  ");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sqlBuf.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }

    private class LedgeBean {
        private String applyUnit;
        private String innerAccount;
        private String currency;
        private int settlementAmout;
        private BigDecimal settlementMoney;
        private int outterInSettlementAmount;
        private BigDecimal outterInSettlementMoney;
        private int outeroutSettlementAmount;
        private BigDecimal outeroutSettlementMoney;
        private int innerInSettlementAmount;
        private BigDecimal innerInSettlementMoney;
        private int innerOutSettlementAmount;
        private BigDecimal innerOutSettlementMoney;

        private LedgeBean() {
        }

        public String getApplyUnit() {
            return this.applyUnit;
        }

        public void setApplyUnit(String applyUnit) {
            this.applyUnit = applyUnit;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public String getInnerAccount() {
            return this.innerAccount;
        }

        public void setInnerAccount(String innerAccount) {
            this.innerAccount = innerAccount;
        }

        public int getInnerInSettlementAmount() {
            return this.innerInSettlementAmount;
        }

        public void setInnerInSettlementAmount(int innerInSettlementAmount) {
            this.innerInSettlementAmount = innerInSettlementAmount;
        }

        public BigDecimal getInnerInSettlementMoney() {
            return this.innerInSettlementMoney;
        }

        public void setInnerInSettlementMoney(BigDecimal innerInSettlementMoney) {
            this.innerInSettlementMoney = innerInSettlementMoney;
        }

        public int getInnerOutSettlementAmount() {
            return this.innerOutSettlementAmount;
        }

        public void setInnerOutSettlementAmount(int innerOutSettlementAmount) {
            this.innerOutSettlementAmount = innerOutSettlementAmount;
        }

        public BigDecimal getInnerOutSettlementMoney() {
            return this.innerOutSettlementMoney;
        }

        public void setInnerOutSettlementMoney(BigDecimal innerOutSettlementMoney) {
            this.innerOutSettlementMoney = innerOutSettlementMoney;
        }

        public int getOuteroutSettlementAmount() {
            return this.outeroutSettlementAmount;
        }

        public void setOuteroutSettlementAmount(int outeroutSettlementAmount) {
            this.outeroutSettlementAmount = outeroutSettlementAmount;
        }

        public BigDecimal getOuteroutSettlementMoney() {
            return this.outeroutSettlementMoney;
        }

        public void setOuteroutSettlementMoney(BigDecimal outeroutSettlementMoney) {
            this.outeroutSettlementMoney = outeroutSettlementMoney;
        }

        public int getOutterInSettlementAmount() {
            return this.outterInSettlementAmount;
        }

        public void setOutterInSettlementAmount(int outterInSettlementAmount) {
            this.outterInSettlementAmount = outterInSettlementAmount;
        }

        public BigDecimal getOutterInSettlementMoney() {
            return this.outterInSettlementMoney;
        }

        public void setOutterInSettlementMoney(BigDecimal outterInSettlementMoney) {
            this.outterInSettlementMoney = outterInSettlementMoney;
        }

        public int getSettlementAmout() {
            return this.settlementAmout;
        }

        public void setSettlementAmout(int settlementAmout) {
            this.settlementAmout = settlementAmout;
        }

        public BigDecimal getSettlementMoney() {
            return this.settlementMoney;
        }

        public void setSettlementMoney(BigDecimal settlementMoney) {
            this.settlementMoney = settlementMoney;
        }
    }
}

