/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.AbstractSettleLedgerFilterUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettleLedgerFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;

public class SettleLedgerFilterUI
extends AbstractSettleLedgerFilterUI {
    CompanyOrgUnitCollection coll;
    private String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";

    protected void init() throws Exception {
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        if (this.coll == null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("id");
            this.coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
        }
        super.init();
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndMonth);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        SettleLedgerFilterParam param = new SettleLedgerFilterParam();
        String[] companyIds = this.getCompanyIds();
        param.setCompanyIdAry(companyIds);
        if (this.cboCurrency.getSelectedItem().equals(FMSysDefinedEnum.SELECT_ALL)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        }
        param.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        param.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        param.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        param.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        param.setByCompany(this.rdbCompany.isSelected());
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof SettleLedgerFilterParam)) {
            return;
        }
        SettleLedgerFilterParam settleLedgerFilterParam = (SettleLedgerFilterParam)param;
        String[] companyIds = settleLedgerFilterParam.getCompanyIdAry();
        this.setCompanyIds(companyIds);
        String currencyId = settleLedgerFilterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.rdbCompany.setSelected(settleLedgerFilterParam.isByCompany());
        this.rdbPeriod.setSelected(!settleLedgerFilterParam.isByCompany());
        this.spiBeginYear.setValue((Object)new Integer(settleLedgerFilterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(settleLedgerFilterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(settleLedgerFilterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(settleLedgerFilterParam.getEndMonth()));
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        if (AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiEndYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth)) {
            this.spiBeginYear.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CheckDateFromTo"));
            SysUtil.abort();
        }
        try {
            Date fsUsedDate = FSClientHelper.getClearingHouse().getOpenDate();
            Calendar cal = Calendar.getInstance();
            cal.set(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear), AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth), 0, 0, 0);
            if (cal.getTime().before(fsUsedDate)) {
                this.spiBeginYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CheckBeginDate"));
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
        if (FSClientHelper.isClearingHouseCompanyId("")) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        super.companyValueChange((Object)array);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
        this.rdbCompany.setSelected(true);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected Class getParamClass() {
        return SettleLedgerFilterParam.class;
    }
}

