/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.BalanceDirectionEnum;
import com.kingdee.eas.fm.fs.client.AbstractSubsidiaryLedgerHandler;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;

public class SubsidiaryLedgerByCompanyHandler
extends AbstractSubsidiaryLedgerHandler {
    public void fillData2(IMetaDataPK mainQueryPK, KDTable tblMain, IRowSet rs, SubsidiaryLedgerFilterParam param, BOSUuid currencyId, String bankAcctNumber) throws EASBizException, BOSException, SQLException {
        GregorianCalendar endCal;
        GregorianCalendar beginCal;
        Date date;
        BankInfo clearingHouseParam = FSClientHelper.getClearingHouse();
        String beginBalanceDesc = EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource", (String)"Balance");
        String dayTotalDesc = EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource", (String)"DayTotal");
        String monthTotalDesc = EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource", (String)"MonthTotal");
        String yearTotalDesc = EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource", (String)"YearTotal");
        IRow row = null;
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        BalanceDirectionEnum direction = null;
        BigDecimal tmpDayDebitTotal = Constants.ZERO;
        BigDecimal tmpDayCreditTotal = Constants.ZERO;
        GregorianCalendar cal = new GregorianCalendar();
        if (param.isByDay()) {
            date = param.getFromDate();
        } else {
            GregorianCalendar begincal = new GregorianCalendar(param.getBeginYear(), param.getBeginMonth() - 1, 1);
            date = begincal.getTime();
        }
        BigDecimal balance = this.getBeginBalance(mainQueryPK, bankAcctNumber, currencyId.toString(), date);
        if (param.isDispBalance()) {
            row = tblMain.addRow();
            this.fillBeginBalanceRow(date, row, balance, beginBalanceDesc, clearingHouseParam);
        }
        if (rs == null || rs.size() == 0) {
            return;
        }
        rs.beforeFirst();
        rs.next();
        date = rs.getDate("date");
        cal.setTime(date);
        int tmpYear = cal.get(1);
        int tmpMonth = cal.get(2);
        int tmpDay = cal.get(5);
        rs.beforeFirst();
        while (rs.next()) {
            date = rs.getDate("date");
            cal.setTime(date);
            int day = cal.get(5);
            int month = cal.get(2);
            int year = cal.get(1);
            debitAmt = rs.getBigDecimal("debitAmount");
            creditAmt = rs.getBigDecimal("creditAmount");
            if (debitAmt == null) {
                debitAmt = CasConstants.ZERO;
            }
            if (creditAmt == null) {
                creditAmt = CasConstants.ZERO;
            }
            if (day == tmpDay && param.isDisDayTotal()) {
                tmpDayDebitTotal = tmpDayDebitTotal.add(debitAmt);
                tmpDayCreditTotal = tmpDayCreditTotal.add(creditAmt);
            }
            if (day != tmpDay && param.isDisDayTotal()) {
                row = tblMain.addRow();
                this.fillDayTotalRow(date, dayTotalDesc, row, tmpDayDebitTotal, tmpDayCreditTotal, balance, direction);
                tmpDayDebitTotal = debitAmt;
                tmpDayCreditTotal = creditAmt;
            }
            if (month != tmpMonth && param.isDispMouthTotal()) {
                beginCal = new GregorianCalendar(tmpYear, tmpMonth, 1);
                endCal = new GregorianCalendar(tmpYear, tmpMonth + 1, 1);
                row = tblMain.addRow();
                this.fillTotalRow(monthTotalDesc, row, mainQueryPK, bankAcctNumber, currencyId.toString(), beginCal.getTime(), endCal.getTime(), balance, direction);
            }
            if (year != tmpYear && param.isDispYearTotal()) {
                beginCal = new GregorianCalendar(tmpYear, 0, 1);
                endCal = new GregorianCalendar(tmpYear + 1, 0, 1);
                row = tblMain.addRow();
                this.fillTotalRow(yearTotalDesc, row, mainQueryPK, bankAcctNumber, currencyId.toString(), beginCal.getTime(), endCal.getTime(), balance, direction);
            }
            if (month != tmpMonth && param.isDispBalance()) {
                row = tblMain.addRow();
                endCal = new GregorianCalendar(tmpYear, tmpMonth, 0, 23, 59, 59);
                this.fillBeginBalanceRow(endCal.getTime(), row, balance, beginBalanceDesc, clearingHouseParam);
            }
            direction = (balance = balance.add(debitAmt).subtract(creditAmt)).compareTo(Constants.ZERO) == 0 ? BalanceDirectionEnum.BALANCE : (balance.compareTo(Constants.ZERO) > 0 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT);
            row = tblMain.addRow();
            this.fillOneDetailRow(rs, row, balance, debitAmt, creditAmt, direction);
            tmpDay = day;
            tmpMonth = month;
            tmpYear = year;
        }
        if (param.isDisDayTotal()) {
            row = tblMain.addRow();
            this.fillDayTotalRow(date, dayTotalDesc, row, tmpDayDebitTotal, tmpDayCreditTotal, balance, direction);
        }
        if (param.isDispMouthTotal()) {
            beginCal = new GregorianCalendar(tmpYear, tmpMonth, 1);
            endCal = new GregorianCalendar(tmpYear, tmpMonth + 1, 1);
            row = tblMain.addRow();
            this.fillTotalRow(monthTotalDesc, row, mainQueryPK, bankAcctNumber, currencyId.toString(), beginCal.getTime(), endCal.getTime(), balance, direction);
        }
        if (param.isDispYearTotal()) {
            beginCal = new GregorianCalendar(tmpYear, 0, 1);
            endCal = new GregorianCalendar(tmpYear + 1, 0, 1);
            row = tblMain.addRow();
            this.fillTotalRow(yearTotalDesc, row, mainQueryPK, bankAcctNumber, currencyId.toString(), beginCal.getTime(), endCal.getTime(), balance, direction);
        }
    }

    private BigDecimal getBeginBalance(IMetaDataPK mainQueryPK, String acctNumber, String currencyId, Date from) throws SQLException, EASBizException, BOSException {
        HashSet<String> acctSet = new HashSet<String>();
        if (acctNumber.indexOf(",") == -1) {
            acctSet.add(acctNumber);
        } else {
            String[] acctArray = acctNumber.split(",");
            for (int i = 0; i < acctArray.length; ++i) {
                acctSet.add(acctArray[i]);
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)DateTimeUtils.truncateDate((Date)from), CompareType.LESS));
        fi.getFilterItems().add(new FilterItemInfo("payeeBankAcct", acctSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("payerBankAcct", acctSet, CompareType.INCLUDE));
        fi.setMaskString("(#0 and #1 and #2 and (#3 or #4))");
        ev.setFilter(fi);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ");
        sb.append(" SUM(DEBITAMOUNT)-SUM(CREDITAMOUNT) AS BALANCE");
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        BigDecimal result = null;
        if (rs.next()) {
            result = rs.getBigDecimal("BALANCE");
        }
        if (result == null) {
            result = Constants.ZERO;
        }
        return result;
    }

    private void fillTotalRow(String description, IRow row, IMetaDataPK mainQueryPK, String acctNumber, String currencyId, Date beginDate, Date endDate, BigDecimal balance, BalanceDirectionEnum direction) throws BOSException, SQLException {
        HashSet<String> acctSet = new HashSet<String>();
        if (acctNumber.indexOf(",") == -1) {
            acctSet.add(acctNumber);
        } else {
            String[] acctArray = acctNumber.split(",");
            for (int i = 0; i < acctArray.length; ++i) {
                acctSet.add(acctArray[i]);
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS));
        fi.getFilterItems().add(new FilterItemInfo("payeeBankAcct", acctSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("payerBankAcct", acctSet, CompareType.INCLUDE));
        fi.setMaskString("(#0 and #1 and #2 and #3 (#5 or #4))");
        ev.setFilter(fi);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ");
        sb.append(" SUM(DEBITAMOUNT) AS DEBITAMT,SUM(CREDITAMOUNT) AS CREDITAMT");
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        BigDecimal debitAmount = Constants.ZERO;
        BigDecimal creditAmount = Constants.ZERO;
        if (rs.next()) {
            debitAmount = rs.getBigDecimal("debitAmt");
            creditAmount = rs.getBigDecimal("creditAmt");
        }
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("date").setValue((Object)Constants.FORMAT_DAY.format(DateUtil.getBeforeDay((Date)endDate)));
        row.getCell("debitAmount").setValue((Object)debitAmount);
        row.getCell("creditAmount").setValue((Object)creditAmount);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("direction").setValue((Object)direction);
        row.getCell("description").setValue((Object)description);
    }
}

