/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.client.AbstractSubsidiaryLedgerFilterUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.event.ChangeEvent;

public class SubsidiaryLedgerFilterUI
extends AbstractSubsidiaryLedgerFilterUI {
    public static final String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    CompanyOrgUnitCollection coll = null;

    @Override
    protected void chkDispUnUsed_actionPerformed(ActionEvent e) throws Exception {
        super.chkDispUnUsed_actionPerformed(e);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    public Object getParam() {
        SubsidiaryLedgerFilterParam para = new SubsidiaryLedgerFilterParam();
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        para.setByDay(this.rdbByDate.isSelected());
        para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiMonthFrom));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiYearFrom));
        para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiMonthTo));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiYearTo));
        para.setToDate(this.dtpDateTo.getSqlDate());
        para.setFromDate(this.dtpDateFrom.getSqlDate());
        para.setDispBalance(this.chkDispBalance.isSelected());
        para.setDispUnUsed(this.chkDispUnUsed.isSelected());
        para.setDispYearTotal(this.chkDispYearTotal.isSelected());
        para.setDispMouthTotal(this.chkDispMouthTotal.isSelected());
        para.setDisDayTotal(this.chkDispDayTotal.isSelected());
        para.setOrderByCompany(this.rdbByCompany.isSelected());
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        SubsidiaryLedgerFilterParam filterParam = (SubsidiaryLedgerFilterParam)param;
        String[] companyIds = filterParam.getCompanyIds();
        this.setCompanyIds(companyIds);
        this.rdbByDate.setSelected(filterParam.isByDay());
        this.rdbByMonth.setSelected(!filterParam.isByDay());
        this.spiYearFrom.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiYearTo.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiMonthFrom.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiMonthTo.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.dtpDateTo.setValue((Object)filterParam.getToDate());
        this.dtpDateFrom.setValue((Object)filterParam.getFromDate());
        this.chkDispBalance.setSelected(filterParam.isDispBalance());
        this.chkDispUnUsed.setSelected(filterParam.isDispUnUsed());
        this.chkDispYearTotal.setSelected(filterParam.isDispYearTotal());
        this.chkDispMouthTotal.setSelected(filterParam.isDispMouthTotal());
        this.chkDispDayTotal.setSelected(filterParam.isDisDayTotal());
        this.rdbByCompany.setSelected(filterParam.isOrderByCompany());
        this.rdbByType.setSelected(!filterParam.isOrderByCompany());
    }

    @Override
    protected void rdbByMonth_stateChanged(ChangeEvent e) throws Exception {
        this.palDate.setVisible(false);
        this.palMonth.setVisible(false);
        if (this.rdbByMonth.isSelected()) {
            this.palMonth.setVisible(true);
        } else {
            this.palDate.setVisible(true);
            if (this.dtpDateFrom.getValue() == null && this.dtpDateTo.getValue() == null) {
                Calendar date = Calendar.getInstance();
                this.dtpDateFrom.setValue((Object)date.getTime());
                this.dtpDateTo.setValue((Object)date.getTime());
            }
        }
    }

    protected void init() throws Exception {
        super.init();
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spiYearFrom, (KDSpinner)this.spiYearTo, (KDSpinner)this.spiMonthFrom, (KDSpinner)this.spiMonthTo);
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        if (this.rdbByMonth.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiYearFrom) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiMonthFrom) > AccessHelper.getSpiValue((KDSpinner)this.spiYearTo) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiMonthTo)) {
                this.spiYearFrom.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        } else {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpDateTo, (String)"NoDate");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpDateFrom, (String)"NoDate");
            if (this.dtpDateTo.getSqlDate().before(this.dtpDateFrom.getSqlDate())) {
                this.dtpDateFrom.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        }
        try {
            Date fsUsedDate = FSClientHelper.getClearingHouse().getOpenDate();
            Calendar cal = Calendar.getInstance();
            if (this.rdbByMonth.isSelected()) {
                cal.set(AccessHelper.getSpiValue((KDSpinner)this.spiYearFrom), AccessHelper.getSpiValue((KDSpinner)this.spiMonthFrom), 0, 0, 0);
            } else {
                cal.setTime(this.dtpDateFrom.getSqlDate());
            }
            if (cal.getTime().before(fsUsedDate)) {
                this.spiYearFrom.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckBeginDate"));
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
        if (FSClientHelper.isClearingHouseCompanyId("")) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        super.companyValueChange((Object)array);
    }

    protected void setDefaultValue() {
        this.chkDispUnUsed.setSelected(false);
        this.rdbByMonth.setSelected(true);
        this.rdbByCompany.setSelected(true);
        this.chkDispBalance.setSelected(true);
        this.chkDispYearTotal.setSelected(true);
        this.chkDispMouthTotal.setSelected(true);
        this.chkDispDayTotal.setSelected(true);
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiYearFrom, (KDSpinner)this.spiMonthFrom, (KDSpinner)this.spiYearTo, (KDSpinner)this.spiMonthTo);
        this.lblMonthFrom.setEnabled(true);
        this.lblMonthTo.setEnabled(true);
        this.lblYearFrom.setEnabled(true);
        this.lblYearTo.setEnabled(true);
        if (this.coll == null) {
            try {
                this.coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
        }
        this.setCompanyIdSet(AccessHelper.getIds((Object[])this.coll.toArray()));
    }

    protected Class getParamClass() {
        return SubsidiaryLedgerFilterParam.class;
    }
}

