/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fs.BalanceDirectionEnum;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InacctTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerEnum;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.client.AbstractSummaryLedgerHandler;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SummaryLedgerFilterParam;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SummaryLedgerByCompanyDateHandler
extends AbstractSummaryLedgerHandler {
    @Override
    public void initTree(SummaryLedgerFilterParam param, KDTree treeList) throws EASBizException, BOSException {
        CompanyOrgUnitCollection companyCol = null;
        String[] companyIds = param.getCompanyIdAry();
        companyCol = FMClientHelper.getCompanyOrgUnitCollection((String[])companyIds);
        FSClientHelper.fillInnerAcctByCompanySupportCache(treeList, companyCol, param.isDispUnUsed(), param.getUsageId());
    }

    @Override
    public void initTable(SummaryLedgerFilterParam param, KDTable tblMain) throws BOSException {
        super.initTable(param, tblMain);
        tblMain.getColumn(0).getStyleAttributes().setHided(true);
    }

    public void _initTable(SummaryLedgerFilterParam param, KDTable tblMain) throws BOSException {
        String column_project = EASResource.getString((String)this.resourcePath, (String)"Project");
        String column_total = EASResource.getString((String)this.resourcePath, (String)"Total");
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("Project");
        headRow.getCell("Project").setValue((Object)column_project);
        boolean bln = true;
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        Calendar begincal = this.adjustBeginDate(beginYear, beginMonth);
        beginYear = begincal.get(1);
        beginMonth = begincal.get(2);
        CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)CycleTypeEnum.MONTH, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        int CycleRangeColSize = coll.size();
        for (int i = 0; i < CycleRangeColSize; ++i) {
            CycleRangeInfo info = coll.get(i);
            tblMain.addColumn().setKey(info.genDateKey());
            headRow.getCell(info.genDateKey()).setValue((Object)info.toString());
        }
        List sumList = SummaryLedgerEnum.getEnumList();
        int size = sumList.size();
        for (int i = 0; i < size; ++i) {
            tblMain.addRow(i).getCell("Project").setValue(sumList.get(i));
        }
    }

    private void fillDataToTable(KDTable tblMain, SummaryLedgerFilterParam param, InnerAccountInfo innerAccount, EntityViewInfo mainQuery, String currencyNumber) throws Exception {
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        Calendar begincal = this.adjustBeginDate(beginYear, beginMonth);
        beginYear = begincal.get(1);
        beginMonth = begincal.get(2);
        IInAcct inacct = InAcctFactory.getRemoteInstance();
        CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)CycleTypeEnum.MONTH, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        BigDecimal beginBalance = Constants.ZERO;
        BigDecimal endBalance = Constants.ZERO;
        BigDecimal debitAmount = Constants.ZERO;
        BigDecimal creditAmount = Constants.ZERO;
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(innerAccount.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        String companyNumber = chCompany.getNumber();
        int CycleRangeColSize = coll.size();
        for (int i = 0; i < CycleRangeColSize; ++i) {
            CycleRangeInfo info = coll.get(i);
            Date beginDate = this.adjustDate(info.getBeginDate());
            Date endDate = this.adjustDate(info.getEndDate());
            beginBalance = inacct.inAcct(companyNumber, innerAccount.getNumber(), currencyNumber, beginDate, endDate, InAcctDataTypeEnum.C);
            debitAmount = inacct.inAcct(companyNumber, innerAccount.getNumber(), currencyNumber, beginDate, endDate, InAcctDataTypeEnum.JF);
            creditAmount = inacct.inAcct(companyNumber, innerAccount.getNumber(), currencyNumber, beginDate, endDate, InAcctDataTypeEnum.DF);
            endBalance = beginBalance.add(debitAmount).subtract(creditAmount);
            tblMain.getRow(0).getCell(info.genDateKey()).setValue((Object)beginBalance);
            tblMain.getRow(1).getCell(info.genDateKey()).setValue((Object)debitAmount);
            tblMain.getRow(2).getCell(info.genDateKey()).setValue((Object)creditAmount);
            tblMain.getRow(3).getCell(info.genDateKey()).setValue((Object)endBalance);
        }
    }

    private void fillDataToTable2(KDTable tblMain, SummaryLedgerFilterParam param, String innerAccountNumber, EntityViewInfo mainQuery, String currencyNumber) throws Exception {
        Date beginDateUI = param.getFromDate();
        Date endDateUI = param.getToDate();
        String chCompanyNumber = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getNumber();
        FPFormulaCollection paramColl = new FPFormulaCollection();
        FPFormulaInfo info = null;
        Date beginDate = this.adjustDate(beginDateUI);
        Date endDate = this.adjustDate(endDateUI);
        info = new FPFormulaInfo();
        info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.C});
        paramColl.add(info);
        info = new FPFormulaInfo();
        info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.JF});
        paramColl.add(info);
        info = new FPFormulaInfo();
        info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.DF});
        paramColl.add(info);
        IRow row = null;
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        FPFormulaCollection resultcoll = iSummaryLedger.exec(InacctTypeEnum.INACCTExt, paramColl);
        row = tblMain.addRow();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        String col_project_name = dtformat.format(beginDateUI) + "~" + dtformat.format(endDateUI);
        row.getCell("Project").setValue((Object)col_project_name);
        int i = 0;
        info = resultcoll.get(i * 3);
        BigDecimal a = info.getResult();
        row.getCell("beginBalanceDc").setValue((Object)BalanceDirectionEnum.getEnum(a.signum()));
        row.getCell("beginBalance").setValue((Object)a.abs());
        info = resultcoll.get(i * 3 + 1);
        BigDecimal b = info.getResult();
        row.getCell("creditAmount").setValue((Object)b);
        info = resultcoll.get(i * 3 + 2);
        BigDecimal c = info.getResult();
        row.getCell("debitAmount").setValue((Object)c);
        BigDecimal d = FMHelper.add((BigDecimal)a, (BigDecimal)b).subtract(c);
        row.getCell("endBalanceDc").setValue((Object)BalanceDirectionEnum.getEnum(d.signum()));
        row.getCell("endBalance").setValue((Object)d.abs());
        BigDecimal beginBalanceTotal = Constants.ZERO;
        BigDecimal endBalanceTotal = Constants.ZERO;
        BigDecimal debitAmountTotal = Constants.ZERO;
        BigDecimal creditAmountTotal = Constants.ZERO;
        for (int i2 = 0; i2 <= tblMain.getRowCount() - 1; ++i2) {
            beginBalanceTotal = beginBalanceTotal.add((BigDecimal)tblMain.getRow(i2).getCell("beginBalance").getValue());
            debitAmountTotal = debitAmountTotal.add((BigDecimal)tblMain.getRow(i2).getCell("debitAmount").getValue());
            creditAmountTotal = creditAmountTotal.add((BigDecimal)tblMain.getRow(i2).getCell("creditAmount").getValue());
            endBalanceTotal = endBalanceTotal.add((BigDecimal)tblMain.getRow(i2).getCell("endBalance").getValue());
        }
        row = tblMain.addRow();
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        String total = EASResource.getString((String)this.resourcePath, (String)"Total");
        row.getCell("Project").setValue((Object)total);
        row.getCell("debitAmount").setValue((Object)debitAmountTotal);
        row.getCell("creditAmount").setValue((Object)creditAmountTotal);
    }

    @Override
    public void fillData(KDTable tblMain, SummaryLedgerFilterParam param, Object condition, EntityViewInfo mainQuery, String currencyNumber) throws Exception {
        InnerAccountInfo info = null;
        if (!(condition instanceof InnerAccountInfo)) {
            return;
        }
        info = (InnerAccountInfo)condition;
        if (info == null) {
            return;
        }
        this.fillDataToTable2(tblMain, param, info.getNumber(), mainQuery, currencyNumber);
    }

    @Override
    public void fillData(KDTable tblMain, SummaryLedgerFilterParam param, String acctNumber, EntityViewInfo mainQuery, String currencyNumber) throws Exception {
        this.fillDataToTable2(tblMain, param, acctNumber, mainQuery, currencyNumber);
    }
}

