/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fs.BalanceDirectionEnum;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InacctTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SummaryLedgerFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public class SummaryLedgerDataHelper {
    private static final Logger logger = CoreUIObject.getLogger(SummaryLedgerDataHelper.class);
    private String[] colName = new String[]{"period", "innerAccountName", "innerAccountNumber", "nowDate", "currencyName", "beginBalanceDc", "beginBalance", "debitAmount", "creditAmount", "endBalanceDc", "endBalance"};
    private List companyList = new ArrayList();

    public IRowSet getCompanyDate(SummaryLedgerFilterParam param, String currencyNumber, String currencyName, Object info) throws Exception {
        BigDecimal c;
        BigDecimal b;
        DynamicRowSet rs = null;
        String acctNumber = ((InnerAccountInfo)info).getNumber();
        String acctAcctNumber = ((InnerAccountInfo)info).getAcctNumber();
        String acctName = ((InnerAccountInfo)info).getName();
        Date nowDate = new Date(System.currentTimeMillis());
        if (acctNumber == null || acctNumber.trim().length() == 0) {
            return null;
        }
        java.util.Date beginDateUI = param.getFromDate();
        java.util.Date endDateUI = param.getToDate();
        String chCompanyNumber = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getNumber();
        FPFormulaCollection paramColl = new FPFormulaCollection();
        FPFormulaInfo infoFP = null;
        java.util.Date beginDate = this.adjustDate(beginDateUI);
        java.util.Date endDate = this.adjustDate(endDateUI);
        infoFP = new FPFormulaInfo();
        infoFP.setParams(new Object[]{chCompanyNumber, acctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.C});
        paramColl.add(infoFP);
        infoFP = new FPFormulaInfo();
        infoFP.setParams(new Object[]{chCompanyNumber, acctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.JF});
        paramColl.add(infoFP);
        infoFP = new FPFormulaInfo();
        infoFP.setParams(new Object[]{chCompanyNumber, acctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.DF});
        paramColl.add(infoFP);
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        FPFormulaCollection resultcoll = iSummaryLedger.exec(InacctTypeEnum.INACCTExt, paramColl);
        String period = beginDateUI + "~" + endDateUI;
        infoFP = resultcoll.get(0);
        BigDecimal a = infoFP.getResult();
        String beginBalanceDc = BalanceDirectionEnum.getEnum(a.signum()).toString();
        BigDecimal beginbalance = a.abs();
        infoFP = resultcoll.get(1);
        BigDecimal creditAmount = b = infoFP.getResult();
        infoFP = resultcoll.get(2);
        BigDecimal debitAmount = c = infoFP.getResult();
        BigDecimal d = FMHelper.add((BigDecimal)a, (BigDecimal)b).subtract(c);
        String endBalanceDc = BalanceDirectionEnum.getEnum(d.signum()).toString();
        BigDecimal endBalance = d.abs();
        try {
            DynamicRowSet DyRs = new DynamicRowSet(this.colName.length);
            for (int i = 0; i < this.colName.length; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.colName[i].toString();
                DyRs.setColInfo(i + 1, ci);
            }
            rs = DyRs;
            rs.moveToInsertRow();
            rs.updateString("period", period);
            rs.updateString("innerAccountName", acctName);
            rs.updateString("innerAccountNumber", acctAcctNumber);
            rs.updateDate("nowDate", nowDate);
            rs.updateString("currencyName", currencyName);
            rs.updateString("beginBalanceDc", beginBalanceDc);
            rs.updateBigDecimal("beginBalance", beginbalance);
            rs.updateBigDecimal("debitAmount", debitAmount);
            rs.updateBigDecimal("creditAmount", creditAmount);
            rs.updateString("endBalanceDc", endBalanceDc);
            rs.updateBigDecimal("endBalance", endBalance);
            rs.insertRow();
            rs.beforeFirst();
            while (rs.next()) {
                logger.error((Object)rs.getString("period"));
                logger.error((Object)rs.getString("innerAccountName"));
                logger.error((Object)rs.getString("beginBalanceDc"));
            }
        }
        catch (SQLException e1) {
            throw new Exception(e1);
        }
        return rs;
    }

    public IRowSet getCompany(SummaryLedgerFilterParam param, String currencyNumber, String currencyName, Object info, String project) throws Exception {
        CycleRangeInfo cycleInfo;
        DynamicRowSet rs = null;
        String acctNumber = ((InnerAccountInfo)info).getNumber();
        String acctAcctNumber = ((InnerAccountInfo)info).getAcctNumber();
        String acctName = ((InnerAccountInfo)info).getName();
        Date nowDate = new Date(System.currentTimeMillis());
        if (acctNumber == null || acctNumber.trim().length() == 0) {
            return null;
        }
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        Calendar begincal = this.adjustBeginDate(beginYear, beginMonth);
        beginYear = begincal.get(1);
        beginMonth = begincal.get(2);
        CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)CycleTypeEnum.MONTH, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        int CycleRangeColSize = coll.size();
        String chCompanyNumber = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getNumber();
        FPFormulaCollection paramColl = new FPFormulaCollection();
        FPFormulaInfo infoFP = null;
        for (int i = 0; i < CycleRangeColSize; ++i) {
            cycleInfo = coll.get(i);
            java.util.Date beginDate = this.adjustDate(cycleInfo.getBeginDate());
            java.util.Date endDate = this.adjustDate(cycleInfo.getEndDate());
            infoFP = new FPFormulaInfo();
            infoFP.setParams(new Object[]{chCompanyNumber, acctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.C});
            paramColl.add(infoFP);
            infoFP = new FPFormulaInfo();
            infoFP.setParams(new Object[]{chCompanyNumber, acctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.JF});
            paramColl.add(infoFP);
            infoFP = new FPFormulaInfo();
            infoFP.setParams(new Object[]{chCompanyNumber, acctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.DF});
            paramColl.add(infoFP);
        }
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        FPFormulaCollection resultcoll = iSummaryLedger.exec(InacctTypeEnum.INACCTExt, paramColl);
        try {
            DynamicRowSet DyRs = new DynamicRowSet(this.colName.length);
            for (int i = 0; i < this.colName.length; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.colName[i].toString();
                DyRs.setColInfo(i + 1, ci);
            }
            rs = DyRs;
            String[] dates = project.split("-");
            for (int i = 0; i < CycleRangeColSize; ++i) {
                cycleInfo = coll.get(i);
                if (cycleInfo.getYear() != Integer.parseInt(dates[0]) || cycleInfo.getMonth() != Integer.parseInt(dates[1])) continue;
                rs.moveToInsertRow();
                rs.updateString("period", cycleInfo.toString());
                rs.updateString("innerAccountName", acctName);
                rs.updateString("innerAccountNumber", acctAcctNumber);
                rs.updateDate("nowDate", nowDate);
                rs.updateString("currencyName", currencyName);
                infoFP = resultcoll.get(i * 3);
                BigDecimal a = infoFP.getResult();
                rs.updateString("beginBalanceDc", BalanceDirectionEnum.getEnum(a.signum()).toString());
                rs.updateBigDecimal("beginBalance", a.abs());
                infoFP = resultcoll.get(i * 3 + 1);
                BigDecimal b = infoFP.getResult();
                rs.updateBigDecimal("creditAmount", b);
                infoFP = resultcoll.get(i * 3 + 2);
                BigDecimal c = infoFP.getResult();
                rs.updateBigDecimal("debitAmount", c);
                BigDecimal d = FMHelper.add((BigDecimal)a, (BigDecimal)b).subtract(c);
                rs.updateString("endBalanceDc", BalanceDirectionEnum.getEnum(d.signum()).toString());
                rs.updateBigDecimal("endBalance", d.abs());
                rs.insertRow();
            }
            rs.beforeFirst();
            while (rs.next()) {
                logger.error((Object)rs.getString("period"));
                logger.error((Object)rs.getString("innerAccountName"));
                logger.error((Object)rs.getString("beginBalanceDc"));
            }
        }
        catch (SQLException e1) {
            throw new Exception(e1);
        }
        return rs;
    }

    public IRowSet getPeriodDate(SummaryLedgerFilterParam param, String currencyNumber, String currencyName, InnerAccountInfo innerAcct) throws Exception {
        String innerAccountNumber;
        DynamicRowSet rs = null;
        Date nowDate = new Date(System.currentTimeMillis());
        InnerAccountCollection innerAcctColl = this.getInnerAccountColl(param);
        int innerSize = innerAcctColl.size();
        java.util.Date beginDateUI = param.getFromDate();
        java.util.Date endDateUI = param.getToDate();
        java.util.Date beginDate = this.adjustDate(beginDateUI);
        java.util.Date endDate = this.adjustDate(endDateUI);
        FPFormulaCollection paramColl = new FPFormulaCollection();
        FPFormulaInfo info = null;
        String chCompanyNumber = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getNumber();
        if (innerSize == 0) {
            return null;
        }
        for (int i = 0; i < innerSize; ++i) {
            innerAccountNumber = innerAcctColl.get(i).getNumber();
            info = new FPFormulaInfo();
            info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.C});
            paramColl.add(info);
            info = new FPFormulaInfo();
            info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.JF});
            paramColl.add(info);
            info = new FPFormulaInfo();
            info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.DF});
            paramColl.add(info);
        }
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        FPFormulaCollection resultcoll = iSummaryLedger.exec(InacctTypeEnum.INACCTExt, paramColl);
        InnerAccountInfo innerAcctInfo = null;
        String period = beginDate + "~" + endDate;
        try {
            int i;
            DynamicRowSet DyRs = new DynamicRowSet(this.colName.length);
            for (i = 0; i < this.colName.length; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.colName[i].toString();
                DyRs.setColInfo(i + 1, ci);
            }
            rs = DyRs;
            for (i = 0; i < innerSize; ++i) {
                innerAccountNumber = innerAcctColl.get(i).getNumber();
                innerAcctInfo = innerAcctColl.get(i);
                if (!innerAcctInfo.getId().toString().equals(innerAcct.getId().toString())) continue;
                rs.moveToInsertRow();
                rs.updateString("period", period);
                rs.updateString("innerAccountName", innerAcctInfo.getName());
                rs.updateString("innerAccountNumber", innerAcctInfo.getAcctNumber());
                rs.updateDate("nowDate", nowDate);
                rs.updateString("currencyName", currencyName);
                info = resultcoll.get(i * 3);
                BigDecimal a = info.getResult();
                rs.updateString("beginBalanceDc", BalanceDirectionEnum.getEnum(a.signum()).toString());
                rs.updateBigDecimal("beginBalance", a.abs());
                info = resultcoll.get(i * 3 + 1);
                BigDecimal b = info.getResult();
                rs.updateBigDecimal("creditAmount", b);
                info = resultcoll.get(i * 3 + 2);
                BigDecimal c = info.getResult();
                rs.updateBigDecimal("debitAmount", c);
                BigDecimal d = FMHelper.add((BigDecimal)a, (BigDecimal)b).subtract(c);
                rs.updateString("endBalanceDc", BalanceDirectionEnum.getEnum(d.signum()).toString());
                rs.updateBigDecimal("endBalance", d.abs());
                rs.insertRow();
            }
            rs.beforeFirst();
            while (rs.next()) {
                logger.error((Object)rs.getString("period"));
                logger.error((Object)rs.getString("beginBalanceDc"));
            }
        }
        catch (SQLException e1) {
            throw new Exception(e1);
        }
        return rs;
    }

    public IRowSet getPeriod(Object condition, SummaryLedgerFilterParam param, String currencyNumber, String currencyName, InnerAccountInfo innerAcct) throws Exception {
        String innerAccountNumber;
        CycleRangeInfo period = (CycleRangeInfo)condition;
        DynamicRowSet rs = null;
        Date nowDate = new Date(System.currentTimeMillis());
        InnerAccountCollection innerAcctColl = this.getInnerAccountColl(param);
        int innerSize = innerAcctColl.size();
        java.util.Date beginDate = this.adjustDate(period.getBeginDate());
        java.util.Date endDate = this.adjustDate(period.getEndDate());
        FPFormulaCollection paramColl = new FPFormulaCollection();
        FPFormulaInfo info = null;
        String chCompanyNumber = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getNumber();
        if (innerSize == 0) {
            return null;
        }
        for (int i = 0; i < innerSize; ++i) {
            innerAccountNumber = innerAcctColl.get(i).getNumber();
            info = new FPFormulaInfo();
            info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.C});
            paramColl.add(info);
            info = new FPFormulaInfo();
            info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.JF});
            paramColl.add(info);
            info = new FPFormulaInfo();
            info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.DF});
            paramColl.add(info);
        }
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        FPFormulaCollection resultcoll = iSummaryLedger.exec(InacctTypeEnum.INACCTExt, paramColl);
        InnerAccountInfo innerAcctInfo = null;
        try {
            int i;
            DynamicRowSet DyRs = new DynamicRowSet(this.colName.length);
            for (i = 0; i < this.colName.length; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.colName[i].toString();
                DyRs.setColInfo(i + 1, ci);
            }
            rs = DyRs;
            for (i = 0; i < innerSize; ++i) {
                innerAccountNumber = innerAcctColl.get(i).getNumber();
                innerAcctInfo = innerAcctColl.get(i);
                if (!innerAcctInfo.getId().toString().equals(innerAcct.getId().toString())) continue;
                rs.moveToInsertRow();
                rs.updateString("period", period.toString());
                rs.updateString("innerAccountName", innerAcctInfo.getName());
                rs.updateString("innerAccountNumber", innerAcctInfo.getAcctNumber());
                rs.updateDate("nowDate", nowDate);
                rs.updateString("currencyName", currencyName);
                info = resultcoll.get(i * 3);
                BigDecimal a = info.getResult();
                rs.updateString("beginBalanceDc", BalanceDirectionEnum.getEnum(a.signum()).toString());
                rs.updateBigDecimal("beginBalance", a.abs());
                info = resultcoll.get(i * 3 + 1);
                BigDecimal b = info.getResult();
                rs.updateBigDecimal("creditAmount", b);
                info = resultcoll.get(i * 3 + 2);
                BigDecimal c = info.getResult();
                rs.updateBigDecimal("debitAmount", c);
                BigDecimal d = FMHelper.add((BigDecimal)a, (BigDecimal)b).subtract(c);
                rs.updateString("endBalanceDc", BalanceDirectionEnum.getEnum(d.signum()).toString());
                rs.updateBigDecimal("endBalance", d.abs());
                rs.insertRow();
            }
            rs.beforeFirst();
            while (rs.next()) {
                logger.error((Object)rs.getString("period"));
                logger.error((Object)rs.getString("beginBalanceDc"));
            }
        }
        catch (SQLException e1) {
            throw new Exception(e1);
        }
        return rs;
    }

    protected java.util.Date adjustDate(java.util.Date date) {
        BankInfo clearingHouse = null;
        try {
            clearingHouse = FSClientHelper.getClearingHouse();
            java.util.Date openDate = clearingHouse.getOpenDate();
            if (date.before(openDate)) {
                return openDate;
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return date;
    }

    protected Calendar adjustBeginDate(int beginYear, int beginMonth) {
        BankInfo clearingHouse = null;
        GregorianCalendar begincal = new GregorianCalendar(beginYear, beginMonth, 1);
        java.util.Date beginDate = begincal.getTime();
        try {
            clearingHouse = FSClientHelper.getClearingHouse();
            java.util.Date openDate = clearingHouse.getOpenDate();
            if (beginDate.before(openDate)) {
                begincal.setTime(openDate);
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return begincal;
    }

    private InnerAccountCollection getInnerAccountColl(SummaryLedgerFilterParam param) throws BOSException {
        CompanyOrgUnitCollection coll = FMClientHelper.getCompanyOrgUnitCollection((String[])param.getCompanyIdAry());
        ArrayList<String> innerAcctList = new ArrayList<String>();
        InnerAccountCollection innerAcctColl = new InnerAccountCollection();
        this.companyList.clear();
        String companyName = null;
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo company = coll.get(i);
            String companyID = company.getId().toString();
            companyName = company.getName();
            InnerAccountCollection iac = FSClientHelper.getInnerAccountCollection(companyID, param.getUsageId(), param.isDispUnUsed());
            if (iac == null) continue;
            innerAcctColl.addCollection(iac);
            for (int j = 0; j < iac.size(); ++j) {
                InnerAccountInfo innerAccountInfo = iac.get(j);
                String innerAccountName = innerAccountInfo.getNumber();
                innerAcctList.add(innerAccountName);
                this.companyList.add(companyName);
            }
        }
        return innerAcctColl;
    }
}

