/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AccountPropertyFactory;
import com.kingdee.eas.basedata.assistant.AccountPropertyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.client.AbstractSummaryLedgerFilterUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SummaryLedgerFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import javax.swing.event.ChangeEvent;

public class SummaryLedgerFilterUI
extends AbstractSummaryLedgerFilterUI {
    private String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";

    protected void init() throws Exception {
        super.init();
        CompanyOrgUnitCollection coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
        this.setCompanyIdSet(AccessHelper.getIds((Object[])coll.toArray()));
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spiFromYear, (KDSpinner)this.spiToYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToMonth);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    public Object getParam() {
        SummaryLedgerFilterParam param = new SummaryLedgerFilterParam();
        String[] companyIds = this.getCompanyIds();
        param.setCompanyIdAry(companyIds);
        param.setIA(this.chkIA.isSelected());
        param.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiFromMonth));
        param.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiFromYear));
        param.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiToMonth));
        param.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiToYear));
        param.setByCompany(this.rdbCompany.isSelected());
        param.setUsageId(FMHelper.Array2Set((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmptAccountUse)));
        param.setByDay(this.rdbByDate.isSelected());
        param.setToDate(this.dtpDateTo.getSqlDate());
        param.setFromDate(this.dtpDateFrom.getSqlDate());
        param.setDispUnUsed(this.chkDispUnUsed.isSelected());
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof SummaryLedgerFilterParam)) {
            return;
        }
        SummaryLedgerFilterParam filterParam = (SummaryLedgerFilterParam)param;
        String[] companyIds = filterParam.getCompanyIdAry();
        this.setCompanyIds(companyIds);
        this.spiFromYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiFromMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiToYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiToMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.rdbCompany.setSelected(filterParam.isByCompany());
        this.rdbPeriod.setSelected(!filterParam.isByCompany());
        this.chkIA.setSelected(filterParam.isIA());
        this.chkDispUnUsed.setSelected(filterParam.isDispUnUsed());
        this.rdbByDate.setSelected(filterParam.isByDay());
        this.rdbByMonth.setSelected(!filterParam.isByDay());
        this.dtpDateTo.setValue((Object)filterParam.getToDate());
        this.dtpDateFrom.setValue((Object)filterParam.getFromDate());
        if (filterParam.getUsageId() != null && filterParam.getUsageId().size() > 0) {
            try {
                String id2 = null;
                for (String id2 : filterParam.getUsageId()) {
                }
                AccountPropertyInfo accountPropertyInfo = AccountPropertyFactory.getRemoteInstance().getAccountPropertyInfo((IObjectPK)new ObjectUuidPK(id2));
                this.prmptAccountUse.setData((Object)accountPropertyInfo);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        if (this.rdbByMonth.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiFromYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiFromMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiToYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiToMonth)) {
                this.spiFromYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        } else {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)this.resourcePath, (KDDatePicker)this.dtpDateTo, (String)"NoDate");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)this.resourcePath, (KDDatePicker)this.dtpDateFrom, (String)"NoDate");
            if (this.dtpDateTo.getSqlDate().before(this.dtpDateFrom.getSqlDate())) {
                this.dtpDateFrom.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        }
        try {
            Date fsUsedDate = FSClientHelper.getClearingHouse().getOpenDate();
            Calendar cal = Calendar.getInstance();
            if (this.rdbByMonth.isSelected()) {
                cal.set(AccessHelper.getSpiValue((KDSpinner)this.spiFromYear), AccessHelper.getSpiValue((KDSpinner)this.spiFromMonth), 0, 0, 0);
            } else {
                cal.setTime(this.dtpDateFrom.getSqlDate());
            }
            if (cal.getTime().before(fsUsedDate)) {
                this.spiFromYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CheckBeginDate"));
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
        if (FSClientHelper.isClearingHouseCompanyId(null)) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        super.companyValueChange((Object)array);
    }

    @Override
    protected void rdbByMonth_stateChanged(ChangeEvent e) throws Exception {
        this.palDate.setVisible(false);
        this.palMonth.setVisible(false);
        if (this.rdbByMonth.isSelected()) {
            this.palMonth.setVisible(true);
        } else {
            this.palDate.setVisible(true);
            if (this.dtpDateFrom.getValue() == null && this.dtpDateTo.getValue() == null) {
                Calendar date = Calendar.getInstance();
                this.dtpDateFrom.setValue((Object)date.getTime());
                this.dtpDateTo.setValue((Object)date.getTime());
            }
        }
    }

    protected Class getParamClass() {
        return SummaryLedgerFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.rdbByMonth.setSelected(true);
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiFromYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToYear, (KDSpinner)this.spiToMonth);
        this.prmptAccountUse.setData(null);
        this.rdbCompany.setSelected(true);
        this.chkDispUnUsed.setSelected(false);
    }
}

