/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.AbstractSummaryLedgerHandler;
import com.kingdee.eas.fm.fs.client.AbstractSummaryLedgerUI;
import com.kingdee.eas.fm.fs.client.FSAnalysisHandlerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterParam;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerUI;
import com.kingdee.eas.fm.fs.client.SummaryLedgerDataHelper;
import com.kingdee.eas.fm.fs.client.SummaryLedgerDataProvider;
import com.kingdee.eas.fm.fs.client.SummaryLedgerFilterParam;
import com.kingdee.eas.fm.fs.client.SummaryLedgerFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SummaryLedgerUI
extends AbstractSummaryLedgerUI {
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    private static Logger logger = Logger.getLogger(SummaryLedgerUI.class);
    private SummaryLedgerFilterUI filterUI;
    private BankInfo clearingHouse;
    public static final String SUMMARYLEDGER_FILENAME = "/FM/FS/SUMMARYLEDGER";

    public void onShow() throws Exception {
        super.onShow();
        this.treeList.requestFocus();
    }

    private IRowSet appendRowSet(IRowSet rs, IRowSet rs2) {
        try {
            rs2.beforeFirst();
            while (rs2.next()) {
                rs.moveToInsertRow();
                rs.updateString("period", rs2.getString("period"));
                rs.updateString("innerAccountName", rs2.getString("innerAccountName"));
                rs.updateString("innerAccountNumber", rs2.getString("innerAccountNumber"));
                rs.updateString("nowDate", rs2.getString("nowDate"));
                rs.updateString("currencyName", rs2.getString("currencyName"));
                rs.updateString("beginBalanceDc", rs2.getString("beginBalanceDc"));
                rs.updateBigDecimal("beginBalance", rs2.getBigDecimal("beginBalance"));
                rs.updateBigDecimal("debitAmount", rs2.getBigDecimal("debitAmount"));
                rs.updateBigDecimal("creditAmount", rs2.getBigDecimal("creditAmount"));
                rs.updateString("endBalanceDc", rs2.getString("endBalanceDc"));
                rs.updateBigDecimal("endBalance", rs2.getBigDecimal("endBalance"));
                rs.insertRow();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rs;
    }

    public IRowSet getRowSet() throws Exception {
        IRowSet rowSet = null;
        IRowSet rs = null;
        Object[] paths = this.treeList.getSelectionPaths();
        if (EmptyUtil.isEmpty((Object[])paths)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"162_SummaryLedgerUI"));
            SysUtil.abort();
        }
        for (int i = 0; i < paths.length; ++i) {
            InnerAccountInfo innerAcct;
            Object path = paths[i];
            if (path == null) {
                return null;
            }
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)((TreePath)path).getLastPathComponent();
            Object info = node.getUserObject();
            if (info == null) {
                return null;
            }
            this.getUIContext().put("currentNode", info.toString());
            SummaryLedgerFilterParam param = (SummaryLedgerFilterParam)this.getUIContext().get("userParam");
            CurrencyInfo curInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
            String currencyNumber = curInfo.getNumber();
            String currencyName = curInfo.getName();
            SummaryLedgerDataHelper sLDH = new SummaryLedgerDataHelper();
            if (info instanceof CompanyOrgUnitInfo) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"162_SummaryLedgerUI"));
                SysUtil.abort();
            }
            int selectedRow = this.tblMain.getSelectManager().getActiveRowIndex();
            if (param.isByCompany()) {
                if (param.isByDay()) {
                    rowSet = sLDH.getCompanyDate(param, currencyNumber, currencyName, info);
                } else {
                    Object project = this.tblMain.getCell(selectedRow, "Project").getValue();
                    if (project != null) {
                        rowSet = sLDH.getCompany(param, currencyNumber, currencyName, info, project.toString());
                    }
                }
            } else if (param.isByDay()) {
                innerAcct = (InnerAccountInfo)this.tblMain.getCell(selectedRow, "Project").getValue();
                if (innerAcct != null) {
                    rowSet = sLDH.getPeriodDate(param, currencyNumber, currencyName, innerAcct);
                }
            } else {
                if (!(info instanceof CycleRangeInfo)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"162_SummaryLedgerUI"));
                    SysUtil.abort();
                }
                innerAcct = (InnerAccountInfo)this.tblMain.getCell(selectedRow, "Project").getValue();
                CycleRangeInfo period = (CycleRangeInfo)info;
                if (innerAcct != null) {
                    rowSet = sLDH.getPeriod(period, param, currencyNumber, currencyName, innerAcct);
                }
            }
            if (EmptyUtil.isEmpty((Object)rowSet)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"dataIsNull"));
                SysUtil.abort();
            }
            if (i == 0) {
                rs = rowSet.createCopy();
                continue;
            }
            this.appendRowSet(rs, rowSet);
        }
        return rs;
    }

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeList_valueChanged(e);
        FMClientHelper.clearTable((KDTable)this.tblMain);
        TreePath path = this.treeList.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        Object info = node.getUserObject();
        if (info == null) {
            return;
        }
        this.getUIContext().put("currentNode", info.toString());
        SummaryLedgerFilterParam param = (SummaryLedgerFilterParam)this.getFilterParam();
        this.getUIContext().put("userParam", ObjectUtil.cloneObject((Serializable)((Object)param)));
        AbstractSummaryLedgerHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        handler.initTable(param, this.tblMain);
        CurrencyInfo curInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (info instanceof CompanyOrgUnitInfo) {
            StringBuffer sb = new StringBuffer();
            this.parseAcctNumber(sb, node);
            String acctNumber = sb.toString();
            if (acctNumber == null || acctNumber.trim().length() == 0) {
                return;
            }
            handler.fillData(this.tblMain, param, acctNumber, this.mainQuery, curInfo.getNumber());
        } else if (info instanceof CycleRangeInfo) {
            handler.fillData(this.tblMain, param, info, this.mainQuery, curInfo.getNumber());
        } else if (info instanceof String) {
            CycleRangeInfo period = new CycleRangeInfo();
            handler.fillData(this.tblMain, param, period, this.mainQuery, curInfo.getNumber());
        } else if (info instanceof InnerAccountInfo) {
            String acctNumber = ((InnerAccountInfo)info).getNumber();
            if (acctNumber == null || acctNumber.trim().length() == 0) {
                return;
            }
            handler.fillData(this.tblMain, param, acctNumber, this.mainQuery, curInfo.getNumber());
        }
        handler.setCurrencyFormat(this.tblMain, curInfo.getId());
    }

    protected void execQuery() throws BOSException {
        SummaryLedgerFilterParam param = (SummaryLedgerFilterParam)this.getFilterParam();
        if (param.isByCompany()) {
            this.getUIContext().put("selectCondition", EASResource.getString((String)resourcePath, (String)"accountUnit"));
            this.actionViewSubsidiaryLedger.setEnabled(true);
        } else {
            this.getUIContext().put("selectCondition", EASResource.getString((String)resourcePath, (String)"cm25"));
            this.actionViewSubsidiaryLedger.setEnabled(false);
        }
        CurrencyInfo curInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (curInfo == null) {
            return;
        }
        this.tblMain.checkParsed();
        AbstractSummaryLedgerHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        try {
            handler.initTree(param, this.treeList);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort();
        }
        if (param.isByCompany()) {
            FSClientHelper.setFirstInnerAcctNodeSelected(this.treeList);
        } else {
            FMClientHelper.goLeaf((KDTree)this.treeList);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new SummaryLedgerFilterUI();
        }
        return this.filterUI;
    }

    private void checkClearHourse() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
    }

    public void onLoad() throws Exception {
        this.checkClearHourse();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        super.onLoad();
        this.btnQuery.setText(this.resHelper.getString("ActionQuery.SHORT_DESCRIPTION"));
        this.btnPrint.setText(this.resHelper.getString("ActionPrint.SHORT_DESCRIPTION"));
        this.btnPrintPre.setText(this.resHelper.getString("ActionPrintPre.SHORT_DESCRIPTION"));
        this.btnRefresh.setText(this.resHelper.getString("ActionRefresh.NAME"));
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.treeList_valueChanged(null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewSubsidiaryLedger.setIcon(EASResource.getIcon((String)"imgTbtn_list"));
        this.kDMenuItemSubsidiaryLedger.setIcon(EASResource.getIcon((String)"imgTbtn_list"));
    }

    @Override
    public void actionViewSubsidiaryLedger_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node;
        Object info;
        boolean isValiNode;
        SubsidiaryLedgerFilterParam detailParam = new SubsidiaryLedgerFilterParam();
        SummaryLedgerFilterParam param = (SummaryLedgerFilterParam)this.getFilterParam();
        TreePath path = this.treeList.getSelectionPath();
        if (path == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource", (String)"SelectValidRecord"));
            SysUtil.abort();
        }
        if (!(isValiNode = (info = (node = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject()) instanceof InnerAccountInfo)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource", (String)"SelectValidRecord"));
            SysUtil.abort();
        }
        CurrencyInfo curInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        detailParam.setCompanyIds(param.getCompanyIdAry());
        detailParam.setByDay(param.isByDay());
        if (param.isByDay()) {
            detailParam.setFromDate(param.getFromDate());
            detailParam.setToDate(param.getToDate());
        } else {
            detailParam.setBeginYear(param.getBeginYear());
            detailParam.setBeginMonth(param.getBeginMonth());
            detailParam.setEndYear(param.getEndYear());
            detailParam.setEndMonth(param.getEndMonth());
        }
        detailParam.setDispUnUsed(param.isDispUnUsed());
        detailParam.setDispBalance(true);
        detailParam.setDispMouthTotal(true);
        detailParam.setDispYearTotal(true);
        detailParam.setDisDayTotal(true);
        detailParam.setOrderByCompany(true);
        SubsidiaryLedgerUI.showSubsidiaryLedgerUI((IUIObject)this, detailParam, node, curInfo);
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    public void parseAcctNumber(StringBuffer acctNumber, DefaultKingdeeTreeNode node) {
        int childCount = node.getChildCount();
        if (childCount == 0) {
            return;
        }
        for (int j = 0; j < childCount; ++j) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.treeList.getModel().getChild(node, j);
            if (childNode.getUserObject() instanceof InnerAccountInfo) {
                InnerAccountInfo innerAcct = (InnerAccountInfo)childNode.getUserObject();
                if (acctNumber.length() == 0) {
                    acctNumber.append(innerAcct.getNumber());
                    continue;
                }
                acctNumber.append(",");
                acctNumber.append(innerAcct.getNumber());
                continue;
            }
            if (childNode.getUserObject() instanceof AccountBankInfo) {
                AccountBankInfo bankAcct = (AccountBankInfo)childNode.getUserObject();
                if (acctNumber.length() == 0) {
                    acctNumber.append(bankAcct.getNumber());
                    continue;
                }
                acctNumber.append(",");
                acctNumber.append(bankAcct.getNumber());
                continue;
            }
            this.parseAcctNumber(acctNumber, childNode);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.lblCurrency.getBoundLabelText()).append("&[Currency]&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        HashMap map = new HashMap();
        map.put("selectCondition", this.getUIContext().get("selectCondition"));
        map.put("Company", this.getUIContext().get("currentNode"));
        if (currency != null) {
            map.put("Currency", currency.getName());
        }
        return map;
    }

    @Override
    public void actionTDPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"cm48"));
            SysUtil.abort();
        }
        if (this.tblMain.getSelectManager().getActiveRowIndex() == this.tblMain.getRowCount() - 1) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"COUNTLINE_NOT_PRINT"));
            SysUtil.abort();
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        SummaryLedgerDataProvider data = new SummaryLedgerDataProvider(this);
        appHlp.printPreview(SUMMARYLEDGER_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"cm48"));
            SysUtil.abort();
        }
        if (this.tblMain.getSelectManager().getActiveRowIndex() == this.tblMain.getRowCount() - 1) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"COUNTLINE_NOT_PRINT"));
            SysUtil.abort();
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        SummaryLedgerDataProvider data = new SummaryLedgerDataProvider(this);
        appHlp.print(SUMMARYLEDGER_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }
}

