/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.service.helper.PermissionParameterFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fm.be.SubmitPasswordFactory;
import com.kingdee.eas.fm.be.client.SubmitPasswordUI;
import com.kingdee.eas.fm.bond.BondUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.DefaultExRatePrecProvider;
import com.kingdee.eas.fm.common.client.DefaultOriginalCurrencyPrecProvider;
import com.kingdee.eas.fm.common.client.DefaultTablePrecisionFormat;
import com.kingdee.eas.fm.common.client.EReceiptCommonClientHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fs.ITransDownBill;
import com.kingdee.eas.fm.fs.ITransDownBillFacade;
import com.kingdee.eas.fm.fs.SourceTypeEnum;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransDownBillCollection;
import com.kingdee.eas.fm.fs.TransDownBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillStateEnum;
import com.kingdee.eas.fm.fs.client.AbstractTransDownBillListUI;
import com.kingdee.eas.fm.fs.client.ApplyTransBillRejectedUI;
import com.kingdee.eas.fm.fs.client.TransBaseBillQueryProcess;
import com.kingdee.eas.fm.fs.client.TransDownBillEditUI;
import com.kingdee.eas.fm.fs.client.TransDownBillFilterUI;
import com.kingdee.eas.fm.fs.client.TransDownBillHandler;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IFrameHelperFacade;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TransDownBillListUI
extends AbstractTransDownBillListUI {
    protected CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    public static final String TRANSDOWN_COPY = "COPY";
    private static final Logger logger = CoreUIObject.getLogger(TransDownBillListUI.class);
    TransDownBillFilterUI filterUI = null;
    public static final String PAYMENTBILL_FILENAME = "/FM/TR/Down";

    private void checkPassword() throws UIException {
        try {
            String checkFlag = SubmitPasswordFactory.getRemoteInstance().checkPassword("password");
            if ("0".equals(checkFlag)) {
                return;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SubmitPasswordUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow.getUIObject().getUIContext().get("password") == null || !uiWindow.getUIObject().getUIContext().get("password").equals("true")) {
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSubmitToBe_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        Component component = (Component)e.getSource();
        this.checkPassword();
        String error = "";
        String errorDetail = "";
        Map errorMap = new HashMap();
        try {
            ITransDownBillFacade facade = TransDownBillFacadeFactory.getRemoteInstance();
            errorMap = (Map)facade.batchCommitToBe(idSet).get("errorMap");
            for (String number : errorMap.keySet()) {
                String errorD = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"401_billNumber"), number, (String)errorMap.get(number));
                errorDetail = errorDetail + errorD;
            }
            error = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"402_commitToBeSuccess"), idSet.size() - errorMap.size(), errorMap.size());
            if ("true".equalsIgnoreCase(PermissionParameterFactory.getRemoteInstance().getPermissionParameter("EnableAutoSign"))) {
                this.actionSignature_actionPerformed(e);
            }
        }
        finally {
            this.refresh(e);
            if (!EmptyUtil.isEmpty((String)errorDetail)) {
                MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
            } else {
                FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
            }
        }
    }

    public TransDownBillListUI() throws Exception {
        DefaultTablePrecisionFormat precFmt = new DefaultTablePrecisionFormat();
        DefaultOriginalCurrencyPrecProvider origCurrPrecProvider = new DefaultOriginalCurrencyPrecProvider("currency.id");
        precFmt.setPrecProvider((ITablePrecisionProvider)origCurrPrecProvider);
        precFmt.initFormat(this.tblMain, new String[]{"totalAmt", "confirmedAmt", "amount"});
        DefaultTablePrecisionFormat precFmt2 = new DefaultTablePrecisionFormat();
        DefaultExRatePrecProvider exRatePrecProvider = new DefaultExRatePrecProvider("company.id", "currency.id", "bizDate");
        precFmt2.setPrecProvider((ITablePrecisionProvider)exRatePrecProvider);
        precFmt2.initFormat(this.tblMain, new String[]{"exchangeRate"});
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (String)this.getOprtState());
        super.onLoad();
        this.actionViewBdgBalance.setEnabled(true);
        this.actionViewBdgBalance.setVisible(true);
        if ("true".equalsIgnoreCase(PermissionParameterFactory.getRemoteInstance().getPermissionParameter("EnableAutoSign"))) {
            this.btnSignature.setVisible(false);
            this.btnViewSignature.setVisible(true);
            this.btnViewSignature.setEnabled(true);
        }
        if (!BondUtil.getBooleanParam(null, (String)"TM108", (CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionRejected.setVisible(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_payment"));
        this.actionUnConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unpayment"));
        this.actionSendReceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_send"));
        this.actionWithdrawReceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_replied"));
        this.actionSubmitToBe.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionBatchConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_selectall"));
        this.actionBatchSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionRejected.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fclose"));
        this.actionTdPrintView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionTdPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionNavEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionCreateTo.setVisible(false);
        this.actionTdPrint.setEnabled(true);
        this.actionTdPrintView.setEnabled(true);
    }

    @Override
    protected String getEditUIName() {
        return TransDownBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TransDownBillFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new TransDownBillFilterUI();
        }
        return this.filterUI;
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = this.tblMain.getColumn("seq").getColumnIndex();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("fpItem1.number"));
        sic.add(new SelectorItemInfo("entrys.outBgItemNumber"));
        sic.add(new SelectorItemInfo("entrys.unit.number"));
        sic.add(new SelectorItemInfo("entrys.fpItem.number"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.InnerAcct.id"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("mbgNumber"));
        sic.add(new SelectorItemInfo("mbgName"));
        sic.add(new SelectorItemInfo("entrys.fundFlowItem.*"));
        sic.add(new SelectorItemInfo("entrys.mbgNumber"));
        sic.add(new SelectorItemInfo("entrys.mbgName"));
        sic.add(new SelectorItemInfo("entrys.project.number"));
        sic.add(new SelectorItemInfo("entrys.project.name"));
        sic.add(new SelectorItemInfo("entrys.feeType.number"));
        sic.add(new SelectorItemInfo("entrys.feeType.name"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("motherAcctBank.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.name"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.name"));
        return sic;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new TransBaseBillQueryProcess();
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    private void changeButtonStatus() {
        boolean canCommittoBe;
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        if (row == null) {
            return;
        }
        int billStatus = ((BizEnumValueInfo)row.getCell("state").getValue()).getInt();
        boolean isVouchered = (Boolean)row.getCell("Fivouchered").getValue();
        boolean isCommittoBe = (Boolean)row.getCell("isCommittoBe").getValue();
        boolean[] billActionStatus = TransDownBillHandler.getBillActionStatus(billStatus);
        this.actionBatchSubmit.setEnabled(billStatus == 1);
        this.actionAudit.setEnabled(billActionStatus[0]);
        this.actionAntiAudit.setEnabled(billActionStatus[1]);
        this.actionConfirm.setEnabled(billActionStatus[2]);
        this.actionBatchConfirm.setEnabled(billActionStatus[2]);
        this.actionUnConfirm.setEnabled(billActionStatus[3]);
        this.actionSendReceipt.setEnabled(billActionStatus[4]);
        this.actionWithdrawReceipt.setEnabled(billActionStatus[5]);
        boolean bl = canCommittoBe = 3 == billStatus && !isCommittoBe;
        if (((Boolean)row.getCell("isTransDetail").getValue()).booleanValue()) {
            canCommittoBe = false;
        }
        this.actionSubmitToBe.setEnabled(canCommittoBe);
        boolean[] voucherActionStatus = TransDownBillHandler.getVoucherActionStatus(billStatus, isVouchered);
        this.actionVoucher.setEnabled(voucherActionStatus[0]);
        this.actionDelVoucher.setEnabled(voucherActionStatus[1]);
        Set idList = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
        if (idList != null && idList.size() > 1) {
            this.actionBatchSubmit.setEnabled(true);
            this.actionAudit.setEnabled(true);
            this.actionAntiAudit.setEnabled(true);
            this.actionConfirm.setEnabled(true);
            this.actionUnConfirm.setEnabled(true);
            this.actionSendReceipt.setEnabled(true);
            this.actionWithdrawReceipt.setEnabled(true);
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(true);
            this.actionBatchConfirm.setEnabled(true);
            this.actionSubmitToBe.setEnabled(true);
        }
        int smartType = 1;
        if (!EmptyUtil.isEmpty((Object)row.getCell("isSmart").getValue())) {
            smartType = ((BizEnumValueInfo)row.getCell("isSmart").getValue()).getInt();
        }
        if (smartType == 2 || smartType == 4) {
            this.actionOpenSmart.setEnabled(true);
            this.actionCloseSmart.setEnabled(false);
        } else if (smartType == 1 || smartType == 3) {
            this.actionOpenSmart.setEnabled(false);
            this.actionCloseSmart.setEnabled(true);
        } else {
            this.actionOpenSmart.setEnabled(false);
            this.actionCloseSmart.setEnabled(false);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBoforeEdit();
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)TRANSDOWN_COPY, (Object)TRANSDOWN_COPY);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private void checkBoforeEdit() throws TransBillException {
        this.checkSelected();
        int index = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(index);
        int state = ((BizEnumValueInfo)row.getCell("state").getValue()).getInt();
        String number = (String)row.getCell("number").getValue();
        if (state != 1 && state != 2) {
            throw new TransBillException(TransBillException.STATEERROREDIT, new Object[]{number});
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    private Set getSelectedIdSet() {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        return idSet;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        TransDownBillInfo info = ((ITransDownBill)this.getBizInterface()).getTransDownBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        IFrameHelperFacade facade1 = FrameHelperFacadeFactory.getRemoteInstance();
        Map idmap = facade1.getPlainTextMapCollection(info.getBOSType(), new IObjectPK[]{new ObjectUuidPK(id)}, "motherAcctBank");
        Set idSet = this.getSelectedIdSet();
        boolean hasWf = FMHelper.hasWFInstance(null, (String)this.getSelectedKeyValue());
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            ITransDownBillFacade facade = TransDownBillFacadeFactory.getRemoteInstance();
            Map result = facade.batchAudit(idSet);
            int success = (Integer)result.get("success");
            StringBuffer errorDetail = (StringBuffer)result.get("error");
            if (!EmptyUtil.isEmpty((String)errorDetail.toString())) {
                int failedCount = idSet.size() - success;
                String title = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"TransBaseBillAuditFail"), new Integer(success), new Integer(failedCount));
                MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)errorDetail.toString(), (int)0);
            } else {
                String title = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"TransBaseBillAuditSuccess");
                MsgBox.showInfo((Component)((Object)this), (String)title);
            }
        }
        this.refresh(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        Set idSet = this.getSelectedIdSet();
        ITransDownBillFacade facade = TransDownBillFacadeFactory.getRemoteInstance();
        Map result = facade.batchAntiAudit(idSet);
        int success = (Integer)result.get("success");
        StringBuffer errorDetail = (StringBuffer)result.get("error");
        if (!EmptyUtil.isEmpty((String)errorDetail.toString())) {
            int failedCount = idSet.size() - success;
            String title = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"TransBaseBillAntiAuditFail"), new Integer(success), new Integer(failedCount));
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)errorDetail.toString(), (int)0);
        } else {
            String title = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"TransBaseBillAntiAuditSuccess");
            MsgBox.showInfo((Component)((Object)this), (String)title);
        }
        this.refresh(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkBoforeConfirm();
        String id = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "CONFIRM");
        uiWindow.show();
    }

    private void checkBoforeConfirm() throws TransBillException {
        this.checkSelected();
        int index = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(index);
        int state = ((BizEnumValueInfo)row.getCell("state").getValue()).getInt();
        String number = (String)row.getCell("number").getValue();
        if (state != 3) {
            throw new TransBillException(TransBillException.STATEERRORDOWNCONFIRM);
        }
    }

    @Override
    public void actionUnConfirm_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        int result;
        Set idSet = this.getSelectedIdSet();
        ITransDownBillFacade facade = TransDownBillFacadeFactory.getRemoteInstance();
        boolean hasSendReceipt = facade.hasSendReceipt(idSet);
        if (hasSendReceipt && (result = MsgBox.showConfirm3((Component)((Object)this), (String)(msg = EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"unConfirmMsg")))) != 0) {
            return;
        }
        facade.unConfirm(idSet);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        this.refresh(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSendReceipt_actionPerformed(ActionEvent e) throws Exception {
        int successCounts;
        Set idSet = this.getSelectedIdSet();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList ids = new ArrayList(idSet);
        ArrayList appliedList = new ArrayList();
        ArrayList appliedFailList = new ArrayList();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(ids);
            for (int i = 0; i < ids.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(ids.get(i));
                if (boolResult.booleanValue()) {
                    appliedList.add(ids.get(i));
                    continue;
                }
                appliedFailList.add(ids.get(i));
            }
            ITransDownBillFacade facade = TransDownBillFacadeFactory.getRemoteInstance();
            successCounts = 0;
            if (appliedList.size() > 0) {
                successCounts = facade.sendReceipt(new HashSet(appliedList));
            }
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e, (int)successCounts);
        this.refresh(e);
    }

    @Override
    public void actionWithdrawReceipt_actionPerformed(ActionEvent e) throws Exception {
        Set idSet = this.getSelectedIdSet();
        ITransDownBillFacade facade = TransDownBillFacadeFactory.getRemoteInstance();
        int successCounts = facade.withdrawReceipt(idSet);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e, (int)successCounts);
        this.refresh(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        TransDownBillInfo info = ((ITransDownBill)this.getBizInterface()).getTransDownBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        FMClientHelper.viewBgBalance((Component)((Object)this), null, null, (IObjectValue)info);
    }

    @Override
    public void actionTdPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fs.TransDownBillHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "TransDownBillHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        String entryDsName = "TransDownBillEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fs.TransDownBillEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "parentId");
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(PAYMENTBILL_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTdPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fs.TransDownBillHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "TransDownBillHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        String entryDsName = "TransDownBillEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fs.TransDownBillEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "parentId");
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(PAYMENTBILL_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "bizDate", "motherAcctBank", "usage", "currency.name", "exchangeRate", "totalAmt", "totalCounts", "confirmedAmt", "confirmedCounts", "seq", "state", "isCommittoBe", "isUrgent", "Fivouchered", "accessories", "creator.name", "auditor.name", "cashier.name", "accountant.name", "unitAcctBank", "recBank", "differBank", "differPlace", "payeeArea", "subAcct", "unit", "amount", "isSuccess", "isSendReceipt", "bgItem", "recProvince", "recCity", "project", "sourceType", "feeType.name"};
    }

    @Override
    public void actionRejected_actionPerformed(ActionEvent e) throws Exception {
        super.actionRejected_actionPerformed(e);
        ApplyTransBillRejectedUI.show((CoreUIObject)this, this.getSelectedIdSet(), SourceTypeEnum.APPTRANSDOWN);
        this.refresh(e);
    }

    private void checkRejected() throws EASBizException, BOSException {
        TransDownBillInfo info = this.getSelectedInfo();
        if (!TransDownBillStateEnum.SAVED.equals((Object)info.getState()) && !TransDownBillStateEnum.SUBMITED.equals((Object)info.getState())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"286_TransDownBillListUI"));
            SysUtil.abort();
        }
        if (!SourceTypeEnum.APPTRANSDOWN.equals((Object)info.getSourceType())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"287_TransDownBillListUI"));
            SysUtil.abort();
        }
    }

    private TransDownBillInfo getSelectedInfo() throws EASBizException, BOSException {
        this.checkSelected();
        return TransDownBillFactory.getRemoteInstance().getTransDownBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    @Override
    public void actionBatchConfirm_actionPerformed(ActionEvent e) throws Exception {
        Boolean boolResult;
        int i;
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        this.checkBoforeConfirm();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("number");
        evi.getSelector().add("company.id");
        evi.getSelector().add("id");
        TransDownBillCollection coll = TransDownBillFactory.getRemoteInstance().getTransDownBillCollection(evi);
        HashMap<String, TransDownBillInfo> idInfoMap = new HashMap<String, TransDownBillInfo>();
        TransDownBillInfo info = null;
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        for (int i2 = 0; i2 < coll.size(); ++i2) {
            info = coll.get(i2);
            iPermission.checkDataPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "TRANS_DOWN_CONFIRM", (IObjectPK)new ObjectUuidPK(info.getId().toString()));
            idInfoMap.put(info.getId().toString(), info);
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        List idList = FMHelper.set2List((Set)idSet);
        ArrayList appliedList = new ArrayList();
        String errorDetail = "";
        Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
        for (i = 0; i < idList.size(); ++i) {
            boolResult = (Boolean)resultRequest.get(idList.get(i));
            if (!boolResult.booleanValue()) continue;
            appliedList.add(idList.get(i));
        }
        for (i = 0; i < idList.size(); ++i) {
            boolResult = (Boolean)resultRequest.get(idList.get(i));
            if (boolResult.booleanValue()) continue;
            TransDownBillInfo downInfo = (TransDownBillInfo)idInfoMap.get(idList.get(i));
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"411_reqMutex_error"), downInfo.getNumber()) + "\n";
            errorDetail = errorDetail + msg;
        }
        Set appliedSet = FMHelper.list2Set(appliedList);
        Map map = TransDownBillFacadeFactory.getRemoteInstance().batchConfirm(appliedSet);
        for (String id : map.keySet()) {
            errorDetail = errorDetail + (String)map.get(id) + "\n";
        }
        String error = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"403_batchConfirmSuccess"), appliedList.size() - map.size(), idList.size() - (appliedList.size() - map.size()));
        Component component = (Component)e.getSource();
        this.refresh(e);
        MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        if (appliedList.size() > 0) {
            iMutex.batchReleaseObjIDForUpdate(appliedList);
        }
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        Map map = TransDownBillFactory.getRemoteInstance().batchSubmit(idSet);
        String errorDetail = (String)map.get("errorDetail");
        this.refresh(e);
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"289_TransDownBillListUI");
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
        SysUtil.abort();
    }

    protected IRow appendFootRow() {
        IRow footRow = super.appendFootRow();
        if (footRow != null) {
            String[] numberCols = new String[]{"totalAmt", "totalCounts", "confirmedAmt", "confirmedCounts"};
            int[] numberColsPrecision = new int[]{4, 0, 4, 0};
            for (int i = 0; i < numberCols.length; ++i) {
                this.tblMain.getFootRow(0).getCell(numberCols[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)numberColsPrecision[i]));
            }
        }
        return footRow;
    }

    @Override
    public void actionNavEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptCommonClientHelper.viewEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    @Override
    public void actionOpenSmart_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList validList = this.getSelectedIdValues();
        Set validSet = FMHelper.list2Set((List)validList);
        BatchExecuteResult result = new BatchExecuteResult();
        result = (BatchExecuteResult)TransDownBillFactory.getRemoteInstance().openSmart(validSet);
        StringBuffer errorDetail = new StringBuffer();
        if (!EmptyUtil.isEmpty((Object)result) && !EmptyUtil.isEmpty((Collection)result.getDetailMsgList())) {
            for (int i = 0; i < result.getDetailMsgList().size(); ++i) {
                errorDetail.append((String)result.getDetailMsgList().get(i) + "\n");
            }
        }
        if (EmptyUtil.isEmpty((String)errorDetail.toString())) {
            MsgBox.showInfo((String)result.getSummaryMsg());
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)result.getSummaryMsg(), (String)errorDetail.toString(), (int)0);
        }
        this.refresh(e);
    }

    @Override
    public void actionCloseSmart_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList validList = this.getSelectedIdValues();
        Set validSet = FMHelper.list2Set((List)validList);
        BatchExecuteResult result = new BatchExecuteResult();
        result = (BatchExecuteResult)TransDownBillFactory.getRemoteInstance().closeSmart(validSet);
        StringBuffer errorDetail = new StringBuffer();
        if (!EmptyUtil.isEmpty((Object)result) && !EmptyUtil.isEmpty((Collection)result.getDetailMsgList())) {
            for (int i = 0; i < result.getDetailMsgList().size(); ++i) {
                errorDetail.append((String)result.getDetailMsgList().get(i) + "\n");
            }
        }
        if (EmptyUtil.isEmpty((String)errorDetail.toString())) {
            MsgBox.showInfo((String)result.getSummaryMsg());
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)result.getSummaryMsg(), (String)errorDetail.toString(), (int)0);
        }
        this.refresh(e);
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }
}

