/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.TransAmtInfo;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public abstract class TransUpDownBillHandler {
    public static final String resClassName = "com.kingdee.eas.fm.fs.TransBillResource";
    private static final String COL_SEQ = "seq";
    public static final String COL_UNITACCTBANK = "unitAcctBank";
    public static final String COL_RECPROVINCE = "recProvince";
    public static final String COL_RECCITY = "recCity";
    public static final String COL_SUBACCT = "subAcct";
    public static final String COL_UNIT_INNERACCT = "unitInnerAcct";
    public static final String COL_UNIT = "unit";
    public static final String COL_UNITID = "unitID";
    public static final String COL_AMOUNT = "amount";
    public static final String COL_ISSUCCESSED = "isSuccessed";
    private static final String COL_DESC = "description";
    public static final String COL_FPITEM = "fpItem";
    public static final String COL_BGITEM = "bgItem";
    public static final String COL_RECBANK = "recBank";
    public static final String COL_PAYEEBANKCODE = "payeeBankCode";
    public static final String COL_BALANCE = "balance";
    protected TransUpDownBillHelper helper = null;
    protected static final boolean[][] billActionStatus = new boolean[][]{{false, false, false, false, false, false, false}, {true, false, false, false, false, false, false}, {false, true, true, false, false, false, true}, {false, false, false, true, true, true, false}};
    protected static final boolean[][] voucherActionStatus = new boolean[][]{{false, false}, {true, false}, {false, true}};

    public static int confirmClearEntry(CoreUIObject ui, KDTable table) {
        if (table == null || table.getRowCount3() <= 0) {
            return 0;
        }
        String msg = EASResource.getString((String)resClassName, (String)"confirmClearEntry");
        return MsgBox.showConfirm3((Component)ui, (String)msg);
    }

    public static String getResString(String resName) {
        return EASResource.getString((String)resClassName, (String)resName);
    }

    public void initKDTable(KDTable table) {
        table.checkParsed();
        table.getColumn(COL_SEQ).getStyleAttributes().setHided(true);
        table.getColumn(COL_SEQ).getStyleAttributes().setLocked(true);
        table.getColumn(COL_UNIT).getStyleAttributes().setLocked(true);
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(true);
        prmt.setDisplayFormat("$number$ $name$");
        prmt.setEditFormat("$number$");
        prmt.setCommitFormat("$number$");
        prmt.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
        table.getColumn(COL_UNITACCTBANK).setEditor((ICellEditor)editor);
        if (table.getColumn(COL_RECPROVINCE) != null) {
            KDBizPromptBox prmtProvince = new KDBizPromptBox();
            prmtProvince.setEditable(true);
            prmtProvince.setDisplayFormat("$name$");
            prmtProvince.setCommitFormat("$name$");
            prmtProvince.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7ProvinceQuery");
            ExtendParser parserProvince = new ExtendParser(prmtProvince);
            prmtProvince.setCommitParser((IParser)parserProvince);
            prmtProvince.setMaxLength(80);
            KDTDefaultCellEditor editorProvince = new KDTDefaultCellEditor((IKDEditor)prmtProvince);
            table.getColumn(COL_RECPROVINCE).setEditor((ICellEditor)editorProvince);
        }
        if (table.getColumn(COL_RECCITY) != null) {
            KDBizPromptBox prmtCity = new KDBizPromptBox();
            prmtCity.setEditable(true);
            prmtCity.setDisplayFormat("$name$");
            prmtCity.setCommitFormat("$name$");
            prmtCity.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CityQuery");
            ExtendParser parserCity = new ExtendParser(prmtCity);
            prmtCity.setCommitParser((IParser)parserCity);
            prmtCity.setMaxLength(80);
            KDTDefaultCellEditor editorCity = new KDTDefaultCellEditor((IKDEditor)prmtCity);
            table.getColumn(COL_RECCITY).setEditor((ICellEditor)editorCity);
        }
        KDCheckBox cbx = new KDCheckBox();
        KDTDefaultCellEditor editor3 = new KDTDefaultCellEditor((JCheckBox)cbx);
        table.getColumn(COL_ISSUCCESSED).setEditor((ICellEditor)editor3);
        KDTextField txt = new KDTextField();
        txt.setMaxLength(80);
        KDTDefaultCellEditor editor2 = new KDTDefaultCellEditor((JTextField)txt);
        table.getColumn(COL_DESC).setEditor((ICellEditor)editor2);
        if (table.getColumn(COL_BGITEM) != null) {
            KDBizPromptBox prmtbgItem = new KDBizPromptBox();
            FMClientHelper.initBgItemF7((KDBizPromptBox)prmtbgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
            KDTDefaultCellEditor bgEditor = new KDTDefaultCellEditor((IKDEditor)prmtbgItem);
            table.getColumn(COL_BGITEM).setEditor((ICellEditor)bgEditor);
            table.getColumn(COL_BGITEM).getStyleAttributes().setHided(false);
        }
    }

    public void setPayeeAreaEvi(KDBizPromptBox prmtPayeeArea, AccountBankInfo acctBankInfo) {
        int type = -1;
        if (acctBankInfo != null && acctBankInfo.getBankInterfaceType() != null) {
            type = acctBankInfo.getBankInterfaceType().getValue();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankInterfaceType", (Object)new Integer(type)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        prmtPayeeArea.setEntityViewInfo(evi);
        prmtPayeeArea.getQueryAgent().resetRuntimeEntityView();
    }

    public void initAmtEditor(KDTable table, String currencyId) throws Exception {
        if (EmptyUtil.isEmpty((String)currencyId)) {
            return;
        }
        table.checkParsed();
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)currencyId));
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField((KDTable)table, (String)COL_AMOUNT, (int)prec, (BigDecimal)Constants.MIN_VALUE);
        FMClientHelper.setNumberFormat((KDTable)table, (String)COL_AMOUNT, (String)currencyId);
        if (table.getColumn(COL_BALANCE) != null) {
            BookNotifyClientHelper.setTableCellEditorByFormattedTextField((KDTable)table, (String)COL_BALANCE, (int)prec, (BigDecimal)Constants.MIN_VALUE);
            FMClientHelper.setNumberFormat((KDTable)table, (String)COL_BALANCE, (String)currencyId);
        }
    }

    public static boolean isLocalCurrency(String currencyId, CompanyOrgUnitInfo company) {
        CurrencyInfo localCurrency;
        boolean isLocCurrency = false;
        if (currencyId == null) {
            return isLocCurrency;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (currencyId.equals((localCurrency = company.getBaseCurrency()).getId().toString())) {
            isLocCurrency = true;
        }
        return isLocCurrency;
    }

    public void setTotalAmt(KDTable table, KDFormattedTextField txtTotalAmt) {
        BigDecimal sumAmt = this.getEntrySumAmt(table, COL_AMOUNT, false);
        txtTotalAmt.setValue((Object)sumAmt);
    }

    public void setConfirmedAmt(KDTable table, KDFormattedTextField txtConfirmedAmt) {
        BigDecimal sumAmt = this.getEntrySumAmt(table, COL_AMOUNT, true);
        txtConfirmedAmt.setValue((Object)sumAmt);
    }

    public BigDecimal getEntrySumAmt(KDTable table, String colName, boolean isCalConfirm) {
        if (table == null || table.getRowCount3() < 1 || colName == null) {
            return Constants.ZERO;
        }
        IRow row = null;
        Object obj = null;
        BigDecimal sumAmt = Constants.ZERO;
        BigDecimal tempAmt = Constants.ZERO;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            boolean isConfirmed;
            row = table.getRow(i);
            if (isCalConfirm && ((obj = row.getCell(COL_ISSUCCESSED).getValue()) == null || !(isConfirmed = ((Boolean)obj).booleanValue())) || row.getCell(colName).getValue() == null) continue;
            tempAmt = (BigDecimal)row.getCell(colName).getValue();
            sumAmt = sumAmt.add(tempAmt);
        }
        return sumAmt;
    }

    public void setEntrySeq(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        int seq = 1;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            if (row.getCell(COL_SEQ) == null) continue;
            row.getCell(COL_SEQ).setValue((Object)new Integer(seq++));
        }
    }

    public void setEntryBalance(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        boolean seq = true;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            if (row.getCell(COL_BALANCE) == null) continue;
            row.getCell(COL_SEQ).setValue(null);
        }
    }

    public void setTotalCounts(KDTable table, KDFormattedTextField txt) {
        int counts = this.getCounts(table, false);
        txt.setValue((Object)new Integer(counts));
    }

    public void setConfirmedCounts(KDTable table, KDFormattedTextField txt) {
        int counts = this.getCounts(table, true);
        txt.setValue((Object)new Integer(counts));
    }

    private int getCounts(KDTable table, boolean isCalConfirm) {
        if (table == null || table.getRowCount3() < 1) {
            return 0;
        }
        if (!isCalConfirm) {
            return table.getRowCount3();
        }
        int count = 0;
        Object obj = null;
        IRow row = null;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            boolean isConfirmed;
            row = table.getRow(i);
            obj = row.getCell(COL_ISSUCCESSED).getValue();
            if (obj == null || !(isConfirmed = ((Boolean)obj).booleanValue())) continue;
            ++count;
        }
        return count;
    }

    public static EntityViewInfo getMotherAcctBankEvi(String companyId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo getSettleTypeEvi() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public EntityViewInfo getUnitAcctBankEvi(String motherAcctBankId) throws EASBizException, BOSException {
        Set idSet = this.helper.getUnitAcctBankIdSet(motherAcctBankId);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public void setUnitAcctBankEvi(String motherAcctBankId, KDBizPromptBox prmtBox) throws EASBizException, BOSException {
        prmtBox.setEntityViewInfo(this.getUnitAcctBankEvi(motherAcctBankId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("openArea.*");
        sic.add("bank.*");
        prmtBox.setSelectorCollection(sic);
    }

    public TransAmtInfo getTransAmtInfo(String unitAcctBankId, String currencyId) throws EASBizException, BOSException {
        return this.helper.getTransAmtInfo(unitAcctBankId, currencyId);
    }

    public void batchFill(KDTable table, String motherAcctBankId, String currencyId) throws EASBizException, BOSException {
        table.removeRows();
        if (EmptyUtil.isEmpty((String)motherAcctBankId) || EmptyUtil.isEmpty((String)currencyId)) {
            return;
        }
        List list = this.helper.getTransAmtList(motherAcctBankId, currencyId);
        TransAmtInfo amtInfo = null;
        IRow row = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            AccountBankInfo unitAcctBankInfo;
            amtInfo = (TransAmtInfo)list.get(i);
            row = table.addRow();
            amtInfo.getAcctBank().setDisplayFormat("$number$ $name$");
            row.getCell(COL_UNITACCTBANK).setValue((Object)amtInfo.getAcctBank());
            if (row.getCell(COL_SUBACCT) != null) {
                row.getCell(COL_SUBACCT).setValue((Object)amtInfo.getSubAcct());
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)amtInfo.getUnitInnerAcct())) {
                amtInfo.getUnitInnerAcct().setDisplayFormat("$name$");
                if (row.getCell(COL_UNIT_INNERACCT) != null) {
                    row.getCell(COL_UNIT_INNERACCT).setValue((Object)amtInfo.getUnitInnerAcct());
                }
            }
            row.getCell(COL_UNIT).setValue((Object)amtInfo.getUnit());
            if (row.getCell(COL_UNITID) != null && amtInfo.getUnit().getId() != null) {
                row.getCell(COL_UNITID).setValue((Object)amtInfo.getUnit().getId());
            }
            if (row.getCell("fundFlowItem") != null) {
                FundFlowItemInfo fundFlowItemInfo = null;
                try {
                    fundFlowItemInfo = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo((IObjectPK)new ObjectUuidPK("ZjkAAACV6cRggo5y"));
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                if (fundFlowItemInfo != null) {
                    row.getCell("fundFlowItem").setValue((Object)fundFlowItemInfo);
                }
            }
            if (row.getCell(COL_AMOUNT) != null) {
                row.getCell(COL_AMOUNT).setValue((Object)amtInfo.getAmount());
            }
            if (row.getCell(COL_ISSUCCESSED) != null) {
                row.getCell(COL_ISSUCCESSED).setValue((Object)Boolean.FALSE);
            }
            if (amtInfo.getAcctBank().getOpenArea() != null) {
                if (!EmptyUtil.isEmpty((Object)row.getCell(COL_RECPROVINCE))) {
                    row.getCell(COL_RECPROVINCE).setValue((Object)amtInfo.getAcctBank().getOpenArea().getProvince());
                }
                if (!EmptyUtil.isEmpty((Object)row.getCell(COL_RECCITY))) {
                    row.getCell(COL_RECCITY).setValue((Object)amtInfo.getAcctBank().getOpenArea().getName());
                }
            }
            if (row.getCell(COL_RECBANK) != null) {
                unitAcctBankInfo = amtInfo.getAcctBank();
                row.getCell(COL_RECBANK).setValue((Object)unitAcctBankInfo.getBank().getName());
            }
            if (row.getCell(COL_PAYEEBANKCODE) == null) continue;
            unitAcctBankInfo = amtInfo.getAcctBank();
            String item = BEBankFactory.getRemoteInstance().getBankNo(unitAcctBankInfo.getBank().getName());
            row.getCell(COL_PAYEEBANKCODE).setValue((Object)item);
        }
    }

    public void batchFillBalance(KDTable kdtEntrys, Set acctBankUnitSet, String currencyId, String oprtState) throws EASBizException, BOSException {
        Map amtMap = this.helper.getTransAcctBankAmt(acctBankUnitSet, currencyId);
        TransAmtInfo amtInfo = null;
        boolean isAddNew = OprtState.ADDNEW.equals(oprtState);
        for (int i = 0; i < kdtEntrys.getRowCount(); ++i) {
            IRow row = kdtEntrys.getRow(i);
            if (row.getCell(COL_UNITACCTBANK) == null || row.getCell(COL_UNITACCTBANK).getValue() == null) continue;
            AccountBankInfo acctBankInfo = (AccountBankInfo)row.getCell(COL_UNITACCTBANK).getValue();
            String key = acctBankInfo.getId().toString() + "_" + currencyId;
            amtInfo = (TransAmtInfo)amtMap.get(key);
            if (row.getCell(COL_BALANCE) != null && amtInfo != null) {
                row.getCell(COL_BALANCE).setValue((Object)amtInfo.getBalance());
            }
            if (row.getCell(COL_AMOUNT) == null || !isAddNew || amtInfo == null) continue;
            row.getCell(COL_AMOUNT).setValue((Object)amtInfo.getAmount());
        }
    }

    public void fillEntryAmt(KDTable table, String currencyId) throws EASBizException, BOSException {
        IRow row = null;
        TransAmtInfo amtInfo = null;
        AccountBankInfo unitAcctBankInfo = null;
        String unitAcctBankId = null;
        int size = table.getRowCount3();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            unitAcctBankInfo = (AccountBankInfo)row.getCell(COL_UNITACCTBANK).getValue();
            if (unitAcctBankInfo == null || (amtInfo = this.helper.getTransAmtInfo(unitAcctBankId = unitAcctBankInfo.getId().toString(), currencyId)) == null) continue;
            row.getCell(COL_AMOUNT).setValue((Object)amtInfo.getAmount());
        }
    }

    public static void checkEntryValid(IUIObject ui, KDTable table) throws EASBizException {
        IRow row = null;
        AccountBankInfo info = null;
        HashMap<String, TempData> map = new HashMap<String, TempData>();
        String key = null;
        BigDecimal amount = Constants.ZERO;
        boolean allIsZero = true;
        boolean isRepeatAccountBank = false;
        int count = table.getRowCount();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            TempData tmpDate;
            row = table.getRow(rowIndex);
            if (!(row.getCell(COL_UNITACCTBANK).getValue() instanceof AccountBankInfo)) continue;
            info = (AccountBankInfo)row.getCell(COL_UNITACCTBANK).getValue();
            key = info.getId().toString();
            if (!map.containsKey(key)) {
                tmpDate = new TempData();
                tmpDate.rowNumber.add(new Integer(rowIndex + 1));
                tmpDate.acctBank = info.getName();
                map.put(key, tmpDate);
            } else {
                tmpDate = (TempData)map.get(key);
                tmpDate.rowNumber.add(new Integer(rowIndex + 1));
                isRepeatAccountBank = true;
            }
            amount = row.getCell(COL_AMOUNT) == null ? Constants.ZERO : (BigDecimal)row.getCell(COL_AMOUNT).getValue();
            if (amount.signum() == 0) continue;
            allIsZero = false;
        }
        if (isRepeatAccountBank) {
            String str = TransUpDownBillHandler.composeMap(map);
            int ret = MsgBox.showConfirm3((Component)((Component)ui), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"295_TransUpDownBillHandler"), (String)str);
            if (0 != ret) {
                SysUtil.abort();
            }
        }
        if (allIsZero) {
            throw new TransBillException(TransBillException.ENTRYAMTISALLZERO);
        }
    }

    private static String composeMap(Map map) {
        String ret = "";
        for (TempData tmpData : map.values()) {
            boolean isFirst = true;
            String numberLine = null;
            if (tmpData.rowNumber.size() <= 1) continue;
            for (Integer intValue : tmpData.rowNumber) {
                if (isFirst) {
                    isFirst = false;
                    numberLine = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"404_theNumber"), (int)intValue);
                    continue;
                }
                numberLine = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"405_andTheNumber"), (int)intValue);
            }
            ret = ret + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"299_TransUpDownBillHandler") + numberLine + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"300_TransUpDownBillHandler") + tmpData.acctBank + "\n";
        }
        return ret;
    }

    static class TempData {
        List rowNumber = new ArrayList();
        String acctBank;

        TempData() {
        }
    }
}

