/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fm.be.AccBankBalanceTypeEnum;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BankAccountBalanceCaculator
implements ICalculator,
IMethodBatchQuery {
    private ICalculateContextProvider calProvider;
    private Context context;
    private List paramList = new ArrayList();
    private Map companyMap = new HashMap(400);
    private Map currencyMap = new HashMap(50);

    public BankAccountBalanceCaculator() {
    }

    public BankAccountBalanceCaculator(ICalculateContextProvider calContext, Context serverCtxParam) {
        this.calProvider = calContext;
        this.context = serverCtxParam;
    }

    public void initCalculateContext(ICalculateContextProvider calProvider) {
        this.calProvider = calProvider;
        this.context = this.calProvider.getServerContext();
    }

    public BigDecimal BankBalanceExt(String companyNum, String accountBankNum, String bizDate, String dataType) throws BOSException, EASBizException {
        return null;
    }

    public boolean batchQuery(Map methods) {
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.execute(param);
        }
        return true;
    }

    public void execute(SortedParameterArray params) {
        this.initParam(params);
        this.calculate();
        this.handleResult(params);
    }

    private void handleResult(SortedParameterArray params) {
        for (int i = 0; i < this.paramList.size(); ++i) {
            Parameter param = params.getParameter(i);
            Param result = (Param)this.paramList.get(i);
            if (result.isHasException()) {
                param.setValue((Object)result.getException().getMessage());
                continue;
            }
            if (result.getResult() == null) {
                param.setValue((Object)Constants.ZERO);
                continue;
            }
            param.setValue(result.getResult());
        }
    }

    private void initParam(SortedParameterArray params) {
        this.cacheData();
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            Parameter param = params.getParameter(i);
            Param p = new Param(param);
            p.init();
            this.paramList.add(p);
        }
    }

    private void calculate() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TOP 1 a.FBizDate, a.FlstBalance, a.fBalance, a.fValiBalance, a.FCompanyId, a.FAccountBankid, a.FCurrencyId, a.FBankInterfaceType, a.FaccurateBizDate,ACCOUNTBANK.FisClosed,ACCOUNTBANK.FcloseDate \n").append("  \tFROM T_BE_AccountBankBalance as a \n").append("  \tLEFT JOIN T_ORG_Company AS COMPANY ON a.FCompanyID = COMPANY.FID \n").append("  \tLEFT JOIN T_BD_AccountBanks AS ACCOUNTBANK ON a.FAccountBankID = ACCOUNTBANK.FID \n").append("\tWHERE 1=1 AND a.FBizDate <=  ? \n");
        SQLUtil builder = null;
        Param param = null;
        ResultSet rs = null;
        for (int i = 0; i < this.paramList.size(); ++i) {
            BigDecimal lstBalance = FMConstants.ZERO;
            BigDecimal balance = FMConstants.ZERO;
            BigDecimal valiBalance = FMConstants.ZERO;
            param = (Param)this.paramList.get(i);
            Set accountBankSet = param.getAccountBankIdSet();
            for (String accountBankId : accountBankSet) {
                builder = new SQLUtil();
                builder.appendSql(sql.toString());
                builder.addParam((Object)param.getBizDate());
                if (param.getCompanyIdSet() != null && !param.getCompanyIdSet().isEmpty()) {
                    builder.appendSql(" AND ");
                    builder.appendParam("a.FCompanyId", param.getCompanyIdSet().toArray());
                }
                builder.appendSql(" AND ");
                builder.appendSql(" ACCOUNTBANK.fid = '" + accountBankId + "' ");
                builder.appendSql(" ORDER\u3000BY a.FBizDate DESC ");
                try {
                    rs = builder.exeQuery(this.context);
                    if (!rs.next() || rs.getString("FisClosed") == null) continue;
                    if (rs.getBoolean("FisClosed") && rs.getDate("FcloseDate") != null) {
                        if (!param.getBizDate().before(rs.getDate("FcloseDate"))) continue;
                        if (null != rs.getBigDecimal("FlstBalance")) {
                            lstBalance = lstBalance.add(rs.getBigDecimal("FlstBalance"));
                        }
                        if (null != rs.getBigDecimal("Fbalance")) {
                            balance = balance.add(rs.getBigDecimal("Fbalance"));
                        }
                        if (null == rs.getBigDecimal("FvaliBalance")) continue;
                        valiBalance = valiBalance.add(rs.getBigDecimal("FvaliBalance"));
                        continue;
                    }
                    if (rs.getBoolean("FisClosed")) continue;
                    if (null != rs.getBigDecimal("FlstBalance")) {
                        lstBalance = lstBalance.add(rs.getBigDecimal("FlstBalance"));
                    }
                    if (null != rs.getBigDecimal("Fbalance")) {
                        balance = balance.add(rs.getBigDecimal("Fbalance"));
                    }
                    if (null == rs.getBigDecimal("FvaliBalance")) continue;
                    valiBalance = valiBalance.add(rs.getBigDecimal("FvaliBalance"));
                }
                catch (SQLException e) {
                    ExceptionHandler.handle((Throwable)e);
                    param.setException(e);
                }
                catch (BOSException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                    param.setException((Exception)((Object)e1));
                }
            }
            if (param.getData().equals((Object)AccBankBalanceTypeEnum.lstBalance)) {
                param.setResult(lstBalance);
                continue;
            }
            if (param.getData().equals((Object)AccBankBalanceTypeEnum.CurBalance)) {
                param.setResult(balance);
                continue;
            }
            if (!param.getData().equals((Object)AccBankBalanceTypeEnum.valiBalance)) continue;
            param.setResult(valiBalance);
        }
    }

    private void cacheData() {
        EntityViewInfo evi = this.getEvi();
        try {
            CompanyOrgUnitCollection comColl = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitCollection(evi);
            int size = comColl.size();
            for (int i = 0; i < size; ++i) {
                CompanyOrgUnitInfo comInfo = comColl.get(i);
                this.companyMap.put(comInfo.getNumber(), comInfo.getId().toString());
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private EntityViewInfo getEvi() {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        evi.setSelector(sic);
        return evi;
    }

    private class Param {
        private final Parameter param;
        private Set companyIdSet = new HashSet();
        private Set accountBankIdSet = new HashSet();
        private Date bizDate;
        private AccBankBalanceTypeEnum data;
        private boolean hasException = false;
        private Exception ex;
        private Object result;
        DateFormat FORMAT_DAY = new SimpleDateFormat("yyyy-MM-dd");

        public Param(Parameter param) {
            this.param = param;
        }

        public Set getCompanyIdSet() {
            return this.companyIdSet;
        }

        public void setCompanyIdSet(Set companyIdSet) {
            this.companyIdSet = companyIdSet;
        }

        public Set getAccountBankIdSet() {
            return this.accountBankIdSet;
        }

        public void setAccountBankIdSet(Set accountBankIdSet) {
            this.accountBankIdSet = accountBankIdSet;
        }

        public Date getBizDate() {
            return this.bizDate;
        }

        public void setBizDate(Date bizDate) {
            this.bizDate = bizDate;
        }

        public AccBankBalanceTypeEnum getData() {
            return this.data;
        }

        public void setData(AccBankBalanceTypeEnum data) {
            this.data = data;
        }

        public boolean isHasException() {
            return this.hasException;
        }

        public void setHasException(boolean hasException) {
            this.hasException = hasException;
        }

        public void setException(Exception ex) {
            this.ex = ex;
            this.hasException = true;
        }

        public Exception getException() {
            return this.ex;
        }

        public Parameter getParam() {
            return this.param;
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public void init() {
            Object[] args = this.param.getArgs();
            String companyNums = args[0].toString();
            String accountBankNums = args[1].toString();
            String bizDateStr = args[2].toString();
            String type = args[3].toString();
            this.initCompanyIdSet(companyNums);
            this.initAccountBankIdSet(accountBankNums);
            this.initDates(bizDateStr);
            this.initDataType(type);
        }

        private void initAccountBankIdSet(String accountBankNums) {
            if (FMHelper.isEmpty((String)accountBankNums)) {
                return;
            }
            String[] accountBankNum = accountBankNums.split(";");
            HashSet<String> accountBankNumSet = new HashSet<String>();
            for (int i = 0; i < accountBankNum.length; ++i) {
                accountBankNumSet.add(accountBankNum[i].trim());
            }
            try {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", accountBankNumSet, CompareType.INCLUDE));
                EntityViewInfo evi = BankAccountBalanceCaculator.this.getEvi();
                evi.setFilter(filter);
                IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)BankAccountBalanceCaculator.this.context);
                AccountBankCollection coll = iAccountBank.getAccountBankCollection(evi);
                for (int i = 0; i < coll.size(); ++i) {
                    this.accountBankIdSet.add(coll.get(i).getId().toString());
                }
                if (this.accountBankIdSet == null || this.accountBankIdSet.isEmpty()) {
                    this.setHasException(true);
                    this.setException((Exception)((Object)new BOSException(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"380_NtPayableBatchCalculator"))));
                }
            }
            catch (BOSException e) {
                this.setHasException(true);
                this.setException((Exception)((Object)e));
                ExceptionHandler.handle((Throwable)e);
            }
        }

        private void initDataType(String type) {
            if (!StringUtils.isEmpty((String)type)) {
                this.data = AccBankBalanceTypeEnum.getEnum((String)type);
                if (this.data == null) {
                    this.setHasException(true);
                    this.setException((Exception)((Object)new BOSException("Data Type Error!")));
                }
            } else {
                this.setHasException(true);
                this.setException((Exception)((Object)new BOSException("Data Type Null!")));
            }
        }

        private void initDates(String bizDateStr) {
            if (!StringUtils.isEmpty((String)bizDateStr)) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    DateFormat format = FMHelper.getNationalDateFormat((Context)BankAccountBalanceCaculator.this.context);
                    this.bizDate = dateFormat.parse(dateFormat.format(format.parse(bizDateStr)));
                }
                catch (ParseException e) {
                    this.setHasException(true);
                    this.setException(e);
                }
            } else {
                this.bizDate = (Date)BankAccountBalanceCaculator.this.calProvider.getReportAdapter().getReportProperty("Report_EndDate");
            }
        }

        private void initCompanyIdSet(String companyNums) {
            if (!StringUtils.isEmpty((String)companyNums)) {
                String[] companyNum = companyNums.split(";");
                for (int i = 0; i < companyNum.length; ++i) {
                    Object companyId = BankAccountBalanceCaculator.this.companyMap.get(companyNum[i].trim());
                    this.companyIdSet.add(companyId);
                    if (companyId != null) continue;
                    this.setHasException(true);
                    this.setException((Exception)((Object)new BOSException("One Or More Company Number Is Invalid!")));
                }
            } else {
                String reportCompanyId = (String)BankAccountBalanceCaculator.this.calProvider.getReportAdapter().getReportProperty("Company.ID");
                this.companyIdSet.add(reportCompanyId);
            }
        }
    }
}

