/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.util.client.EASResource;

public class FundTransferBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        FundTransferBillInfo loanInfo = this.getFundTransferBillInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        JournalInfo journalInfo = this.createJournalInfoAmt(loanInfo);
        journalColl.add(journalInfo);
        return journalColl;
    }

    private JournalInfo createJournalInfoAmt(FundTransferBillInfo info) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getDistributeAcctBank());
        journalInfo.setCurrency(info.getCurrency());
        journalInfo.setCreateDate(info.getBizDate());
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setCreditAmount(info.getLoanAmt());
        journalInfo.setIsDebit(false);
        journalInfo.setBizDate(info.getEffectiveDate());
        journalInfo.setAccountView(info.getDistributeAcctBank().getAccount());
        journalInfo.setOppAccountView(info.getOpAcctView());
        journalInfo.setBillType(BillTypeEnum.fundTransferBill);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setDescription(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"46_FundTransferBillBookNotifyBuilder"));
        journalInfo.setCompany(info.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private FundTransferBillInfo getFundTransferBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        FundTransferBillInfo info = FundTransferBillFactory.getLocalInstance(ctx).getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("distributeAcctBank.account.*");
        return sic;
    }
}

