/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.IvtModuleResourceReader;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillFactory;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.client.AbstractFundTransRateAdjustBillEditUI;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;

public class FundTransRateAdjustBillEditUI
extends AbstractFundTransRateAdjustBillEditUI {
    private boolean successFlag;
    public static final String FUNDTRANSRATEADJUSTBILL_FILENAME = "/FM/INVEST/FT/FUNDTRANSRATEADJUSTBILL";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        super.onLoad();
        this.prmtOpp.setVisible(true);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        try {
            FundTransferBillInfo loanInfo = this.editData.getLoan();
            if (loanInfo != null) {
                this.cboRelations.setSelectedItem((Object)loanInfo.getRelationWithCmp());
                this.prmtAcctBank.setValue((Object)loanInfo.getDistributeAcctBank());
                this.prmtLoan.setValue((Object)loanInfo);
                if (loanInfo.getRelationWithCmp() == RelationshipWithLoanCompanyEnum.INTERIOR) {
                    this.prmtOpp.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
                    this.prmtOpp.getQueryAgent().resetRuntimeEntityView();
                    this.prmtOpp.setValue((Object)loanInfo.getTransCompany());
                    this.prmtOpp.setData((Object)loanInfo.getTransCompany());
                    this.prmtOpp.setToolTipText(loanInfo.getTransCompany().getName());
                    this.prmtOpp.setText(loanInfo.getTransCompany().getName());
                    this.contOpp.setBoundLabelText(IvtModuleResourceReader.getMsg((String)"transCompany"));
                } else {
                    this.prmtOpp.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerQuery");
                    this.prmtOpp.getQueryAgent().resetRuntimeEntityView();
                    this.prmtOpp.setValue((Object)loanInfo.getCustomer());
                    this.contOpp.setBoundLabelText(IvtModuleResourceReader.getMsg((String)"customer"));
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e.getCause());
        }
        this.actionRemove.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkAdjustDate});
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransRateAdjustBillFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.doBizCheck();
    }

    private void doBizCheck() {
        if (this.txtYearDays.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"yearday_error"));
            SysUtil.abort();
        }
        if (this.txtRateAfterAdjt.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"rate_error"));
            SysUtil.abort();
        }
        if (this.txtPenaRateAfterAdj.getBigDecimalValue().compareTo(Constants.ZERO) < 0 || this.txtPenaRateAfterAdj.getBigDecimalValue().compareTo(Constants.ONE_HUNDRED) >= 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"penarate_error"));
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getRateExpression() != null) {
            this.comboRateExpression.setSelectedItem((Object)this.editData.getRateExpression());
        }
        if (this.editData.getPenAccrualType() != null) {
            this.comboPenAccrualType.setSelectedItem((Object)this.editData.getPenAccrualType());
        }
        this.txtYearDays.setValue((Object)new Integer(this.editData.getYearDays()));
    }

    private SelectorItemCollection getLoanInfoSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("transCompany.id"));
        sic.add(new SelectorItemInfo("transCompany.name"));
        sic.add(new SelectorItemInfo("transCompany.number"));
        sic.add(new SelectorItemInfo("distributeAcctBank.id"));
        sic.add(new SelectorItemInfo("distributeAcctBank.name"));
        sic.add(new SelectorItemInfo("distributeAcctBank.number"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.number"));
        return sic;
    }

    protected IObjectValue createNewData() {
        FundTransRateAdjustBillInfo rateAdjustInfo = new FundTransRateAdjustBillInfo();
        if (this.getUIContext().get("loanid") != null) {
            IObjectPK pk = (IObjectPK)this.getUIContext().get("loanid");
            try {
                FundTransferBillInfo loanInfo = FundTransferBillFactory.getRemoteInstance().getFundTransferBillInfo(pk, this.getLoanInfoSelector());
                rateAdjustInfo.setLoan(loanInfo);
                rateAdjustInfo.setAdjustSeq(loanInfo.getAdjustRateTimes() + 1);
                rateAdjustInfo.setLastAdjustDate(loanInfo.getLastAdjustDate());
                rateAdjustInfo.setCurrency(loanInfo.getCurrency());
                rateAdjustInfo.setAdjustDate(DateUtil.getDayBegin());
                rateAdjustInfo.setRateExpression(IntRateTypeExpressionEnum.YEAR);
                rateAdjustInfo.setYearDays(IvtModualUtils.VALUE_360);
                rateAdjustInfo.setRateAfterAdjt(Constants.ZERO);
                rateAdjustInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
                rateAdjustInfo.setPenaRateAfterAdj(Constants.ZERO);
                rateAdjustInfo.setCompany(this.currentCompany);
                rateAdjustInfo.setCreator(this.userinfo);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        } else {
            rateAdjustInfo.setAdjustDate(DateUtil.getDayBegin());
            rateAdjustInfo.setRateExpression(IntRateTypeExpressionEnum.YEAR);
            rateAdjustInfo.setYearDays(IvtModualUtils.VALUE_360);
            rateAdjustInfo.setRateAfterAdjt(Constants.ZERO);
            rateAdjustInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
            rateAdjustInfo.setPenaRateAfterAdj(Constants.ZERO);
            rateAdjustInfo.setCompany(this.currentCompany);
        }
        return rateAdjustInfo;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.successFlag = true;
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.disposeUIWindow();
    }

    public static void show(CoreUIObject ui, IObjectPK pk) throws EASBizException, UIException {
        if (pk == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"loanid", (Object)pk);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FundTransRateAdjustBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean flag = ((FundTransRateAdjustBillEditUI)uiWindow.getUIObject()).getSuccessFlag();
        if (flag) {
            uiWindow.close();
        }
    }

    private boolean getSuccessFlag() {
        return false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("loan.*");
        select.add("creator.name");
        select.add("company.name");
        select.add(new SelectorItemInfo("loan.transCompany.name"));
        select.add(new SelectorItemInfo("loan.customer.name"));
        select.add(new SelectorItemInfo("loan.distributeAcctBank.name"));
        return select;
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransRateAdjustBillTDPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransRateAdjustBillTDPrint(true);
    }

    private void fundTransRateAdjustBillTDPrint(boolean isPreview) {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        idSet.add(this.editData.getId());
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransRateAdjustBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSRATEADJUSTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSRATEADJUSTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }
}

