/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillFactory;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillInfo;
import com.kingdee.eas.fm.ft.client.AbstractFundTransRateAdjustBillListUI;
import com.kingdee.eas.fm.ft.client.FundTransRateAdjustBilFilterUI;
import com.kingdee.eas.fm.ft.client.FundTransRateAdjustBillEditUI;
import com.kingdee.eas.fm.ft.client.FundTransRateAdjustBillListUIQueryProcessor;
import com.kingdee.eas.fm.ft.client.FundTrasnferBillChooseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundTransRateAdjustBillListUI
extends AbstractFundTransRateAdjustBillListUI {
    private Set setIDs;
    private static final Logger logger = CoreUIObject.getLogger(FundTransRateAdjustBillListUI.class);
    private String uiParam;
    private LicenseService licenseService = new LicenseService((IUIObject)this);
    private FundTransRateAdjustBilFilterUI filter;
    FillListener fillListener = new FillListener();
    public static final String FUNDTRANSRATEADJUSTBILL_FILENAME = "/FM/IM/FUNDTRANSRATEADJUSTBILL";

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompanyCommon);
        this.uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.uiParam != null) {
            this.licenseService.checkLicence();
            if (this.getBOTPViewStatus() != 1 && this.uiParam.equals("DO_ADJUST")) {
                this.checkHasNumber();
                this.setIDs = FundTrasnferBillChooseUI.show((CoreUI)this);
                if (this.setIDs == null) {
                    SysUtil.abort();
                }
            }
        }
        super.onLoad();
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(this.actionAuditResult.isEnabled());
        this.actionCreateTo.setVisible(false);
        this.actionCreateTo.setEnabled(false);
        this.actionWorkFlowG.setEnabled(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAddNew.setVisible(false);
    }

    private void checkHasNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new FundTransRateAdjustBillInfo(), this.currentCompanyCommon.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new FundTransRateAdjustBillListUIQueryProcessor();
    }

    protected void execQuery() {
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.setIDs = null;
    }

    private String parseValue(Set setIDs) {
        StringBuffer returnSb = new StringBuffer();
        Object[] ids = setIDs.toArray();
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                returnSb.append(ids[i].toString());
                continue;
            }
            returnSb.append(ids[i].toString()).append(",");
        }
        return returnSb.toString();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filter == null) {
            this.filter = new FundTransRateAdjustBilFilterUI();
        }
        return this.filter;
    }

    protected String getEditUIName() {
        return FundTransRateAdjustBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransRateAdjustBillFactory.getRemoteInstance();
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 2;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionRateAdjust.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_backwarddepreciat"));
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    public void actionRateAdjust_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasNumber();
        this.setIDs = FundTrasnferBillChooseUI.show((CoreUI)this);
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.refresh(e);
        }
    }

    private FundTransRateAdjustBillInfo getSelectInfo() throws Exception {
        this.checkSelected();
        return FundTransRateAdjustBillFactory.getRemoteInstance().getFundTransRateAdjustBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getCustomerSelectors());
    }

    private SelectorItemCollection getCustomerSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add("loan.adjustRateTimes");
        return selector;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.deleteCheck();
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.editCheck();
        super.actionEdit_actionPerformed(e);
    }

    private void editCheck() throws Exception {
        FundTransRateAdjustBillInfo rateAdjustInfo = this.getSelectInfo();
        if (rateAdjustInfo.isIsUsed()) {
            MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"rateAdjBillEdit_error1"));
            SysUtil.abort();
        }
        if (rateAdjustInfo.getAdjustSeq() != rateAdjustInfo.getLoan().getAdjustRateTimes()) {
            MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"rateAdjBillEdit_error2"));
            SysUtil.abort();
        }
    }

    private void deleteCheck() throws Exception {
        FundTransRateAdjustBillInfo rateAdjustInfo = this.getSelectInfo();
        if (rateAdjustInfo.getAdjustSeq() != rateAdjustInfo.getLoan().getAdjustRateTimes()) {
            MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"rateAdjBillDelete_error2"));
            SysUtil.abort();
        }
        if (rateAdjustInfo.isIsUsed()) {
            MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"rateAdjBillDelete_error1"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransRateAdjustBillTDPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransRateAdjustBillTDPrint(true);
    }

    private void fundTransRateAdjustBillTDPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransRateAdjustBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(FMHelper.list2Set((List)idList), headPK);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSRATEADJUSTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSRATEADJUSTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }

    public boolean destroyWindow() {
        try {
            this.licenseService.releaseLicense();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return super.destroyWindow();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(FundTransRateAdjustBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                if (row.getCell("transCompany.name").getValue() != null) {
                    row.getCell("oppName").setValue(row.getCell("transCompany.name").getValue());
                } else {
                    row.getCell("oppName").setValue(row.getCell("customer.name").getValue());
                }
                this.setAmtCellNumberFormat(row);
            }
        }

        private void setAmtCellNumberFormat(IRow row) {
            String rateFormat = "";
            BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("rateExpression").getValue();
            Object enu = exp.getValue();
            rateFormat = "year".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
            row.getCell("rateAfterAdjt").getStyleAttributes().setNumberFormat(rateFormat);
            row.getCell("rateAfterAdjt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            exp = (BizEnumValueInfo)row.getCell("penAccrualType").getValue();
            enu = exp.getValue();
            rateFormat = "addPercent".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
            row.getCell("penaRateAfterAdj").getStyleAttributes().setNumberFormat(rateFormat);
            row.getCell("penaRateAfterAdj").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("yearDays").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

