/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationDetailCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationDetailFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationDetailInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.ReturnWayEnum;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.GuaranteeTypeCollection;
import com.kingdee.eas.fm.fin.GuaranteeTypeFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.MainConLoanFactory;
import com.kingdee.eas.fm.fin.MainConLoanInfo;
import com.kingdee.eas.fm.fin.client.F7FinancingProductsTreeUI;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.ft.FundTransRepayingPlanCollection;
import com.kingdee.eas.fm.ft.FundTransRepayingPlanInfo;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBillStatusEnum;
import com.kingdee.eas.fm.ft.FundTransferInterestBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.LoanAndRepayEntryCollection;
import com.kingdee.eas.fm.ft.LoanAndRepayEntryEnum;
import com.kingdee.eas.fm.ft.LoanAndRepayEntryInfo;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferBillEditUI;
import com.kingdee.eas.fm.ft.client.FundTransClientHelper;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FundTransferBillEditUI
extends AbstractFundTransferBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferBillEditUI.class);
    public static final String FUNDTRANSFERBILL_FILENAME = "/FM/INVEST/FT/FUNDTRANSFERBILL";

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (FMHelper.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "ft_loan_02addnew";
        }
        return "ft_loan_01view";
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        if (this.pkEffectiveDate.getSqlDate() != null && this.pkMaturityDate.getSqlDate() != null) {
            this.editData.setHorizon(FinHorizon.getHorizon((KDDatePicker)this.pkEffectiveDate, (KDDatePicker)this.pkMaturityDate));
        }
        this.fillRepayTableToVo();
        this.fillLoanAndRepayTableToVo();
        String tmp = this.contRate.getBoundLabelText();
        if (tmp.indexOf("(") != -1 && tmp.indexOf(")") != -1) {
            tmp = tmp.substring(tmp.indexOf("(") + 1, tmp.indexOf(")"));
            this.editData.setRateForDisplay(this.editData.getRate() + tmp);
        }
        if ((tmp = this.contPenaRate.getBoundLabelText()).indexOf("(") != -1 && tmp.indexOf(")") != -1) {
            tmp = tmp.substring(tmp.indexOf("(") + 1, tmp.indexOf(")"));
        }
        this.editData.setPenaRateForDisplay(this.editData.getPenaRate() + tmp);
        this.editData.setRate(this.txtRate.getBigDecimalValue());
        this.editData.setFivouchered(false);
        this.editData.setLastAdjustDate(this.editData.getEffectiveDate());
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.actionRecount_actionPerformed(e);
        super.actionSubmit_actionPerformed(e);
        this.restoreData();
        this.calcCompsValueAtEditState();
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkBizDate});
    }

    private void restoreData() {
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void fillRepayTableToVo() {
        this.editData.getRepayingPlan().clear();
        for (int i = 0; i < this.kdtRepayingPlan.getRowCount(); ++i) {
            FundTransRepayingPlanInfo ftrp = new FundTransRepayingPlanInfo();
            IRow row = this.kdtRepayingPlan.getRow(i);
            Integer seq = (Integer)row.getCell("seq").getValue();
            Date returnDate = (Date)row.getCell("repayingDate").getValue();
            BigDecimal returnAmt = (BigDecimal)row.getCell("repayingAmt").getValue();
            ftrp.setSeq(seq);
            ftrp.setRepayingDate(DateTimeUtils.truncateDate((Date)returnDate));
            ftrp.setRepayingAmt(returnAmt);
            this.editData.getRepayingPlan().add(ftrp);
        }
    }

    private void fillLoanAndRepayTableToVo() {
        this.editData.getLoanAndRepay().clear();
        for (int i = 0; i < this.kdtLoanAndRepay.getRowCount(); ++i) {
            LoanAndRepayEntryInfo info = new LoanAndRepayEntryInfo();
            IRow row = this.kdtLoanAndRepay.getRow(i);
            LoanInfo loanInfo = (LoanInfo)row.getCell("loan").getValue();
            MainConLoanInfo mainConLoanInfo = (MainConLoanInfo)row.getCell("mainConLoan").getValue();
            BigDecimal useAmt = (BigDecimal)row.getCell("useAmt").getValue();
            BigDecimal returnAmt = (BigDecimal)row.getCell("returnAmt").getValue();
            BigDecimal occAmt = (BigDecimal)row.getCell("occAmt").getValue();
            BigDecimal loanRate = (BigDecimal)row.getCell("loanRate").getValue();
            LoanAndRepayEntryEnum loanAndRepayEntryEnum = (LoanAndRepayEntryEnum)((Object)row.getCell("state").getValue());
            info.setSeq(i);
            info.setLoan(loanInfo);
            info.setMainConLoan(mainConLoanInfo);
            info.setUseAmt(useAmt);
            info.setReturnAmt(returnAmt);
            info.setOccAmt(occAmt);
            info.setLoanRate(loanRate);
            info.setState(loanAndRepayEntryEnum);
            this.editData.getLoanAndRepay().add(info);
        }
    }

    public void initDataStatus() {
        super.initDataStatus();
        FundTransferBillInfo transferInfo = (FundTransferBillInfo)this.getDataObject();
        Boolean isAddHis = (Boolean)this.getUIContext().get("IS_ADD_HIS");
        boolean ishis = transferInfo.isIsHistoryBill();
        if (isAddHis != null && isAddHis.booleanValue() || ishis) {
            this.pkLastSettleDate.setEnabled(true);
            this.txtLoanBalanceAmt.setEnabled(true);
            this.setUITitle_History();
        } else {
            this.pkLastSettleDate.setEnabled(false);
            this.txtLoanBalanceAmt.setEnabled(false);
        }
        boolean isActionEnabled = this.getOprtState().equals(OprtState.VIEW) || "FINDVIEW".equals(this.getOprtState());
        this.btnAddPlan.setEnabled(!isActionEnabled);
        this.btnDelPlan.setEnabled(!isActionEnabled);
        this.actionAddNew.setEnabled(!isActionEnabled);
        this.actionAddNew.setVisible(!isActionEnabled);
        this.actionCreateFrom.setEnabled(!isActionEnabled);
        this.actionCreateFrom.setVisible(!isActionEnabled);
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.actionPre.setEnabled(false);
            this.actionPre.setVisible(false);
            this.actionNext.setEnabled(false);
            this.actionNext.setVisible(false);
            this.actionFirst.setEnabled(false);
            this.actionFirst.setVisible(false);
            this.actionLast.setEnabled(false);
            this.actionLast.setVisible(false);
        }
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            if (transferInfo.getStatus() == FundTransferBillStatusEnum.SAVE) {
                this.txtLoanBalanceAmt.setEnabled(transferInfo.isIsHistoryBill());
                this.pkLastSettleDate.setEnabled(transferInfo.isIsHistoryBill());
                this.actionSave.setEnabled(true);
                this.actionSave.setVisible(true);
                this.actionAddNew.setEnabled(true);
                this.actionAddNew.setVisible(true);
            } else {
                this.actionSave.setEnabled(false);
                this.actionSave.setVisible(false);
                this.actionAddNew.setEnabled(false);
                this.actionAddNew.setVisible(false);
                this.txtLoanBalanceAmt.setEnabled(transferInfo.isIsHistoryBill());
                this.pkLastSettleDate.setEnabled(transferInfo.isIsHistoryBill());
            }
        } else {
            this.kdtRepayingPlan.setEditable(false);
        }
        if (transferInfo.getRelationWithCmp() == RelationshipWithLoanCompanyEnum.INTERIOR) {
            this.contTransCompany.setVisible(true);
            if (this.getBOTPViewStatus() == 1) {
                this.prmtTransCompany.setEnabled(false);
            } else {
                this.prmtTransCompany.setEnabled(true);
            }
            this.contCustomer.setVisible(false);
            this.prmtCustomer.setEnabled(false);
        } else {
            this.contTransCompany.setVisible(false);
            this.prmtTransCompany.setEnabled(false);
            this.contCustomer.setVisible(true);
            if (this.getBOTPViewStatus() == 1) {
                this.prmtCustomer.setEnabled(false);
                this.comboRelationWithCmp.setEnabled(false);
            } else {
                this.prmtCustomer.setEnabled(true);
                this.comboRelationWithCmp.setEnabled(true);
            }
        }
        if (this.getUIContext().get("wfInstInfo") != null) {
            this.actionCreateFrom.setVisible(false);
            this.actionCreateFrom.setEnabled(false);
        }
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPersonalSite.setVisible(false);
        if (this.getBOTPViewStatus() == 1 && !FMHelper.isEmpty((String)transferInfo.getSourceBillId()) && BOSUuid.read((String)transferInfo.getSourceBillId()).getType().equals((Object)new ReceivableBillInfo().getBOSType())) {
            this.actionSave.setEnabled(false);
        }
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.kDTabbedPane1.setEnabledAt(this.kDTabbedPane1.indexOfComponent((Component)this.kDPanel1), false);
        this.btnAddLoan.setEnabled(true);
        this.btnDelLoan.setEnabled(true);
        this.btnRecount.setEnabled(true);
    }

    private void setUITitle_History() {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setUITitle(FundTransClientHelper.getFTModualMsg("history_bill_add_new"));
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.setUITitle(FundTransClientHelper.getFTModualMsg("history_bill_edit"));
        } else if (this.getOprtState().equals(OprtState.VIEW)) {
            this.setUITitle(FundTransClientHelper.getFTModualMsg("history_bill_view"));
        }
    }

    @Override
    public void loadFields() {
        CompanyOrgUnitInfo company;
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        } else {
            company = SysContext.getSysContext().getCurrentFIUnit();
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)company.getBaseCurrency());
        }
        if (this.isSetPrecisionAuto()) {
            try {
                this.setPrecision();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e.getCause());
            }
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        } else {
            company = SysContext.getSysContext().getCurrentFIUnit();
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)company.getBaseCurrency());
        }
        if (this.editData.getIntRateExpression() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboIntRateExpression, (Object)this.editData.getIntRateExpression());
            this.txtYearDays.setValue((Object)new Integer(this.editData.getYearDays()));
        }
        if (this.editData.getFinacingProduct() == null && this.comboFinacingProduct.getItemCount() > 0) {
            this.comboFinacingProduct.setSelectedIndex(0);
        }
        if (this.editData.getExchangeRate() != null && this.editData.getExchangeRate().compareTo(Constants.ZERO) > 0) {
            this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
        this.comboRelationWithCmp.setSelectedItem((Object)this.editData.getRelationWithCmp());
        this.comboReturnWay.setSelectedItem((Object)this.editData.getReturnWay());
        this.pkEffectiveDate.setValue((Object)this.editData.getEffectiveDate());
        this.pkMaturityDate.setValue((Object)this.editData.getMaturityDate());
        this.pkBizDate.setValue((Object)this.editData.getBizDate());
        this.txtLoanAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtRate.setValue((Object)this.editData.getRate());
        try {
            this.comboRelationWithCmp_itemStateChanged(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (this.editData.getRelationWithCmp() == RelationshipWithLoanCompanyEnum.EXTERIOR && null != this.editData.getCustomer().getId().toString()) {
            try {
                CustomerInfo customerInfo = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(this.editData.getCustomer().getId().toString()));
                this.prmtCustomer.setValue((Object)customerInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.prmtTransCompany.setValue((Object)this.editData.getTransCompany());
        this.setOtheValuesRelatedEffeDate((Date)this.pkMaturityDate.getValue());
        this.pkLastSettleDate.setValue((Object)this.editData.getLastSettleDate());
        this.fillRepayPlanTable();
        this.fillLoanAndRepayTable();
        this.restoreData();
        this.txtYearDays.setPrecision(0);
        String srcBillID = (String)this.getUIContext().get("srcBillID");
        if (null != srcBillID && FMHelper.isInstanceof((String)srcBillID, LoanApplyBillInfo.class)) {
            try {
                EntityViewInfo evi;
                LoanApplyBillInfo labInfo = LoanApplyBillFactory.getRemoteInstance().getLoanApplyBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (labInfo.getGuaranteeTypeInputMode() != null) {
                    evi = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("property", (Object)new Integer(labInfo.getGuaranteeTypeInputMode().getValue())));
                    evi.setFilter(filter);
                    GuaranteeTypeCollection gtc = GuaranteeTypeFactory.getRemoteInstance().getGuaranteeTypeCollection(evi);
                    if (null != gtc && gtc.size() > 0) {
                        this.prmtGuaranteeType.setValue((Object)gtc.get(0));
                    }
                }
                if (labInfo.getIntRateType() != null) {
                    evi = new EntityViewInfo();
                    evi.getSelector().add(new SelectorItemInfo("*"));
                    evi.getSelector().add(new SelectorItemInfo("factorDay"));
                    IntRateTypeInfo intRateInfo = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK(labInfo.getIntRateType().getId()), evi.getSelector());
                    this.prmtRateType.setData((Object)intRateInfo);
                    this.txtFloatingPoint.setValue((Object)labInfo.getBasePoints());
                    this.comboIntRateExpression.setSelectedItem((Object)labInfo.getIntRateTypeExpression());
                    this.txtRate.setValue((Object)labInfo.getYieldRate());
                    this.txtYearDays.setValue((Object)new Integer(labInfo.getYearDays()));
                }
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        if (!EmptyUtil.isEmpty((Object)this.editData.isIsLoanAndRepay()) && this.editData.isIsLoanAndRepay()) {
            this.kDTabbedPane1.setEnabledAt(this.kDTabbedPane1.indexOfComponent((Component)this.kDPanel1), true);
        }
    }

    private void fillRepayPlanTable() {
        FundTransRepayingPlanCollection repaycol = this.editData.getRepayingPlan();
        this.kdtRepayingPlan.removeRows();
        for (int i = 0; i < repaycol.size(); ++i) {
            FundTransRepayingPlanInfo info = repaycol.get(i);
            IRow row = this.kdtRepayingPlan.addRow();
            row.getCell("seq").setValue((Object)new Integer(info.getSeq()));
            row.getCell("repayingDate").setValue((Object)info.getRepayingDate());
            row.getCell("repayingAmt").setValue((Object)info.getRepayingAmt());
        }
    }

    private void fillLoanAndRepayTable() {
        LoanAndRepayEntryCollection loanAndRepaycol = this.editData.getLoanAndRepay();
        this.kdtLoanAndRepay.removeRows();
        for (int i = 0; i < loanAndRepaycol.size(); ++i) {
            LoanAndRepayEntryInfo info = loanAndRepaycol.get(i);
            IRow row = this.kdtLoanAndRepay.addRow();
            row.getCell("seq").setValue((Object)new Integer(info.getSeq()));
            row.getCell("state").setValue((Object)info.getState());
            row.getCell("loan").setValue((Object)info.getLoan());
            row.getCell("mainConLoan").setValue((Object)info.getMainConLoan());
            row.getCell("useAmt").setValue((Object)info.getUseAmt());
            row.getCell("returnAmt").setValue((Object)info.getReturnAmt());
            row.getCell("occAmt").setValue((Object)info.getOccAmt());
            BigDecimal loanRate = info.getLoanRate().setScale(5, 4);
            row.getCell("loanRate").setValue((Object)loanRate);
            if (info.getState() == null || !info.getState().equals((Object)LoanAndRepayEntryEnum.PERMUTATION)) continue;
            row.getCell("loan").getStyleAttributes().setLocked(true);
            row.getCell("useAmt").getStyleAttributes().setLocked(true);
        }
        try {
            this.caculateAllInRate();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getCause());
        }
    }

    public void onLoad() throws Exception {
        if (!this.getOprtState().equals("FINDVIEW")) {
            ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        }
        this.initTable();
        this.txtIntFreeAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtGuaranteeAmt.setMinimumValue((Comparable)Constants.ZERO);
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        super.onLoad();
        KDPromptSelector opseelect = F7SelectorFactory.getAccountF7((IUIObject)this, (String)this.currentCompany.getId().toString());
        this.prmtSettleAcctView.setSelector(opseelect);
        this.prmtOpAcctView.setSelector(opseelect);
        FMClientHelper.setCustomerF7((CoreUI)this, (KDBizPromptBox)this.prmtCustomer, (boolean)true, null);
        F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)this.prmtTransCompany, (boolean)false);
        this.initOtherControls();
        this.menuItemSave.setVisible(this.btnSave.isVisible());
        this.dealWithReturnWay();
        this.prmtTransCompany.setEditFormat("$number$");
        this.actionAddPlan.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionDelPlan.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.prmtOpAcctView.setCommitFormat("$number$");
        this.restoreData();
        this.txtDescription.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        if (this.getBOTPViewStatus() == 1) {
            SupplierInfo info = null;
            try {
                ReceivableBillInfo receivableBillInfo;
                String srcBillID = (String)this.getUIContext().get("srcBillID");
                if (null != srcBillID && FMHelper.isInstanceof((String)srcBillID, ReceivableBillInfo.class) && (receivableBillInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(srcBillID))).getDeliverSupp() != null && !(info = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(receivableBillInfo.getDeliverSupp().getId().toString()))).isIsInternalCompany() && info.getInternalCompany() == null) {
                    this.prmtTransCompany.setEnabled(true);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
        this.calcCompsValueAtEditState();
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.comboCurrency.getSelectedItem();
    }

    protected void resetPrecisionForLocalAmt() {
        super.resetPrecisionForLocalAmt();
        this.txtLoanAmtLocal.setPrecision(this.getBaseCurrencyPrecision());
    }

    protected void resetPrecisionForOtherComponent() {
        super.resetPrecisionForOtherComponent();
        this.txtFloatingPoint.setPrecision(2);
    }

    private void initOtherControls() {
        this.pkBizDate.setSupportedEmpty(false);
        this.pkEffectiveDate.setSupportedEmpty(false);
        this.pkMaturityDate.setSupportedEmpty(false);
        this.pkLastSettleDate.setSupportedEmpty(false);
        this.txtGuaranteeAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtPenaRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtLoanBalanceAmt.setMinimumValue((Comparable)Constants.ZERO);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransferBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        FundTransferBillInfo ftInfo = new FundTransferBillInfo();
        this.setDefaultValues(ftInfo);
        return ftInfo;
    }

    private void setDefaultValues(FundTransferBillInfo ftInfo) {
        ftInfo.setAdjustRateTimes(0);
        Date NOW = DateTimeUtils.truncateDate((Date)DateUtil.getDayBegin());
        ftInfo.setEffectiveDate(NOW);
        ftInfo.setIsGenLoan(false);
        ftInfo.setMaturityDate(NOW);
        ftInfo.setBizDate(NOW);
        ftInfo.setYearDays(360);
        ftInfo.setIsHistoryBill(false);
        ftInfo.setRepayTotalAmt(Constants.ZERO);
        ftInfo.setStatus(FundTransferBillStatusEnum.SAVE);
        ftInfo.setFloatingPoint(Constants.ZERO);
        ftInfo.setLoanAmt(Constants.ZERO);
        ftInfo.setLoanBalanceAmt(Constants.ZERO);
        ftInfo.setPenaRate(Constants.ZERO);
        ftInfo.setIntFreeAmt(Constants.ZERO);
        ftInfo.setRate(Constants.ZERO);
        ftInfo.setGuaranteeAmt(Constants.ZERO);
        ftInfo.setIntRateExpression(IntRateTypeExpressionEnum.YEAR);
        ftInfo.setYearDays(360);
        ftInfo.setReturnWay(ReturnWayEnum.AT_TERM_WITH_ORI_AMT);
        ftInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
        ftInfo.setLoanAmtLocal(Constants.ZERO);
        ftInfo.setCreator(this.userinfo);
        ftInfo.setRelationWithCmp(RelationshipWithLoanCompanyEnum.INTERIOR);
        try {
            IntRateTypeInfo rateType = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK(ResourceFactory.getConsultativeRate()));
            ftInfo.setRateType(rateType);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        ftInfo.setRelationWithCmp(RelationshipWithLoanCompanyEnum.INTERIOR);
        ftInfo.setReturnWay(ReturnWayEnum.AT_TERM_WITH_ORI_AMT);
        ftInfo.setLastSettleDate(DateUtil.getBeforeDay((Date)NOW));
        ftInfo.setCompany(this.currentCompany);
        ftInfo.setRepayTimes(0);
        ftInfo.setAdjustRateTimes(0);
        ftInfo.setExtTimes(0);
        ftInfo.getRepayingPlan().clear();
        ftInfo.getRepayingPlan().add(this.createDefaultRepayPlan(null));
        Boolean isAddHis = (Boolean)this.getUIContext().get("IS_ADD_HIS");
        if (isAddHis == null) {
            ftInfo.setIsHistoryBill(false);
        } else {
            ftInfo.setIsHistoryBill(isAddHis);
        }
        ftInfo.setIsOverdue(false);
        ftInfo.setFloatAction(FloatActionEnum.BASEINTRATE_FLOAT);
    }

    private FundTransRepayingPlanInfo createDefaultRepayPlan(FundTransferBillInfo ftInfo) {
        Date NOW = DateTimeUtils.truncateDate((Date)DateUtil.getDayBegin());
        FundTransRepayingPlanInfo clrp = new FundTransRepayingPlanInfo();
        clrp.setSeq(1);
        if (ftInfo == null) {
            clrp.setRepayingDate(NOW);
        } else {
            clrp.setRepayingDate(ftInfo.getMaturityDate());
        }
        clrp.setRepayingAmt(Constants.ZERO);
        return clrp;
    }

    private void initTable() throws Exception {
        this.initRepayPlanTable();
        this.initLoanAndRepayTable();
    }

    private void initRepayPlanTable() throws Exception {
        this.kdtRepayingPlan.checkParsed();
        this.kdtRepayingPlan.removeRows();
        this.kdtRepayingPlan.refresh();
        this.kdtRepayingPlan.getColumn("seq").getStyleAttributes().setLocked(true);
        FundTransClientHelper.setTableCellEditorByDate(this.kdtRepayingPlan, "repayingDate");
        FundTransClientHelper.setTableCellEditorByFormattedTextField(this.kdtRepayingPlan, "repayingAmt", this.getBaseCurrencyPrecision());
    }

    private void initLoanAndRepayTable() throws Exception {
        this.kdtLoanAndRepay.checkParsed();
        this.kdtLoanAndRepay.removeRows();
        this.kdtLoanAndRepay.refresh();
        this.txtAllInRate.setRemoveingZeroInDispaly(false);
        this.txtAllInRate.setEditable(false);
        this.txtAllInRate.setPrecision(5);
        this.txtAllInRate.setValue((Object)BigDecimal.ZERO);
        this.kdtLoanAndRepay.getColumn("seq").getStyleAttributes().setLocked(false);
        this.kdtLoanAndRepay.getColumn("state").setEditor(this.getStateCheck());
        FundTransClientHelper.setTableCellEditorByFormattedTextField(this.kdtLoanAndRepay, "useAmt", this.getBaseCurrencyPrecision());
        KDFormattedTextField returnAmt = new KDFormattedTextField();
        returnAmt.setDataType(1);
        returnAmt.setPrecision(this.getBaseCurrencyPrecision());
        returnAmt.setRoundingMode(4);
        returnAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.kdtLoanAndRepay.getColumn("returnAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtLoanAndRepay.getColumn("returnAmt").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)returnAmt));
        this.kdtLoanAndRepay.getColumn("returnAmt").getStyleAttributes().setLocked(true);
        KDFormattedTextField loanRateFmat = new KDFormattedTextField();
        loanRateFmat.setDataType(1);
        loanRateFmat.setPrecision(5);
        loanRateFmat.setRoundingMode(4);
        loanRateFmat.setMinimumValue((Comparable)Constants.ZERO);
        loanRateFmat.setRemoveingZeroInDispaly(false);
        this.kdtLoanAndRepay.getColumn("loanRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtLoanAndRepay.getColumn("loanRate").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)loanRateFmat));
        this.kdtLoanAndRepay.getColumn("loanRate").getStyleAttributes().setLocked(true);
        KDFormattedTextField occAmt = new KDFormattedTextField();
        occAmt.setDataType(1);
        occAmt.setPrecision(this.getBaseCurrencyPrecision());
        occAmt.setRoundingMode(4);
        occAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.kdtLoanAndRepay.getColumn("occAmt").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)occAmt));
        this.kdtLoanAndRepay.getColumn("occAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtLoanAndRepay.getColumn("occAmt").getStyleAttributes().setLocked(true);
        this.kdtLoanAndRepay.getColumn("loan").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getLoanViewPrmt()));
        ObjectValueRender renderer = new ObjectValueRender();
        renderer.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtLoanAndRepay.getColumn("loan").setRenderer((IBasicRender)renderer);
        KDBizPromptBox f7MainConLoan = new KDBizPromptBox();
        f7MainConLoan.setQueryInfo("com.kingdee.eas.fm.fin.app.F7MainConLoanQuery");
        f7MainConLoan.setDisplayFormat("$conNumber$");
        f7MainConLoan.setEditFormat("$conNumber$");
        f7MainConLoan.setCommitFormat("$conNumber$");
        KDTDefaultCellEditor loanEditor = new KDTDefaultCellEditor((IKDEditor)f7MainConLoan);
        this.kdtLoanAndRepay.getColumn("mainConLoan").setEditor((ICellEditor)loanEditor);
        ObjectValueRender renderer1 = new ObjectValueRender();
        renderer1.setFormat((IDataFormat)new BizDataFormat("$conNumber$"));
        this.kdtLoanAndRepay.getColumn("mainConLoan").setRenderer((IBasicRender)renderer1);
        this.kdtLoanAndRepay.getColumn("mainConLoan").getStyleAttributes().setLocked(true);
    }

    @Override
    protected void kdtLoanAndRepay_editStopped(KDTEditEvent e) throws Exception {
        if (e.getValue() instanceof LoanAndRepayEntryEnum && e.getOldValue() != e.getValue()) {
            int rowIndex = this.kdtLoanAndRepay.getSelectManager().getActiveRowIndex();
            IRow row = this.kdtLoanAndRepay.getRow(rowIndex);
            if (row.getCell("state").getValue() != null && ((LoanAndRepayEntryEnum)((Object)row.getCell("state").getValue())).equals((Object)LoanAndRepayEntryEnum.PERMUTATION)) {
                int falg = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"60_LoanAndRepay"));
                if (falg == 0) {
                    row.getCell("loan").getStyleAttributes().setLocked(true);
                    row.getCell("useAmt").getStyleAttributes().setLocked(true);
                    row.getCell("returnAmt").setValue(row.getCell("useAmt").getValue());
                    row.getCell("occAmt").setValue((Object)BigDecimal.ZERO);
                    this.addLoanLine(this.kdtLoanAndRepay);
                } else {
                    row.getCell("state").setValue((Object)LoanAndRepayEntryEnum.NORMAL);
                }
            } else {
                row.getCell("loan").getStyleAttributes().setLocked(false);
                row.getCell("useAmt").getStyleAttributes().setLocked(false);
            }
        }
    }

    private ICellEditor getStateCheck() {
        KDComboBox stateCheck = new KDComboBox();
        stateCheck.addItems(LoanAndRepayEntryEnum.getEnumList().toArray());
        stateCheck.putClientProperty((Object)"jump", (Object)"false");
        KDTDefaultCellEditor state = new KDTDefaultCellEditor((JComboBox)stateCheck);
        return state;
    }

    private KDBizPromptBox getLoanViewPrmt() {
        KDBizPromptBox prmtLoan = new KDBizPromptBox();
        prmtLoan.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    FundTransferBillEditUI.this.prmtLoan_dataChanged(eventObj);
                }
                catch (EASBizException e) {
                    FundTransferBillEditUI.this.handUIException(e);
                }
                catch (BOSException e) {
                    FundTransferBillEditUI.this.handUIException(e);
                }
            }
        });
        prmtLoan.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    FundTransferBillEditUI.this.prmtLoan_willShow(e);
                }
                catch (EASBizException e1) {
                    FundTransferBillEditUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    FundTransferBillEditUI.this.handUIException(e1);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        prmtLoan.setQueryInfo("com.kingdee.eas.fm.fin.app.F7LoanQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balance", (Object)BigDecimal.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)3, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        prmtLoan.setEntityViewInfo(evi);
        ExtendParser parser = new ExtendParser(prmtLoan);
        prmtLoan.setCommitParser((IParser)parser);
        prmtLoan.setVisible(true);
        prmtLoan.setDisplayFormat("$number$");
        prmtLoan.setEditFormat("$number$");
        prmtLoan.setCommitFormat("$number$");
        prmtLoan.getQueryAgent().resetRuntimeEntityView();
        return prmtLoan;
    }

    protected void prmtLoan_dataChanged(DataChangeEvent eventObj) throws EASBizException, BOSException {
        int rowIndex = this.kdtLoanAndRepay.getSelectManager().getActiveRowIndex();
        MainConLoanInfo mInfo = new MainConLoanInfo();
        if (eventObj.getNewValue() instanceof LoanInfo) {
            LoanInfo lInfo = (LoanInfo)eventObj.getNewValue();
            BigDecimal loanRate = lInfo.getYieldRate().setScale(5, 4);
            this.kdtLoanAndRepay.getRow(rowIndex).getCell("loanRate").setValue((Object)loanRate);
            mInfo = MainConLoanFactory.getRemoteInstance().getMainConLoanInfo((IObjectPK)new ObjectUuidPK(lInfo.getMainConLoan().getId().toString()));
        }
        this.kdtLoanAndRepay.getRow(rowIndex).getCell("mainConLoan").setValue((Object)mInfo);
    }

    protected void prmtLoan_willShow(SelectorEvent e) throws Exception {
        KDBizPromptBox prmtLoan = (KDBizPromptBox)e.getSource();
        prmtLoan.setQueryInfo("com.kingdee.eas.fm.fin.app.F7LoanQuery");
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balance", (Object)BigDecimal.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)3, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyInfo.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLoanAndRepay", (Object)true, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        prmtLoan.setEntityViewInfo(evi);
        ExtendParser parser = new ExtendParser(prmtLoan);
        prmtLoan.setCommitParser((IParser)parser);
        prmtLoan.setVisible(true);
        prmtLoan.setDisplayFormat("$number$");
        prmtLoan.setEditFormat("$number$");
        prmtLoan.setCommitFormat("$number$");
        prmtLoan.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void comboRelationWithCmp_itemStateChanged(ItemEvent e) throws Exception {
        RelationshipWithLoanCompanyEnum rswc = (RelationshipWithLoanCompanyEnum)this.comboRelationWithCmp.getSelectedItem();
        if (rswc == RelationshipWithLoanCompanyEnum.EXTERIOR) {
            this.contCustomer.setVisible(true);
            this.prmtCustomer.setRequired(true);
            this.prmtCustomer.setEnabled(true);
            if (this.getBOTPViewStatus() == 1) {
                this.prmtCustomer.setEnabled(false);
                this.comboRelationWithCmp.setEnabled(false);
            } else {
                this.prmtCustomer.setEnabled(true);
                this.comboRelationWithCmp.setEnabled(true);
            }
            this.prmtTransCompany.setRequired(false);
            this.prmtTransCompany.setValue(null);
            this.prmtTransCompany.setEnabled(false);
            this.contTransCompany.setVisible(false);
        } else {
            this.contTransCompany.setVisible(true);
            this.prmtTransCompany.setRequired(true);
            this.prmtTransCompany.setEnabled(true);
            if (this.getBOTPViewStatus() == 1) {
                this.prmtTransCompany.setEnabled(false);
                this.comboRelationWithCmp.setEnabled(false);
            } else {
                this.prmtTransCompany.setEnabled(true);
                this.comboRelationWithCmp.setEnabled(true);
            }
            this.prmtCustomer.setRequired(false);
            this.prmtCustomer.setValue(null);
            this.prmtCustomer.setEnabled(false);
            this.contCustomer.setVisible(false);
        }
    }

    protected void loanAmtChanged() {
        int rowCount = this.kdtRepayingPlan.getRowCount();
        BigDecimal loanAmt = this.txtLoanAmt.getBigDecimalValue();
        if (rowCount > 0) {
            int index = rowCount > 1 ? 0 : rowCount - 1;
            this.kdtRepayingPlan.getRow(index).getCell("repayingAmt").setValue((Object)loanAmt);
        }
    }

    @Override
    protected void prmtDistributeAcctBank_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo accBank = (AccountBankInfo)this.prmtDistributeAcctBank.getValue();
        if (accBank != null) {
            accBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBank.getId()), this.getCustomSelector());
            this.prmtSettleAcctView.setValue((Object)accBank.getAccount());
            this.prmtOpAcctView.setValue((Object)this.getSettleAccountView(accBank));
        }
        this.setCurrency(accBank);
        this.txtYearDays.setPrecision(0);
    }

    private AccountViewInfo getSettleAccountView(AccountBankInfo accBank) throws Exception {
        if (accBank.getClassificatio() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("kaclassficlink", (Object)accBank.getClassificatio().getId()));
            filter.getFilterItems().add(new FilterItemInfo("accountitemlink", (Object)"00000000-0000-0000-0000-000000000081F9F423C0"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("accountlink.*"));
            KAClassficationDetailCollection col = KAClassficationDetailFactory.getRemoteInstance().getKAClassficationDetailCollection(evi);
            KAClassficationDetailInfo info = col.get(0);
            if (info != null) {
                return info.getAccountlink();
            }
        }
        return null;
    }

    private SelectorItemCollection getCustomSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        return sic;
    }

    private void setCurrency(AccountBankInfo accBank) {
        if (accBank != null) {
            if (accBank.isIsByCurrency()) {
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)accBank.getCurrency());
                this.comboCurrency.setEnabled(false);
            } else {
                this.comboCurrency.setEnabled(true);
            }
        }
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.actionAddPlan_actionPerformed(e);
    }

    @Override
    public void actionAddPlan_actionPerformed(ActionEvent e) throws Exception {
        ReturnWayEnum returnWay = (ReturnWayEnum)this.comboReturnWay.getSelectedItem();
        if (returnWay == ReturnWayEnum.RETURN_BY_STAGES || returnWay == ReturnWayEnum.OTHER_WAY) {
            this.addLine(this.kdtRepayingPlan);
        }
    }

    protected void addLine(KDTable table) {
        Integer seq = this.getCurrenctSeq();
        IRow row = table.addRow();
        row.getCell("seq").setValue((Object)seq);
        row.getCell("repayingDate").setValue((Object)((Date)this.pkMaturityDate.getValue()));
        row.getCell("repayingAmt").setValue((Object)Constants.ZERO);
    }

    private Integer getCurrenctSeq() {
        if (this.kdtRepayingPlan.getRowCount() != 0) {
            int intTmp = (Integer)this.kdtRepayingPlan.getRow(this.kdtRepayingPlan.getRowCount() - 1).getCell("seq").getValue() + 1;
            return new Integer(intTmp);
        }
        return new Integer(1);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.actionDelPlan_actionPerformed(e);
    }

    @Override
    public void actionDelPlan_actionPerformed(ActionEvent e) throws Exception {
        this.dealRepayPlan_Del();
    }

    private void dealRepayPlan_Del() {
        this.checkRepayPlanCanBeDelete(this.kdtRepayingPlan);
        int rowToBeDelete = 0;
        if (this.confirmRemove()) {
            rowToBeDelete = this.kdtRepayingPlan.getRowCount() - 1;
            this.kdtRepayingPlan.removeRow(rowToBeDelete);
        }
    }

    private void checkRepayPlanCanBeDelete(KDTable kdtEntrys) {
        if (kdtEntrys.getRowCount() == 1) {
            MsgBox.showInfo((String)ResourceFactory.getBizModelResourceMsg((String)"need_a_plan"));
            SysUtil.abort();
        }
    }

    protected void setKDTableFormat(CurrencyInfo currencyInfo) throws Exception {
        FMClientHelper.setNumberFormat((KDTable)this.kdtRepayingPlan, (String)"repayingAmt", (String)currencyInfo.getId().toString());
        FMClientHelper.setNumberFormat((KDTable)this.kdtLoanAndRepay, (String)"useAmt", (String)currencyInfo.getId().toString());
        FMClientHelper.setNumberFormat((KDTable)this.kdtLoanAndRepay, (String)"returnAmt", (String)currencyInfo.getId().toString());
        FMClientHelper.setNumberFormat((KDTable)this.kdtLoanAndRepay, (String)"occAmt", (String)currencyInfo.getId().toString());
        if (this.kdtRepayingPlan.getRowCount() > 0) {
            // empty if block
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        super.verifyInput(e);
        this.doBizCheck();
    }

    private void doBizCheck() throws Exception {
        this.checkTable();
        if (this.editData.getIntFreeAmt().compareTo(Constants.ZERO) < 0 || this.editData.getIntFreeAmt().compareTo(this.editData.getLoanAmt()) > 0) {
            MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"intfreeamt_toolager"));
            this.txtIntFreeAmt.requestFocus();
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((Object)this.editData.getYearDays()) || 0 == this.editData.getYearDays()) {
            MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"YearDaysRemind"));
            this.txtYearDays.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.isIsHistoryBill()) {
            Date lastSettleDate = DateUtil.getAfterDay((Date)this.editData.getLastSettleDate());
            if ((lastSettleDate = DateTimeUtils.truncateDate((Date)lastSettleDate)).compareTo(this.editData.getEffectiveDate()) < 0 || lastSettleDate.compareTo(this.editData.getMaturityDate()) > 0) {
                this.pkLastSettleDate.requestFocus();
                FundTransClientHelper.showMsgAndAbort((CoreUI)this, "invalid_settledate");
            }
        }
    }

    private void checkTable() {
        this.checkRepayPlan();
        this.checkLoanAndRepay();
    }

    private void checkRepayPlan() {
        int count = this.kdtRepayingPlan.getRowCount();
        IRow row = null;
        BigDecimal totalAmt = Constants.ZERO;
        for (int i = 0; i < count; ++i) {
            Date date;
            row = this.kdtRepayingPlan.getRow(i);
            this.checkRow(row, i);
            totalAmt = totalAmt.add((BigDecimal)row.getCell("repayingAmt").getValue());
            if (i == count - 1 && (date = (Date)row.getCell("repayingDate").getValue()).compareTo(this.editData.getMaturityDate()) <= 0) continue;
        }
        this.checkAmt(totalAmt);
    }

    private void checkLoanAndRepay() {
        int count = this.kdtLoanAndRepay.getRowCount();
        IRow row = null;
        BigDecimal totalAmt = Constants.ZERO;
        HashSet<BOSUuid> loanSet = new HashSet<BOSUuid>();
        if (count == 0) {
            if (this.chkisLoanAndRepay.isSelected()) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"58_LoanAndRepay"));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < count; ++i) {
                row = this.kdtLoanAndRepay.getRow(i);
                this.checkLoanAndRepayRow(row, i);
                totalAmt = totalAmt.add((BigDecimal)row.getCell("useAmt").getValue());
                if (row.getCell("loan").getValue() == null || row.getCell("state").getValue() == null || !((LoanAndRepayEntryEnum)((Object)row.getCell("state").getValue())).equals((Object)LoanAndRepayEntryEnum.NORMAL)) continue;
                if (loanSet.contains(((LoanInfo)row.getCell("loan").getValue()).getId())) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"59_LoanAndRepay"));
                    SysUtil.abort();
                    continue;
                }
                loanSet.add(((LoanInfo)row.getCell("loan").getValue()).getId());
            }
            this.checkUseAmt(totalAmt);
        }
    }

    private void checkLoanAndRepayRow(IRow row, int i) {
        BigDecimal useAmt = BigDecimal.ZERO;
        if (row.getCell("useAmt").getValue() != null) {
            useAmt = (BigDecimal)row.getCell("useAmt").getValue();
        }
        if (row.getCell("loan").getValue() == null || row.getCell("mainConLoan").getValue() == null || row.getCell("state").getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"58_LoanAndRepay"));
            SysUtil.abort();
        }
        if (row.getCell("state").getValue() != null && !((LoanAndRepayEntryEnum)((Object)row.getCell("state").getValue())).equals((Object)LoanAndRepayEntryEnum.PERMUTATION) && useAmt.compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"58_LoanAndRepay"));
            SysUtil.abort();
        }
    }

    private void checkUseAmt(BigDecimal totalAmt) {
        if (totalAmt.compareTo(this.txtLoanAmt.getBigDecimalValue()) != 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"57_LoanAndRepay"));
            SysUtil.abort();
        }
    }

    private void checkAmt(BigDecimal totalAmt) {
        if (totalAmt.compareTo(this.txtLoanAmt.getBigDecimalValue()) != 0) {
            MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"repay_plan_error"));
            SysUtil.abort();
        }
    }

    private void checkRow(IRow row, int i) {
        BigDecimal repayAmt;
        if (row.getCell("repayingDate").getValue() == null || row.getCell("repayingAmt").getValue() == null) {
            MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"entries_not_full"));
            SysUtil.abort();
        }
        if ((repayAmt = (BigDecimal)row.getCell("repayingAmt").getValue()).compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"repayamt_error1"));
            SysUtil.abort();
        }
        if (i != 0) {
            Date lastDate = (Date)this.kdtRepayingPlan.getRow(i - 1).getCell("repayingDate").getValue();
            Date date = (Date)row.getCell("repayingDate").getValue();
            if (DateTimeUtils.truncateDate((Date)date).before(DateTimeUtils.truncateDate((Date)lastDate))) {
                MsgBox.showWarning((String)ResourceFactory.getBizModelResourceMsg((String)"returnDate_error"));
                SysUtil.abort();
            }
        } else {
            Date date = (Date)row.getCell("repayingDate").getValue();
            if (date.compareTo(this.editData.getEffectiveDate()) < 0) {
                FundTransClientHelper.showMsgAndAbort((CoreUI)this, "first_entries_date_error_plan");
            }
        }
    }

    protected void setOtheValuesRelatedMatuDate(Date maturityDate) {
        int rowCount = this.kdtRepayingPlan.getRowCount();
        if (rowCount == 1) {
            this.kdtRepayingPlan.getRow(0).getCell("repayingDate").setValue((Object)maturityDate);
        }
    }

    protected void txtFloatingPoint_dataChanged(DataChangeEvent e) throws Exception {
        this.reCalYearRate();
    }

    @Override
    protected void prmtDistributeAcctBank_willShow(SelectorEvent e) throws Exception {
        this.setprmtDistributeAcctBankFilter();
    }

    @Override
    protected void prmtDistributeAcctBank_willCommit(CommitEvent e) throws Exception {
        this.setprmtDistributeAcctBankFilter();
    }

    private void setprmtDistributeAcctBankFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtDistributeAcctBank.setEntityViewInfo(evi);
        this.prmtDistributeAcctBank.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtTransCompany_willShow(SelectorEvent e) throws Exception {
        this.setTransCompanyFilter();
    }

    @Override
    protected void prmtTransCompany_willCommit(CommitEvent e) throws Exception {
        this.setTransCompanyFilter();
    }

    private void setTransCompanyFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.currentCompany.getId().toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)Boolean.TRUE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtTransCompany.setEntityViewInfo(evi);
        this.prmtTransCompany.getQueryAgent().resetRuntimeEntityView();
    }

    protected void setOtheValuesRelatedEffeDate(Date effctiveDate) {
        Date tmpDate = DateTimeUtils.truncateDate((Date)((Date)this.pkEffectiveDate.getValue()));
        if (tmpDate != null) {
            tmpDate = DateUtil.getBeforeDay((Date)tmpDate);
            this.pkLastSettleDate.setValue((Object)DateTimeUtils.truncateDate((Date)tmpDate));
        }
    }

    @Override
    protected void prmtFinancingProduct_willCommit(CommitEvent e) throws Exception {
        this.setFinancingProductFilter();
    }

    @Override
    protected void prmtFinancingProduct_willShow(SelectorEvent e) throws Exception {
        this.setFinancingProductFilter();
    }

    private void setFinancingProductFilter() {
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("repayingPlan.id"));
        sic.add(new SelectorItemInfo("repayingPlan.repayingDate"));
        sic.add(new SelectorItemInfo("repayingPlan.repayingAmt"));
        sic.add(new SelectorItemInfo("transCompany.id"));
        sic.add(new SelectorItemInfo("transCompany.name"));
        sic.add(new SelectorItemInfo("transCompany.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("distributeAcctBank.id"));
        sic.add(new SelectorItemInfo("distributeAcctBank.name"));
        sic.add(new SelectorItemInfo("distributeAcctBank.number"));
        sic.add(new SelectorItemInfo("settleAcctView.id"));
        sic.add(new SelectorItemInfo("settleAcctView.name"));
        sic.add(new SelectorItemInfo("settleAcctView.number"));
        sic.add(new SelectorItemInfo("opAcctView.id"));
        sic.add(new SelectorItemInfo("opAcctView.name"));
        sic.add(new SelectorItemInfo("opAcctView.number"));
        sic.add(new SelectorItemInfo("guaranteeType.id"));
        sic.add(new SelectorItemInfo("guaranteeType.name"));
        sic.add(new SelectorItemInfo("guaranteeType.number"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("finacingProduct.id"));
        sic.add(new SelectorItemInfo("finacingProduct.name"));
        sic.add(new SelectorItemInfo("finacingProduct.number"));
        sic.add(new SelectorItemInfo("guaranteeType.id"));
        sic.add(new SelectorItemInfo("guaranteeType.name"));
        sic.add(new SelectorItemInfo("guaranteeType.number"));
        sic.add(new SelectorItemInfo("repayingPlan.seq"));
        sic.add(new SelectorItemInfo("repayingPlan.repayingDate"));
        sic.add(new SelectorItemInfo("repayingPlan.repayingAmt"));
        sic.add(new SelectorItemInfo("rateType.id"));
        sic.add(new SelectorItemInfo("rateType.number"));
        sic.add(new SelectorItemInfo("rateType.name"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("accountant.id"));
        sic.add(new SelectorItemInfo("accountant.number"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("loanAndRepay.seq"));
        sic.add(new SelectorItemInfo("loanAndRepay.loan.*"));
        sic.add(new SelectorItemInfo("loanAndRepay.mainConLoan.*"));
        sic.add(new SelectorItemInfo("loanAndRepay.useAmt"));
        sic.add(new SelectorItemInfo("loanAndRepay.returnAmt"));
        sic.add(new SelectorItemInfo("loanAndRepay.occAmt"));
        sic.add(new SelectorItemInfo("loanAndRepay.state"));
        sic.add(new SelectorItemInfo("loanAndRepay.loanRate"));
        sic.add("fundFlowItem.*");
        return sic;
    }

    @Override
    protected void comboReturnWay_itemStateChanged(ItemEvent e) throws Exception {
        this.dealWithReturnWay();
    }

    private void dealWithReturnWay() throws Exception {
        ReturnWayEnum returnWay = (ReturnWayEnum)this.comboReturnWay.getSelectedItem();
        if (returnWay == ReturnWayEnum.RETURN_BY_STAGES || returnWay == ReturnWayEnum.OTHER_WAY) {
            if (this.kdtRepayingPlan.getRowCount() > 0) {
                this.kdtRepayingPlan.setEditable(true);
                this.btnAddPlan.setEnabled(true);
                this.btnDelPlan.setEnabled(true);
            }
        } else {
            if (this.kdtRepayingPlan.getRowCount() > 0) {
                this.kdtRepayingPlan.setEditable(false);
                this.btnAddPlan.setEnabled(false);
                this.btnDelPlan.setEnabled(false);
            }
            this.kdtRepayingPlan.removeRows();
            IRow row = this.kdtRepayingPlan.addRow();
            row.getCell("seq").setValue((Object)new Integer(1));
            row.getCell("repayingDate").setValue((Object)this.pkMaturityDate.getSqlDate());
            row.getCell("repayingAmt").setValue((Object)this.txtLoanAmt.getBigDecimalValue());
        }
    }

    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.kdtLoanAndRepay.removeRows();
        super.comboCurrency_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("DefaultQueryFilter", this.getFilter());
        ctx.put("LoanApplyBillType", LoanPropertyEnum.InGroup);
        this.getBillEdit().createFrom(null, ctx);
        this.btnCreateFrom.setEnabled(true);
    }

    private FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isGenLoanOrgBill", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("loanBalanceAmt", (Object)Constants.ZERO, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("financingOrg.id", null, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("financingOrg.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
        return filterInfo;
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getBOTPViewStatus() == 1 && this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setDefaultValuesForBOTP((FundTransferBillInfo)dataObject);
            boolean bl = false;
        }
    }

    private void setDefaultValuesForBOTP(FundTransferBillInfo ftInfo) {
        ftInfo.setAdjustRateTimes(0);
        Date NOW = DateTimeUtils.truncateDate((Date)DateUtil.getDayBegin());
        ftInfo.setIsGenLoan(false);
        ftInfo.setBizDate(NOW);
        ftInfo.setYearDays(360);
        ftInfo.setIsHistoryBill(false);
        ftInfo.setRepayTotalAmt(Constants.ZERO);
        ftInfo.setStatus(FundTransferBillStatusEnum.SAVE);
        ftInfo.setFloatingPoint(Constants.ZERO);
        ftInfo.setRate(ftInfo.getRate() == null ? Constants.ZERO : ftInfo.getRate());
        ftInfo.setPenaRate(Constants.ZERO);
        ftInfo.setIntFreeAmt(Constants.ZERO);
        ftInfo.setGuaranteeAmt(Constants.ZERO);
        ftInfo.setIntRateExpression(IntRateTypeExpressionEnum.YEAR);
        ftInfo.setYearDays(360);
        ftInfo.setReturnWay(ReturnWayEnum.AT_TERM_WITH_ORI_AMT);
        ftInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
        ftInfo.setLoanAmtLocal(Constants.ZERO);
        ftInfo.setCreator(this.userinfo);
        if (ftInfo.getCustomer() == null && ftInfo.getTransCompany() != null) {
            ftInfo.setRelationWithCmp(RelationshipWithLoanCompanyEnum.INTERIOR);
        } else if (ftInfo.getCustomer() != null && ftInfo.getTransCompany() == null) {
            ftInfo.setRelationWithCmp(RelationshipWithLoanCompanyEnum.EXTERIOR);
        } else {
            ftInfo.setRelationWithCmp(RelationshipWithLoanCompanyEnum.INTERIOR);
        }
        ftInfo.setCompany(this.currentCompany);
        try {
            IntRateTypeInfo rateType = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK(ResourceFactory.getConsultativeRate()));
            ftInfo.setRateType(rateType);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        ftInfo.setReturnWay(ReturnWayEnum.AT_TERM_WITH_ORI_AMT);
        if (ftInfo.getEffectiveDate() != null) {
            ftInfo.setLastSettleDate(DateUtil.getBeforeDay((Date)ftInfo.getEffectiveDate()));
        }
        ftInfo.setRepayTimes(0);
        ftInfo.setAdjustRateTimes(0);
        ftInfo.setExtTimes(0);
        ftInfo.getRepayingPlan().clear();
        ftInfo.getRepayingPlan().add(this.createDefaultRepayPlan(ftInfo));
        Boolean isAddHis = (Boolean)this.getUIContext().get("IS_ADD_HIS");
        if (isAddHis == null) {
            ftInfo.setIsHistoryBill(false);
        } else {
            ftInfo.setIsHistoryBill(isAddHis);
        }
        ftInfo.setIsOverdue(false);
    }

    @Override
    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.editData.setCompany(company);
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.ft.app.FundTransferBill", null, (IObjectValue)this.editData);
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    protected void prmtOpAcctView_willCommit(CommitEvent e) throws Exception {
        this.setPrmtOpAcctViewFilter(this.prmtOpAcctView);
    }

    @Override
    protected void prmtOpAcctView_willShow(SelectorEvent e) throws Exception {
        this.setPrmtOpAcctViewFilter(this.prmtOpAcctView);
    }

    private void setPrmtOpAcctViewFilter(KDBizPromptBox prmtloanAccountViewParam) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String currencyId = currencyInfo.getId().toString();
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        prmtloanAccountViewParam.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        prmtloanAccountViewParam.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)true);
        prmtloanAccountViewParam.setEntityViewInfo(evi);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.prmtFinancingProduct.getQueryAgent().resetRuntimeEntityView();
        this.prmtFinancingProduct.addSelectorListener(new SelectorListener(){
            F7FinancingProductsTreeUI prmtParent_F7ListUI = null;

            public void willShow(SelectorEvent e) {
                if (this.prmtParent_F7ListUI == null) {
                    try {
                        this.prmtParent_F7ListUI = new F7FinancingProductsTreeUI();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("BillType", (Object)new Integer(1), CompareType.EQUALS));
                    this.prmtParent_F7ListUI.setFilterInfo(filter);
                    HashMap<String, Window> ctx = new HashMap<String, Window>();
                    ctx.put("bizUIOwner", SwingUtilities.getWindowAncestor((Component)this.prmtParent_F7ListUI));
                    this.prmtParent_F7ListUI.setF7Use(true, ctx);
                    FundTransferBillEditUI.this.prmtFinancingProduct.setSelector((KDPromptSelector)this.prmtParent_F7ListUI);
                }
            }
        });
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferBillTDPrint(false);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.actionTDPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.actionTDPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferBillTDPrint(true);
    }

    private void fundTransferBillTDPrint(boolean isPreview) {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        idSet.add(this.editData.getId());
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSFERBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSFERBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }

    @Override
    protected void chkisLoanAndRepay_actionPerformed(ActionEvent e) throws Exception {
        super.chkisLoanAndRepay_actionPerformed(e);
        if (this.chkisLoanAndRepay.isSelected()) {
            this.kDTabbedPane1.setEnabledAt(this.kDTabbedPane1.indexOfComponent((Component)this.kDPanel1), true);
            this.txtAllInRate.setValue((Object)BigDecimal.ZERO);
        } else {
            this.kdtLoanAndRepay.removeRows();
            this.kDTabbedPane1.setEnabledAt(this.kDTabbedPane1.indexOfComponent((Component)this.kDPanel1), false);
            this.kDTabbedPane1.setSelectedComponent((Component)this.kDPanel2);
            this.txtAllInRate.setValue((Object)BigDecimal.ZERO);
        }
    }

    @Override
    public void actionAddLoan_actionPerformed(ActionEvent e) throws Exception {
        this.addLoanLine(this.kdtLoanAndRepay);
    }

    protected void addLoanLine(KDTable table) {
        IRow row = table.addRow();
        row.getCell("loan").setValue(null);
        row.getCell("mainConLoan").setValue(null);
        if (this.kdtLoanAndRepay.getRowCount() == 1) {
            row.getCell("useAmt").setValue((Object)this.txtLoanAmt.getNumberValue());
        } else {
            row.getCell("useAmt").setValue((Object)BigDecimal.ZERO);
        }
        row.getCell("returnAmt").setValue((Object)BigDecimal.ZERO);
        row.getCell("occAmt").setValue((Object)BigDecimal.ZERO);
        BigDecimal loanRate = BigDecimal.ZERO;
        loanRate = loanRate.setScale(5, 4);
        row.getCell("loanRate").setValue((Object)loanRate);
        row.getCell("state").setValue(LoanAndRepayEntryEnum.getEnumList().get(0));
    }

    @Override
    public void actionDelLoan_actionPerformed(ActionEvent e) throws Exception {
        this.dealLoan_Del();
    }

    private void dealLoan_Del() {
        this.removeLine(this.kdtLoanAndRepay);
    }

    @Override
    public void actionRecount_actionPerformed(ActionEvent e) throws Exception {
        LoanAndRepayEntryEnum loanAndRepayEntryEnum;
        BigDecimal useAmt;
        IRow row;
        int i;
        BigDecimal balanceAmt;
        BigDecimal loanAmt = this.txtLoanAmt.getBigDecimalValue();
        BigDecimal loanBalanceAmt = this.txtLoanBalanceAmt.getBigDecimalValue();
        BigDecimal amt = balanceAmt = loanAmt.subtract(loanBalanceAmt);
        BigDecimal sumAmt = loanAmt;
        this.editData.getLoanAndRepay().clear();
        for (i = 0; i < this.kdtLoanAndRepay.getRowCount(); ++i) {
            row = this.kdtLoanAndRepay.getRow(i);
            useAmt = (BigDecimal)row.getCell("useAmt").getValue();
            loanAndRepayEntryEnum = (LoanAndRepayEntryEnum)((Object)row.getCell("state").getValue());
            if (!loanAndRepayEntryEnum.equals((Object)LoanAndRepayEntryEnum.PERMUTATION)) continue;
            sumAmt = sumAmt.subtract(useAmt);
            amt = amt.subtract(useAmt);
        }
        for (i = 0; i < this.kdtLoanAndRepay.getRowCount(); ++i) {
            row = this.kdtLoanAndRepay.getRow(i);
            useAmt = (BigDecimal)row.getCell("useAmt").getValue();
            loanAndRepayEntryEnum = (LoanAndRepayEntryEnum)((Object)row.getCell("state").getValue());
            if (!loanAndRepayEntryEnum.equals((Object)LoanAndRepayEntryEnum.NORMAL) || sumAmt.compareTo(BigDecimal.ZERO) != 1) continue;
            BigDecimal ratio = useAmt.divide(sumAmt, 8, RoundingMode.HALF_UP);
            BigDecimal returnAmt = amt.multiply(ratio);
            row.getCell("returnAmt").setValue((Object)returnAmt);
            row.getCell("occAmt").setValue((Object)useAmt.subtract(returnAmt));
        }
    }

    private void calcCompsValueAtEditState() throws EASBizException, BOSException {
        if (this.editData.getId() != null && this.getOprtState().equals(OprtState.EDIT)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("adjustRateTimes"));
            sic.add(new SelectorItemInfo("repayTimes"));
            sic.add(new SelectorItemInfo("extTimes"));
            sic.add(new SelectorItemInfo("fivouchered"));
            sic.add(new SelectorItemInfo("status"));
            sic.add(new SelectorItemInfo("isGenPayBill"));
            sic.add(new SelectorItemInfo("isLoanAndRepay"));
            FundTransferBillInfo info = FundTransferBillFactory.getRemoteInstance().getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("transBill.id", (Object)info.getId().toString()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            FundTransferInterestBillCollection ftInterestBillCol = FundTransferInterestBillFactory.getRemoteInstance().getFundTransferInterestBillCollection(evi);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info) && (info.getAdjustRateTimes() > 0 || info.getRepayTimes() > 0 || info.getExtTimes() > 0 || info.isFivouchered() || info.getStatus() == FundTransferBillStatusEnum.AUDITED || info.isIsGenLoan() || ftInterestBillCol != null && ftInterestBillCol.size() > 0)) {
                JComponent[] ctrls = new JComponent[]{this.txtNumber, this.pkBizDate, this.prmtFinancingProduct, this.comboRelationWithCmp, this.prmtTransCompany, this.prmtCustomer, this.prmtDistributeAcctBank, this.prmtSettleAcctView, this.prmtOpAcctView, this.comboCurrency, this.txtExchangeRate, this.txtLoanAmt, this.pkEffectiveDate, this.txtLoanAmtLocal, this.txtLoanBalanceAmt, this.pkMaturityDate, this.prmtRateType, this.txtFloatingPoint, this.comboIntRateExpression, this.txtYearDays, this.txtRate, this.comboPenAccrualType, this.txtPenaRate, this.txtIntFreeAmt, this.prmtGuaranteeType, this.txtGuaranteeAmt, this.pkLastSettleDate, this.comboReturnWay, this.prmtBgItem, this.prmtFundFlowItem, this.prmtProject, this.txtDescription};
                if (info.isIsLoanAndRepay()) {
                    this.chkisLoanAndRepay.setEnabled(true);
                    FinUtils.setEditable((JComponent[])ctrls, (boolean)false);
                    this.kDTabbedPane1.setEnabledAt(0, false);
                    this.kDTabbedPane1.setEnabledAt(1, true);
                    this.kDTabbedPane1.setSelectedComponent((Component)this.kDPanel1);
                } else {
                    this.chkisLoanAndRepay.setEnabled(true);
                    FinUtils.setEditable((JComponent[])ctrls, (boolean)false);
                    this.kDTabbedPane1.setEnabledAt(0, false);
                    this.kDTabbedPane1.setEnabledAt(1, false);
                }
            }
        }
    }

    protected void setTableToSumField() {
        this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
    }

    protected KDTable getDetailTable() {
        return this.kdtLoanAndRepay;
    }

    protected String[] getSumColNames() {
        return new String[]{"useAmt@%R_{0.##########}f", "returnAmt@%R_{0.##########}f", "occAmt@%R_{0.##########}f"};
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "bizDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }

    @Override
    protected void prmtSettleAcctView_willShow(SelectorEvent e) throws EASBizException, BOSException {
        this.setPrmtOpAcctViewFilter(this.prmtSettleAcctView);
    }

    @Override
    public void actionCountAllInRate_actionPerformed(ActionEvent e) throws Exception {
        this.caculateAllInRate();
    }

    protected void caculateAllInRate() throws Exception {
        BigDecimal toalRateAmt = BigDecimal.ZERO;
        BigDecimal toalUseAmt = BigDecimal.ZERO;
        for (int i = 0; i < this.kdtLoanAndRepay.getRowCount(); ++i) {
            IRow row = this.kdtLoanAndRepay.getRow(i);
            LoanAndRepayEntryEnum loanAndRepayEntryEnum = (LoanAndRepayEntryEnum)((Object)row.getCell("state").getValue());
            if (!loanAndRepayEntryEnum.equals((Object)LoanAndRepayEntryEnum.NORMAL)) continue;
            BigDecimal useAmt = BigDecimal.ZERO;
            if (!EmptyUtil.isEmpty((Object)row.getCell("useAmt").getValue())) {
                useAmt = (BigDecimal)row.getCell("useAmt").getValue();
            }
            BigDecimal loanRate = BigDecimal.ZERO;
            if (!EmptyUtil.isEmpty((Object)row.getCell("loanRate").getValue())) {
                loanRate = (BigDecimal)row.getCell("loanRate").getValue();
            }
            toalRateAmt = toalRateAmt.add(useAmt.multiply(loanRate));
            toalUseAmt = toalUseAmt.add(useAmt);
        }
        if (!toalUseAmt.equals(BigDecimal.ZERO)) {
            double allInRate = toalRateAmt.divide(toalUseAmt, 5, 4).doubleValue();
            this.txtAllInRate.setValue((Object)allInRate);
        }
    }

    @Override
    protected void comboFloatAction_itemStateChanged(ItemEvent e) throws Exception {
        this.reCalYearRate();
    }

    private void reCalYearRate() throws BOSException, EASBizException {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        Date date = DateTimeUtils.truncateDate((Date)this.pkEffectiveDate.getSqlDate());
        BigDecimal bdBP = this.txtFloatingPoint.getBigDecimalValue();
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtRateType.getData();
        if (intRateType == null) {
            this.txtRate.setValue((Object)new BigDecimal(String.valueOf(0)));
        } else if (!this.isXUEXILILV(intRateType)) {
            FloatActionEnum floatActionEnum = null;
            Object obj = this.comboFloatAction.getSelectedItem();
            floatActionEnum = obj == null ? FloatActionEnum.BASEINTRATE_FLOAT : (FloatActionEnum)obj;
            this.txtRate.setValue((Object)BigDecimal.ZERO);
            this.txtRate.setValue((Object)this.getYieldRate(currency, intRateType, date, bdBP, floatActionEnum));
        }
    }

    private BigDecimal getYieldRate(CurrencyInfo currency, IntRateTypeInfo intRateType, Date date, BigDecimal bdBP, FloatActionEnum floatAction) throws BOSException, EASBizException {
        if (currency != null && intRateType != null && date != null && bdBP != null) {
            IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), currency.getId().toString(), date);
            BigDecimal bdBaseRate = null;
            bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
            BigDecimal bdYieldRate = floatAction.equals((Object)FloatActionEnum.BASEINTRATE_FLOAT) ? bdBaseRate.multiply(new BigDecimal(String.valueOf(1)).add(bdBP.divide(Constants.ONE_HUNDRED, 10, 4))) : bdBaseRate.add(bdBP);
            if (bdYieldRate.compareTo(Constants.ZERO) < 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
                this.txtFloatingPoint.requestFocus();
                SysUtil.abort();
            }
            return bdYieldRate;
        }
        return Constants.ZERO;
    }

    protected boolean isXUEXILILV(IntRateTypeInfo intRateType) {
        return intRateType.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=") || intRateType.getId().toString().equals("QYYAAAAKQTYkfZJ0");
    }
}

