/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillCollection;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillFactory;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBillCollection;
import com.kingdee.eas.fm.ft.FundTransferBillFacadeFactory;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBillStatusEnum;
import com.kingdee.eas.fm.ft.FundTransferInterestBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.IFundTransferBill;
import com.kingdee.eas.fm.ft.IFundTransferBillFacade;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferBillListUI;
import com.kingdee.eas.fm.ft.client.FundTransClientHelper;
import com.kingdee.eas.fm.ft.client.FundTransferBillEditUI;
import com.kingdee.eas.fm.ft.client.FundTransferBillFilterParam;
import com.kingdee.eas.fm.ft.client.FundTransferBillFilterUI;
import com.kingdee.eas.fm.ft.client.FundTransferBillQueryProcessor;
import com.kingdee.eas.fm.ft.client.FundTransferExtBillEditUI;
import com.kingdee.eas.fm.ft.client.FundTransferRepayBillEditUI;
import com.kingdee.eas.fm.ft.client.FundTrasnferBillChooseUI;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundTransferBillListUI
extends AbstractFundTransferBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferBillListUI.class);
    private FundTransferBillFilterUI filterUI;
    private IContextHelper iContextHelper;
    FillListener fillListener = new FillListener();
    private final Integer Audit = new Integer(3);
    private final Integer Save = new Integer(0);
    public static final String FUNDTRANSFERBILL_FILENAME = "/FM/INVEST/FT/FUNDTRANSFERBILL";

    protected String getEditUIName() {
        return FundTransferBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransferBillFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new FundTransferBillQueryProcessor();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FundTransferBillFilterUI();
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompanyCommon);
        this.iContextHelper = ContextHelperFactory.getRemoteInstance();
        super.onLoad();
        this.actionRepay.setEnabled(true);
        this.actionExt.setEnabled(true);
        this.actionAddNewHis.setEnabled(true);
        this.actionCreateTo.setVisible(true);
        this.actionImportData.setVisible(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAdjustRate.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_backwarddepreciat"));
        this.actionRepay.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_requite"));
        this.actionAddNewHis.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.actionOverdue.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_showbusiness"));
        this.actionCancelOverdue.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_undo"));
        this.actionExt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_movedata"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionBacthSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionAudit.setVisible(true);
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setVisible(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_discount"));
        this.actionAntiBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceldiscount"));
        int bookType = this.iContextHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompanyCommon.getId()));
        if (bookType != 0) {
            this.actionBook.setVisible(false);
            this.actionAntiBook.setVisible(false);
            this.actionBook.setEnabled(false);
            this.actionAntiBook.setEnabled(false);
        } else {
            this.actionBook.setVisible(true);
            this.actionAntiBook.setVisible(true);
            this.actionBook.setEnabled(true);
            this.actionAntiBook.setEnabled(true);
        }
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    public void actionRepay_actionPerformed(ActionEvent e) throws Exception {
        this.checkRepay();
        FundTransferRepayBillEditUI.showRepayWindow((CoreUIObject)this, this.getSelectedKeyValue());
        this.refreshList();
    }

    private void checkRepay() throws Exception {
        FundTransferBillInfo info = this.getSelectObject();
        this.checkBalanceEnough(info, "repay_error_lackofbalance");
        this.checkStatus(info);
    }

    @Override
    public void actionExt_actionPerformed(ActionEvent e) throws Exception {
        this.checkExt();
        FundTransferExtBillEditUI.showExtEdidUI((CoreUIObject)this, (IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        this.refreshList();
    }

    private void checkExt() throws Exception {
        FundTransferBillInfo info = this.getSelectObject();
        this.checkBalanceEnough(info, "ext_error_lackofbalance");
        this.checkStatus(info);
        this.checkIsOverdue(info, "bill_overdue");
    }

    private void checkIsOverdue(FundTransferBillInfo info, String msgKey) {
        if (info.isIsOverdue()) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, msgKey);
        }
    }

    private void checkBalanceEnough(FundTransferBillInfo info, String msgKey) {
        if (FundTransClientHelper.isLessEqualThanZero(info.getLoanBalanceAmt())) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, msgKey);
        }
    }

    private void checkStatus(FundTransferBillInfo info) {
        if (info.getStatus() != FundTransferBillStatusEnum.AUDITED) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, "status_error1");
        }
    }

    @Override
    public void actionOverdue_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkSelected();
            ArrayList ids = this.getSelectedIdValues();
            if (ids != null && ids.size() > 0) {
                HashSet idSet = new HashSet(ids);
                ((IFundTransferBill)this.getBizInterface()).batchOverDue(idSet);
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof AbortException)) {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
            SysUtil.abort((Throwable)ex);
        }
        FundTransClientHelper.showMsg((CoreUI)this, "overdue_success");
        this.refreshList();
    }

    @Override
    public void actionCancelOverdue_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkSelected();
            ArrayList ids = this.getSelectedIdValues();
            if (ids != null && ids.size() > 0) {
                HashSet idSet = new HashSet(ids);
                ((IFundTransferBill)this.getBizInterface()).batchCancelOveDue(idSet);
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof AbortException)) {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
            SysUtil.abort((Throwable)ex);
        }
        FundTransClientHelper.showMsg((CoreUI)this, "cancel_overdue_successful");
        this.refreshList();
    }

    @Override
    public void actionAddNewHis_actionPerformed(ActionEvent e) throws Exception {
        this.closeExistedEditUI();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.closeExistedEditUI();
        super.actionAddNew_actionPerformed(e);
    }

    private void closeExistedEditUI() throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        Object mainUI = null;
        mainUI = frame instanceof NewMainFrame ? ((NewMainFrame)frame).getMainUI() : UIFactoryHelper.getMainUIObject((Map)uiContext);
        IUIObject uiObject = mainUI.getUiManager().findUIObject(this.getEditUIName(), (Map)uiContext, this.dataObjects, OprtState.ADDNEW);
        if (uiObject != null) {
            uiWindow = uiObject.getUIWindow();
            uiWindow.close();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FundTransferBillInfo info = this.getSelectObject();
        this.checkHasBeenAudited(info);
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkModfify();
        super.actionRemove_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkVoucher();
        super.actionVoucher_actionPerformed(e);
        this.refreshList();
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
        this.refreshList();
    }

    private void checkVoucher() throws Exception {
        FundTransferBillInfo info = this.getSelectObject();
        this.checkIsHistroyBill(info);
        this.checkStatus(info);
    }

    private void checkIsHistroyBill(FundTransferBillInfo info) {
        if (info.isIsHistoryBill()) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, "vouchered_error_his_bill");
        }
    }

    private void checkModfify() throws Exception {
        FundTransferBillInfo info = this.getSelectObject();
        this.checkHasBeenAdjustRate(info);
        this.checkHasRepaied(info);
        this.checkHasExt(info);
        this.chekcHasIntBillRelated(info);
        this.chekcHasVoucher(info);
        this.checkHasBeenAudited(info);
        this.checkHasBeenRecByLoan(info);
    }

    private void checkHasBeenRecByLoan(FundTransferBillInfo info) {
        if (info.isIsGenLoan()) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, "has_been_received");
        }
    }

    private void checkHasBeenAudited(FundTransferBillInfo info) {
        if (info.getStatus() == FundTransferBillStatusEnum.AUDITED) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, "has_been_audited");
        }
    }

    private void chekcHasVoucher(FundTransferBillInfo info) {
        if (info.isFivouchered()) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, "has_vouchered");
        }
    }

    private void chekcHasIntBillRelated(FundTransferBillInfo info) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("transBill.id", (Object)info.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        try {
            FundTransferInterestBillCollection ftInterestBillCol = FundTransferInterestBillFactory.getRemoteInstance().getFundTransferInterestBillCollection(evi);
            if (ftInterestBillCol != null && ftInterestBillCol.size() > 0) {
                FundTransClientHelper.showMsgAndAbort((CoreUI)this, "has_related_interest_bill");
            }
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    private void checkHasExt(FundTransferBillInfo info) {
        if (info.getExtTimes() > 0) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, "has_related_ext_bill");
        }
    }

    private void checkHasRepaied(FundTransferBillInfo info) {
        if (info.getRepayTimes() > 0) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, "has_related_repay_bill");
        }
    }

    private void checkHasBeenAdjustRate(FundTransferBillInfo info) {
        if (info.getAdjustRateTimes() > 0) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, "has_related_rateAdj_bill");
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals((Object)this.actionAddNewHis)) {
            uiContext.put((Object)"IS_ADD_HIS", (Object)Boolean.TRUE);
        }
        if (action.equals(this.actionAddNew)) {
            uiContext.put((Object)"IS_ADD_HIS", (Object)Boolean.FALSE);
        }
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("GaranteeType.property"));
        return sic;
    }

    private FundTransferBillInfo getSelectObject() throws Exception {
        this.checkSelected();
        FundTransferBillInfo info = ((IFundTransferBill)this.getBizInterface()).getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        return info;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("company.id");
        sic.add("company.number");
        sic.add("company.name");
        sic.add("distributeAcctBank.id");
        sic.add("distributeAcctBank.number");
        sic.add("distributeAcctBank.name");
        sic.add("intFreeAmt");
        sic.add("lastRepayDate");
        sic.add("extTimes");
        sic.add("repayTimes");
        sic.add("finacingProduct.FinancingSource.id");
        sic.add("fpItem.id");
        sic.add("fpItem.number");
        sic.add("fpItem.name");
        sic.add("project.id");
        sic.add("project.number");
        sic.add("project.name");
        sic.add("outBgItemId");
        sic.add("outBgItemName");
        sic.add("outBgItemNumber");
        return sic;
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        StringBuffer sb = new StringBuffer("select fid from T_FT_FundTransferBill where 1=1 and  ");
        sb.append(FMHelper.buildIn((String)"fid", (Object[])ids.toArray()));
        sb.append("and  FStatus = 3 and (FIsGenLoan = 0 or FIsGenLoan is null) and FPaymentBillID is null");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        HashSet<String> IDs = new HashSet<String>();
        while (rs.next()) {
            IDs.add(rs.getString(1));
        }
        if (IDs == null || IDs.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"20_FundTransferBillListUI"));
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", IDs, CompareType.INCLUDE));
        evi.setFilter(filter);
        FundTransferBillCollection col = FundTransferBillFactory.getRemoteInstance().getFundTransferBillCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            FundTransferBillInfo info = col.get(i);
            if (!FinHelper.hasDeferRecordOfFundTransfer((String)info.getId().toString()) || !FinHelper.hasIntRecordOfFundTransfer((String)info.getId().toString()) || !FinHelper.hasRepaymentOfFundTransfer((String)info.getId().toString()) || info.isIsGenPayBill()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"348_LoanListUI"));
                this.abort();
            }
            if (!this.isLoanAdjustInterest(info.getId().toString())) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"290_BondsListUI"));
            this.abort();
        }
        FundTransferBillFactory.getRemoteInstance().antiAudit(IDs);
        this.refreshList();
    }

    public boolean isLoanAdjustInterest(String loanId) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        FundTransRateAdjustBillCollection coll = FundTransRateAdjustBillFactory.getRemoteInstance().getFundTransRateAdjustBillCollection(evi);
        return !EmptyUtil.isEmpty((AbstractObjectCollection)coll);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        StringBuffer sb = new StringBuffer("select fid from T_FT_FundTransferBill where 1=1 and  ");
        sb.append(FMHelper.buildIn((String)"fid", (Object[])ids.toArray()));
        sb.append("and  FStatus != 0 and FStatus != 3  ");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        HashSet<String> IDs = new HashSet<String>();
        while (rs.next()) {
            IDs.add(rs.getString(1));
        }
        if (IDs == null || IDs.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"21_FundTransferBillListUI"));
            return;
        }
        String[] idList = IDs.toArray(new String[IDs.size()]);
        IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
        String[] idsInProcess = service2.checkBizObjInWfProcess(idList);
        if (idsInProcess != null && idsInProcess.length > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"61_FundTransferBillListUI"));
            return;
        }
        FundTransferBillFactory.getRemoteInstance().audit(IDs);
        this.refreshList();
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
        }
    }

    @Override
    public void actionBacthSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List returnMsg = FundTransferBillFactory.getRemoteInstance().batchSubmit(new HashSet(this.getSelectedIdValues()));
        if (returnMsg.size() > 0) {
            if (returnMsg.size() == 1 && returnMsg.get(0).equals(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"22_FundTransferBillListUI"))) {
                returnMsg.clear();
            }
            this.showMsg(returnMsg);
        }
        this.refreshList();
    }

    private void showMsg(List returnMsg) {
        String msg = EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"22_FundTransferBillListUI");
        MsgBox.showInfo((Component)((Object)this), (String)msg);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            if (filter == null) {
                filter = new FilterInfo();
                filter.appendFilterItem("isGenLoan", (Object)Boolean.FALSE);
                filter.appendFilterItem("status", (Object)3);
                String targetBill = (String)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBill");
                String transCompany = (String)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("CurrencyID");
                if (targetBill != null && targetBill.equals("Loan") && transCompany != null) {
                    filter.appendFilterItem("transCompany.id", (Object)transCompany);
                }
            }
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter") != null) {
                return (FilterInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter");
            }
            if ("LoanRepaymentApply".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(FundTransferBillStatusEnum.AUDITED.getValue())));
                filter.getFilterItems().add(new FilterItemInfo("loanBalanceAmt", (Object)"0", CompareType.GREATER));
                filter.getFilterItems().add(new FilterItemInfo("transCompany.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
                return filter;
            }
            if ("LoanExhibition".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(FundTransferBillStatusEnum.AUDITED.getValue())));
                filter.getFilterItems().add(new FilterItemInfo("loanBalanceAmt", (Object)"0", CompareType.GREATER));
                filter.getFilterItems().add(new FilterItemInfo("transCompany.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
                return filter;
            }
        }
        return filter;
    }

    @Override
    public void actionAdjustRate_actionPerformed(ActionEvent e) throws Exception {
        this.adjustRateCheck();
        this.checkHasNumber();
        HashSet set = new HashSet(this.getSelectedIdValues());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("rateType.id", (Object)ResourceFactory.getConsultativeRate()));
        evi.setFilter(filter);
        FundTransferBillCollection collection = new FundTransferBillCollection();
        FundTransferBillCollection fundTransferBillCollection = FundTransferBillFactory.getRemoteInstance().getFundTransferBillCollection(evi);
        if (!FMHelper.isEmpty((AbstractObjectCollection)fundTransferBillCollection)) {
            for (int i = 0; i < fundTransferBillCollection.size(); ++i) {
                FundTransferBillInfo info = fundTransferBillCollection.get(i);
                if (info.getStatus() != FundTransferBillStatusEnum.AUDITED) continue;
                collection.add(info);
            }
        }
        this.getUIContext().put("ids", collection);
        FundTrasnferBillChooseUI.show((CoreUI)this);
    }

    private void checkHasNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new FundTransRateAdjustBillInfo(), this.currentCompanyCommon.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    private void adjustRateCheck() throws Exception {
        FundTransferBillInfo info = this.getSelectObject();
        this.checkRateType(info);
        this.checkStatus_adjst(info);
        this.checkBalance(info);
    }

    private void checkBalance(FundTransferBillInfo info) {
        if (info.getLoanBalance().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"balance_zero_adj_ft"));
            SysUtil.abort();
        }
    }

    private void checkStatus_adjst(FundTransferBillInfo loanInfo) {
        if (loanInfo.getStatus() != FundTransferBillStatusEnum.AUDITED) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"status_tmp_store_adj_ft"));
            SysUtil.abort();
        }
    }

    private void checkRateType(FundTransferBillInfo info) {
        if (!this.isConsultiveRateType(info.getRateType())) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"not_consultive_ratetype_ft"));
            SysUtil.abort();
        }
    }

    private boolean isConsultiveRateType(IntRateTypeInfo rateType) {
        return rateType.getId().toString().equals(ResourceFactory.getConsultativeRate());
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    protected boolean isFootVisible() {
        return true;
    }

    private FilterInfo getBillCanbeReceived() {
        Map btpeditparameter;
        String targetBillType;
        FilterInfo filterInfo = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && (targetBillType = (String)(btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBill")) != null && "Loan".equals(targetBillType)) {
            this.getUIContext().put("LoanApplyBillType", LoanPropertyEnum.InGroup);
            filterInfo.getFilterItems().add(new FilterItemInfo("loanBalanceAmt", (Object)Constants.ZERO, CompareType.GREATER));
            filterInfo.getFilterItems().add(new FilterItemInfo("transCompany.id", (Object)((String)btpeditparameter.get("CurrencyID"))));
            filterInfo.getFilterItems().add(new FilterItemInfo("isGenLoan", (Object)Boolean.FALSE));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)this.Audit));
        }
        return filterInfo;
    }

    public void execQuery() {
        FilterInfo extFilter = this.getBillCanbeReceived();
        if (extFilter != null && extFilter.getFilterItems().size() > 0) {
            try {
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e.getCause());
            }
        }
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            if (extFilter == null) {
                extFilter = new FilterInfo();
            }
            extFilter.appendFilterItem("isGenLoan", (Object)Boolean.FALSE);
            if ("PaymentBill".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
                IContextHelper iContextHelper = ContextHelperFactory.getRemoteInstance();
                CompanyOrgUnitInfo companyInfo = iContextHelper.getCurrentCompany();
                extFilter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(FundTransferBillStatusEnum.AUDITED.getValue())));
                extFilter.appendFilterItem("company.id", (Object)companyInfo.getId().toString());
                extFilter.getFilterItems().add(new FilterItemInfo("loanBalanceAmt", (Object)"0", CompareType.GREATER));
                extFilter.appendFilterItem("cashier.name", null);
                extFilter.appendFilterItem("repayTimes", (Object)"0");
                extFilter.appendFilterItem("paymentBill.number", null);
            }
        }
        try {
            if (this.mainQuery.getFilter() != null) {
                extFilter.mergeFilter(this.mainQuery.getFilter(), "AND");
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.mainQuery.setFilter(extFilter);
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            FundTransferBillFilterParam param = (FundTransferBillFilterParam)this.getFilterUI().getParam();
            if (this.tblMain.getFootManager() != null) {
                IRow row = this.tblMain.getFootManager().getFootRow(0);
                String curID = null;
                curID = param.getCurrencyInfo() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyInfo());
                String[] columns = new SumFiledsInfo(SumBillEnum.FtLoan).getSumFileds();
                for (int i = 0; i < columns.length; ++i) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        FundTransferBillInfo info;
        if (this.getSelectedKeyValues() != null && this.getSelectedIdValues().size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"23_FundTransferBillListUI"));
            SysUtil.abort();
        }
        if ((info = this.getSelectObject()).getStatus() != FundTransferBillStatusEnum.AUDITED) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"24_FundTransferBillListUI"));
            SysUtil.abort();
        }
        super.actionCreateTo_actionPerformed(e);
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (destBosTypeList != null && destBosTypeList.size() > 0) {
            destBosTypeList.remove("051F1B22");
            destBosTypeList.remove("89ACD27D");
            destBosTypeList.remove("3A9A0A91");
        }
        return destBosTypeList;
    }

    public void beforeTransform(IObjectCollection srcObjCols, String destBillBosType) {
        try {
            if ("1E5849AD".equals(destBillBosType)) {
                this.checkExt();
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.beforeTransform(srcObjCols, destBillBosType);
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        BizEnumValueDTO status = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("status").getValue();
            if (status.getInt() != 3) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"26_FundTransferBillListUI"));
            SysUtil.abort();
        } else if (ids.size() == indexs.length) {
            IFundTransferBillFacade facade = FundTransferBillFacadeFactory.getRemoteInstance();
            facade.book(ids);
            this.showMsg(e);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"27_FundTransferBillListUI"))) == 0) {
            IFundTransferBillFacade facade = FundTransferBillFacadeFactory.getRemoteInstance();
            facade.book(ids);
            this.showMsg(e);
        }
    }

    @Override
    public void actionAntiBook_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        Object cashier = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            cashier = row.getCell("cashier.name").getValue();
            if (cashier == null) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"28_FundTransferBillListUI"));
            SysUtil.abort();
        } else if (ids.size() == indexs.length) {
            IFundTransferBillFacade facade = FundTransferBillFacadeFactory.getRemoteInstance();
            facade.antiBook(ids);
            this.showMsg(e);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"29_FundTransferBillListUI"))) == 0) {
            IFundTransferBillFacade facade = FundTransferBillFacadeFactory.getRemoteInstance();
            facade.antiBook(ids);
            this.showMsg(e);
        }
    }

    private void showMsg(ActionEvent e) throws Exception {
        this.refresh(e);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.fundTransferBillTDPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.fundTransferBillTDPrint(true);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.actionTDPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.actionTDPrintPreview_actionPerformed(e);
    }

    private void fundTransferBillTDPrint(boolean isPreview) {
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(FMHelper.list2Set((List)idList), headPK);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSFERBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSFERBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "bizDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionBacthSubmit", "actionAntiAudit"};
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.FundTransferBill";
        param.alias = "\u8d44\u91d1\u5f80\u6765\u5355";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.FundTransferBill";
        param.alias = "\u8d44\u91d1\u5f80\u6765\u5355";
        param.putContextParam((Object)"filter", (Object)this.getMainQuery().getFilter());
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 1, false);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(FundTransferBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                Integer precesion = (Integer)row.getCell("currency.precision").getValue();
                this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precesion));
                String format = FMClientHelper.getNumberFtm((int)FundTransferBillListUI.this.getBaseCurrencyPrecision());
                this.setNumberFormat(row, "loanLocalAmt", format);
                String rateFormat = "";
                BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("intRateExpression").getValue();
                Object enu = exp.getValue();
                rateFormat = "year".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
                row.getCell("rate").getStyleAttributes().setNumberFormat(rateFormat);
                row.getCell("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                exp = (BizEnumValueInfo)row.getCell("penAccrualType").getValue();
                enu = exp.getValue();
                rateFormat = "addPercent".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
                row.getCell("penaRate").getStyleAttributes().setNumberFormat(rateFormat);
                row.getCell("penaRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }

        private void setAmtCellNumberFormat(IRow row, String format) {
            this.setNumberFormat(row, "loanAmt", format);
            this.setNumberFormat(row, "exchangeRate", format, false);
            this.setNumberFormat(row, "loanBalanceAmt", format);
            this.setNumberFormat(row, "guarateeAmt", format);
        }

        private void setNumberFormat(IRow row, String columnKey, String format) {
            this.setNumberFormat(row, columnKey, format, true);
        }

        private void setNumberFormat(IRow row, String columnKey, String format, boolean doFormat) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            if (doFormat) {
                styleAttributes.setNumberFormat(format);
            } else {
                String formatRate = FMClientHelper.getNumberFtm((int)5);
                styleAttributes.setNumberFormat(formatRate);
            }
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

