/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferExtBillFactory;
import com.kingdee.eas.fm.ft.FundTransferExtBillInfo;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferExtBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundTransferExtBillEditUI
extends AbstractFundTransferExtBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferExtBillEditUI.class);
    private boolean isSuccess = false;
    public static final String FUNDTRANSFEREXTBILL_FILENAME = "/FM/INVEST/FT/FUNDTRANSFEREXTBILL";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (FMHelper.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "ft_ext_02addnew";
        }
        return "ft_ext_01view";
    }

    @Override
    public void loadFields() {
        try {
            this.setPrecision();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        } else {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)company.getBaseCurrency());
        }
        this.resetTranscompany();
        this.restoreData();
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkBizDate});
    }

    private void restoreData() {
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        super.onLoad();
        this.actionCreateTo.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.prmtCustomer.setEnabled(false);
        this.prmtTransCompany.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.txtExtendSeq.setRemoveingZeroInDispaly(true);
        this.actionMultiapprove.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionNextPerson.setEnabled(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanRemove();
        super.actionRemove_actionPerformed(e);
    }

    private void checkCanEdit() throws Exception {
        if (this.editData.isFivouchered()) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"bill_vouchered"));
        }
        this.checkSeq(this.editData, 1);
    }

    private void checkCanRemove() throws Exception {
        if (this.editData.isFivouchered()) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"bill_vouchered"));
        }
        this.checkSeq(this.editData, 2);
    }

    private void checkSeq(FundTransferExtBillInfo extInfo, int type) throws Exception {
        int maxSeq = extInfo.getLoan().getExtTimes();
        if (extInfo.getExtendSeq() != maxSeq) {
            if (type == 1) {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"edit_error1"));
                SysUtil.abort();
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"delete_error1"));
                SysUtil.abort();
            }
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        FundTransferExtBillInfo extInfo = (FundTransferExtBillInfo)this.getDataObject();
        if (extInfo.getCurrency() != null && this.currentCompany.getBaseCurrency().getId().toString().equals(extInfo.getCurrency().getId().toString())) {
            this.txtExchangeRate.setEditable(false);
        } else {
            this.txtExchangeRate.setEditable(true);
        }
        if (extInfo.getLoan() != null) {
            if (extInfo.getLoan().getRelationWithCmp() == RelationshipWithLoanCompanyEnum.INTERIOR) {
                this.contTransCompany.setVisible(true);
                this.contCustomer.setVisible(false);
            } else {
                this.contTransCompany.setVisible(false);
                this.contCustomer.setVisible(true);
            }
        } else {
            this.contTransCompany.setVisible(true);
            this.contCustomer.setVisible(false);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.actionPre.setEnabled(false);
            this.actionPre.setVisible(false);
            this.actionNext.setEnabled(false);
            this.actionNext.setVisible(false);
            this.actionFirst.setEnabled(false);
            this.actionFirst.setVisible(false);
            this.actionLast.setEnabled(false);
            this.actionLast.setVisible(false);
            this.actionTraceDown.setEnabled(false);
            this.actionTraceDown.setVisible(false);
            this.actionTraceUp.setEnabled(false);
            this.actionTraceUp.setVisible(false);
            this.actionCreateTo.setEnabled(true);
            this.actionCreateTo.setVisible(true);
        } else {
            this.actionCreateFrom.setEnabled(false);
            this.actionCreateFrom.setVisible(false);
        }
        this.actionCreateTo.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.pkAfterExtDate.setSupportedEmpty(false);
        this.pkBizDate.setSupportedEmpty(false);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.txtNumber.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("extendSeq"));
        sic.add(new SelectorItemInfo("loanBalance"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("loanBalanceLocal"));
        sic.add(new SelectorItemInfo("transCompany.id"));
        sic.add(new SelectorItemInfo("transCompany.number"));
        sic.add(new SelectorItemInfo("transCompany.name"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("beforeExtDate"));
        sic.add(new SelectorItemInfo("afterExtDate"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("accountant.id"));
        sic.add(new SelectorItemInfo("accountant.number"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("loan.id"));
        sic.add(new SelectorItemInfo("loan.number"));
        sic.add(new SelectorItemInfo("loan.effectiveDate"));
        sic.add(new SelectorItemInfo("loan.relationWithCmp"));
        sic.add(new SelectorItemInfo("loan.transCompany.id"));
        sic.add(new SelectorItemInfo("loan.transCompany.number"));
        sic.add(new SelectorItemInfo("loan.transCompany.name"));
        sic.add(new SelectorItemInfo("loan.customer.id"));
        sic.add(new SelectorItemInfo("loan.customer.name"));
        sic.add(new SelectorItemInfo("loan.customer.number"));
        sic.add(new SelectorItemInfo("loan.currency.id"));
        sic.add(new SelectorItemInfo("loan.currency.number"));
        sic.add(new SelectorItemInfo("loan.currency.name"));
        sic.add(new SelectorItemInfo("loan.extTimes"));
        sic.add(new SelectorItemInfo("loan.maturityDate"));
        sic.add(new SelectorItemInfo("loan.loanBalanceAmt"));
        sic.add(new SelectorItemInfo("loan.exchangeRate"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        return sic;
    }

    public SelectorItemCollection getFundSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("effectiveDate"));
        sic.add(new SelectorItemInfo("relationWithCmp"));
        sic.add(new SelectorItemInfo("transCompany.id"));
        sic.add(new SelectorItemInfo("transCompany.number"));
        sic.add(new SelectorItemInfo("transCompany.name"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("extTimes"));
        sic.add(new SelectorItemInfo("maturityDate"));
        sic.add(new SelectorItemInfo("loanBalanceAmt"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        return sic;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        FundTransferExtBillInfo editInfo;
        FundTransferBillInfo loan;
        super.setDataObject(dataObject);
        if (this.getBOTPViewStatus() == 1 && (loan = (editInfo = (FundTransferExtBillInfo)dataObject).getLoan()) != null) {
            try {
                loan = FundTransferBillFactory.getRemoteInstance().getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(editInfo.getLoan().getId()), this.getFundSelectors());
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
            editInfo.setCreator(this.userinfo);
            editInfo.setExtendSeq(loan.getExtTimes() + 1);
            editInfo.setBeforeExtDate(DateTimeUtils.truncateDate((Date)loan.getMaturityDate()));
            editInfo.setTransCompany(loan.getTransCompany());
            editInfo.setCustomer(loan.getCustomer());
            editInfo.setCompany(this.currentCompany);
            editInfo.setBizDate(DateUtil.getDayBegin());
            editInfo.setLoan(loan);
            editInfo.setLoanBalance(loan.getLoanBalanceAmt());
            editInfo.setLoanBalanceLocal(FMHelper.multiply((BigDecimal)editInfo.getLoanBalance(), (BigDecimal)editInfo.getExchangeRate()));
            String description = EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"32_FundTransferExtBillEditUI");
            description = MessageFormat.format(description, loan.getNumber(), editInfo.getExtendSeq());
            editInfo.setDescription(description);
        }
    }

    private void resetTranscompany() {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getTransCompany() != null || this.editData.getTransCompany() == null && this.editData.getCustomer() == null) {
            this.contTransCompany.setVisible(true);
            this.contCustomer.setVisible(false);
            this.prmtTransCompany.setVisible(true);
            this.prmtCustomer.setVisible(false);
        }
        if (this.editData.getCustomer() != null) {
            this.contCustomer.setVisible(true);
            this.contTransCompany.setVisible(false);
            this.prmtCustomer.setVisible(true);
            this.prmtTransCompany.setVisible(false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransferExtBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        FundTransferExtBillInfo extInfo = new FundTransferExtBillInfo();
        extInfo.setBizDate(DateUtil.getDayBegin());
        extInfo.setAfterExtDate(DateUtil.getDayBegin());
        extInfo.setCompany(this.currentCompany);
        extInfo.setCreator(this.userinfo);
        if (this.getUIContext().get("FundTransBillID") != null) {
            IObjectPK loanPK = (IObjectPK)this.getUIContext().get("FundTransBillID");
            FundTransferBillInfo ftLoanSelected = null;
            try {
                ftLoanSelected = FundTransferBillFactory.getRemoteInstance().getFundTransferBillInfo(loanPK, this.getLoanSelectors());
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e.getCause());
            }
            extInfo.setSourceBillId(loanPK.toString());
            extInfo.setFivouchered(false);
            extInfo.setExtendSeq(ftLoanSelected.getExtTimes() + 1);
            extInfo.setLoanBalance(ftLoanSelected.getLoanBalanceAmt());
            extInfo.setExchangeRate(ftLoanSelected.getExchangeRate());
            extInfo.setLoanBalanceLocal(FMHelper.multiply((BigDecimal)extInfo.getLoanBalance(), (BigDecimal)extInfo.getExchangeRate()));
            extInfo.setLoan(ftLoanSelected);
            extInfo.setTransCompany(ftLoanSelected.getTransCompany());
            extInfo.setCustomer(ftLoanSelected.getCustomer());
            extInfo.setCurrency(ftLoanSelected.getCurrency());
            extInfo.setBeforeExtDate(DateTimeUtils.truncateDate((Date)ftLoanSelected.getMaturityDate()));
            extInfo.setAfterExtDate(extInfo.getBeforeExtDate());
            String description = EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"32_FundTransferExtBillEditUI");
            description = MessageFormat.format(description, ftLoanSelected.getNumber(), extInfo.getExtendSeq());
            extInfo.setDescription(description);
        }
        return extInfo;
    }

    private SelectorItemCollection getLoanSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("extTimes"));
        sic.add(new SelectorItemInfo("effectiveDate"));
        sic.add(new SelectorItemInfo("maturityDate"));
        sic.add(new SelectorItemInfo("loanBalanceAmt"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("relationWithCmp"));
        sic.add(new SelectorItemInfo("transCompany.id"));
        sic.add(new SelectorItemInfo("transCompany.number"));
        sic.add(new SelectorItemInfo("transCompany.name"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        return sic;
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkBizDate});
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calLocalAmt();
    }

    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
    }

    private void calLocalAmt() {
        BigDecimal localAmt = FMHelper.multiply((BigDecimal)this.txtLoanBalance.getBigDecimalValue(), (BigDecimal)this.txtExchangeRate.getBigDecimalValue());
        this.txtLoanBalanceLocal.setValue((Object)localAmt);
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    protected void resetPrecisionForLocalAmt() {
        this.txtLoanBalanceLocal.setPrecision(this.getBaseCurrencyPrecision());
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.comboCurrency.getSelectedItem();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.prmtLoan.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getModelResourceMsg((String)"shouldcreatefrom_fundtrans_ext"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.editData.getBeforeExtDate().compareTo(this.editData.getAfterExtDate()) >= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"34_FundTransferExtBillEditUI"));
            this.pkAfterExtDate.requestFocus();
            SysUtil.abort();
        }
    }

    protected void resetPrecisionForOtherComponent() {
        this.txtExchangeRate.setPrecision(5);
    }

    public static void showExtEdidUI(CoreUIObject ui, IObjectPK pk) throws EASBizException, UIException {
        if (pk == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"FundTransBillID", (Object)pk);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(FundTransferExtBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean flag = ((FundTransferExtBillEditUI)uiWindow.getUIObject()).getSuccessFlag();
        if (flag) {
            uiWindow.close();
        }
    }

    private boolean getSuccessFlag() {
        return this.isSuccess;
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("DefaultQueryFilter", this.getFilter());
        ctx.put("fundTransfer", "fundTransfer");
        this.getBillEdit().createFrom(null, ctx);
        this.btnCreateFrom.setEnabled(true);
    }

    private FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("loanBalanceAmt", (Object)Constants.ZERO, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("isOverdue", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
        return filterInfo;
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferExtBillTDPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferExtBillTDPrint(true);
    }

    private void fundTransferExtBillTDPrint(boolean isPreview) {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        idSet.add(this.editData.getId());
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferExtBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSFEREXTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSFEREXTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }
}

