/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferExtBillFilterUI;
import com.kingdee.eas.fm.ft.client.FundTransferExtBillFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class FundTransferExtBillFilterUI
extends AbstractFundTransferExtBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferExtBillFilterUI.class);

    @Override
    protected void comboRelationshipWithLoanCompany_actionPerformed(ActionEvent e) throws Exception {
        Object rswc = this.comboRelations.getSelectedItem();
        if (rswc instanceof RelationshipWithLoanCompanyEnum) {
            if (rswc == RelationshipWithLoanCompanyEnum.EXTERIOR) {
                this.prmtLoanCompany.setValue(null);
                this.prmtCustomer.setEnabled(true);
                this.contLoanCompany.setVisible(false);
                this.contCustomer.setVisible(true);
            } else {
                this.prmtCustomer.setValue(null);
                this.prmtLoanCompany.setEnabled(true);
                this.contCustomer.setVisible(false);
                this.contLoanCompany.setVisible(true);
            }
        } else {
            this.prmtCustomer.setValue(null);
            this.prmtLoanCompany.setValue(null);
            this.contCustomer.setVisible(false);
            this.contLoanCompany.setVisible(false);
        }
    }

    protected void init() throws Exception {
        super.init();
        this.dpEffectiveDate.setSupportedEmpty(false);
        this.dpMaturityDate.setSupportedEmpty(false);
        this.customInit();
        F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)this.prmtLoanCompany, (boolean)true);
        FMClientHelper.setCustomerFilterF7(null, (KDBizPromptBox)this.prmtCustomer, (boolean)true, null);
        this.comboRelations.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void customInit() {
        this.initDate();
        this.initRelations();
        this.prmtCustomer.setValue(null);
        this.prmtCustomer.setEnabledMultiSelection(true);
        this.prmtLoanCompany.setValue(null);
        this.prmtLoanCompany.setEnabledMultiSelection(true);
        this.initCurrency();
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initRelations() {
        this.comboRelations.setSelectedItem((Object)RelationshipWithLoanCompanyEnum.INTERIOR);
    }

    private void initDate() {
        Date now = new Date();
        this.dpEffectiveDate.setValue((Object)this.getStartDate(now));
        this.dpMaturityDate.setValue((Object)now);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public boolean verify() {
        if (DateTimeUtils.truncateDate((Date)((Date)this.dpEffectiveDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.dpMaturityDate.getValue())))) {
            MsgBox.showInfo((String)ResourceFactory.getModelResourceMsg((String)"effectivedate_error"));
            Date d = new Date();
            this.dpEffectiveDate.setValue((Object)this.getStartDate(d));
            this.dpEffectiveDate.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.customInit();
    }

    public Object getParam() {
        Object relations;
        FundTransferExtBillFilterParam cbfp = new FundTransferExtBillFilterParam();
        if (null != this.dpEffectiveDate.getValue()) {
            cbfp.setEffectiveDate(DateTimeUtils.truncateDate((Date)((Date)this.dpEffectiveDate.getValue())));
        }
        if (null != this.dpMaturityDate.getValue()) {
            cbfp.setMaturityDate(DateTimeUtils.truncateDate((Date)((Date)this.dpMaturityDate.getValue())));
        }
        if ((relations = this.comboRelations.getSelectedItem()) instanceof RelationshipWithLoanCompanyEnum) {
            cbfp.setRelations((RelationshipWithLoanCompanyEnum)relations);
            if (relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                if (this.prmtLoanCompany.getValue() != null) {
                    cbfp.setLoanCompanys(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoanCompany));
                    cbfp.setRelations(RelationshipWithLoanCompanyEnum.INTERIOR);
                }
            } else if (this.prmtCustomer.getValue() != null) {
                cbfp.setCustomers(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCustomer));
                cbfp.setRelations(RelationshipWithLoanCompanyEnum.EXTERIOR);
            }
        }
        cbfp.setBOTP(false);
        if (null != this.cboCurrency.getSelectedItem()) {
            Object obj = this.cboCurrency.getSelectedItem();
            if (obj instanceof CurrencyInfo) {
                cbfp.setCurrencyInfo((CurrencyInfo)this.cboCurrency.getSelectedItem());
            } else {
                cbfp.setCurrencyInfo(null);
            }
        }
        return cbfp;
    }

    protected Class getParamClass() {
        return FundTransferExtBillFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        FundTransferExtBillFilterParam filterParam = (FundTransferExtBillFilterParam)param;
        this.dpEffectiveDate.setValue((Object)filterParam.getEffectiveDate());
        this.dpMaturityDate.setValue((Object)filterParam.getMaturityDate());
        if (filterParam.getRelations() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboRelations, (Object)filterParam.getRelations());
        } else {
            this.comboRelations.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.prmtLoanCompany.setValue(null);
        this.prmtCustomer.setValue(null);
        if (filterParam.getRelations() == RelationshipWithLoanCompanyEnum.INTERIOR) {
            this.prmtCustomer.setValue(null);
            this.setBizPromtValues(filterParam.getLoanCompanys(), 1);
        } else if (filterParam.getRelations() == RelationshipWithLoanCompanyEnum.EXTERIOR) {
            this.prmtLoanCompany.setValue(null);
            this.setBizPromtValues(filterParam.getCustomers(), 2);
        } else {
            this.prmtLoanCompany.setValue(null);
            this.prmtCustomer.setValue(null);
        }
        if (filterParam.getCurrencyInfo() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)filterParam.getCurrencyInfo());
        } else {
            this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
    }

    private void setBizPromtValues(String[] ids, int paraType) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        try {
            switch (paraType) {
                case 1: {
                    this.setLoanCompany(ev);
                    break;
                }
                case 2: {
                    this.setCustomer(ev);
                    break;
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setCustomer(EntityViewInfo ev) throws BOSException {
        CustomerCollection customCol = CustomerFactory.getRemoteInstance().getCustomerCollection(ev);
        this.prmtCustomer.setValue((Object)customCol.toArray());
    }

    private void setLoanCompany(EntityViewInfo ev) throws BOSException {
        CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
        this.prmtLoanCompany.setValue((Object)companyCol.toArray());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpEffectiveDate.setSupportedEmpty(false);
        this.dpMaturityDate.setSupportedEmpty(false);
    }
}

