/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.StateEnum;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ft.FundTransferInterestBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.IFundTransferInterestBill;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferInterestBillListUI;
import com.kingdee.eas.fm.ft.client.FTIntListPropress;
import com.kingdee.eas.fm.ft.client.FundTransferInterestBillEditUI;
import com.kingdee.eas.fm.ft.client.FundTransferInterestBillFilterUI;
import com.kingdee.eas.fm.ft.client.FundTransferInterestBillParam;
import com.kingdee.eas.fm.ft.client.FundTransferPreIntScopeChooserUI;
import com.kingdee.eas.fm.ft.client.FundTransferRecIntScopeChooserUI;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundTransferInterestBillListUI
extends AbstractFundTransferInterestBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferInterestBillListUI.class);
    private FundTransferInterestBillFilterUI filterUI;
    private static final String STATUS_SUMBIT_DISPLAY = ResourceFactory.getBizModelResourceMsg((String)"status_submit");
    private static final String STATUS_TMP_SAVE = ResourceFactory.getBizModelResourceMsg((String)"status_tempsave");
    private Set setIDs;
    private String uiParam;
    private LicenseService licenseService = new LicenseService((IUIObject)this);
    FillListener fillListener = new FillListener();
    public static final String FUNDTRANSFERINTERESTBILL_FILENAME = "/FM/IM/FUNDTRANSFERINTERESTBILL";

    protected CommonQueryProcessor getQueryProcessor() {
        return new FTIntListPropress();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        return sic;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FundTransferInterestBillFilterUI();
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return FundTransferInterestBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransferInterestBillFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompanyCommon);
        this.uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.getBOTPViewStatus() != 1) {
            this.licenseService.checkLicence();
            if (this.uiParam.equals("PRE_INT")) {
                this.setIDs = FundTransferPreIntScopeChooserUI.showPreIntScopeChooserUI((CoreUI)this);
                if (this.setIDs == null || this.setIDs.size() == 0) {
                    SysUtil.abort();
                }
            } else if (this.uiParam.equals("REC_INT")) {
                this.setIDs = FundTransferRecIntScopeChooserUI.showRecIntScopeChooserUI((CoreUI)this);
                if (this.setIDs == null || this.setIDs.size() == 0) {
                    SysUtil.abort();
                }
            }
        }
        super.onLoad();
        this.actionViewDoProccess.setEnabled(false);
        this.actionWorkFlowG.setEnabled(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionBatchSubmit.setEnabled(false);
        this.actionBatchSubmit.setVisible(false);
        this.btnBatchSubmit.setEnabled(false);
        this.btnBatchSubmit.setVisible(false);
        this.menuItemBatchSumbit.setEnabled(false);
        this.menuItemBatchSumbit.setVisible(false);
        this.onshows();
    }

    private void onshows() {
        boolean isFpItem = FMClientHelper.getIsFpOrBg();
        FMClientHelper.initFpOrBgF7Item((boolean)isFpItem, (IColumn)this.tblMain.getColumn("fpItem"), (IColumn)this.tblMain.getColumn("bgItem"));
    }

    protected void execQuery() {
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.setIDs = null;
        this.onshows();
        this.formatFootRow();
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            FundTransferInterestBillParam param = (FundTransferInterestBillParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyInfo() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyInfo());
            String[] columns = new SumFiledsInfo(SumBillEnum.FtLoanInt).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String parseValue(Set setIDs) {
        StringBuffer returnSb = new StringBuffer();
        Object[] ids = setIDs.toArray();
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                returnSb.append(ids[i].toString());
                continue;
            }
            returnSb.append(ids[i].toString()).append(",");
        }
        return returnSb.toString();
    }

    private void checkHasNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new FundTransferInterestBillInfo(), this.currentCompanyCommon.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showWarning((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionBatchSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionPreInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocount"));
        this.actionRecInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionGatherBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionAddNew.setVisible(false);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionPreInt_actionPerformed(ActionEvent e) throws Exception {
        this.setIDs = FundTransferPreIntScopeChooserUI.showPreIntScopeChooserUI((CoreUI)this);
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.refresh(e);
        }
    }

    @Override
    public void actionRecInt_actionPerformed(ActionEvent e) throws Exception {
        this.setIDs = FundTransferRecIntScopeChooserUI.showRecIntScopeChooserUI((CoreUI)this);
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.refresh(e);
        }
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        StringBuffer sb = new StringBuffer("select fid from T_FT_FundTransferInterestBill where 1=1 and  ");
        sb.append(FMHelper.buildIn((String)"fid", (Object[])ids.toArray()));
        sb.append("and  feffectedstatus=1");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        HashSet<String> IDs = new HashSet<String>();
        while (rs.next()) {
            IDs.add(rs.getString(1));
        }
        if (IDs == null || IDs.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"no_bill_submited"));
            return;
        }
        ((IFundTransferInterestBill)this.getBizInterface()).batchSubmit(IDs);
        this.refreshList();
    }

    @Override
    public void actionGatherBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList<Object> errorNumber = new ArrayList<Object>();
        Map m = this.checkGatherBill();
        for (Map.Entry entry : m.entrySet()) {
            errorNumber.add(entry.getValue());
            idList.remove(entry.getKey());
        }
        if (idList.size() > 0) {
            CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
            FundTransferInterestBillInfo fundTransferInfo = null;
            ObjectUuidPK pk = null;
            IFundTransferInterestBill iFundTransfer = null;
            for (String arr : idList) {
                pk = new ObjectUuidPK(arr);
                iFundTransfer = (IFundTransferInterestBill)this.getBizInterface();
                fundTransferInfo = iFundTransfer.getFundTransferInterestBillInfo((IObjectPK)pk, this.getBOTPSelectors());
                if (!fundTransferInfo.getIntCalType().equals((Object)IntCalTypeEnum.REC_INT) && !fundTransferInfo.getIntCalType().equals((Object)IntCalTypeEnum.REPAY_INT) || fundTransferInfo.isIsGatherBill() || !fundTransferInfo.getEffectedStatus().equals((Object)StateEnum.EAA)) {
                    errorNumber.add(fundTransferInfo.getNumber());
                    continue;
                }
                billCollection.add((CoreBillBaseInfo)fundTransferInfo);
            }
            if (billCollection.size() > 0) {
                FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new FundTransferInterestBillInfo().getBOSType().toString(), (String)new ReceivingBillInfo().getBOSType().toString(), (CoreBillBaseCollection)billCollection, (boolean)false);
            }
        }
        if (errorNumber.size() > 0) {
            String error = EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"55_FundTransferInterestBillListUI");
            error = MessageFormat.format(error, errorNumber.size(), errorNumber.toString().replaceAll("\\[|\\]", ""));
            MsgBox.showError((String)error);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"56_FundTransferInterestBillListUI"));
        }
        this.refreshList();
    }

    private Map checkGatherBill() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        Set intSet = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
        Iterator iter = intSet.iterator();
        while (iter.hasNext()) {
            int rowNumber = (Integer)iter.next();
            IRow row = this.tblMain.getRow(rowNumber);
            String id = (String)row.getCell("id").getValue();
            String number = (String)row.getCell("number").getValue();
            String intCalType = row.getCell("intCalType").getValue().toString();
            boolean isGatherBill = (Boolean)row.getCell("isGatherBill").getValue();
            String effectedStatus = row.getCell("effectedStatus").getValue().toString();
            if ((intCalType.equals(IntCalTypeEnum.REC_INT.toString()) || intCalType.equals(IntCalTypeEnum.REPAY_INT.toString())) && !isGatherBill && effectedStatus.equals(StateEnum.EAA.toString())) continue;
            map.put(id, number);
        }
        return map;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        this.checkOut(idSet);
        this.checkStatus(true);
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanbEdit();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        this.checkOut(idSet);
        this.checkStatus(false);
        super.actionEdit_actionPerformed(e);
    }

    private void checkStatus(boolean isRemove) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        String showMsg = null;
        showMsg = isRemove ? EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"89_ConsignmentApplicationEditUI") : EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"125_ConsignmentBillListUI");
        FundTransferInterestBillInfo intBillInfo = this.getSelectedObject((IObjectPK)pk, sic);
        if (StateEnum.EAA.equals((Object)intBillInfo.getEffectedStatus())) {
            MsgBox.showWarning((Component)((Object)this), (String)showMsg);
            SysUtil.abort();
        }
    }

    private void checkCanbEdit() throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fivouchered"));
        sic.add(new SelectorItemInfo("isStriked"));
        FundTransferInterestBillInfo intBillInfo = this.getSelectedObject((IObjectPK)pk, sic);
        if (intBillInfo.isFivouchered()) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"bill_edit_error1"));
            SysUtil.abort();
        }
        if (intBillInfo.isIsStriked()) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"bill_edit_error2"));
            SysUtil.abort();
        }
    }

    private FundTransferInterestBillInfo getSelectedObject(IObjectPK pk, SelectorItemCollection sic) throws Exception {
        return ((IFundTransferInterestBill)this.getBizInterface()).getFundTransferInterestBillInfo(pk, sic);
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 3;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedKeyValues() != null && this.getSelectedIdValues().size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"23_FundTransferBillListUI"));
            SysUtil.abort();
        }
        String selectId = this.getSelectedKeyValue();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("effectedStatus"));
        FundTransferInterestBillInfo billInfo = FundTransferInterestBillFactory.getRemoteInstance().getFundTransferInterestBillInfo((IObjectPK)new ObjectUuidPK(selectId), selector);
        if (!StateEnum.EAA.equals((Object)billInfo.getEffectedStatus())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"93_ConsignmentApplicationListUI"));
            this.abort();
        }
        super.actionCreateTo_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferInterestBillTDPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferInterestBillTDPrint(true);
    }

    private void fundTransferInterestBillTDPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferInterestBillHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(FMHelper.list2Set((List)idList), headPK);
        String mainDsName = "FundTransferInterestBillHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(FMHelper.list2Set((List)idList)));
        String entryDsName = "FundTransferInterestBillEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferInterestBillEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "transferInterest.id");
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSFERINTERESTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSFERINTERESTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        StringBuffer sb = new StringBuffer("select fid from T_FT_FundTransferInterestBill where 1=1 and  ");
        sb.append(StringUtil.buildIn((String)"fid", (Object[])ids.toArray()));
        sb.append("and  FEffectedStatus = 1  ");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        HashSet<String> IDs = new HashSet<String>();
        while (rs.next()) {
            IDs.add(rs.getString(1));
        }
        if (IDs == null || IDs.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"62_CANNOTAUDIT"));
            return;
        }
        FundTransferInterestBillFactory.getRemoteInstance().audit(IDs);
        this.refresh(e);
    }

    private void checkOut(Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filters);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("endDate"));
        view.setSelector(sic);
        FundTransferInterestBillCollection colls = FundTransferInterestBillFactory.getRemoteInstance().getFundTransferInterestBillCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            FundTransferInterestBillInfo intBillInfo = colls.get(i);
            this.checkFinalCheckout(intBillInfo.getEndDate());
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        StringBuffer sb = new StringBuffer("select fid from T_FT_FundTransferInterestBill where 1=1 and  ");
        sb.append(StringUtil.buildIn((String)"fid", (Object[])ids.toArray()));
        sb.append("and  FEffectedStatus = 2  ");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        HashSet<String> IDs = new HashSet<String>();
        while (rs.next()) {
            IDs.add(rs.getString(1));
        }
        if (IDs == null || IDs.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"20_FundTransferBillListUI"));
            return;
        }
        this.checkOut(IDs);
        FundTransferInterestBillFactory.getRemoteInstance().unAudit(IDs);
        this.refresh(e);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "endDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionUnAudit"};
    }

    private void checkFinalCheckout(Date endDate) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        Calendar cl = Calendar.getInstance();
        cl.setTime(endDate);
        cl.add(5, 1);
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.FIN_MANAGE, (String)companyInfo.getId().toString(), (Date)cl.getTime());
        if (!canOp) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        super.tblMain_tableSelectChanged(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        FundTransferInterestBillInfo sourceBill = ((IFundTransferInterestBill)this.getBizInterface()).getFundTransferInterestBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.actionVoucher.setEnabled(!sourceBill.isFivouchered() && StateEnum.EAA.equals((Object)sourceBill.getEffectedStatus()));
    }

    public boolean destroyWindow() {
        try {
            this.licenseService.releaseLicense();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return super.destroyWindow();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(FundTransferInterestBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                this.formatRow(tblMain, i);
            }
        }

        private void formatRow(KDTable tblMain, int i) {
            IRow row = tblMain.getRow(i);
            Integer precesion = (Integer)row.getCell("currency.precision").getValue();
            this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precesion));
            BizEnumValueInfo rateExpression = (BizEnumValueInfo)row.getCell("rateExpression").getValue();
            String formatTmp = "";
            formatTmp = "year".equals(rateExpression.getValue()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
            row.getCell("rate").getStyleAttributes().setNumberFormat(formatTmp);
            row.getCell("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            BizEnumValueInfo penaAccrualType = (BizEnumValueInfo)row.getCell("penaAccrualType").getValue();
            formatTmp = penaAccrualType.getValue().equals("addPercent") ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
            row.getCell("penaRate").getStyleAttributes().setNumberFormat(formatTmp);
            row.getCell("penaRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("overdueDays").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("intervalDays").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }

        private void setAmtCellNumberFormat(IRow row, String format) {
            this.setNumberFormat(row, "amount", format);
            this.setNumberFormat(row, "shijiIntAmt", format);
            this.setNumberFormat(row, "yingjiIntAmt", format);
            this.setNumberFormat(row, "shijiPenaAmt", format);
            this.setNumberFormat(row, "yingjiPenaAmt", format);
            this.setNumberFormat(row, "shijiPenaAmt", format);
            this.setNumberFormat(row, "strikeAmt", format);
        }

        private void setNumberFormat(IRow row, String columnKey, String format) {
            this.setNumberFormat(row, columnKey, format, true);
        }

        private void setNumberFormat(IRow row, String columnKey, String format, boolean doFormat) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            if (doFormat) {
                styleAttributes.setNumberFormat(format);
            } else {
                String formatRate = FMClientHelper.getNumberFtm((int)5);
                styleAttributes.setNumberFormat(formatRate);
            }
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

