/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.ft.FundTransferInterestBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferRecIntScopeChooserUI;
import com.kingdee.eas.fm.ft.client.FundTransClientHelper;
import com.kingdee.eas.fm.ft.client.FundTransferIntBillModifyFpItemsUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundTransferRecIntScopeChooserUI
extends AbstractFundTransferRecIntScopeChooserUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferRecIntScopeChooserUI.class);
    private Set createdIntReceivedID;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        super.onLoad();
        this.customed_init();
        this.comboRelations.setSelectedItem((Object)RelationshipWithLoanCompanyEnum.INTERIOR);
        this.comboRelations.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.prmtLoan.setEnabledMultiSelection(true);
        this.prmtLoan.setRequired(true);
        FMClientHelper.setCustomerF7(null, (KDBizPromptBox)this.prmtCustomer, (boolean)true, null);
    }

    private void customed_init() {
        this.initchkStartDate();
        this.initDate();
    }

    private void initDate() {
        if (this.chkStartDate.isSelected()) {
            this.pdStartDate.setEditable(true);
            this.pdStartDate.setEnabled(true);
            this.pdStartDate.setSupportedEmpty(false);
            this.pdStartDate.setValue((Object)new Date());
            this.dpEndDate.setSupportedEmpty(false);
            this.dpEndDate.setValue((Object)new Date());
        } else {
            this.pdStartDate.setEditable(false);
            this.pdStartDate.setEnabled(false);
            this.pdStartDate.setValue(null);
            this.dpEndDate.setSupportedEmpty(false);
        }
    }

    private void initchkStartDate() {
        this.chkStartDate.setSelected(false);
    }

    private void initCurrency(KDComboBox comboCurrency) {
        CashHelper.initCombCurrency((KDComboBox)comboCurrency, (boolean)false);
        comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    @Override
    public void chkStartDate_actionPerformed(ActionEvent e) {
        if (this.chkStartDate.isSelected()) {
            this.pdStartDate.setEditable(true);
            this.pdStartDate.setEnabled(true);
            this.pdStartDate.setSupportedEmpty(false);
            this.pdStartDate.setValue((Object)new Date());
            this.dpEndDate.setSupportedEmpty(false);
            this.dpEndDate.setValue((Object)new Date());
        } else {
            this.pdStartDate.setEditable(false);
            this.pdStartDate.setEnabled(false);
            this.pdStartDate.setValue(null);
            this.dpEndDate.setSupportedEmpty(false);
        }
    }

    public boolean verify() {
        Set ids;
        if (this.chkStartDate.isSelected() && ((Date)this.dpEndDate.getValue()).compareTo((Date)this.pdStartDate.getValue()) <= 0) {
            MsgBox.showInfo((String)ResourceFactory.getModelResourceMsg((String)"effectivedate_error"));
            this.pdStartDate.setFocusable(true);
            SysUtil.abort();
        }
        if ((ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoan))) == null || ids.size() == 0) {
            MsgBox.showInfo((String)ResourceFactory.getBizModelResourceMsg((String)"choose_fundtransfer"));
            SysUtil.abort();
        }
        return true;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        super.disposeUIWindow();
    }

    @Override
    protected void prmtFinancingProduct_willShow(SelectorEvent e) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillType", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtFinancingProduct.setEntityViewInfo(view);
        this.prmtFinancingProduct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public void prmtLoan_willShow(SelectorEvent e) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        evi.setFilter(filter);
        this.prmtLoan.setEntityViewInfo(evi);
        this.prmtLoan.getQueryAgent().resetRuntimeEntityView();
    }

    private void setFilterItems(FilterInfo filter) {
        this.setCurrencyFilterItem(filter);
        this.setLoanCompanyFilterItem(filter);
        this.setBalanceFilterItem(filter);
        this.setStatusFilter(filter);
        this.setPrmtFinancingProductFilter(filter);
    }

    private void setStatusFilter(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
    }

    private void setBalanceFilterItem(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("loanBalanceAmt", (Object)Constants.ZERO, CompareType.GREATER));
    }

    private void setLoanCompanyFilterItem(FilterInfo filter) {
        Object rswc = this.comboRelations.getSelectedItem();
        if (rswc instanceof RelationshipWithLoanCompanyEnum) {
            if (rswc == RelationshipWithLoanCompanyEnum.EXTERIOR) {
                String[] customerIDs = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCustomer);
                if (customerIDs != null && customerIDs.length > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)FMHelper.asSet((String[])customerIDs), CompareType.INCLUDE));
                }
                filter.getFilterItems().add(new FilterItemInfo("transCompany.id", null, CompareType.EQUALS));
            } else {
                String[] loanCompanyIDs = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoanCompany);
                if (loanCompanyIDs != null && loanCompanyIDs.length > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("transCompany.id", (Object)FMHelper.asSet((String[])loanCompanyIDs), CompareType.INCLUDE));
                }
                filter.getFilterItems().add(new FilterItemInfo("customer.id", null, CompareType.EQUALS));
            }
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
    }

    private void setCurrencyFilterItem(FilterInfo filter) {
        Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCurrency));
        if (ids != null && ids.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)ids, CompareType.INCLUDE));
        }
    }

    private void setPrmtFinancingProductFilter(FilterInfo filter) {
        Object[] obj = (Object[])this.prmtFinancingProduct.getData();
        if (EmptyUtil.isEmpty((Object[])obj) || EmptyUtil.isEmpty((Object)obj[0])) {
            return;
        }
        String[] stringObj = new String[obj.length];
        FinancingProductsInfo info = null;
        String productId = null;
        for (int index = 0; index < obj.length; ++index) {
            info = (FinancingProductsInfo)obj[index];
            stringObj[index] = productId = info.getId().toString();
        }
        if (stringObj.length > 0) {
            filter.getFilterItems().add(new FilterItemInfo("finacingProduct.id", (Object)FMHelper.Array2Set((String[])stringObj), CompareType.INCLUDE));
        }
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.checkFinalCheckout();
        this.createdIntReceivedID = new HashSet();
        this.createdIntReceivedID.clear();
        boolean isFpItemControl = FundTransClientHelper.isControlledByFpItem_FundTransferInterestBill();
        if (!isFpItemControl) {
            this.withoutFpItemControl();
        } else {
            this.withFpItemControl();
        }
    }

    private void withFpItemControl() throws Exception {
        Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoan));
        FundTransferInterestBillCollection ftIntCol = FundTransferInterestBillFactory.getRemoteInstance().batchRecIntWithFpItem(ids, (Date)this.pdStartDate.getValue(), (Date)this.dpEndDate.getValue());
        this.createdIntReceivedID = FundTransferIntBillModifyFpItemsUI.showModifyFpItemsUI(this, ftIntCol);
        if (this.createdIntReceivedID == null || this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((String)ResourceFactory.getBizModelResourceMsg((String)"no_rec_int_bill_created"));
            SysUtil.abort();
        } else {
            this.disposeUIWindow();
        }
    }

    private void withoutFpItemControl() throws Exception {
        Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoan));
        this.createdIntReceivedID = FundTransferInterestBillFactory.getRemoteInstance().batchRecInt(ids, (Date)this.pdStartDate.getValue(), (Date)this.dpEndDate.getValue());
        if (this.createdIntReceivedID == null || this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((String)ResourceFactory.getBizModelResourceMsg((String)"no_rec_int_bill_created"));
            SysUtil.abort();
        } else {
            this.disposeUIWindow();
        }
    }

    public static Set showRecIntScopeChooserUI(CoreUI ui) {
        Set createdIntReceivedID = new HashSet();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FundTransferRecIntScopeChooserUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            createdIntReceivedID = ((FundTransferRecIntScopeChooserUI)uiWindow.getUIObject()).getCreatedIntID();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return createdIntReceivedID;
    }

    private Set getCreatedIntID() {
        return this.createdIntReceivedID;
    }

    @Override
    protected void comboRelations_actionPerformed(ActionEvent e) throws Exception {
        Object rswc = this.comboRelations.getSelectedItem();
        if (rswc instanceof RelationshipWithLoanCompanyEnum) {
            if (rswc == RelationshipWithLoanCompanyEnum.EXTERIOR) {
                this.prmtLoanCompany.setValue(null);
                this.contLoanCompany.setVisible(false);
                this.contCustomer.setVisible(true);
            } else {
                this.prmtCustomer.setValue(null);
                this.contCustomer.setVisible(false);
                this.contLoanCompany.setVisible(true);
            }
        } else {
            this.contCustomer.setVisible(false);
            this.contLoanCompany.setVisible(false);
        }
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        Calendar cl = Calendar.getInstance();
        cl.setTime((Date)this.dpEndDate.getValue());
        cl.add(5, 1);
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.FIN_MANAGE, (String)this.currentCompany.getId().toString(), (Date)cl.getTime());
        if (!canOp) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

