/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.gnt.GnoteCollection;
import com.kingdee.eas.fm.gnt.GnoteFactory;
import com.kingdee.eas.fm.gnt.GnoteInfo;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordFactory;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordInfo;
import com.kingdee.eas.fm.gnt.GntException;
import com.kingdee.eas.fm.gnt.OppUnitFactory;
import com.kingdee.eas.fm.gnt.OppUnitInfo;
import com.kingdee.eas.fm.gnt.client.AbstractAppopriationEditUI;
import com.kingdee.eas.fm.gnt.common.MyPersonPromptBox;
import com.kingdee.eas.fm.gnt.common.NoteHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NoteStateEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class AppopriationEditUI
extends AbstractAppopriationEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AppopriationEditUI.class);
    GnoteProvideRecordInfo provide = null;
    private static final String GntResource = "com.kingdee.eas.fm.gnt.GntResource";
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    public AppopriationEditUI() throws Exception {
        MyPersonPromptBox select = NoteHelper.initPerson((IUIObject)this, this.prmtSigner);
        select.setSelectable(false).setExpandMode(MyPersonPromptBox.SPECIEL_ADMIN);
    }

    @Override
    public void storeFields() {
        this.editData.setPayeeCompany(this.prmtPayeeCompany.getText());
        if (this.provide != null) {
            this.editData.setNtType(this.provide.getNtType());
        }
        this.editData.setCompany((CompanyOrgUnitInfo)this.prmtPayUnit.getData());
        super.storeFields();
        this.editData.setIssueDate(DateTimeUtils.truncateDate((Date)((Date)this.dpIssueDate.getValue())));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        UserInfo user;
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (JFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.cmbCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayUnit);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtPayeeAcctBank);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayAcctBank);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtPayeeBank);
        if (this.provide == null) {
            throw new GntException(GntException.NUMBERERROR);
        }
        if (!this.provide.getNtType().getGroup().equals((Object)NTTypeGroupEnum.APPROPRIATION)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"numberNull"));
            SysUtil.abort();
        }
        if (this.provide.getParent().getBank() != null && !this.editData.getPaybank().getId().equals((Object)this.provide.getParent().getBank().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"bankNotMatch"));
            SysUtil.abort();
        }
        if (!(user = SysContext.getSysContext().getCurrentUserInfo()).getPerson().getId().equals((Object)this.provide.getReceiptor().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"NotSamePerson"));
            SysUtil.abort();
        }
        if (FMHelper.isEmpty((String)this.prmtPayeeCompany.getText())) {
            this.prmtPayeeCompany.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)FMClientVerifyHelper.getMessage((Component)this.prmtPayeeCompany));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)this.provide.getReceiptDate()).compareTo(this.editData.getIssueDate()) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"IssDateTooBig"));
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    @Override
    public void loadFields() {
        Map map = this.getUIContext();
        boolean isCopy = map.get("COPY") == null ? false : map.get("COPY").toString().equals("COPY");
        super.loadFields();
        this.prmtPayeeCompany.setText(this.editData.getPayeeCompany());
        if (this.getOprtState().equals(OprtState.ADDNEW) && !isCopy) {
            this.dpIssueDate.setValue((Object)new Date());
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                CurrencyInfo currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)company);
                FMClientHelper.setSelectObject((KDComboBox)this.cmbCurrency, (Object)currency);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbCurrency, (Object)this.editData.getCurrency());
        }
        this.prmtPayUnit.setValue((Object)this.editData.getPayUnit());
        this.prmtPayAcctBank.setValue((Object)this.editData.getPayAcctBank());
        this.prmtPayBank.setValue((Object)this.editData.getPaybank());
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    public void onLoad() throws Exception {
        FMClientHelper.initComboCurrency((KDComboBox)this.cmbCurrency, (boolean)false);
        super.onLoad();
        CompanyF7 f7 = new CompanyF7();
        this.prmtPayUnit.setSelector((KDPromptSelector)f7);
        this.prmtPayUnit.setEnabledMultiSelection(false);
        CurrencyInfo currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
        }
        MyPersonPromptBox select = NoteHelper.initPerson((IUIObject)this, this.prmtSigner);
        select.setSelectable(false).setExpandMode(MyPersonPromptBox.SPECIEL_ADMIN);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.chkMenuItemSubmitAndPrint.setSelected(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectValue createNewData() {
        Map map = this.getUIContext();
        if (map.get("COPY") != null && map.get("COPY").toString().equals("COPY")) {
            String id = map.get("ID").toString();
            try {
                GnoteInfo info = new GnoteInfo();
                GnoteInfo oldInfo = GnoteFactory.getRemoteInstance().getGnoteInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
                info = oldInfo.copy();
                info.setAbandonDate(null);
                info.setNoteState(NoteStateEnum.save);
                return info;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        GnoteInfo info = new GnoteInfo();
        return info;
    }

    @Override
    public void setOprtState(String oprtType) {
        boolean isCopy;
        super.setOprtState(oprtType);
        Map map = this.getUIContext();
        boolean bl = isCopy = map.get("COPY") == null ? false : map.get("COPY").toString().equals("COPY");
        if (this.getOprtState().equals(OprtState.EDIT)) {
            // empty if block
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        GnoteInfo note = (GnoteInfo)this.getDataObject();
        if (this.getOprtState().equals(OprtState.VIEW) && note.getNoteState().equals((Object)NoteStateEnum.canceled)) {
            this.actionEdit.setEnabled(false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GnoteFactory.getRemoteInstance();
    }

    @Override
    protected void prmtPayeeCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayeeCompany_dataChanged(e);
        if (CoreBaseInfo.class.isInstance(e.getNewValue())) {
            OppUnitInfo oppUnit = (OppUnitInfo)e.getNewValue();
            if (oppUnit == null) {
                return;
            }
            this.txtPayeeAcctBank.setText(oppUnit.getAcctBank());
            this.txtPayeeBank.setText(oppUnit.getBank());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        boolean isUpdate;
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        boolean bl = isUpdate = this.getUIContext().get("UPDATE") != null && this.getUIContext().get("UPDATE").toString().equals("update");
        if (isUpdate) {
            GnoteInfo gnote = this.getNotUsedNote(this.txtNumber.getText().trim());
            this.setDataObject((IObjectValue)gnote);
            this.setOprtState(OprtState.EDIT);
            this.provide = this.getDetailedProvideInfo(this.editData.getProvide());
            super.actionSubmit_actionPerformed(e);
            this.getUIContext().put("UPDATE", null);
        } else {
            GnoteInfo oldNote = GnoteFactory.getRemoteInstance().getGnoteInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
            if (oldNote.getNumber().equals(this.txtNumber.getText().trim())) {
                this.provide = this.getDetailedProvideInfo(this.editData.getProvide());
                super.actionSubmit_actionPerformed(e);
            } else {
                GnoteInfo gnote = (GnoteInfo)NoteHelper.getNotUsedNote((ICoreBillBase)GnoteFactory.getRemoteInstance(), this.txtNumber.getText().trim());
                this.provide = this.getDetailedProvideInfo(gnote.getProvide());
                super.actionSubmit_actionPerformed(e);
                gnote = GnoteFactory.getRemoteInstance().getGnoteInfo((IObjectPK)new ObjectUuidPK(gnote.getId().toString()));
                this.setDataObject((IObjectValue)gnote);
            }
        }
        this.setSave(true);
    }

    private GnoteProvideRecordInfo getDetailedProvideInfo(GnoteProvideRecordInfo provide) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("parent.bank.*"));
        provide = GnoteProvideRecordFactory.getRemoteInstance().getGnoteProvideRecordInfo((IObjectPK)new ObjectUuidPK(provide.getId().toString()), sic);
        return provide;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.getUIContext().put("UPDATE", "update");
    }

    private GnoteInfo getNotUsedNote(String number) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("provide.id", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("noteState", (Object)NoteStateEnum.store));
        view.setFilter(filter);
        GnoteCollection coll = GnoteFactory.getRemoteInstance().getGnoteCollection(view);
        GnoteInfo gnote = new GnoteInfo();
        if (coll.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)GntResource, (String)"numberNull"));
            SysUtil.abort();
        } else {
            gnote = coll.get(0);
        }
        return gnote;
    }

    @Override
    public void actionReturn_actionPerformed(ActionEvent e) throws Exception {
        boolean isVC;
        if (!this.isSaved() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"saveBeforeAction"));
            return;
        }
        boolean fiVouchered = this.editData.getBoolean("fiVouchered");
        boolean hasReturn = this.editData.get("abandonDate") != null;
        boolean isPrint = this.editData.getInt("notestate") == 2;
        boolean bl = isVC = this.editData.getDate("vcDate") != null;
        if (hasReturn || isVC || fiVouchered) {
            throw new GntException(GntException.CANTRETURN);
        }
        int result1 = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"isCanceled"));
        if (result1 != 0) {
            return;
        }
        this.editData.setDate("abandonDate", new Date());
        this.editData.setInt("noteState", 4);
        this.getBizInterface().update((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBaseInfo)this.editData);
        int result2 = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"isAddNew"));
        if (result2 == 0) {
            this.doAddNewAfterReturn();
        }
    }

    private void doAddNewAfterReturn() throws ParserException, BOSException {
        this.txtNumber.setEnabled(true);
        this.getUIContext().put("UPDATE", "update");
        GnoteInfo note = new GnoteInfo();
        note = this.editData.copy();
        note.setAbandonDate(null);
        this.setOprtState(OprtState.EDIT);
        this.setDataObject((IObjectValue)note);
        this.loadFields();
        this.initScrollButtons();
        this.unLockUI();
        EntityViewInfo view = new EntityViewInfo("SELECT number where number>'" + note.getNumber() + "'  order by Number ASC ");
        GnoteCollection coll = GnoteFactory.getRemoteInstance().getGnoteCollection(view);
        if (coll.size() == 0) {
            return;
        }
        this.txtNumber.setText(coll.get(0).getNumber());
    }

    @Override
    protected void prmtPayUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayUnit_dataChanged(e);
        if (e.getNewValue() == null) {
            NoteHelper.removeFilterItem(this.prmtPayAcctBank, "company.id");
            NoteHelper.removeFilterItem(this.prmtPayeeCompany, "company.id");
            NoteHelper.removeFilterItem(this.prmtPayAcctBank, "isClosed");
            return;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("accountBank.*"));
        sic.add(new SelectorItemInfo("juridicalPerson.name"));
        sic.add(new SelectorItemInfo("juridicalPerson.id"));
        sic.add(new SelectorItemInfo("*"));
        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
        this.prmtPayAcctBank.setValue(null);
        this.prmtPayBank.setValue(null);
        this.prmtSigner.setValue(null);
        AccountBankInfo relateBankAcct = company.getAccountBank();
        FilterItemInfo filterItem1 = new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS);
        NoteHelper.mergerFilterItem(this.prmtPayAcctBank, filterItem1);
        NoteHelper.mergerFilterItem(this.prmtPayAcctBank, filterItem2);
        NoteHelper.mergerFilterItem(this.prmtPayeeCompany, filterItem1);
        if (relateBankAcct == null) {
            IRowSet rs;
            IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.prmtPayAcctBank.getQueryAgent().getQueryInfoPK());
            if (this.prmtPayAcctBank.getEntityViewInfo() != null) {
                executor.setObjectView(this.prmtPayAcctBank.getEntityViewInfo());
            }
            if ((rs = executor.executeQuery()).next()) {
                String id = rs.getObject("id").toString();
                AccountBankInfo firstBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(id));
                this.prmtPayAcctBank.setValue((Object)firstBank);
            }
        } else {
            relateBankAcct = company.getAccountBank();
            AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(company.getAccountBank().getId().toString()));
            this.prmtPayAcctBank.setValue((Object)relateBankAcct);
        }
        AccountBankInfo f7AccountValue = (AccountBankInfo)this.prmtPayAcctBank.getValue();
        if (f7AccountValue != null && f7AccountValue.getBank() != null) {
            BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(f7AccountValue.getBank().getId().toString()));
            this.prmtPayBank.setValue((Object)bank);
        }
        MyPersonPromptBox select = (MyPersonPromptBox)this.prmtSigner.getSelector();
        select.setExpandAdmin(company.getId().toString());
        FilterItemInfo item = new FilterItemInfo("company.id", (Object)company.getId().toString());
        NoteHelper.mergerFilterItem(this.prmtPayeeCompany, item);
    }

    @Override
    protected void prmtPayAcctBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayAcctBank_dataChanged(e);
        AccountBankInfo account = (AccountBankInfo)e.getNewValue();
        if (account == null) {
            return;
        }
        if (account.getBank() != null) {
            BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(account.getBank().getId().toString()));
            this.prmtPayBank.setValue((Object)bank);
        }
    }

    @Override
    protected void txtNumber_focusLost(FocusEvent e) throws Exception {
        super.txtNumber_focusLost(e);
        if (FMHelper.isEmpty((String)this.txtNumber.getText())) {
            return;
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("signer.*");
        sic.add("payeeCompany.*");
        sic.add("paybank.*");
        sic.add("currency.*");
        return sic;
    }

    @Override
    protected void cmbCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
        }
    }

    private void saveOppUnit(String name, String account, String bank, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)name)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        filter.getFilterItems().add(new FilterItemInfo("acctBank", (Object)account));
        filter.getFilterItems().add(new FilterItemInfo("bank", (Object)bank));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        view.setFilter(filter);
        CoreBaseCollection coll = OppUnitFactory.getRemoteInstance().getCollection(view);
        if (coll.size() > 0) {
            return;
        }
        OppUnitInfo oppUnit = new OppUnitInfo();
        oppUnit.setName(name);
        oppUnit.setBank(bank);
        oppUnit.setAcctBank(account);
        oppUnit.setCompany(company);
        OppUnitFactory.getRemoteInstance().addnew((CoreBaseInfo)oppUnit);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        if (!this.isSaved() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected String getTDFileName() {
        return "/FM/GOV/Appr";
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.gnt.app.GnoteAppopQuery");
    }

    protected void afterSubmitAddNew() {
        GnoteInfo info = this.editData.copy();
        super.afterSubmitAddNew();
        this.getUIContext().put("UPDATE", "update");
        this.prmtPayeeCompany.setValue((Object)info.getPayeeCompany());
        this.txtPayeeAcctBank.setText(info.getPayeeAcctBank());
        this.txtPayeeBank.setText(info.getPayeeBank());
    }
}

