/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordFactory;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordInfo;
import com.kingdee.eas.fm.gnt.GntException;
import com.kingdee.eas.fm.gnt.OppUnitFactory;
import com.kingdee.eas.fm.gnt.OppUnitInfo;
import com.kingdee.eas.fm.gnt.client.AbstractGnoteChequeEditUI;
import com.kingdee.eas.fm.gnt.client.GnoteTDPrintDelegate;
import com.kingdee.eas.fm.gnt.common.MyPersonPromptBox;
import com.kingdee.eas.fm.gnt.common.NoteHelper;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NoteStateEnum;
import com.kingdee.eas.fm.nt.SelSymbolEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class GnoteChequeEditUI
extends AbstractGnoteChequeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(GnoteChequeEditUI.class);
    private static final String queryName = "com.kingdee.eas.fm.gnt.app.GnoteChequeQuery";
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private static final String GntResource = "com.kingdee.eas.fm.gnt.GntResource";
    GnoteProvideRecordInfo provide = null;
    boolean isVerification = false;

    public GnoteChequeEditUI() throws Exception {
        MyPersonPromptBox select = NoteHelper.initPerson((IUIObject)this, this.prmtSigner);
        select.setSelectable(false).setExpandMode(MyPersonPromptBox.SPECIEL_ADMIN);
    }

    @Override
    public void storeFields() {
        Map map = this.getUIContext();
        if (this.getOprtState().equals(OprtState.EDIT) && this.isVerification) {
            this.editData.setIsVC(true);
            this.editData.setVcDate(new Date());
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW) || !this.isVerification) {
            // empty if block
        }
        this.editData.setIsApply(false);
        this.editData.setIsOwnReceive(false);
        if (!this.isVerification && !this.chkIsQuota.isSelected()) {
            this.editData.setNull("sealSymbol");
        } else {
            this.editData.setSealSymbol(SelSymbolEnum.getEnum((int)this.kDButtonGroupSeal.getValue()));
        }
        if (this.provide != null) {
            this.editData.setNtType(this.provide.getNtType());
        }
        this.editData.setPayeeName(this.prmtoppUnit.getText());
        super.storeFields();
        if (this.chkIsQuota.isSelected() && !this.isVerification && !this.getOprtState().equals(OprtState.VIEW)) {
            this.editData.setAmount(null);
            this.txtAmount.setText(null);
        }
        if (this.chkIsQuota.isSelected() && !FMHelper.isEmpty((String)this.txtAmount.getText()) && this.isVerification) {
            this.editData.setIssueDate(DateTimeUtils.truncateDate((Date)((Date)this.dpIssueDate.getValue())));
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTDPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtoppUnit.setText(this.editData.getPayeeName());
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                CurrencyInfo currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)company);
                FMClientHelper.setSelectObject((KDComboBox)this.cbCurrency, (Object)currency);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cbCurrency, (Object)this.editData.getCurrency());
        }
        this.chkIsLineation.setSelected(this.editData.isIsLineation());
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.dpIssueDate.setValue((Object)new Date());
            this.chkIsQuota.setSelected(true);
            this.kDButtonGroupSeal.setValue(0);
            this.txtAmount.setEnabled(false);
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.kDButtonGroupSeal.setValue(this.editData.getSealSymbol().getValue());
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int lenthOfAmount;
        UserInfo user;
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayBank);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBankAcct);
        if (FMHelper.isEmpty((String)this.prmtoppUnit.getText())) {
            this.prmtoppUnit.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)FMClientVerifyHelper.getMessage((Component)this.prmtoppUnit));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        if (this.provide == null) {
            throw new GntException(GntException.NUMBERERROR);
        }
        if (!this.provide.getNtType().getGroup().equals((Object)NTTypeGroupEnum.CHEQUE)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"numberNull"));
            SysUtil.abort();
        }
        if (!this.editData.getBank().getId().equals((Object)this.provide.getParent().getBank().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"bankNotMatch"));
            SysUtil.abort();
        }
        if (!(user = SysContext.getSysContext().getCurrentUserInfo()).getPerson().getId().equals((Object)this.provide.getReceiptor().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"NotSamePerson"));
            SysUtil.abort();
        }
        if (!this.chkIsQuota.isSelected()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        } else if (!this.getOprtState().equals(OprtState.ADDNEW) && this.chkIsQuota.isSelected() && this.isVerification && (lenthOfAmount = (this.txtAmount.getIntegerValue() + "").length()) - this.kDButtonGroupSeal.getValue() > 3) {
            throw new GntException(GntException.AMOUNTBIGTHANQUOTA);
        }
        if (DateTimeUtils.truncateDate((Date)this.provide.getReceiptDate()).compareTo(this.editData.getIssueDate()) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"IssDateTooBig"));
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        FMClientHelper.initComboCurrency((KDComboBox)this.cbCurrency, (boolean)false);
        super.onLoad();
        CurrencyInfo currency = (CurrencyInfo)this.cbCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
        }
        CompanyF7 f7 = new CompanyF7();
        this.prmtCompany.setSelector((KDPromptSelector)f7);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.chkMenuItemSubmitAndPrint.setSelected(false);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtAmount.setHorizontalAlignment(4);
        this.setSealSymbolVisible(this.chkIsQuota.isSelected());
        this.txtAmount.setEnabled(!this.chkIsQuota.isSelected() || this.isVerification);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtPayBank, (Boolean)new Boolean(true));
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.updateUITitle();
    }

    protected IObjectValue createNewData() {
        Map map = this.getUIContext();
        if (map.get("COPY") != null && map.get("COPY").toString().equals("COPY")) {
            String id = map.get("ID").toString();
            try {
                ChequeInfo info = new ChequeInfo();
                ChequeInfo oldInfo = ChequeFactory.getRemoteInstance().getChequeInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
                info = oldInfo.copy();
                info.setAbandonDate(null);
                return info;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        ChequeInfo cheque = new ChequeInfo();
        return cheque;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ChequeFactory.getRemoteInstance();
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCompany_dataChanged(e);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
        if (company == null) {
            NoteHelper.removeFilterItem(this.prmtBankAcct, "company.id");
            NoteHelper.removeFilterItem(this.prmtBankAcct, "company.id");
            NoteHelper.removeFilterItem(this.prmtoppUnit, "isClosed");
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("accountBank.*"));
        sic.add(new SelectorItemInfo("juridicalPerson.name"));
        sic.add(new SelectorItemInfo("juridicalPerson.id"));
        sic.add(new SelectorItemInfo("*"));
        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
        this.prmtBankAcct.setValue(null);
        this.prmtPayBank.setValue(null);
        this.prmtSigner.setValue(null);
        AccountBankInfo relateBankAcct = company.getAccountBank();
        FilterItemInfo filterItem1 = new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS);
        NoteHelper.mergerFilterItem(this.prmtBankAcct, filterItem1);
        NoteHelper.mergerFilterItem(this.prmtBankAcct, filterItem2);
        NoteHelper.mergerFilterItem(this.prmtoppUnit, filterItem1);
        if (relateBankAcct == null) {
            IRowSet rs;
            IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.prmtBankAcct.getQueryAgent().getQueryInfoPK());
            if (this.prmtBankAcct.getEntityViewInfo() != null) {
                executor.setObjectView(this.prmtBankAcct.getEntityViewInfo());
            }
            if ((rs = executor.executeQuery()).next()) {
                String id = rs.getObject("id").toString();
                AccountBankInfo firstBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(id));
                this.prmtBankAcct.setValue((Object)firstBank);
            }
        } else {
            relateBankAcct = company.getAccountBank();
            AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(company.getAccountBank().getId().toString()));
            this.prmtBankAcct.setValue((Object)relateBankAcct);
        }
        MyPersonPromptBox select = (MyPersonPromptBox)this.prmtSigner.getSelector();
        select.setExpandAdmin(company.getId().toString());
    }

    @Override
    protected void prmtBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBankAcct_dataChanged(e);
        AccountBankInfo account = (AccountBankInfo)e.getNewValue();
        if (account == null) {
            return;
        }
        if (account.getBank() != null) {
            BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(account.getBank().getId().toString()));
            this.prmtPayBank.setValue((Object)bank);
        }
    }

    @Override
    protected void txtNumber_focusLost(FocusEvent e) throws Exception {
        super.txtNumber_focusLost(e);
    }

    @Override
    public void setOprtState(String oprtType) {
        IKDComponent[] components;
        super.setOprtState(oprtType);
        Map map = this.getUIContext();
        boolean isCopy = map.get("COPY") == null ? false : map.get("COPY").toString().equals("COPY");
        boolean bl = this.isVerification = map.get("Verification") == null ? false : (Boolean)map.get("Verification");
        if (this.getOprtState().equals(OprtState.VIEW)) {
            components = new IKDComponent[]{this.btnQian, this.btnWan, this.btnShiwan, this.chkIsQuota, this.chkIsLineation};
            FMClientHelper.setCompEnable((IKDComponent[])components, (boolean)false);
            this.btnQian.setEnabled(false);
            this.btnWan.setEnabled(false);
            this.btnShiwan.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.EDIT) && this.isVerification) {
            components = new IKDComponent[]{this.dpIssueDate, this.txtNumber, this.cbCurrency, this.prmtCompany, this.chkIsLineation, this.prmtBankAcct, this.prmtPayBank, this.prmtSigner, this.txtUsage};
            FMClientHelper.setCompEnable((IKDComponent[])components, (boolean)false);
            this.btnQian.setEnabled(false);
            this.btnWan.setEnabled(false);
            this.btnShiwan.setEnabled(false);
            this.txtAmount.setEnabled(true);
            this.chkIsQuota.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.EDIT) && !this.isVerification) {
            components = new IKDComponent[]{this.btnQian, this.btnWan, this.btnShiwan, this.chkIsQuota, this.chkIsLineation};
            FMClientHelper.setCompEnable((IKDComponent[])components, (boolean)true);
            if (this.chkIsQuota.getSelected() == 32) {
                this.btnQian.setEnabled(true);
                this.btnWan.setEnabled(true);
                this.btnShiwan.setEnabled(true);
            }
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            components = new IKDComponent[]{this.txtNumber, this.cbCurrency, this.prmtSigner, this.txtUsage, this.prmtBankAcct, this.prmtCompany, this.chkIsQuota, this.chkIsLineation};
            FMClientHelper.setCompEnable((IKDComponent[])components, (boolean)true);
            this.btnQian.setEnabled(true);
            this.btnWan.setEnabled(true);
            this.btnShiwan.setEnabled(true);
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW) || isCopy) {
            // empty if block
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        ChequeInfo cheque = (ChequeInfo)this.getDataObject();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            // empty if block
        }
    }

    @Override
    protected void cbCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.cbCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.cbCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
        }
    }

    @Override
    protected void chkIsQuota_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsQuota_stateChanged(e);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        if (this.chkIsQuota.isSelected()) {
            this.txtAmount.setText("");
            this.txtAmount.setEnabled(false);
            this.setSealSymbolVisible(true);
            if (!this.isVerification) {
                this.kDButtonGroupSeal.setValue(0);
            }
        } else {
            this.txtAmount.setEnabled(true);
            this.setSealSymbolVisible(false);
        }
        if (this.editData != null && this.getOprtState().equals(OprtState.EDIT) && this.isVerification) {
            this.txtAmount.setEnabled(true);
            this.kDButtonGroupSeal.setValue(this.editData.getSealSymbol().getValue());
        }
    }

    private void setSealSymbolVisible(boolean visible) {
        this.kDLabelContainer3.setVisible(visible);
        this.btnQian.setVisible(visible);
        this.btnWan.setVisible(visible);
        this.btnShiwan.setVisible(visible);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        if (!this.isSaved() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        GnoteTDPrintDelegate data = new GnoteTDPrintDelegate(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected String getTDFileName() {
        return "/FM/GOV/Cheque";
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK(queryName);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        boolean isUpdate;
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        boolean bl = isUpdate = this.getUIContext().get("UPDATE") != null && this.getUIContext().get("UPDATE").toString().equals("update");
        if (isUpdate) {
            ChequeInfo gnote = this.getNotUsedNote(this.txtNumber.getText().trim());
            BOSUuid id = gnote.getId();
            this.setDataObject((IObjectValue)gnote);
            this.setOprtState(OprtState.EDIT);
            super.actionSubmit_actionPerformed(e);
        } else {
            ChequeInfo oldNote = ChequeFactory.getRemoteInstance().getChequeInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
            if (oldNote.getNumber().equals(this.txtNumber.getText().trim())) {
                super.actionSubmit_actionPerformed(e);
            } else {
                ChequeInfo gnote = (ChequeInfo)NoteHelper.getNotUsedNote((ICoreBillBase)ChequeFactory.getRemoteInstance(), this.txtNumber.getText().trim());
                super.actionSubmit_actionPerformed(e);
                this.setDataObject((IObjectValue)gnote);
            }
        }
        this.setSave(true);
        this.updateUITitle();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.getUIContext().put("UPDATE", "update");
    }

    private GnoteProvideRecordInfo getDetailedProvideInfo(GnoteProvideRecordInfo provide) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("parent.bank.*"));
        provide = GnoteProvideRecordFactory.getRemoteInstance().getGnoteProvideRecordInfo((IObjectPK)new ObjectUuidPK(provide.getId().toString()), sic);
        return provide;
    }

    private ChequeInfo getNotUsedNote(String number) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("provide.id", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("noteState", (Object)NoteStateEnum.store));
        view.setFilter(filter);
        ChequeCollection coll = ChequeFactory.getRemoteInstance().getChequeCollection(view);
        ChequeInfo note = new ChequeInfo();
        if (coll.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)GntResource, (String)"numberNull"));
            SysUtil.abort();
        } else {
            note = coll.get(0);
        }
        return note;
    }

    @Override
    public void actionReturn_actionPerformed(ActionEvent e) throws Exception {
        boolean isVC;
        if (!this.isSaved() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"saveBeforeAction"));
            return;
        }
        boolean fiVouchered = this.editData.getBoolean("fiVouchered");
        boolean hasReturn = this.editData.get("abandonDate") != null;
        boolean isPrint = this.editData.getInt("notestate") == 2;
        boolean bl = isVC = this.editData.getDate("vcDate") != null;
        if (hasReturn || isVC || fiVouchered) {
            throw new GntException(GntException.CANTRETURN);
        }
        int result1 = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"isCanceled"));
        if (result1 != 0) {
            return;
        }
        this.editData.setDate("abandonDate", new Date());
        this.editData.setInt("noteState", 4);
        this.getBizInterface().update((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBaseInfo)this.editData);
        int result2 = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"isAddNew"));
        if (result2 == 0) {
            this.doAddNewAfterReturn();
        }
        this.updateUITitle();
    }

    private void doAddNewAfterReturn() throws BOSException, ParserException {
        this.txtNumber.setEnabled(true);
        this.getUIContext().put("UPDATE", "update");
        ChequeInfo note = new ChequeInfo();
        note = this.editData.copy();
        note.setAbandonDate(null);
        this.setOprtState(OprtState.EDIT);
        this.setDataObject((IObjectValue)note);
        this.loadFields();
        this.initScrollButtons();
        this.unLockUI();
        EntityViewInfo view = new EntityViewInfo("SELECT number where number>'" + note.getNumber() + "'  order by Number ASC ");
        ChequeCollection coll = ChequeFactory.getRemoteInstance().getChequeCollection(view);
        if (coll.size() == 0) {
            return;
        }
        this.txtNumber.setText(coll.get(0).getNumber());
    }

    protected void afterSubmitAddNew() {
        ChequeInfo info = this.editData.copy();
        super.afterSubmitAddNew();
        this.getUIContext().put("UPDATE", "update");
        ChequeCollection coll = new ChequeCollection();
        try {
            EntityViewInfo view = new EntityViewInfo("SELECT number where number>'" + info.getNumber() + "'  order by Number ASC ");
            coll = ChequeFactory.getRemoteInstance().getChequeCollection(view);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        catch (ParserException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
        if (coll.size() == 0) {
            return;
        }
        this.updateUITitle();
        this.txtNumber.setText(coll.get(0).getNumber());
        this.prmtoppUnit.setText(info.getPayeeName());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cashier.*"));
        sic.add(new SelectorItemInfo("oppAccount.*"));
        sic.add(new SelectorItemInfo("turnInAcctBank.*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("settleType.*"));
        return sic;
    }

    private void saveOppUnit(String name, String account, String bank, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)name)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        filter.getFilterItems().add(new FilterItemInfo("acctBank", (Object)account));
        filter.getFilterItems().add(new FilterItemInfo("bank", (Object)bank));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        view.setFilter(filter);
        CoreBaseCollection coll = OppUnitFactory.getRemoteInstance().getCollection(view);
        if (coll.size() > 0) {
            return;
        }
        OppUnitInfo oppUnit = new OppUnitInfo();
        oppUnit.setName(name);
        oppUnit.setBank(bank);
        oppUnit.setAcctBank(account);
        oppUnit.setCompany(company);
        OppUnitFactory.getRemoteInstance().addnew((CoreBaseInfo)oppUnit);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.prmtoppUnit.setText(this.editData.getPayeeName());
    }

    public void updateUITitle() {
        boolean isUpdate;
        String resPath = "com.kingdee.eas.fm.common.FMResource";
        this.resHelper = new ResourceBundleHelper(AbstractGnoteChequeEditUI.class.getName());
        String name = this.resHelper.getString("this.title");
        boolean bl = isUpdate = this.getUIContext().get("UPDATE") != null && this.getUIContext().get("UPDATE").toString().equals("update");
        if (isUpdate) {
            this.setUITitle(name + " - " + EASResource.getString((String)resPath, (String)"new"));
            return;
        }
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals("FINDVIEW")) {
            this.setUITitle(name + " - " + EASResource.getString((String)resPath, (String)"view"));
            return;
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.setUITitle(name + " - " + EASResource.getString((String)resPath, (String)"edit"));
            return;
        }
        this.setUITitle(name);
    }
}

