/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.gnt.GnoteFilterParam;
import com.kingdee.eas.fm.gnt.client.AbstractGnoteFilterUI;
import com.kingdee.eas.fm.gnt.common.NoteHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class GnoteFilterUI
extends AbstractGnoteFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(GnoteFilterUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.gnt.GntResource";

    public void onLoad() throws Exception {
        NoteHelper.initNTTypeF7(this.prmtNoteType);
        super.onLoad();
        CompanyF7 f7 = new CompanyF7();
        f7.setMultiSelect(true);
        this.prmtCompany.setSelector((KDPromptSelector)f7);
        if (this.getUIContext().get("type") != null) {
            this.ckIsQuota.setVisible(false);
        }
    }

    protected void init() throws Exception {
        super.init();
        this.pkStartDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkEndDate.setValue((Object)DateUtil.getEndDayOfCurMonth());
        this.prmtCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkStartDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkEndDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        Date dateFrom = this.pkStartDate.getSqlDate();
        Date dateTo = this.pkEndDate.getSqlDate();
        if (dateTo.compareTo(dateFrom) < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"startDateMustSmallThanEndDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        Set companySet;
        GnoteFilterParam filterParam = new GnoteFilterParam();
        Set NoteTypeSet = this.getIdSetFromF7(this.prmtNoteType);
        Set CompanyIDSet = this.getIdSetFromF7(this.prmtCompany);
        if (NoteTypeSet != null && NoteTypeSet.size() > 0) {
            filterParam.setNoteTypeSet(NoteTypeSet);
        }
        if (CompanyIDSet != null && CompanyIDSet.size() > 0) {
            filterParam.setCompanyF7Set(CompanyIDSet);
        }
        if ((companySet = this.getCompanyIdSet()) != null && companySet.size() > 0) {
            filterParam.setCompanyIdSet(companySet);
        }
        if (this.pkStartDate.getSqlDate() != null) {
            filterParam.setStartDate(DateTimeUtils.truncateDate((java.util.Date)this.pkStartDate.getSqlDate()));
        }
        if (this.pkEndDate.getSqlDate() != null) {
            filterParam.setEndDate(DateTimeUtils.truncateDate((java.util.Date)this.pkEndDate.getSqlDate()));
        }
        filterParam.setIsQuota(this.ckIsQuota.isSelected());
        return filterParam;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        GnoteFilterParam filterParam = (GnoteFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        this.pkStartDate.setValue((Object)filterParam.getStartDate());
        this.pkEndDate.setValue((Object)filterParam.getEndDate());
        this.ckIsQuota.setSelected(filterParam.IsQuota().booleanValue());
        try {
            this.prmtNoteType.setData((Object)this.getBaseInfoFromIdSet(filterParam.getNoteTypeSet()));
            this.prmtCompany.setData((Object)this.getBaseInfoFromIdSet(filterParam.getCompanyF7Set()));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected Class getParamClass() {
        return GnoteFilterParam.class;
    }
}

