/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.gnt.client.AppopriationEditUI;
import com.kingdee.eas.fm.gnt.client.GnoteChequeEditUI;
import com.kingdee.eas.fm.gnt.client.TeleOrderEditUI;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.SelSymbolEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSetMetaData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GnoteHandler {
    private String editUIName = "";
    private String mainQueryName = "";
    QueryInfo query = null;
    EntityObjectInfo entity = null;
    private NTTypeGroupEnum noteTypeEnum = null;
    private KDTable table = null;
    private static final String ChequeQuery = "com.kingdee.eas.fm.gnt.app.GnoteChequeQuery";
    private static final String TeleOrderQuery = "com.kingdee.eas.fm.gnt.app.GnoteTeleOrderQuery";
    private static final String AppopQuery = "com.kingdee.eas.fm.gnt.app.GnoteAppopQuery";

    public GnoteHandler(NTTypeGroupEnum enums) {
        this.setNoteTypeEnum(enums);
    }

    public GnoteHandler(KDTable table) {
        this.table = table;
    }

    public void initTableHeader() throws Exception {
        FMClientHelper.clearTable((KDTable)this.table);
        SelectorInfo selectors = this.query.getSelector();
        for (int i = 0; i < selectors.size(); ++i) {
            Pattern pattern;
            Matcher match;
            String displayFormat;
            String isShow;
            IColumn column = this.table.addColumn();
            String width = selectors.get(i).getExtendedProperty("colWidthInKDTable");
            column.setKey(selectors.get(i).getName());
            String key = column.getKey();
            if (key.equals("amount") || key.equals("issueDate") || key.equals("vcDate") || key.equals("abandonDate")) {
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            if (width != null) {
                column.setWidth(Integer.parseInt(width));
            }
            if ((isShow = selectors.get(i).getExtendedProperty("isVisibleForKDTable")) != null && !Boolean.valueOf(isShow).booleanValue()) {
                column.getStyleAttributes().setHided(true);
            }
            if (!FMHelper.isEmpty((String)(displayFormat = selectors.get(i).getExtendedProperty("displayFormat")))) {
                column.getStyleAttributes().setNumberFormat(displayFormat);
            }
            if ((match = (pattern = Pattern.compile("\\S*[id|ID]")).matcher(selectors.get(i).getName())).matches()) {
                column.getStyleAttributes().setHided(true);
            }
            if (!selectors.get(i).getName().equals("isTransCheque")) continue;
            column.getStyleAttributes().setHided(true);
        }
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            row.getCell(i).setValue((Object)selectors.get(i).getDisplayName());
        }
    }

    public FilterInfo initFilterInfo(FilterInfo filter) {
        if (this.getQuery().getName().equals(ChequeQuery)) {
            return filter;
        }
        if (this.getQuery().getName().equals(ChequeQuery)) {
            return null;
        }
        return filter;
    }

    public void fillTalble(EntityViewInfo view) throws Exception {
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        MetaDataPK pk = new MetaDataPK(this.mainQueryName);
        IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        executor.option().isAutoTranslateEnum = true;
        executor.setObjectView(view);
        IRowSet rs = executor.executeQuery();
        Class<?> entityClass = Class.forName(this.entity.getBusinessImplName() + "Info");
        IObjectValue value = (IObjectValue)entityClass.newInstance();
        while (rs.next()) {
            ResultSetMetaData meta = rs.getMetaData();
            IRow row = this.table.addRow();
            int fieldCount = meta.getColumnCount();
            for (int i = 0; i < fieldCount; ++i) {
                String columnName = meta.getColumnName(i + 1);
                value.put(columnName, rs.getObject(columnName));
                if (columnName.equals("sealSymbol") && rs.getObject(columnName) != null) {
                    if (rs.getObject(columnName) instanceof BizEnumValueInfo) {
                        row.getCell(i).setValue((Object)SelSymbolEnum.getEnum((int)((BizEnumValueInfo)rs.getObject(columnName)).getInt()));
                        continue;
                    }
                    row.getCell(i).setValue((Object)SelSymbolEnum.getEnum((int)Integer.parseInt((String)rs.getObject(columnName))));
                    continue;
                }
                row.getCell(i).setValue(rs.getObject(columnName));
            }
            row.setUserObject((Object)value);
            Object currencyId = row.getCell("currency.id").getValue();
            if (currencyId != null) {
                CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId.toString()));
                int precsion = currency.getPrecision();
                row.getCell("amount").getStyleAttributes().setNumberFormat("%r-[ ]0." + precsion + "n");
                continue;
            }
            row.getCell("amount").getStyleAttributes().setNumberFormat("%r-[ ]0.4n");
        }
    }

    public void setNoteTypeEnum(NTTypeGroupEnum enums) {
        this.noteTypeEnum = enums;
        try {
            this.setPropertyByNoteType(enums);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPropertyByNoteType(NTTypeGroupEnum enums) {
        String entityName = null;
        if (enums.getValue() == 1) {
            this.editUIName = GnoteChequeEditUI.class.getName();
            this.mainQueryName = ChequeQuery;
            entityName = "com.kingdee.eas.fm.nt.app.Cheque";
        } else if (enums.getValue() == 12) {
            this.editUIName = AppopriationEditUI.class.getName();
            this.mainQueryName = AppopQuery;
            entityName = "com.kingdee.eas.fm.gnt.app.Gnote";
        } else if (enums.getValue() == 11) {
            this.editUIName = TeleOrderEditUI.class.getName();
            this.mainQueryName = TeleOrderQuery;
            entityName = "com.kingdee.eas.fm.gnt.app.Gnote";
        }
        MetaDataPK pkQuery = new MetaDataPK(this.mainQueryName);
        MetaDataPK pkEntity = new MetaDataPK(entityName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        this.query = loader.getQuery((IMetaDataPK)pkQuery);
        this.entity = (EntityObjectInfo)loader.getBusinessObject((IMetaDataPK)pkEntity);
    }

    public String getEditUIName() {
        return this.editUIName;
    }

    public EntityObjectInfo getEntity() {
        return this.entity;
    }

    public String getMainQueryName() {
        return this.mainQueryName;
    }

    public QueryInfo getQuery() {
        return this.query;
    }
}

