/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.gnt.GnoteFacadeFactory;
import com.kingdee.eas.fm.gnt.GnoteFilterParam;
import com.kingdee.eas.fm.gnt.client.AbstractGnoteUsedListUI;
import com.kingdee.eas.fm.gnt.client.GnoteUsedFilterUI;
import com.kingdee.eas.fm.nt.NoteStateEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class GnoteUsedListUI
extends AbstractGnoteUsedListUI {
    private static final Logger logger = CoreUIObject.getLogger(GnoteUsedListUI.class);
    private GnoteUsedFilterUI filterUI = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.setEnabled(false);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new GnoteUsedFilterUI();
            this.filterUI.getUIContext().put("type", "used");
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void execQuery() throws BOSException {
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        GnoteFilterParam param = (GnoteFilterParam)((Object)this.filterUI.getParam());
        HashMap<String, Object> hmParam = new HashMap<String, Object>();
        hmParam.put("companySet", param.getCompanyF7Set());
        hmParam.put("noteTypeSet", param.getNoteTypeSet());
        hmParam.put("startDate", param.getStartDate());
        hmParam.put("endDate", param.getEndDate());
        IRowSet rs = GnoteFacadeFactory.getRemoteInstance().getGnoteUsed(hmParam);
        try {
            while (rs.next()) {
                IRow row = this.tblMain.addRow();
                row.getCell("company").setValue((Object)rs.getString("companyname"));
                row.getCell("number").setValue((Object)rs.getString("fnumber"));
                row.getCell("date").setValue((Object)new SimpleDateFormat("yyyy-MM-dd").format(rs.getDate("fissueDate")));
                row.getCell("nttype").setValue((Object)rs.getString("nttype"));
                row.getCell("signer").setValue((Object)rs.getString("signer"));
                row.getCell("state").setValue((Object)NoteStateEnum.getEnum((int)rs.getInt("state")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

