/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.gnt.GnoteFacadeFactory;
import com.kingdee.eas.fm.gnt.GnoteInfo;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordInfo;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordFactory;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordInfo;
import com.kingdee.eas.fm.gnt.GntException;
import com.kingdee.eas.fm.gnt.common.MyPersonPromptBox;
import com.kingdee.eas.fm.gnt.common.NoteNumberHelper;
import com.kingdee.eas.fm.nt.INTType;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.NoteStateEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NoteHelper {
    public static final String GNTSOURCE_PATH = "com.kingdee.eas.fm.gnt.GntResource";

    public static CoreBaseInfo[] getBaseInfoFromIdSet(Set idSet) throws BOSException {
        if (idSet == null || idSet.size() <= 0) {
            return null;
        }
        ICoreBase bizCtrl = EJBAccessFactory.createRemoteInstance().getEntityBizInterface(idSet.toArray()[0].toString());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        CoreBaseCollection collection = bizCtrl.getCollection(evi);
        CoreBaseInfo[] ovs = new CoreBaseInfo[collection.size()];
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ovs[i] = collection.get(i);
        }
        return ovs;
    }

    public static void initNoteTypeCombo(KDComboBox comboBox) throws BOSException {
        NTTypeCollection NTTypeColl = (NTTypeCollection)NoteHelper.getNTTypeColl();
        if (NTTypeColl != null && NTTypeColl.size() > 0) {
            int size = NTTypeColl.size();
            for (int i = 0; i < size; ++i) {
                NTTypeInfo info = NTTypeColl.get(i);
                comboBox.addItem((Object)info);
            }
        } else {
            return;
        }
    }

    public static void initNTTypeF7(KDBizPromptBox bizBox) {
        bizBox.setEnabledMultiSelection(true);
        EntityViewInfo evi = bizBox.getEntityViewInfo();
        if (evi == null) {
            evi = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(1));
        set.add(new Integer(11));
        set.add(new Integer(12));
        filter.getFilterItems().add(new FilterItemInfo("IsUsed", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("group", set, CompareType.INCLUDE));
        evi.getSorter().add(new SorterItemInfo("number"));
        bizBox.setEntityViewInfo(evi);
    }

    public static void main(String[] args) {
    }

    public static IObjectCollection getNTTypeColl() throws BOSException {
        INTType INTType2 = NTTypeFactory.getRemoteInstance();
        NTTypeCollection NTTypeColl = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(1));
        set.add(new Integer(11));
        set.add(new Integer(12));
        filter.getFilterItems().add(new FilterItemInfo("IsUsed", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("group", set, CompareType.INCLUDE));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        NTTypeColl = INTType2.getNTTypeCollection(viewInfo);
        return NTTypeColl;
    }

    public static Set getNTTypeIdSet(NTTypeGroupEnum enums) throws BOSException {
        EntityViewInfo noteTypeView = new EntityViewInfo();
        FilterInfo noteTypeFilter = new FilterInfo();
        noteTypeFilter.getFilterItems().add(new FilterItemInfo("group", (Object)new Integer(enums.getValue())));
        noteTypeView.setFilter(noteTypeFilter);
        noteTypeView.getSelector().add("id");
        CoreBaseCollection nttypeColl = NTTypeFactory.getRemoteInstance().getCollection(noteTypeView);
        HashSet<String> nttypeIDSet = new HashSet<String>();
        for (int i = 0; i < nttypeColl.size(); ++i) {
            nttypeIDSet.add(nttypeColl.get(i).getId().toString());
        }
        return nttypeIDSet;
    }

    public static void mergerFilterItem(KDBizPromptBox f7, FilterItemInfo filterItem) throws Exception {
        EntityViewInfo view = f7.getEntityViewInfo();
        if (view != null) {
            FilterItemCollection filters = view.getFilter().getFilterItems();
            boolean hasFilter = false;
            for (int i = 0; i < filters.size(); ++i) {
                if (!filters.get(i).getPropertyName().equals(filterItem.getPropertyName())) continue;
                filters.remove(filters.get(i));
                filters.add(filterItem);
                hasFilter = true;
                break;
            }
            if (!hasFilter) {
                filters.add(filterItem);
            }
            f7.setEntityViewInfo(view);
        } else {
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(filterItem);
            view.setFilter(filter);
            f7.setEntityViewInfo(view);
        }
    }

    public static void removeFilterItem(KDBizPromptBox f7, String name) {
        EntityViewInfo view = f7.getEntityViewInfo();
        if (view == null) {
            return;
        }
        FilterItemCollection filters = view.getFilter().getFilterItems();
        boolean hasFilter = false;
        if (filters.size() == 0) {
            return;
        }
        for (int i = 0; i < filters.size(); ++i) {
            if (!filters.get(i).getPropertyName().equals(name)) continue;
            filters.remove(filters.get(i));
            break;
        }
        f7.setEntityViewInfo(view);
    }

    public static void checkNumberValid(Component comp, GnoteProvideRecordInfo provide, KDTextField txtNumber) throws BOSException, EASBizException, GntException {
        if (provide == null) {
            provide = (GnoteProvideRecordInfo)GnoteFacadeFactory.getRemoteInstance().getProvideByNoteNumber(txtNumber.getText());
        }
        if (provide == null) {
            throw new GntException(GntException.NUMBERERROR);
        }
        GnotePurchaseRecordInfo purchase = GnotePurchaseRecordFactory.getRemoteInstance().getGnotePurchaseRecordInfo((IObjectPK)new ObjectUuidPK(provide.getParent().getId().toString()));
        HashSet set = provide.getUsedNumbersHashSet();
        List list = NoteNumberHelper.getProvidedNotesNum(provide.getReceiptedNum());
        HashSet provideNumber = NoteNumberHelper.getCodingNumber(purchase.getNumRule(), list);
        if (!provideNumber.contains(txtNumber.getText())) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)GNTSOURCE_PATH, (String)"NumberNotExist"));
            SysUtil.abort();
        }
        if (set.contains(txtNumber.getText())) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)GNTSOURCE_PATH, (String)"NumberUsed"));
            SysUtil.abort();
        }
    }

    public static CoreBaseInfo getNotUsedNote(ICoreBillBase intface, String number) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("provide.id", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("noteState", (Object)NoteStateEnum.store));
        view.setFilter(filter);
        CoreBaseCollection coll = intface.getCollection(view);
        GnoteInfo note = new GnoteInfo();
        if (coll.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)GNTSOURCE_PATH, (String)"numberNull"));
            SysUtil.abort();
        } else {
            note = coll.get(0);
        }
        return note;
    }

    public static MyPersonPromptBox initPerson(IUIObject coreui, KDBizPromptBox box) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("All_Admins", "YES");
        map.put("DEFAULT_SHOW_ALL", Boolean.TRUE);
        MyPersonPromptBox select = new MyPersonPromptBox(coreui, map);
        box.setSelector((KDPromptSelector)select);
        select.setHasCUDefaultFilter(false);
        box.setHasCUDefaultFilter(false);
        box.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        return select;
    }
}

