/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;

public class IbtHelper {
    public static BigDecimal subBigDecimalPrc(CurrencyInfo currency, BigDecimal amount) {
        if (currency != null && amount != null) {
            int p = currency.getPrecision();
            amount = amount.setScale(p, 4);
        }
        return amount;
    }

    private static void initNumber(CoreBaseInfo info, KDTextField txtField, String companyId) {
        if (!FMHelper.isEmpty((String)info.getString("number"))) {
            return;
        }
        boolean rst = IbtHelper.hasNumber(info, companyId);
        if (rst) {
            txtField.setEditable(false);
            txtField.setEnabled(false);
            txtField.setRequired(false);
            String number = IbtHelper.getDispNumber(info, companyId);
            if (!FMHelper.isEmpty((String)number)) {
                info.setString("number", number);
                txtField.setText(number);
            }
        } else {
            txtField.setEnabled(true);
            txtField.setEditable(true);
            txtField.setRequired(true);
        }
    }

    public static void initNumber(CoreBaseInfo info, KDTextField txtField, String companyId, FmRpcCacheInfo rpcCacheInfo) {
        if (rpcCacheInfo != null) {
            if (!FMHelper.isEmpty((String)info.getString("number"))) {
                txtField.setEnabled(false);
                return;
            }
            if (rpcCacheInfo.isHasCodeRule()) {
                txtField.setEditable(false);
                txtField.setEnabled(false);
                txtField.setRequired(false);
                String number = rpcCacheInfo.getNumber();
                info.setString("number", number);
                txtField.setText(number);
            } else {
                txtField.setEnabled(true);
                txtField.setEditable(true);
                txtField.setRequired(true);
            }
        } else {
            IbtHelper.initNumber(info, txtField, companyId);
        }
    }

    public static boolean hasNumber(CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getDispNumber(CoreBaseInfo info, String companyId) {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (codingRuleManager.isAddView((IObjectValue)info, companyId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                number = codingRuleManager.getNumber((IObjectValue)info, companyId);
            }
        }
        catch (BOSException bOSException) {
        }
        catch (CodingRuleException codingRuleException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return number;
    }
}

