/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.BillRediscountInEntryFactory;
import com.kingdee.eas.fm.ibt.BillRediscountInEntryInfo;
import com.kingdee.eas.fm.ibt.BillRediscountInFactory;
import com.kingdee.eas.fm.ibt.BillRediscountInInfo;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.IBillRediscountIn;
import com.kingdee.eas.fm.ibt.IbtHelper;
import com.kingdee.eas.fm.ibt.RediscountModeEnum;
import com.kingdee.eas.fm.ibt.RediscountTypeEnum;
import com.kingdee.eas.fm.ibt.client.AbstractBillRediscountInEditUI;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BillRediscountInEditUI
extends AbstractBillRediscountInEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BillRediscountInEditUI.class);
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    private CurrencyInfo EnCurrencyInfo = null;
    private boolean isOnLoadFinished = false;
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";
    private final String fileName = "/FM/IBT/BILLREDISCOUNTIN";

    public BillRediscountInEditUI() throws Exception {
        FinUtils.initCurrencyComboBox((KDComboBox)this.combCurrency);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.kdtBillEntry.getRowCount();
        if (rowCount < 2) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"EntryIsNull"));
            SysUtil.abort();
        }
        IRow row = this.kdtBillEntry.getRow(rowCount - 1);
        BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
        if (!BillTypeEnum.Audit.equals((Object)this.editData.getBillType())) {
            this.editData.setBillType(BillTypeEnum.Submit);
        }
        if (RediscountModeEnum.Monopoly.equals(this.comboRediscountMode.getSelectedItem())) {
            this.editData.setBalance(new BigDecimal(0));
        } else {
            this.editData.setBalance(totalAmount);
        }
        super.actionSubmit_actionPerformed(e);
        this.txtYearDiscountRate.setRemoveingZeroInDispaly(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnAddInBill.setEnabled(true);
        this.btnRemoveInBill.setEnabled(true);
        this.kdtBillEntry.getStyleAttributes().setLocked(false);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBdgBalance_actionPerformed(e);
    }

    protected void fillCellAfterBillSelectedAmountInBillEntry(DataChangeEvent eventObj) {
        BigDecimal amountInFinFee = (BigDecimal)eventObj.getNewValue();
        if (amountInFinFee == null) {
            return;
        }
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        BigDecimal exchangeRateInFinFee = new BigDecimal(String.valueOf(0));
        if (curRow.getCell("rate").getValue() != null) {
            exchangeRateInFinFee = (BigDecimal)curRow.getCell("rate").getValue();
        }
        curRow.getCell("AmountLocalCur").setValue((Object)amountInFinFee.multiply(exchangeRateInFinFee));
        this.setTotalValue(amountInFinFee, amountInFinFee.multiply(exchangeRateInFinFee));
    }

    private void fillCellAfterBillSelectedRateInBillEntry(DataChangeEvent eventObj) {
        BigDecimal rateInFinFee = (BigDecimal)eventObj.getNewValue();
        if (rateInFinFee == null) {
            return;
        }
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        if (curRow.getCell("Amount").getValue() != null) {
            BigDecimal amountInFinFee = (BigDecimal)curRow.getCell("Amount").getValue();
            curRow.getCell("AmountLocalCur").setValue((Object)rateInFinFee.multiply(amountInFinFee));
            this.setTotalValue(amountInFinFee, rateInFinFee.multiply(amountInFinFee));
        }
    }

    private void fillCellAfterBillSelectedAmountLocalCurEntry(DataChangeEvent eventObj) {
        BigDecimal amountLocalCur = (BigDecimal)eventObj.getNewValue();
        if (amountLocalCur == null) {
            return;
        }
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        BigDecimal amountInBillEn = new BigDecimal(String.valueOf(0));
        if (curRow.getCell("Amount").getValue() != null) {
            amountInBillEn = (BigDecimal)curRow.getCell("Amount").getValue();
        }
        this.setTotalValue(amountInBillEn, amountLocalCur);
    }

    private void exchangeCurrency(CurrencyInfo info, int rowIndex) {
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        FinHelper.clearCells((KDTable)this.kdtBillEntry, (int)rowIndex, (String[])new String[]{"rate", "AmountLocalCur"});
        if (info != null) {
            StringBuffer strFormat = new StringBuffer();
            strFormat.append("#,###.");
            for (int i = 0; i < info.getPrecision(); ++i) {
                strFormat.append("0");
            }
            this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setNumberFormat(strFormat.toString());
            if (FinUtils.isBaseCurrency((CurrencyInfo)info, (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
                curRow.getCell("rate").setValue((Object)new BigDecimal(String.valueOf(1)));
                curRow.getCell("rate").getStyleAttributes().setLocked(true);
                this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat("#,###.00");
                curRow.getCell("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                curRow.getCell("AmountLocalCur").setValue((Object)((BigDecimal)curRow.getCell("Amount").getValue()));
                curRow.getCell("AmountLocalCur").getStyleAttributes().setLocked(true);
                curRow.getCell("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                if (curRow.getCell("Amount").getValue() != null) {
                    this.setTotalValue((BigDecimal)curRow.getCell("Amount").getValue(), (BigDecimal)curRow.getCell("Amount").getValue());
                }
            } else {
                ExchangeRateInfo rateInfo = null;
                try {
                    rateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (CurrencyInfo)info, (CurrencyInfo)this.CURRENT_COMPANY.getBaseCurrency(), (Date)new Date());
                    int precision = rateInfo == null ? 5 : rateInfo.getPrecision();
                    StringBuffer strRatePrc = new StringBuffer();
                    strRatePrc.append("#,###.");
                    for (int j = 0; j < precision; ++j) {
                        strRatePrc.append("0");
                    }
                    this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat(strRatePrc.toString());
                }
                catch (FinBizException e) {
                    this.handUIException(e);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                if (rateInfo != null) {
                    curRow.getCell("rate").setValue((Object)rateInfo.getConvertRate());
                    curRow.getCell("rate").getStyleAttributes().setLocked(false);
                    curRow.getCell("rate").getStyleAttributes().setBackground(Color.white);
                    curRow.getCell("AmountLocalCur").getStyleAttributes().setLocked(true);
                    curRow.getCell("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                    if (curRow.getCell("Amount").getValue() != null) {
                        curRow.getCell("AmountLocalCur").setValue((Object)((BigDecimal)curRow.getCell("Amount").getValue()).multiply(rateInfo.getConvertRate()));
                        this.setTotalValue((BigDecimal)curRow.getCell("Amount").getValue(), ((BigDecimal)curRow.getCell("Amount").getValue()).multiply(rateInfo.getConvertRate()));
                    }
                }
            }
        }
    }

    protected void fillCellAfterBillSelectedCurrencyInBillEntry(DataChangeEvent eventObj) {
        CurrencyInfo currencyInfo = (CurrencyInfo)eventObj.getNewValue();
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        if (!currencyInfo.equals((Object)this.EnCurrencyInfo)) {
            for (int i = 0; i < this.kdtBillEntry.getRowCount() - 1; ++i) {
                IRow row = this.kdtBillEntry.getRow(i);
                row.getCell("currency").setValue((Object)currencyInfo);
                this.exchangeCurrency(currencyInfo, i);
            }
            this.EnCurrencyInfo = currencyInfo;
            this.combCurrency.setSelectedItem((Object)this.EnCurrencyInfo);
        }
        if (!this.combCurrency.getSelectedItem().equals(currencyInfo)) {
            currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            CompanyOrgUnitInfo company = this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            for (int i = 0; i < this.kdtBillEntry.getRowCount() - 1; ++i) {
                IRow row = this.kdtBillEntry.getRow(i);
                row.getCell("currency").setValue((Object)currencyInfo);
                this.exchangeCurrency(currencyInfo, i);
            }
        }
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        FinHelper.clearCells((KDTable)this.kdtBillEntry, (int)rowIndex, (String[])new String[]{"rate", "AmountLocalCur"});
        if (currencyInfo != null) {
            if (FinUtils.isBaseCurrency((CurrencyInfo)currencyInfo, (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
                curRow.getCell("rate").setValue((Object)new BigDecimal(String.valueOf(1)));
                curRow.getCell("rate").getStyleAttributes().setLocked(true);
                curRow.getCell("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                curRow.getCell("AmountLocalCur").setValue((Object)((BigDecimal)curRow.getCell("Amount").getValue()));
                if (curRow.getCell("Amount").getValue() != null) {
                    this.setTotalValue((BigDecimal)curRow.getCell("Amount").getValue(), (BigDecimal)curRow.getCell("Amount").getValue());
                } else {
                    this.setTotalValue(new BigDecimal(0), new BigDecimal(String.valueOf(0)));
                }
            } else {
                ExchangeRateInfo rateInfo = null;
                try {
                    rateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (CurrencyInfo)currencyInfo, (CurrencyInfo)this.CURRENT_COMPANY.getBaseCurrency(), (Date)new Date());
                }
                catch (FinBizException e) {
                    this.handUIException(e);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                if (rateInfo != null) {
                    curRow.getCell("rate").setValue((Object)rateInfo.getConvertRate());
                    curRow.getCell("rate").getStyleAttributes().setLocked(false);
                    curRow.getCell("rate").getStyleAttributes().setBackground(Color.white);
                    if (curRow.getCell("Amount").getValue() != null) {
                        curRow.getCell("AmountLocalCur").setValue((Object)((BigDecimal)curRow.getCell("Amount").getValue()).multiply(rateInfo.getConvertRate()));
                        this.setTotalValue((BigDecimal)curRow.getCell("Amount").getValue(), ((BigDecimal)curRow.getCell("Amount").getValue()).multiply(rateInfo.getConvertRate()));
                    }
                }
            }
        }
    }

    protected void initEntrysTable() {
        KDTextField txtEnnumber = new KDTextField();
        txtEnnumber.setRequired(true);
        this.kdtBillEntry.getColumn("number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtEnnumber));
        KDFormattedTextField txtEnAmount = new KDFormattedTextField();
        txtEnAmount.setDataType(1);
        this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        txtEnAmount.setRequired(true);
        txtEnAmount.setNegatived(false);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)txtEnAmount);
        txtEnAmount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BillRediscountInEditUI.this.fillCellAfterBillSelectedAmountInBillEntry(eventObj);
            }
        });
        this.kdtBillEntry.getColumn("Amount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtEnAmount));
        KDFormattedTextField txtEnRate = new KDFormattedTextField();
        txtEnRate.setDataType(1);
        this.kdtBillEntry.getColumn("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        txtEnRate.setRequired(true);
        txtEnRate.setNegatived(false);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)txtEnRate);
        txtEnRate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BillRediscountInEditUI.this.fillCellAfterBillSelectedRateInBillEntry(eventObj);
            }
        });
        this.kdtBillEntry.getColumn("rate").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtEnRate));
        KDFormattedTextField txtEnAmountLocalCur = new KDFormattedTextField();
        txtEnAmountLocalCur.setDataType(1);
        txtEnAmountLocalCur.setPrecision(2);
        this.kdtBillEntry.getColumn("AmountLocalCur").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        txtEnAmountLocalCur.setRequired(true);
        txtEnAmountLocalCur.setNegatived(false);
        txtEnAmountLocalCur.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BillRediscountInEditUI.this.fillCellAfterBillSelectedAmountLocalCurEntry(eventObj);
            }
        });
        this.kdtBillEntry.getColumn("AmountLocalCur").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtEnAmountLocalCur));
        KDBizPromptBox prmtEnCurrency = new KDBizPromptBox();
        ExtendParser parserCurrency = new ExtendParser(prmtEnCurrency);
        prmtEnCurrency.setCommitParser((IParser)parserCurrency);
        prmtEnCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        prmtEnCurrency.setVisible(true);
        prmtEnCurrency.setRequired(true);
        prmtEnCurrency.setEditable(true);
        prmtEnCurrency.setDisplayFormat("$name$");
        prmtEnCurrency.setEditFormat("$number$");
        prmtEnCurrency.setCommitFormat("$number$");
        prmtEnCurrency.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prmtEnCurrency));
        ObjectValueRender avrCurrency = new ObjectValueRender();
        avrCurrency.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtBillEntry.getColumn("currency").setRenderer((IBasicRender)avrCurrency);
        prmtEnCurrency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BillRediscountInEditUI.this.fillCellAfterBillSelectedCurrencyInBillEntry(eventObj);
            }
        });
        this.kdtBillEntry.getColumn("currency").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtEnCurrency));
        KDDatePicker pkEnDate = new KDDatePicker();
        pkEnDate.setRequired(true);
        this.kdtBillEntry.getColumn("endDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkEnDate));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int rowCount;
        IRow row;
        int i;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtRediscountIn);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtRediscountOut);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.combCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLocalCurExRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmountLocalCur);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtYearDiscountRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkEndDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtDiscountAccrual);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        Date bizDate = (Date)this.pkBizDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (bizDate != null && endDate != null && bizDate.after(endDate) || bizDate.equals(endDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEndDateMustAfterStart"));
            this.pkEndDate.setValue((Object)bizDate);
            this.pkEndDate.requestFocus();
            SysUtil.abort();
        }
        if (endDate != null) {
            int roCount = this.kdtBillEntry.getRowCount();
            for (i = 0; i < roCount - 1; ++i) {
                row = this.kdtBillEntry.getRow(i);
                Date enDate = (Date)row.getCell("endDate").getValue();
                if (enDate != null && !enDate.after(endDate)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryEndDataMustAfterStart"));
                    SysUtil.abort();
                }
                if (bizDate == null || enDate == null || enDate.after(bizDate)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryEndDateMustAfterBizDate"));
                SysUtil.abort();
            }
        }
        if ((rowCount = this.kdtBillEntry.getRowCount()) == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"EntryIsNull"));
            SysUtil.abort();
        }
        for (i = 0; i < rowCount - 1; ++i) {
            row = this.kdtBillEntry.getRow(i);
            if (row.getCell("number").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryNumberIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("currency").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryCurrencyIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("Amount").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryAmountIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("Amount").getValue() != null && ((BigDecimal)row.getCell("Amount").getValue()).compareTo(new BigDecimal(0)) == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryMustMoreZero"));
                SysUtil.abort();
            }
            if (row.getCell("endDate").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryEndDateIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("rate").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryRateIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("AmountLocalCur").getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryAmountLocalCurIsNull"));
            SysUtil.abort();
        }
        for (i = 0; i < rowCount - 1; ++i) {
            row = this.kdtBillEntry.getRow(i);
            if (row.getCell("number").getValue() == null) continue;
            int rowi = i + 1;
            for (int j = 0; j < rowCount - 1 - i - 1; ++j) {
                IRow row2 = this.kdtBillEntry.getRow(rowi);
                row2.getCell("number").getValue();
                if (row.getCell("number").getValue().equals(row2.getCell("number").getValue())) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryNumberIsSame"));
                    SysUtil.abort();
                }
                ++rowi;
            }
        }
        IBillRediscountIn billIn = BillRediscountInFactory.getRemoteInstance();
        if (RediscountModeEnum.Monopoly.equals((Object)this.editData.getRediscountMode())) {
            String strId = null;
            for (int i2 = 0; i2 < rowCount - 1; ++i2) {
                boolean isExists;
                IRow row2 = this.kdtBillEntry.getRow(i2);
                if (row2.getCell("number").getValue() == null) continue;
                String strNumber = row2.getCell("number").getValue().toString();
                if (this.editData.getId() != null) {
                    strId = this.editData.getId().toString();
                }
                if (!(isExists = billIn.getEnNumber(strNumber, strId))) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"4_BillRediscountInEditUI");
                msg = MessageFormat.format(msg, strNumber);
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
        }
        this.isCreateBill();
    }

    @Override
    public void loadFields() {
        FinUtils.noActionOnSetDefault((KDComboBox)this.combCurrency, (Object)this.editData.getCurrency());
        if (this.editData.getCurrency() == this.baseCurrency) {
            this.editData.setLocalCurExRate(new BigDecimal("1"));
        }
        if (FinUtils.isBaseCurrency((CurrencyInfo)this.editData.getCurrency(), (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
            this.txtLocalCurExRate.setEditable(false);
        } else {
            this.txtLocalCurExRate.setEditable(true);
        }
        if (this.editData.getCompany() == null) {
            this.editData.setCompany(this.CURRENT_COMPANY);
        }
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString(), (FmRpcCacheInfo)this.rpcCacheInfo);
        this.txtYearDiscountRate.setRemoveingZeroInDispaly(false);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtAmount.setValue(null);
            this.txtAmountLocalCur.setValue(null);
        }
        this.txtAmount.setPrecision(2);
        this.txtDiscountAccrual.setPrecision(2);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            int rowCount = this.kdtBillEntry.getRowCount();
            if (FinUtils.isBaseCurrency((CurrencyInfo)this.editData.getCurrency(), (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
                this.kdtBillEntry.getColumn("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                this.kdtBillEntry.getColumn("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            } else {
                this.kdtBillEntry.getColumn("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            }
            IRow row = this.kdtBillEntry.getRow(rowCount - 1);
            row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            row.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }

    protected SelectorItemCollection getBillRediscSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("localCurExRate"));
        sic.add(new SelectorItemInfo("amountLocalCur"));
        return sic;
    }

    private void loadEntrysBill() {
        this.kdtBillEntry.removeRows(false);
        BigDecimal total = new BigDecimal(String.valueOf(0));
        Iterator iter = this.editData.getEntry().iterator();
        while (iter.hasNext()) {
            BillRediscountInEntryInfo billRediscountInfo = (BillRediscountInEntryInfo)iter.next();
            try {
                billRediscountInfo = BillRediscountInEntryFactory.getRemoteInstance().getBillRediscountInEntryInfo((IObjectPK)new ObjectUuidPK(billRediscountInfo.getId()), this.getBillRediscSelector());
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            IRow row = this.kdtBillEntry.addRow();
            row.getCell("number").setValue((Object)billRediscountInfo.getNumber());
            row.getCell("currency").setValue((Object)billRediscountInfo.getCurrency());
            row.getCell("Amount").setValue((Object)billRediscountInfo.getAmount());
            row.getCell("endDate").setValue((Object)billRediscountInfo.getDate());
            row.getCell("rate").setValue((Object)billRediscountInfo.getRate());
            row.getCell("AmountLocalCur").setValue((Object)billRediscountInfo.getAmountLocalCur());
            total = total.add(billRediscountInfo.getAmountLocalCur());
            if (!row.getCell("number").getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean"))) continue;
            row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            row.getStyleAttributes().setLocked(true);
        }
    }

    protected IObjectValue createNewData() {
        BillRediscountInInfo info = new BillRediscountInInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setBizDate(DateUtil.getDayBegin());
        info.setCurrency(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
        info.setEndDate(DateUtil.getDayBegin());
        info.setRediscountType((RediscountTypeEnum)((Object)this.comboRediscountType.getItemAt(0)));
        info.setRediscountMode((RediscountModeEnum)((Object)this.comboRediscountMode.getItemAt(0)));
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        info.setRediscountIn(companyInfo);
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BillRediscountInEntryInfo info = new BillRediscountInEntryInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BillRediscountInFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        FSClientHelper.checkClearingHouseCompany();
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.getUIContext().get("company") != null) {
            this.CURRENT_COMPANY = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
        this.kdtBillEntry.checkParsed();
        this.initEntrysTable();
        super.onLoad();
        this.isOnLoadFinished = true;
        this.btnAuditResult.setVisible(false);
        this.initF7Filter();
        this.btnAddInBill.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveInBill.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
            BillRediscountInInfo info = BillRediscountInFactory.getRemoteInstance().getBillRediscountInInfo((IObjectPK)pk);
            if (info.isIsReceivableBill()) {
                this.kdtBillEntry.getStyleAttributes().setLocked(true);
                this.btnAddInBill.setEnabled(false);
                this.btnRemoveInBill.setEnabled(false);
                this.comboRediscountMode.setEnabled(false);
            }
            int p = ((CurrencyInfo)this.combCurrency.getSelectedItem()).getPrecision();
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            CurrencyInfo baseCurrency = this.CURRENT_COMPANY.getBaseCurrency();
            if (currencyInfo != null) {
                StringBuffer strFormat = new StringBuffer();
                strFormat.append("#,###.");
                for (int i = 0; i < currencyInfo.getPrecision(); ++i) {
                    strFormat.append("0");
                }
                this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setNumberFormat(strFormat.toString());
                ExchangeRateInfo rateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (CurrencyInfo)currencyInfo, (CurrencyInfo)this.CURRENT_COMPANY.getBaseCurrency(), (Date)new Date());
                if (rateInfo != null) {
                    StringBuffer strRatePrc = new StringBuffer();
                    strRatePrc.append("#,###.");
                    for (int j = 0; j < rateInfo.getPrecision(); ++j) {
                        strRatePrc.append("0");
                    }
                    this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat(strRatePrc.toString());
                } else {
                    this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat("#,###.00");
                }
            }
            if (baseCurrency == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("baseCurrency.*"));
                sic.add(new SelectorItemInfo("baseCurrency.id"));
                sic.add(new SelectorItemInfo("baseCurrency.number"));
                sic.add(new SelectorItemInfo("baseCurrency.name"));
                this.CURRENT_COMPANY = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.CURRENT_COMPANY.getId()), sic);
                baseCurrency = this.CURRENT_COMPANY.getBaseCurrency();
            }
            ExchangeRateInfo exchangeRateInfo = FMHelper.getExRateInfo((CurrencyInfo)currencyInfo, (CurrencyInfo)baseCurrency, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (Date)info.getBizDate());
            if (currencyInfo != null && baseCurrency != null && !currencyInfo.getId().equals((Object)baseCurrency.getId())) {
                this.txtLocalCurExRate.setPrecision(exchangeRateInfo.getPrecision());
                this.txtAmountLocalCur.setPrecision(baseCurrency.getPrecision());
            } else {
                this.txtLocalCurExRate.setPrecision(2);
            }
            this.txtAmount.setPrecision(p);
            this.txtDiscountAccrual.setPrecision(p);
            this.txtYearDiscountRate.setPrecision(4);
        } else {
            this.txtLocalCurExRate.setPrecision(2);
            this.txtAmount.setPrecision(2);
            this.txtDiscountAccrual.setPrecision(2);
            this.txtYearDiscountRate.setPrecision(4);
        }
        this.txtAmountLocalCur.setPrecision(2);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLocalCurExRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmountLocalCur);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtDiscountAccrual);
        this.txtAmount.setNegatived(false);
        this.txtLocalCurExRate.setNegatived(false);
        this.txtAmountLocalCur.setNegatived(false);
        this.txtDiscountAccrual.setNegatived(false);
        this.txtYearDiscountRate.setNegatived(false);
        this.txtYearDiscountRate.setRemoveingZeroInDispaly(false);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmountLocalCur.setHorizontalAlignment(4);
        this.txtDiscountAccrual.setHorizontalAlignment(4);
        this.txtYearDiscountRate.setHorizontalAlignment(4);
        this.txtLocalCurExRate.setHorizontalAlignment(4);
        this.prmtRediscountOut.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        EntityViewInfo viOut = new EntityViewInfo();
        FilterInfo filterOut = new FilterInfo();
        filterOut.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        viOut.setFilter(filterOut);
        this.prmtRediscountOut.setEntityViewInfo(viOut);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        this.prmtRediscountInBank.setSelectorCollection(sic);
        this.prmtRediscountInBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.CURRENT_COMPANY != null && this.CURRENT_COMPANY.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.CURRENT_COMPANY.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        vi.setFilter(filter);
        this.prmtRediscountInBank.setEntityViewInfo(vi);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.EnCurrencyInfo = FinHelper.getBaseCurrencyName((CompanyOrgUnitInfo)this.CURRENT_COMPANY);
            IRow row = this.kdtBillEntry.addRow();
            row.getCell("currency").setValue((Object)FinHelper.getBaseCurrencyName((CompanyOrgUnitInfo)this.CURRENT_COMPANY));
            row.getCell("rate").setValue((Object)new BigDecimal(String.valueOf(1)));
            row.getCell("rate").getStyleAttributes().setLocked(true);
            row.getCell("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            row.getCell("AmountLocalCur").getStyleAttributes().setLocked(true);
            row.getCell("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            IRow rowTotal = this.kdtBillEntry.addRow();
            rowTotal.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean"));
            rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            rowTotal.getStyleAttributes().setLocked(true);
        }
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtRediscountOut, null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void btnAddInBill_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddInBill_actionPerformed(e);
        int rowCount = this.kdtBillEntry.getRowCount();
        if (rowCount == 0) {
            this.EnCurrencyInfo = FinHelper.getBaseCurrencyName((CompanyOrgUnitInfo)this.CURRENT_COMPANY);
            IRow row = this.kdtBillEntry.addRow();
            row.getCell("currency").setValue((Object)FinHelper.getBaseCurrencyName((CompanyOrgUnitInfo)this.CURRENT_COMPANY));
            row.getCell("rate").setValue((Object)new BigDecimal(String.valueOf(1)));
            row.getCell("rate").getStyleAttributes().setLocked(true);
            row.getCell("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            row.getCell("AmountLocalCur").getStyleAttributes().setLocked(true);
            row.getCell("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            IRow rowTotal = this.kdtBillEntry.addRow();
            rowTotal.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean"));
            rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            rowTotal.getStyleAttributes().setLocked(true);
            this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setNumberFormat("#,###.00");
            this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat("#,###.00");
        } else {
            IRow row = this.kdtBillEntry.addRow(rowCount - 1);
            row.getCell("currency").setValue((Object)this.EnCurrencyInfo);
            this.exchangeCurrency(this.EnCurrencyInfo, rowCount - 1);
        }
    }

    @Override
    protected void btnRemoveInBill_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveInBill_actionPerformed(e);
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        if (this.kdtBillEntry.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int rowCo = this.kdtBillEntry.getRowCount();
        if (rowIndex == rowCo - 1) {
            return;
        }
        if (rowCo == 2) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"EntryIsNull"));
            SysUtil.abort();
        }
        KDTSelectBlock selectBlock = null;
        selectBlock = this.kdtBillEntry.getSelectManager().get(0);
        int bottom = selectBlock.getEndRow();
        if (rowCo - 1 == bottom) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryEndRowIsNotDel"));
            SysUtil.abort();
        }
        this.removeLine(this.kdtBillEntry);
        this.calcTotalRowInFinFee();
        int rowCount = this.kdtBillEntry.getRowCount();
        if (rowCount == 1) {
            this.kdtBillEntry.removeRows(false);
        }
    }

    protected void calcTotalRowInFinFee() {
        int rowCount = this.kdtBillEntry.getRowCount();
        BigDecimal total = new BigDecimal(String.valueOf(0));
        BigDecimal totalAmount = new BigDecimal(String.valueOf(0));
        for (int i = 0; i < rowCount - 1; ++i) {
            IRow row = this.kdtBillEntry.getRow(i);
            BigDecimal tmpAmount = (BigDecimal)row.getCell("Amount").getValue();
            BigDecimal tmp = (BigDecimal)row.getCell("AmountLocalCur").getValue();
            if (tmp != null) {
                total = total.add(tmp);
            }
            if (tmpAmount == null) continue;
            totalAmount = totalAmount.add(tmpAmount);
        }
        IRow rowTotal = this.kdtBillEntry.getRow(rowCount - 1);
        rowTotal.getCell("AmountLocalCur").setValue((Object)total);
        rowTotal.getCell("Amount").setValue((Object)totalAmount);
        DateUtil dateh = new DateUtil();
        int days = 0;
        BigDecimal yearDiscRate = this.txtYearDiscountRate.getBigDecimalValue();
        Date bizDate = (Date)this.pkBizDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (totalAmount != null && yearDiscRate != null && !bizDate.after(endDate)) {
            days = DateUtil.getDiffDays((Date)bizDate, (Date)endDate) - 1;
            BigDecimal discountAccrual = totalAmount.multiply(yearDiscRate).multiply(new BigDecimal(days));
            discountAccrual = discountAccrual.divide(new BigDecimal(36000), 2);
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            this.txtDiscountAccrual.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, discountAccrual));
        }
        int count = this.kdtBillEntry.getRowCount();
        BigDecimal disAccrual = this.txtDiscountAccrual.getBigDecimalValue();
        if (count > 0 && disAccrual != null && totalAmount != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            this.txtAmount.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, totalAmount.subtract(disAccrual)));
        }
    }

    protected void setTotalValue(BigDecimal AmountValue, BigDecimal AmountLocalCurValue) {
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        BigDecimal totalAmountLocalCur = new BigDecimal(String.valueOf(0));
        BigDecimal totalAmount = new BigDecimal(String.valueOf(0));
        totalAmount = totalAmount.add(AmountValue);
        totalAmountLocalCur = totalAmountLocalCur.add(AmountLocalCurValue);
        for (int i = 0; i < this.kdtBillEntry.getRowCount(); ++i) {
            if (i == rowIndex || i == this.kdtBillEntry.getRowCount() - 1) continue;
            IRow row = this.kdtBillEntry.getRow(i);
            BigDecimal tmpAmount = (BigDecimal)row.getCell("Amount").getValue();
            BigDecimal tmpAmountLocalCur = (BigDecimal)row.getCell("AmountLocalCur").getValue();
            if (tmpAmount != null) {
                totalAmount = totalAmount.add(tmpAmount);
            }
            if (tmpAmountLocalCur == null) continue;
            totalAmountLocalCur = totalAmountLocalCur.add(tmpAmountLocalCur);
        }
        IRow rowTotal = this.kdtBillEntry.getRow(this.kdtBillEntry.getRowCount() - 1);
        rowTotal.getCell("Amount").setValue((Object)totalAmount);
        rowTotal.getCell("AmountLocalCur").setValue((Object)totalAmountLocalCur);
        DateUtil dateh = new DateUtil();
        int days = 0;
        BigDecimal yearDiscRate = this.txtYearDiscountRate.getBigDecimalValue();
        Date bizDate = (Date)this.pkBizDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (totalAmount != null && yearDiscRate != null && !bizDate.after(endDate)) {
            days = DateUtil.getDiffDays((Date)bizDate, (Date)endDate) - 1;
            BigDecimal discountAccrual = totalAmount.multiply(yearDiscRate).multiply(new BigDecimal(days));
            discountAccrual = discountAccrual.divide(new BigDecimal(36000), 2);
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            this.txtDiscountAccrual.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, discountAccrual));
        }
        int count = this.kdtBillEntry.getRowCount();
        BigDecimal disAccrual = this.txtDiscountAccrual.getBigDecimalValue();
        if (count > 0 && disAccrual != null && totalAmount != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            this.txtAmount.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, totalAmount.subtract(disAccrual)));
        }
    }

    private BigDecimal getLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtLocalCurExRate.getBigDecimalValue();
        if (bdAmount != null && bdLocalExRate != null) {
            return bdAmount.multiply(bdLocalExRate);
        }
        return Constants.ZERO;
    }

    @Override
    protected void combCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.combCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        if (this.combCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.combCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtDiscountAccrual.setPrecision(currency.getPrecision());
            CompanyOrgUnitInfo company = this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                BillRediscountInInfo info = (BillRediscountInInfo)this.getDataObject();
                if (info != null) {
                    CurrencyInfo baseCurrency = company.getBaseCurrency();
                    if (baseCurrency == null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("baseCurrency.*"));
                        sic.add(new SelectorItemInfo("baseCurrency.id"));
                        sic.add(new SelectorItemInfo("baseCurrency.number"));
                        sic.add(new SelectorItemInfo("baseCurrency.name"));
                        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sic);
                        baseCurrency = company.getBaseCurrency();
                    }
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)company, (CurrencyInfo)currency, (CurrencyInfo)baseCurrency, (Date)info.getBizDate(), null);
                }
            }
            catch (EASBizException e1) {
                FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)this.CURRENT_COMPANY.getBaseCurrency());
                throw e1;
            }
            if (currency.getId().equals((Object)this.baseCurrency.getId())) {
                this.txtLocalCurExRate.setPrecision(2);
            }
            BigDecimal amountLocal = this.getLocalAmount();
            this.txtAmountLocalCur.setValue((Object)amountLocal.setScale(2, 4));
            if (FinUtils.isBaseCurrency((CurrencyInfo)currency, (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
                this.txtLocalCurExRate.setEnabled(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
            }
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.txtAmount_dataChanged(e);
        BigDecimal bAmount = (BigDecimal)e.getNewValue();
        if (bAmount != null && this.txtLocalCurExRate.getNumberValue() != null) {
            BigDecimal exRate = (BigDecimal)this.txtLocalCurExRate.getNumberValue();
            BigDecimal amountLocal = bAmount.multiply(exRate);
            amountLocal = amountLocal.setScale(2, 4);
            this.txtAmountLocalCur.setValue((Object)amountLocal);
        }
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.pkBizDate_dataChanged(e);
        DateUtil dateh = new DateUtil();
        int days = 0;
        int count = this.kdtBillEntry.getRowCount();
        if (count > 0) {
            IRow row = this.kdtBillEntry.getRow(count - 1);
            BigDecimal yearDiscRate = this.txtYearDiscountRate.getBigDecimalValue();
            BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
            Date bizDate = (Date)this.pkBizDate.getValue();
            Date endDate = (Date)this.pkEndDate.getValue();
            if (totalAmount != null && yearDiscRate != null && !bizDate.after(endDate)) {
                days = DateUtil.getDiffDays((Date)bizDate, (Date)endDate) - 1;
                BigDecimal discountAccrual = totalAmount.multiply(yearDiscRate).multiply(new BigDecimal(days));
                discountAccrual = discountAccrual.divide(new BigDecimal(36000), 2);
                CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
                this.txtDiscountAccrual.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, discountAccrual));
            }
        }
    }

    @Override
    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.pkEndDate_dataChanged(e);
        DateUtil dateh = new DateUtil();
        int days = 0;
        int count = this.kdtBillEntry.getRowCount();
        if (count > 0) {
            IRow row = this.kdtBillEntry.getRow(count - 1);
            BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
            BigDecimal yearDiscRate = this.txtYearDiscountRate.getBigDecimalValue();
            Date bizDate = (Date)this.pkBizDate.getValue();
            Date endDate = (Date)this.pkEndDate.getValue();
            if (totalAmount != null && yearDiscRate != null && !bizDate.after(endDate)) {
                days = DateUtil.getDiffDays((Date)bizDate, (Date)endDate) - 1;
                BigDecimal discountAccrual = totalAmount.multiply(yearDiscRate).multiply(new BigDecimal(days));
                discountAccrual = discountAccrual.divide(new BigDecimal(36000), 2);
                CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
                this.txtDiscountAccrual.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, discountAccrual));
            }
        }
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLocalCurExRate_dataChanged(e);
        BigDecimal exRate = (BigDecimal)e.getNewValue();
        if (exRate != null && this.txtAmount.getBigDecimalValue() != null) {
            BigDecimal bAmount = this.txtAmount.getBigDecimalValue();
            bAmount = bAmount.multiply(exRate);
            this.txtAmountLocalCur.setValue((Object)bAmount.setScale(2, 4));
        }
    }

    @Override
    protected void txtYearDiscountRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtYearDiscountRate_dataChanged(e);
        BigDecimal yearRate = (BigDecimal)e.getNewValue();
        if (yearRate == null) {
            return;
        }
        if (yearRate.compareTo(new BigDecimal(100)) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"YearRateArea"));
            this.txtYearDiscountRate.setValue((Object)Constants.ZERO);
            this.txtYearDiscountRate.requestFocus();
            SysUtil.abort();
        }
        DateUtil dateh = new DateUtil();
        int days = 0;
        int count = this.kdtBillEntry.getRowCount();
        if (count > 0) {
            IRow row = this.kdtBillEntry.getRow(count - 1);
            BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
            BigDecimal yearDiscRate = this.txtYearDiscountRate.getBigDecimalValue();
            Date bizDate = (Date)this.pkBizDate.getValue();
            Date endDate = (Date)this.pkEndDate.getValue();
            if (totalAmount != null && yearDiscRate != null && !bizDate.after(endDate)) {
                days = DateUtil.getDiffDays((Date)bizDate, (Date)endDate) - 1;
                BigDecimal discountAccrual = totalAmount.multiply(yearDiscRate).multiply(new BigDecimal(days));
                discountAccrual = discountAccrual.divide(new BigDecimal(36000), 2);
                CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
                this.txtDiscountAccrual.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, discountAccrual));
            }
        }
    }

    @Override
    protected void txtDiscountAccrual_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.txtDiscountAccrual_dataChanged(e);
        int count = this.kdtBillEntry.getRowCount();
        BigDecimal disAccrual = (BigDecimal)e.getNewValue();
        if (count > 0) {
            IRow row = this.kdtBillEntry.getRow(count - 1);
            BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
            if (disAccrual != null && totalAmount != null) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
                this.txtAmount.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, totalAmount.subtract(disAccrual)));
            }
        }
    }

    @Override
    public void actionTDPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPreview_actionPerformed(e);
        if (this.editData.getId() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"TDPrintforEdit"));
            SysUtil.abort();
        }
        List idList = this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryName());
        appHlp.printPreview("/FM/IBT/BILLREDISCOUNTIN", (Object)data, (Component)((Object)this));
    }

    private IMetaDataPK getTDQueryName() {
        return new MetaDataPK("com.kingdee.eas.fm.ibt.app.BillRediscountInTDQuery");
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        if (this.editData.getId() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"TDPrintforEdit"));
            SysUtil.abort();
        }
        List idList = this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryName());
        appHlp.print("/FM/IBT/BILLREDISCOUNTIN", (Object)data, (Component)((Object)this));
    }

    protected void isCreateBill() throws BOSException, EASBizException {
        int re = 0;
        if (RediscountModeEnum.Monopoly.equals(this.comboRediscountMode.getSelectedItem())) {
            if (this.editData.getId() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
                BillRediscountInInfo Billinfo = BillRediscountInFactory.getRemoteInstance().getBillRediscountInInfo((IObjectPK)pk);
                if (Billinfo.isIsReceivableBill()) {
                    return;
                }
            }
            if ((re = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"6_BillRediscountInEditUI"))) == 0) {
                int rowCo = this.kdtBillEntry.getRowCount();
                for (int i = 0; i < rowCo - 1; ++i) {
                    IRow row = this.kdtBillEntry.getRow(i);
                    String number = row.getCell("number").getValue().toString();
                    CurrencyInfo currency = (CurrencyInfo)row.getCell("currency").getValue();
                    if (currency.getId() == null) continue;
                    String currencyId = currency.getId().toString();
                    BigDecimal amount = (BigDecimal)row.getCell("Amount").getValue();
                    Date endDate = (Date)row.getCell("endDate").getValue();
                    if (endDate != null) {
                        endDate = DateTimeUtils.truncateDate((Date)endDate);
                    }
                    BigDecimal rate = (BigDecimal)row.getCell("rate").getValue();
                    BigDecimal amountLocalCur = (BigDecimal)row.getCell("AmountLocalCur").getValue();
                    IReceivableBill receivableBill = ReceivableBillFactory.getRemoteInstance();
                    ReceivableBillInfo info = new ReceivableBillInfo();
                    info.setDraftNumber(number);
                    info.setCompany(this.CURRENT_COMPANY);
                    info.setBillState(BillStateEnum.TempSaved);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("group", (Object)new Integer(NTTypeGroupEnum.RECEIVABLE_BankAccept.getValue()), CompareType.EQUALS));
                    view.setFilter(filter);
                    ObjectUuidPK pkNT = new ObjectUuidPK("33333333-3333-3333-3333-3333333333331C9A9013");
                    NTTypeInfo infoNt = NTTypeFactory.getRemoteInstance().getNTTypeInfo((IObjectPK)pkNT);
                    info.setNtType(infoNt);
                    info.setIsFormRediscount(true);
                    info.setTakeDate(DateUtil.getDayBegin());
                    info.setExpiredDate(endDate);
                    info.setCurrency(currency);
                    info.setBillAmt(amount);
                    info.setExchangeRate(rate);
                    info.setNaturalAmt(amountLocalCur);
                    receivableBill.addnew((CoreBaseInfo)info);
                }
                this.editData.setIsReceivableBill(true);
            }
        }
    }
}

