/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditUsageFactory;
import com.kingdee.eas.fm.fin.CreditUsageInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.client.ChooseFinancingProductUI;
import com.kingdee.eas.fm.fin.client.LoanModel;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.BillRediscountOutEntryFactory;
import com.kingdee.eas.fm.ibt.BillRediscountOutEntryInfo;
import com.kingdee.eas.fm.ibt.BillRediscountOutFactory;
import com.kingdee.eas.fm.ibt.BillRediscountOutInfo;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.IBillRediscountOut;
import com.kingdee.eas.fm.ibt.IbtHelper;
import com.kingdee.eas.fm.ibt.RediscountModeEnum;
import com.kingdee.eas.fm.ibt.RediscountTypeEnum;
import com.kingdee.eas.fm.ibt.client.AbstractBillRediscountOutEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BillRediscountOutEditUI
extends AbstractBillRediscountOutEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BillRediscountOutEditUI.class);
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    private CurrencyInfo EnCurrencyInfo = null;
    private boolean isOnLoadFinished = false;
    private boolean isLoadFieldsing = false;
    private boolean isDataLoadFinished = false;
    private boolean isFirstEdit = true;
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";
    private CreditFinancingReduceCollection col;
    boolean Mutex_CreditLocalAmt_CreditCurExRate = false;
    private final String fileName = "/FM/IBT/BILLREDISCOUNTOUT";

    public BillRediscountOutEditUI() throws Exception {
        FinUtils.initCurrencyComboBox((KDComboBox)this.combCurrency);
        int p = ((CurrencyInfo)this.combCurrency.getSelectedItem()).getPrecision();
        this.txtCreditCurExRate.setPrecision(p);
        this.txtCreditLocalAmt.setPrecision(p);
        this.txtRemainAmount.setPrecision(p);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.chkIsInCredit.isSelected()) {
            this.editData.setReduceCol(this.col);
        } else {
            this.editData.setReduceCol(null);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.isDataLoadFinished = false;
        int rowCount = this.kdtBillEntry.getRowCount();
        IRow row = this.kdtBillEntry.getRow(rowCount - 1);
        BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
        if (!BillTypeEnum.Audit.equals((Object)this.editData.getBillType())) {
            this.editData.setBillType(BillTypeEnum.Submit);
        }
        if (RediscountModeEnum.Monopoly.equals(this.comboRediscountMode.getSelectedItem())) {
            this.editData.setBalance(new BigDecimal(0));
        } else {
            this.editData.setBalance(totalAmount);
        }
        if (this.pkBizDate.getValue() != null) {
            this.editData.setIssueDate((Date)this.pkBizDate.getValue());
        }
        if (this.pkEndDate.getValue() != null) {
            this.editData.setExpiredDate((Date)this.pkEndDate.getValue());
        }
        this.editData.setAssExRate(totalAmount);
        this.editData.setInstitution((BankInfo)this.prmtRediscountIn.getValue());
        super.actionSubmit_actionPerformed(e);
        this.txtYearDiscountRate.setRemoveingZeroInDispaly(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnAddInBill.setEnabled(true);
        this.btnRemoveInBill.setEnabled(true);
        this.kdtBillEntry.getStyleAttributes().setLocked(false);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        IBTPBillEdit billEdit = this.getBillEdit();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TargetBillType", "ReceivableBill");
        billEdit.createFrom(null, map);
    }

    protected void fillCellAfterBillSelectedAmountInBillEntry(DataChangeEvent eventObj) {
        BigDecimal amountInFinFee = (BigDecimal)eventObj.getNewValue();
        if (amountInFinFee == null) {
            return;
        }
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        BigDecimal exchangeRateInFinFee = new BigDecimal(String.valueOf(0));
        if (curRow.getCell("rate").getValue() != null) {
            exchangeRateInFinFee = (BigDecimal)curRow.getCell("rate").getValue();
        }
        curRow.getCell("AmountLocalCur").setValue((Object)amountInFinFee.multiply(exchangeRateInFinFee));
        this.setTotalValue(amountInFinFee, amountInFinFee.multiply(exchangeRateInFinFee));
    }

    private void fillCellAfterBillSelectedRateInBillEntry(DataChangeEvent eventObj) {
        BigDecimal rateInFinFee = (BigDecimal)eventObj.getNewValue();
        if (rateInFinFee == null) {
            return;
        }
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        if (curRow.getCell("Amount").getValue() != null) {
            BigDecimal amountInFinFee = (BigDecimal)curRow.getCell("Amount").getValue();
            curRow.getCell("AmountLocalCur").setValue((Object)rateInFinFee.multiply(amountInFinFee));
            this.setTotalValue(amountInFinFee, rateInFinFee.multiply(amountInFinFee));
        }
    }

    private void fillCellAfterBillSelectedAmountLocalCurEntry(DataChangeEvent eventObj) {
        BigDecimal amountLocalCur = (BigDecimal)eventObj.getNewValue();
        if (amountLocalCur == null) {
            return;
        }
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        BigDecimal amountInBillEn = new BigDecimal(String.valueOf(0));
        if (curRow.getCell("Amount").getValue() != null) {
            amountInBillEn = (BigDecimal)curRow.getCell("Amount").getValue();
        }
        this.setTotalValue(amountInBillEn, amountLocalCur);
    }

    private void exchangeCurrency(CurrencyInfo info, int rowIndex) {
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        FinHelper.clearCells((KDTable)this.kdtBillEntry, (int)rowIndex, (String[])new String[]{"rate", "AmountLocalCur"});
        if (info != null) {
            StringBuffer strFormat = new StringBuffer();
            strFormat.append("#,###.");
            for (int i = 0; i < info.getPrecision(); ++i) {
                strFormat.append("0");
            }
            this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setNumberFormat(strFormat.toString());
            if (FinUtils.isBaseCurrency((CurrencyInfo)info, (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
                curRow.getCell("rate").setValue((Object)new BigDecimal(String.valueOf(1)));
                curRow.getCell("rate").getStyleAttributes().setLocked(true);
                this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat("#,###.00");
                curRow.getCell("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                curRow.getCell("AmountLocalCur").setValue((Object)((BigDecimal)curRow.getCell("Amount").getValue()));
                curRow.getCell("AmountLocalCur").getStyleAttributes().setLocked(true);
                curRow.getCell("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                if (curRow.getCell("Amount").getValue() != null) {
                    this.setTotalValue((BigDecimal)curRow.getCell("Amount").getValue(), (BigDecimal)curRow.getCell("Amount").getValue());
                }
            } else {
                ExchangeRateInfo rateInfo = null;
                try {
                    rateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (CurrencyInfo)info, (CurrencyInfo)this.CURRENT_COMPANY.getBaseCurrency(), (Date)new Date());
                    int precision = rateInfo == null ? 5 : rateInfo.getPrecision();
                    StringBuffer strRatePrc = new StringBuffer();
                    strRatePrc.append("#,###.");
                    for (int j = 0; j < precision; ++j) {
                        strRatePrc.append("0");
                    }
                    this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat(strRatePrc.toString());
                }
                catch (FinBizException e) {
                    this.handUIException(e);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                if (rateInfo != null) {
                    curRow.getCell("rate").setValue((Object)rateInfo.getConvertRate());
                    curRow.getCell("rate").getStyleAttributes().setLocked(false);
                    curRow.getCell("rate").getStyleAttributes().setBackground(Color.white);
                    curRow.getCell("AmountLocalCur").getStyleAttributes().setLocked(true);
                    curRow.getCell("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                    if (curRow.getCell("Amount").getValue() != null) {
                        curRow.getCell("AmountLocalCur").setValue((Object)((BigDecimal)curRow.getCell("Amount").getValue()).multiply(rateInfo.getConvertRate()));
                        this.setTotalValue((BigDecimal)curRow.getCell("Amount").getValue(), ((BigDecimal)curRow.getCell("Amount").getValue()).multiply(rateInfo.getConvertRate()));
                    }
                }
            }
        }
    }

    protected void fillCellAfterBillSelectedCurrencyInBillEntry(DataChangeEvent eventObj) {
        CurrencyInfo currencyInfo = (CurrencyInfo)eventObj.getNewValue();
        if (currencyInfo == null) {
            this.EnCurrencyInfo = currencyInfo;
            this.combCurrency.setSelectedItem((Object)this.EnCurrencyInfo);
            return;
        }
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        if (!currencyInfo.equals((Object)this.EnCurrencyInfo)) {
            for (int i = 0; i < this.kdtBillEntry.getRowCount() - 1; ++i) {
                IRow row = this.kdtBillEntry.getRow(i);
                row.getCell("currency").setValue((Object)currencyInfo);
                this.exchangeCurrency(currencyInfo, i);
            }
            this.EnCurrencyInfo = currencyInfo;
            this.combCurrency.setSelectedItem((Object)this.EnCurrencyInfo);
        }
        if (!this.combCurrency.getSelectedItem().equals(currencyInfo)) {
            currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            CompanyOrgUnitInfo company = this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            for (int i = 0; i < this.kdtBillEntry.getRowCount() - 1; ++i) {
                IRow row = this.kdtBillEntry.getRow(i);
                row.getCell("currency").setValue((Object)currencyInfo);
                this.exchangeCurrency(currencyInfo, i);
            }
        }
        IRow curRow = this.kdtBillEntry.getRow(rowIndex);
        FinHelper.clearCells((KDTable)this.kdtBillEntry, (int)rowIndex, (String[])new String[]{"rate", "AmountLocalCur"});
        if (currencyInfo != null) {
            if (FinUtils.isBaseCurrency((CurrencyInfo)currencyInfo, (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
                curRow.getCell("rate").setValue((Object)new BigDecimal(String.valueOf(1)));
                curRow.getCell("rate").getStyleAttributes().setLocked(true);
                curRow.getCell("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                curRow.getCell("AmountLocalCur").setValue((Object)((BigDecimal)curRow.getCell("Amount").getValue()));
                if (curRow.getCell("Amount").getValue() != null) {
                    this.setTotalValue((BigDecimal)curRow.getCell("Amount").getValue(), (BigDecimal)curRow.getCell("Amount").getValue());
                } else {
                    this.setTotalValue(new BigDecimal(0), new BigDecimal(String.valueOf(0)));
                }
            } else {
                ExchangeRateInfo rateInfo = null;
                try {
                    rateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (CurrencyInfo)currencyInfo, (CurrencyInfo)this.CURRENT_COMPANY.getBaseCurrency(), (Date)new Date());
                }
                catch (FinBizException e) {
                    this.handUIException(e);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                if (rateInfo != null) {
                    curRow.getCell("rate").setValue((Object)rateInfo.getConvertRate());
                    curRow.getCell("rate").getStyleAttributes().setLocked(false);
                    curRow.getCell("rate").getStyleAttributes().setBackground(Color.white);
                    if (curRow.getCell("Amount").getValue() != null) {
                        curRow.getCell("AmountLocalCur").setValue((Object)((BigDecimal)curRow.getCell("Amount").getValue()).multiply(rateInfo.getConvertRate()));
                        this.setTotalValue((BigDecimal)curRow.getCell("Amount").getValue(), ((BigDecimal)curRow.getCell("Amount").getValue()).multiply(rateInfo.getConvertRate()));
                    }
                }
            }
        }
    }

    protected void calcTotalRowInFinFee() {
        int rowCount = this.kdtBillEntry.getRowCount();
        BigDecimal total = new BigDecimal(String.valueOf(0));
        BigDecimal totalAmount = new BigDecimal(String.valueOf(0));
        for (int i = 0; i < rowCount - 1; ++i) {
            IRow row = this.kdtBillEntry.getRow(i);
            BigDecimal tmpAmount = (BigDecimal)row.getCell("Amount").getValue();
            BigDecimal tmp = (BigDecimal)row.getCell("AmountLocalCur").getValue();
            if (tmp != null) {
                total = total.add(tmp);
            }
            if (tmpAmount == null) continue;
            totalAmount = totalAmount.add(tmpAmount);
        }
        IRow rowTotal = this.kdtBillEntry.getRow(rowCount - 1);
        rowTotal.getCell("AmountLocalCur").setValue((Object)total);
        rowTotal.getCell("Amount").setValue((Object)totalAmount);
        int count = this.kdtBillEntry.getRowCount();
        BigDecimal disAccrual = this.txtDiscountAccrual.getBigDecimalValue();
        if (count > 0 && disAccrual != null && totalAmount != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            this.txtAmount.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, totalAmount.subtract(disAccrual)));
        }
    }

    protected void setTotalValue(BigDecimal AmountValue, BigDecimal AmountLocalCurValue) {
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        BigDecimal totalAmountLocalCur = new BigDecimal(String.valueOf(0));
        BigDecimal totalAmount = new BigDecimal(String.valueOf(0));
        totalAmount = totalAmount.add(AmountValue);
        totalAmountLocalCur = totalAmountLocalCur.add(AmountLocalCurValue);
        for (int i = 0; i < this.kdtBillEntry.getRowCount(); ++i) {
            if (i == rowIndex || i == this.kdtBillEntry.getRowCount() - 1) continue;
            IRow row = this.kdtBillEntry.getRow(i);
            BigDecimal tmpAmount = (BigDecimal)row.getCell("Amount").getValue();
            BigDecimal tmpAmountLocalCur = (BigDecimal)row.getCell("AmountLocalCur").getValue();
            if (tmpAmount != null) {
                totalAmount = totalAmount.add(tmpAmount);
            }
            if (tmpAmountLocalCur == null) continue;
            totalAmountLocalCur = totalAmountLocalCur.add(tmpAmountLocalCur);
        }
        IRow rowTotal = this.kdtBillEntry.getRow(this.kdtBillEntry.getRowCount() - 1);
        rowTotal.getCell("Amount").setValue((Object)totalAmount);
        rowTotal.getCell("AmountLocalCur").setValue((Object)totalAmountLocalCur);
        DateUtil dateh = new DateUtil();
        int days = 0;
        BigDecimal yearDiscRate = this.txtYearDiscountRate.getBigDecimalValue();
        Date bizDate = (Date)this.pkBizDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (totalAmount != null && yearDiscRate != null && !bizDate.after(endDate)) {
            days = DateUtil.getDiffDays((Date)bizDate, (Date)endDate) - 1;
            BigDecimal discountAccrual = totalAmount.multiply(yearDiscRate).multiply(new BigDecimal(days));
            discountAccrual = discountAccrual.divide(new BigDecimal(36000), 2);
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            this.txtDiscountAccrual.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, discountAccrual));
        }
        int count = this.kdtBillEntry.getRowCount();
        BigDecimal disAccrual = this.txtDiscountAccrual.getBigDecimalValue();
        if (count > 0 && disAccrual != null && totalAmount != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            this.txtAmount.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, totalAmount.subtract(disAccrual)));
        }
    }

    protected void setBotpTotalValue(BigDecimal AmountValue, BigDecimal AmountLocalCurValue) {
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        BigDecimal totalAmountLocalCur = new BigDecimal(String.valueOf(0));
        BigDecimal totalAmount = new BigDecimal(String.valueOf(0));
        for (int i = 0; i < this.kdtBillEntry.getRowCount() - 1; ++i) {
            IRow row = this.kdtBillEntry.getRow(i);
            BigDecimal tmpAmount = (BigDecimal)row.getCell("Amount").getValue();
            BigDecimal tmpAmountLocalCur = (BigDecimal)row.getCell("AmountLocalCur").getValue();
            if (tmpAmount != null) {
                totalAmount = totalAmount.add(tmpAmount);
            }
            if (tmpAmountLocalCur == null) continue;
            totalAmountLocalCur = totalAmountLocalCur.add(tmpAmountLocalCur);
        }
        IRow rowTotal = this.kdtBillEntry.getRow(this.kdtBillEntry.getRowCount() - 1);
        rowTotal.getCell("Amount").setValue((Object)totalAmount);
        rowTotal.getCell("AmountLocalCur").setValue((Object)totalAmountLocalCur);
    }

    @Override
    protected void btnAddInBill_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddInBill_actionPerformed(e);
        int rowCount = this.kdtBillEntry.getRowCount();
        if (rowCount == 0) {
            this.EnCurrencyInfo = FinHelper.getBaseCurrencyName((CompanyOrgUnitInfo)this.CURRENT_COMPANY);
            IRow row = this.kdtBillEntry.addRow();
            row.getCell("currency").setValue((Object)FinHelper.getBaseCurrencyName((CompanyOrgUnitInfo)this.CURRENT_COMPANY));
            row.getCell("rate").setValue((Object)new BigDecimal(String.valueOf(1)));
            row.getCell("rate").getStyleAttributes().setLocked(true);
            row.getCell("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            row.getCell("AmountLocalCur").getStyleAttributes().setLocked(true);
            row.getCell("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            IRow rowTotal = this.kdtBillEntry.addRow();
            rowTotal.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean"));
            rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            rowTotal.getStyleAttributes().setLocked(true);
            this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setNumberFormat("#,###.00");
            this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat("#,###.00");
        } else {
            IRow row = this.kdtBillEntry.addRow(rowCount - 1);
            row.getCell("currency").setValue((Object)this.EnCurrencyInfo);
            this.exchangeCurrency(this.EnCurrencyInfo, rowCount - 1);
        }
    }

    @Override
    protected void btnRemoveInBill_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveInBill_actionPerformed(e);
        int rowIndex = this.kdtBillEntry.getSelectManager().getActiveRowIndex();
        if (this.kdtBillEntry.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int rowCo = this.kdtBillEntry.getRowCount();
        if (rowIndex == rowCo - 1) {
            return;
        }
        if (rowCo == 2) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"EntryIsNull"));
            SysUtil.abort();
        }
        KDTSelectBlock selectBlock = null;
        selectBlock = this.kdtBillEntry.getSelectManager().get(0);
        int bottom = selectBlock.getEndRow();
        if (rowCo - 1 == bottom) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryEndRowIsNotDel"));
            SysUtil.abort();
        }
        this.removeLine(this.kdtBillEntry);
        this.calcTotalRowInFinFee();
        int rowCount = this.kdtBillEntry.getRowCount();
        if (rowCount == 1) {
            this.kdtBillEntry.removeRows(false);
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return super.createNewDetailData(table);
    }

    protected IObjectValue createNewData() {
        BillRediscountOutInfo info = new BillRediscountOutInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setBizDate(DateUtil.getDayBegin());
        info.setCurrency(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
        info.setEndDate(DateUtil.getDayBegin());
        info.setRediscountType(RediscountTypeEnum.RediscountOut);
        info.setRediscountMode(RediscountModeEnum.Monopoly);
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        info.setRediscountOut(companyInfo);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BillRediscountOutFactory.getRemoteInstance();
    }

    private boolean isBotp() {
        int status;
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        return this.getUIContext().get("BOTPViewStatus") instanceof Integer && (status = ((Integer)this.getUIContext().get("BOTPViewStatus")).intValue()) == 1;
    }

    public int getBtpCreateFromType() {
        return 1;
    }

    @Override
    public void loadFields() {
        this.isLoadFieldsing = true;
        if (this.isBotp()) {
            this.editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            this.editData.setBizDate(DateUtil.getDayBegin());
            this.editData.setCurrency(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
            this.editData.setEndDate(DateUtil.getDayBegin());
            this.editData.setRediscountType((RediscountTypeEnum)((Object)this.comboRediscountType.getItemAt(1)));
            this.editData.setRediscountMode((RediscountModeEnum)((Object)this.comboRediscountMode.getItemAt(0)));
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
            this.editData.setRediscountOut(companyInfo);
        }
        FinUtils.noActionOnSetDefault((KDComboBox)this.combCurrency, (Object)this.editData.getCurrency());
        if (this.editData.getCurrency() == this.baseCurrency) {
            this.editData.setLocalCurExRate(new BigDecimal(1));
        }
        if (FinUtils.isBaseCurrency((CurrencyInfo)this.editData.getCurrency(), (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
            this.txtLocalCurExRate.setEditable(false);
        } else {
            this.txtLocalCurExRate.setEditable(true);
        }
        if (this.editData.getCompany() == null) {
            this.editData.setCompany(this.CURRENT_COMPANY);
        }
        this.prmtFinProduct.setValue((Object)this.editData.getType());
        super.loadFields();
        if (this.editData.isIsInCredit()) {
            this.chkIsInCredit.setSelected(true);
            this.chkIsRelBank.setSelected(this.editData.isIsRelBankInCredit());
            this.prmtCreditLimit.setData((Object)this.editData.getCreditLimit());
            this.prmtCreditCurrency.setData((Object)this.editData.getCreditCurrency());
            this.txtCreditCurExRate.setValue((Object)this.editData.getCreditCurExRate(), false);
            this.txtCreditLocalAmt.setValue((Object)this.editData.getCreditLocalAmt(), false);
            try {
                this.txtRemainAmount.setValue((Object)FinUtils.getCreditRemainAmount(null, (CreditLimitInfo)this.editData.getCreditLimit(), (CompanyOrgUnitInfo)this.editData.getCompany()));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        this.editData.setBalance(this.txtAmount.getBigDecimalValue());
        this.editData.setInstitution((BankInfo)this.prmtRediscountIn.getValue());
        this.editData.setType((FinancingProductsInfo)this.prmtFinProduct.getValue());
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString(), (FmRpcCacheInfo)this.rpcCacheInfo);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLocalCurExRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmountLocalCur);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtDiscountAccrual);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtCreditCurExRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtCreditLocalAmt);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtRemainAmount);
        this.txtYearDiscountRate.setRemoveingZeroInDispaly(false);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtAmount.setValue(null);
            this.txtAmountLocalCur.setValue(null);
        }
        this.col = null;
        if (this.editData.getId() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)this.editData.getId().toString()));
            view.setFilter(filter);
            try {
                this.col = CreditFinancingReduceFactory.getRemoteInstance().getCreditFinancingReduceCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.storeFields();
        this.isDataLoadFinished = true;
        this.isLoadFieldsing = false;
        this.btnAddInBill.setEnabled(true);
        this.btnRemoveInBill.setEnabled(true);
        this.txtAmount.setPrecision(2);
        this.txtDiscountAccrual.setPrecision(2);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            int rowCount = this.kdtBillEntry.getRowCount();
            if (FinUtils.isBaseCurrency((CurrencyInfo)this.editData.getCurrency(), (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
                this.kdtBillEntry.getColumn("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                this.kdtBillEntry.getColumn("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            } else {
                this.kdtBillEntry.getColumn("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            }
            IRow row = this.kdtBillEntry.getRow(rowCount - 1);
            row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            row.getStyleAttributes().setLocked(true);
        }
    }

    private void loadEntrysBill() {
        this.kdtBillEntry.removeRows(false);
        BigDecimal total = new BigDecimal(String.valueOf(0));
        Iterator iter = this.editData.getEntry().iterator();
        while (iter.hasNext()) {
            BillRediscountOutEntryInfo billRediscountInfo = (BillRediscountOutEntryInfo)iter.next();
            try {
                billRediscountInfo = BillRediscountOutEntryFactory.getRemoteInstance().getBillRediscountOutEntryInfo((IObjectPK)new ObjectUuidPK(billRediscountInfo.getId()), this.getBillRediscSelector());
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            IRow row = this.kdtBillEntry.addRow();
            row.getCell("number").setValue((Object)billRediscountInfo.getNumber());
            row.getCell("currency").setValue((Object)billRediscountInfo.getCurrency());
            row.getCell("Amount").setValue((Object)billRediscountInfo.getAmount());
            row.getCell("endDate").setValue((Object)billRediscountInfo.getDate());
            row.getCell("rate").setValue((Object)billRediscountInfo.getRate());
            row.getCell("AmountLocalCur").setValue((Object)billRediscountInfo.getAmountLocalCur());
            total = total.add(billRediscountInfo.getAmountLocalCur());
            if (!row.getCell("number").getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean"))) continue;
            row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            row.getStyleAttributes().setLocked(true);
        }
    }

    protected SelectorItemCollection getBillRediscSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("localCurExRate"));
        sic.add(new SelectorItemInfo("amountLocalCur"));
        return sic;
    }

    private void initF7Filter() throws BOSException {
        this.prmtCreditLimit.setEntityViewInfo(FMClientHelper.getNothingFilter());
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtRediscountIn, null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initEntrysTable() {
        KDTextField txtnumber = new KDTextField();
        txtnumber.setRequired(true);
        this.kdtBillEntry.getColumn("number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtnumber));
        KDFormattedTextField txtAmount = new KDFormattedTextField();
        txtAmount.setDataType(1);
        this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        txtAmount.setRequired(true);
        txtAmount.setNegatived(false);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)txtAmount);
        txtAmount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BillRediscountOutEditUI.this.fillCellAfterBillSelectedAmountInBillEntry(eventObj);
            }
        });
        this.kdtBillEntry.getColumn("Amount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAmount));
        KDFormattedTextField txtRate = new KDFormattedTextField();
        txtRate.setDataType(1);
        this.kdtBillEntry.getColumn("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        txtRate.setRequired(true);
        txtRate.setNegatived(false);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)txtRate);
        txtRate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BillRediscountOutEditUI.this.fillCellAfterBillSelectedRateInBillEntry(eventObj);
            }
        });
        this.kdtBillEntry.getColumn("rate").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRate));
        KDFormattedTextField txtAmountLocalCur = new KDFormattedTextField();
        txtAmountLocalCur.setDataType(1);
        txtAmountLocalCur.setPrecision(2);
        this.kdtBillEntry.getColumn("AmountLocalCur").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        txtAmountLocalCur.setRequired(true);
        txtAmountLocalCur.setNegatived(false);
        txtAmountLocalCur.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BillRediscountOutEditUI.this.fillCellAfterBillSelectedAmountLocalCurEntry(eventObj);
            }
        });
        this.kdtBillEntry.getColumn("AmountLocalCur").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAmountLocalCur));
        KDBizPromptBox prmtCurrency = new KDBizPromptBox();
        ExtendParser parserCurrency = new ExtendParser(prmtCurrency);
        prmtCurrency.setCommitParser((IParser)parserCurrency);
        prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        prmtCurrency.setVisible(true);
        prmtCurrency.setRequired(true);
        prmtCurrency.setEditable(true);
        prmtCurrency.setDisplayFormat("$name$");
        prmtCurrency.setEditFormat("$number$");
        prmtCurrency.setCommitFormat("$number$");
        prmtCurrency.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prmtCurrency));
        ObjectValueRender avrCurrency = new ObjectValueRender();
        avrCurrency.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtBillEntry.getColumn("currency").setRenderer((IBasicRender)avrCurrency);
        prmtCurrency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BillRediscountOutEditUI.this.fillCellAfterBillSelectedCurrencyInBillEntry(eventObj);
            }
        });
        this.kdtBillEntry.getColumn("currency").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCurrency));
        KDDatePicker pkDate = new KDDatePicker();
        pkDate.setRequired(true);
        pkDate.setDisplay(true);
        this.kdtBillEntry.getColumn("endDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        FSClientHelper.checkClearingHouseCompany();
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.getUIContext().get("company") != null) {
            this.CURRENT_COMPANY = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
        this.kdtBillEntry.checkParsed();
        this.initEntrysTable();
        super.onLoad();
        this.isOnLoadFinished = true;
        this.btnAuditResult.setVisible(false);
        this.initF7Filter();
        this.btnAddInBill.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveInBill.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            int p = ((CurrencyInfo)this.combCurrency.getSelectedItem()).getPrecision();
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
            BillRediscountOutInfo info = BillRediscountOutFactory.getRemoteInstance().getBillRediscountOutInfo((IObjectPK)pk);
            if (info.isIsBotp()) {
                this.kdtBillEntry.getStyleAttributes().setLocked(true);
                this.btnAddInBill.setEnabled(false);
                this.btnRemoveInBill.setEnabled(false);
            }
            this.txtNumber.setEnabled(true);
            if (currencyInfo != null) {
                StringBuffer strFormat = new StringBuffer();
                strFormat.append("#,###.");
                for (int i = 0; i < currencyInfo.getPrecision(); ++i) {
                    strFormat.append("0");
                }
                this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setNumberFormat(strFormat.toString());
                ExchangeRateInfo rateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (CurrencyInfo)currencyInfo, (CurrencyInfo)this.CURRENT_COMPANY.getBaseCurrency(), (Date)new Date());
                if (rateInfo != null) {
                    StringBuffer strRatePrc = new StringBuffer();
                    strRatePrc.append("#,###.");
                    for (int j = 0; j < rateInfo.getPrecision(); ++j) {
                        strRatePrc.append("0");
                    }
                    this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat(strRatePrc.toString());
                } else {
                    this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat("#,###.00");
                }
            }
            if (info != null) {
                CurrencyInfo baseCurrency = this.CURRENT_COMPANY.getBaseCurrency();
                if (baseCurrency == null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("baseCurrency.*"));
                    sic.add(new SelectorItemInfo("baseCurrency.id"));
                    sic.add(new SelectorItemInfo("baseCurrency.number"));
                    sic.add(new SelectorItemInfo("baseCurrency.name"));
                    this.CURRENT_COMPANY = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.CURRENT_COMPANY.getId()), sic);
                    baseCurrency = this.CURRENT_COMPANY.getBaseCurrency();
                }
                ExchangeRateInfo exchangeRateInfo = FMHelper.getExRateInfo((CurrencyInfo)currencyInfo, (CurrencyInfo)baseCurrency, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (Date)info.getBizDate());
                if (currencyInfo != null && baseCurrency != null && !currencyInfo.getId().equals((Object)baseCurrency.getId())) {
                    this.txtLocalCurExRate.setPrecision(exchangeRateInfo.getPrecision());
                    this.txtCreditCurExRate.setPrecision(exchangeRateInfo.getPrecision());
                    this.txtAmountLocalCur.setPrecision(baseCurrency.getPrecision());
                } else {
                    this.txtLocalCurExRate.setPrecision(2);
                }
            }
            this.txtAmount.setPrecision(p);
            this.txtDiscountAccrual.setPrecision(p);
            this.txtYearDiscountRate.setPrecision(4);
        } else {
            this.txtLocalCurExRate.setPrecision(2);
            this.txtAmount.setPrecision(2);
            this.txtDiscountAccrual.setPrecision(2);
            this.txtYearDiscountRate.setPrecision(4);
            this.txtCreditLocalAmt.setPrecision(2);
            this.txtRemainAmount.setPrecision(2);
        }
        this.txtAmountLocalCur.setPrecision(2);
        this.txtAmount.setNegatived(false);
        this.txtLocalCurExRate.setNegatived(false);
        this.txtAmountLocalCur.setNegatived(false);
        this.txtDiscountAccrual.setNegatived(false);
        this.txtYearDiscountRate.setNegatived(false);
        this.txtYearDiscountRate.setRemoveingZeroInDispaly(false);
        this.txtCreditCurExRate.setNegatived(false);
        this.txtCreditLocalAmt.setNegatived(false);
        this.txtRemainAmount.setNegatived(false);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmountLocalCur.setHorizontalAlignment(4);
        this.txtDiscountAccrual.setHorizontalAlignment(4);
        this.txtYearDiscountRate.setHorizontalAlignment(4);
        this.txtLocalCurExRate.setHorizontalAlignment(4);
        this.txtCreditLocalAmt.setHorizontalAlignment(4);
        this.txtCreditCurExRate.setHorizontalAlignment(4);
        this.txtRemainAmount.setHorizontalAlignment(4);
        this.prmtRediscountIn.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        EntityViewInfo viOut = new EntityViewInfo();
        FilterInfo filterOut = new FilterInfo();
        filterOut.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        viOut.setFilter(filterOut);
        this.prmtRediscountIn.setEntityViewInfo(viOut);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        this.prmtRediscountOutBank.setSelectorCollection(sic);
        this.prmtRediscountOutBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.CURRENT_COMPANY != null && this.CURRENT_COMPANY.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.CURRENT_COMPANY.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        vi.setFilter(filter);
        this.prmtRediscountOutBank.setEntityViewInfo(vi);
        this.prmtFinProduct.setQueryInfo("com.kingdee.eas.fm.fin.app.FinancingProductsQuery");
        this.prmtFinProduct.setDisplayFormat("$name$");
        this.prmtFinProduct.setEditFormat("$number$");
        this.prmtFinProduct.setCommitFormat("$number$");
        this.prmtFinProduct.setEntityViewInfo(LoanModel.getFinProductFilter((FinancingBillTypeEnum)FinancingBillTypeEnum.BillRediscount));
        if (this.isBotp()) {
            this.kdtBillEntry.getStyleAttributes().setLocked(true);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.EnCurrencyInfo = FinHelper.getBaseCurrencyName((CompanyOrgUnitInfo)this.CURRENT_COMPANY);
            if (!this.isBotp()) {
                IRow row = this.kdtBillEntry.addRow();
                row.getCell("currency").setValue((Object)FinHelper.getBaseCurrencyName((CompanyOrgUnitInfo)this.CURRENT_COMPANY));
                row.getCell("rate").setValue((Object)new BigDecimal(String.valueOf(1)));
                row.getCell("rate").getStyleAttributes().setLocked(true);
                row.getCell("rate").getStyleAttributes().setBackground(new Color(0xE8E8E3));
                row.getCell("AmountLocalCur").getStyleAttributes().setLocked(true);
                row.getCell("AmountLocalCur").getStyleAttributes().setBackground(new Color(0xE8E8E3));
            }
            IRow rowTotal = this.kdtBillEntry.addRow();
            rowTotal.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean"));
            rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            rowTotal.getStyleAttributes().setLocked(true);
            if (this.isBotp()) {
                this.btnAddInBill.setEnabled(false);
                this.btnRemoveInBill.setEnabled(false);
                int roCount = this.kdtBillEntry.getRowCount();
                CurrencyInfo currencyInfo = null;
                CurrencyInfo currencyInfoOld = null;
                for (int i = 0; i < roCount - 1; ++i) {
                    IRow row = this.kdtBillEntry.getRow(i);
                    currencyInfo = (CurrencyInfo)row.getCell("currency").getValue();
                    if (i == 0) {
                        currencyInfoOld = currencyInfo;
                    }
                    if (!currencyInfoOld.equals((Object)currencyInfo)) {
                        this.kdtBillEntry.removeRows();
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillOutReceivableCurrencyIsNotSame"));
                        SysUtil.abort();
                    }
                    BigDecimal amount = (BigDecimal)row.getCell("Amount").getValue();
                    BigDecimal amountLocalCur = (BigDecimal)row.getCell("AmountLocalCur").getValue();
                    this.setBotpTotalValue(amount, amountLocalCur);
                }
                if (currencyInfo != null) {
                    FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, currencyInfo);
                    ExchangeRateInfo rateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (CurrencyInfo)currencyInfo, (CurrencyInfo)this.CURRENT_COMPANY.getBaseCurrency(), (Date)new Date());
                    if (rateInfo != null) {
                        StringBuffer strRatePrc = new StringBuffer();
                        strRatePrc.append("#,###.");
                        for (int j = 0; j < rateInfo.getPrecision(); ++j) {
                            strRatePrc.append("0");
                        }
                        this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat(strRatePrc.toString());
                        StringBuffer strAmountPrc = new StringBuffer();
                        strAmountPrc.append("#,###.");
                        for (int k = 0; k < currencyInfo.getPrecision(); ++k) {
                            strAmountPrc.append("0");
                        }
                        this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setNumberFormat(strAmountPrc.toString());
                    } else {
                        this.kdtBillEntry.getColumn("rate").getStyleAttributes().setNumberFormat("#,###.00");
                        this.kdtBillEntry.getColumn("Amount").getStyleAttributes().setNumberFormat("#,###.00");
                    }
                }
                this.editData.setIsBotp(true);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        IRow row;
        int i;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtRediscountIn);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtRediscountOut);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.combCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLocalCurExRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmountLocalCur);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtYearDiscountRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkEndDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtFinProduct);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        if (this.chkIsInCredit.isSelected()) {
            if (this.prmtCreditLimit.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"7_BillRediscountOutEditUI"));
                SysUtil.abort();
            }
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCreditCurrency);
            FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtCreditCurExRate);
        }
        Date bizDate = (Date)this.pkBizDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (bizDate != null && endDate != null && bizDate.after(endDate) || bizDate.equals(endDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEndDateMustAfterStart"));
            this.pkEndDate.setValue((Object)bizDate);
            this.pkEndDate.requestFocus();
            SysUtil.abort();
        }
        if (endDate != null) {
            int roCount = this.kdtBillEntry.getRowCount();
            for (i = 0; i < roCount - 1; ++i) {
                row = this.kdtBillEntry.getRow(i);
                Date enDate = (Date)row.getCell("endDate").getValue();
                if (enDate != null && !enDate.after(endDate)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryEndDataMustAfterStart"));
                    SysUtil.abort();
                }
                if (bizDate == null || enDate == null || enDate.after(bizDate)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryEndDateMustAfterBizDate"));
                SysUtil.abort();
            }
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtDiscountAccrual);
        int rowCount = this.kdtBillEntry.getRowCount();
        if (rowCount == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"EntryIsNull"));
            SysUtil.abort();
        }
        for (i = 0; i < rowCount - 1; ++i) {
            row = this.kdtBillEntry.getRow(i);
            if (row.getCell("number").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryNumberIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("currency").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryCurrencyIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("Amount").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryAmountIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("Amount").getValue() != null && ((BigDecimal)row.getCell("Amount").getValue()).compareTo(new BigDecimal(0)) == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryMustMoreZero"));
                SysUtil.abort();
            }
            if (row.getCell("endDate").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryEndDateIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("rate").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryRateIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("AmountLocalCur").getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryAmountLocalCurIsNull"));
            SysUtil.abort();
        }
        for (i = 0; i < rowCount - 1; ++i) {
            row = this.kdtBillEntry.getRow(i);
            if (row.getCell("number").getValue() == null) continue;
            int rowi = i + 1;
            for (int j = 0; j < rowCount - 1 - i - 1; ++j) {
                IRow row2 = this.kdtBillEntry.getRow(rowi);
                row2.getCell("number").getValue();
                if (row.getCell("number").getValue().equals(row2.getCell("number").getValue())) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillEntryNumberIsSame"));
                    SysUtil.abort();
                }
                ++rowi;
            }
        }
        IBillRediscountOut billOut = BillRediscountOutFactory.getRemoteInstance();
        for (int i2 = 0; i2 < rowCount - 1; ++i2) {
            IRow row2 = this.kdtBillEntry.getRow(i2);
            if (row2.getCell("number").getValue() == null) continue;
            String strNumber = row2.getCell("number").getValue().toString();
            billOut.updateBillState(strNumber);
        }
        if (this.editData.getCreditLimit() != null && this.editData.getCreditLimit().getCreditUsage() != null) {
            CreditUsageInfo uinfo = CreditUsageFactory.getRemoteInstance().getCreditUsageInfo((IObjectPK)new ObjectUuidPK(this.editData.getCreditLimit().getCreditUsage().getId().toString()));
            this.editData.getCreditLimit().setCreditUsage(uinfo);
            if (uinfo.isColligateCredit() && this.editData.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && (this.editData.getReduceCol() == null || this.editData.getReduceCol().size() == 0)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"8_BillRediscountOutEditUI"));
                this.isDataLoadFinished = true;
                SysUtil.abort();
                this.showChooseFinProUI();
            }
        }
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.pkBizDate_dataChanged(e);
        DateUtil dateh = new DateUtil();
        int days = 0;
        int count = this.kdtBillEntry.getRowCount();
        if (count > 0) {
            IRow row = this.kdtBillEntry.getRow(count - 1);
            BigDecimal yearDiscRate = this.txtYearDiscountRate.getBigDecimalValue();
            BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
            Date bizDate = (Date)this.pkBizDate.getValue();
            Date endDate = (Date)this.pkEndDate.getValue();
            if (totalAmount != null && yearDiscRate != null && !bizDate.after(endDate)) {
                days = DateUtil.getDiffDays((Date)bizDate, (Date)endDate) - 1;
                BigDecimal discountAccrual = totalAmount.multiply(yearDiscRate).multiply(new BigDecimal(days));
                discountAccrual = discountAccrual.divide(new BigDecimal(36000), 2);
                CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
                this.txtDiscountAccrual.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, discountAccrual));
            }
        }
    }

    @Override
    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.pkEndDate_dataChanged(e);
        DateUtil dateh = new DateUtil();
        int days = 0;
        int count = this.kdtBillEntry.getRowCount();
        if (count > 0) {
            IRow row = this.kdtBillEntry.getRow(count - 1);
            BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
            BigDecimal yearDiscRate = this.txtYearDiscountRate.getBigDecimalValue();
            Date bizDate = (Date)this.pkBizDate.getValue();
            Date endDate = (Date)this.pkEndDate.getValue();
            if (totalAmount != null && yearDiscRate != null && !bizDate.after(endDate)) {
                days = DateUtil.getDiffDays((Date)bizDate, (Date)endDate) - 1;
                BigDecimal discountAccrual = totalAmount.multiply(yearDiscRate).multiply(new BigDecimal(days));
                discountAccrual = discountAccrual.divide(new BigDecimal(36000), 2);
                CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
                this.txtDiscountAccrual.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, discountAccrual));
            }
        }
    }

    @Override
    protected void chkIsInCredit_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsInCredit_itemStateChanged(e);
        this.txtCreditLocalAmt.setHorizontalAlignment(4);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
        if (currencyInfo != null) {
            int p = currencyInfo.getPrecision();
            this.txtCreditCurExRate.setPrecision(p);
        }
        if (!this.chkIsInCredit.isSelected()) {
            this.txtCreditCurExRate.setEditable(false);
            FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)false);
            this.prmtCreditLimit.setData(null);
            this.prmtCreditCurrency.setData(null);
            this.txtCreditCurExRate.setValue((Object)SysConstant.BIGZERO);
            this.txtRemainAmount.setValue((Object)SysConstant.BIGZERO);
            this.chkIsRelBank.setSelected(false);
            this.chkIsRelBank.setEnabled(false);
            this.txtCreditLocalAmt.setEnabled(false);
            this.txtCreditLocalAmt.setValue((Object)SysConstant.BIGZERO);
        } else {
            FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)true);
            this.editData.setIsInCredit(true);
            this.txtCreditCurExRate.setEditable(true);
            this.chkIsRelBank.setSelected(true);
            this.chkIsRelBank.setEnabled(true);
            this.txtCreditLocalAmt.setEnabled(true);
        }
    }

    @Override
    protected void chkIsRelBank_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsRelBank_itemStateChanged(e);
        this.prmtCreditLimit.setData(null);
        this.prmtCreditCurrency.setData(null);
        this.txtCreditCurExRate.setValue((Object)SysConstant.BIGZERO);
        this.txtRemainAmount.setValue((Object)SysConstant.BIGZERO);
    }

    @Override
    protected void prmtCreditCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCreditCurrency_dataChanged(e);
        CurrencyInfo currency = (CurrencyInfo)e.getNewValue();
        if (currency != null) {
            int prec = currency.getPrecision();
            this.txtRemainAmount.setPrecision(prec);
        }
    }

    private void calcCreditLimitExRate() throws EASBizException, BOSException {
        if (!this.chkIsInCredit.isSelected()) {
            this.txtCreditCurExRate.setValue((Object)SysConstant.BIGZERO);
        } else {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            CurrencyInfo creditCurrencyInfo = (CurrencyInfo)this.prmtCreditCurrency.getData();
            if (currencyInfo == null || creditCurrencyInfo == null) {
                return;
            }
            try {
                BillRediscountOutInfo info = (BillRediscountOutInfo)this.getDataObject();
                if (info != null && (info.getCreditLimit() != null || this.prmtCreditLimit.getData() != null)) {
                    CurrencyInfo creCurrencyInfo;
                    CreditLimitInfo creditInfo;
                    if (info.getCreditLimit() != null) {
                        creditInfo = info.getCreditLimit();
                        creCurrencyInfo = creditInfo.getCurrency();
                        FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtCreditCurExRate, (CompanyOrgUnitInfo)info.getCompany(), (CurrencyInfo)currencyInfo, (CurrencyInfo)creCurrencyInfo, (Date)info.getBizDate(), null);
                    }
                    if (this.prmtCreditLimit.getData() != null) {
                        creditInfo = (CreditLimitInfo)this.prmtCreditLimit.getData();
                        creCurrencyInfo = creditInfo.getCurrency();
                        FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtCreditCurExRate, (CompanyOrgUnitInfo)info.getCompany(), (CurrencyInfo)currencyInfo, (CurrencyInfo)creCurrencyInfo, (Date)info.getBizDate(), null);
                    }
                }
            }
            catch (EASBizException e) {
                this.combCurrency.setSelectedItem(null);
                throw e;
            }
        }
    }

    private void showChooseFinProUI() throws BOSException, EASBizException, Exception {
        CreditLimitInfo creditLimitInfo = (CreditLimitInfo)this.prmtCreditLimit.getValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("CreditUsage.*");
        sic.add("finacingProduct.*");
        creditLimitInfo = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitInfo.getId()), sic);
        if (creditLimitInfo.getCreditUsage().isColligateCredit() && this.isDataLoadFinished && creditLimitInfo.getShareType() == ShareTypeEnum.ASSIGN) {
            this.getUIContext().put("creditPK", new ObjectUuidPK(AccessHelper.getId((Object)this.prmtCreditLimit.getValue())));
            this.getUIContext().put("creditLocalAmt", this.txtCreditLocalAmt.getBigDecimalValue());
            this.getUIContext().put("finproID", AccessHelper.getId((Object)this.prmtFinProduct.getValue()));
            if (this.getOprtState().equals(OprtState.EDIT)) {
                this.getUIContext().put("billID", this.editData.getId().toString());
                if (this.editData.getCreditLimit() != null) {
                    this.getUIContext().put("oldCreitLimitPK", new ObjectUuidPK(this.editData.getCreditLimit().getId()));
                }
            }
            this.col = ChooseFinancingProductUI.showChooseFinancingProductUI((CoreUI)this);
            if (this.col == null || this.col.size() <= 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"9_BillRediscountOutEditUI"));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void prmtCreditLimit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCreditLimit_dataChanged(e);
        CreditLimitInfo creditLimitInfo = (CreditLimitInfo)this.prmtCreditLimit.getData();
        if (creditLimitInfo == null) {
            this.txtCreditCurExRate.setEnabled(false);
            this.prmtCreditCurrency.setData(null);
            this.txtCreditCurExRate.setValue((Object)SysConstant.BIGZERO);
            this.txtRemainAmount.setValue((Object)SysConstant.BIGZERO);
            this.txtCreditLocalAmt.setEnabled(false);
            return;
        }
        this.txtCreditLocalAmt.setEnabled(true);
        creditLimitInfo = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitInfo.getId()), FinUtils.getCreditLimitEntityView().getSelector());
        CurrencyInfo creditCur = creditLimitInfo.getCurrency();
        CurrencyInfo selectSur = (CurrencyInfo)this.combCurrency.getSelectedItem();
        boolean isSameCur = creditCur.getId().equals((Object)selectSur.getId());
        this.prmtCreditCurrency.setData((Object)creditCur);
        this.txtCreditCurExRate.setEnabled(!isSameCur);
        this.txtCreditLocalAmt.setEnabled(!isSameCur);
        this.txtRemainAmount.setValue((Object)FinUtils.getCreditRemainAmount(null, (CreditLimitInfo)creditLimitInfo, (CompanyOrgUnitInfo)this.editData.getCompany()));
        this.calcCreditLimitExRate();
        if (this.prmtCreditLimit.getValue() != null && !this.isLoadFieldsing && creditLimitInfo.getCreditUsage().isColligateCredit()) {
            this.showChooseFinProUI();
        }
    }

    @Override
    protected void prmtCreditLimit_willCommit(CommitEvent e) throws Exception {
        super.prmtCreditLimit_willCommit(e);
        this.setPrmtCreditLimitFilter();
    }

    @Override
    protected void prmtCreditLimit_willShow(SelectorEvent e) throws Exception {
        super.prmtCreditLimit_willShow(e);
        this.setPrmtCreditLimitFilter();
    }

    protected void setPrmtCreditLimitFilter() throws EASBizException, BOSException {
        BankInfo bank = (BankInfo)this.prmtRediscountIn.getData();
        if (bank == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillSelectCreditBank"));
            this.prmtCreditLimit.setEntityViewInfo(FMClientHelper.getNothingFilter());
        } else {
            try {
                this.prmtCreditLimit.setEntityViewInfo(FinUtils.getCreditLimitF7FilterZsd((Object)bank, (String)this.CURRENT_COMPANY.getId().toString(), (boolean)this.chkIsRelBank.isSelected(), (String)AccessHelper.getId((Object)this.prmtFinProduct.getData())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.prmtCreditLimit.getQueryAgent().resetRuntimeEntityView();
        }
    }

    private void reCreditLocalAmt() {
        BigDecimal toAmount = new BigDecimal(0);
        int rowCo = this.kdtBillEntry.getRowCount();
        if (rowCo <= 0) {
            return;
        }
        IRow row = this.kdtBillEntry.getRow(rowCo - 1);
        toAmount = (BigDecimal)row.getCell("Amount").getValue();
        if (toAmount != null && this.txtCreditCurExRate.getBigDecimalValue() != null) {
            this.txtCreditLocalAmt.setValue((Object)FMHelper.multiply((BigDecimal)toAmount, (BigDecimal)this.txtCreditCurExRate.getBigDecimalValue()));
        }
    }

    @Override
    protected void txtCreditCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.Mutex_CreditLocalAmt_CreditCurExRate) {
            this.Mutex_CreditLocalAmt_CreditCurExRate = true;
            try {
                this.reCreditLocalAmt();
            }
            finally {
                this.Mutex_CreditLocalAmt_CreditCurExRate = false;
            }
        }
    }

    @Override
    protected void txtCreditLocalAmt_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.Mutex_CreditLocalAmt_CreditCurExRate) {
            this.Mutex_CreditLocalAmt_CreditCurExRate = true;
            try {
                this.reCalRate();
            }
            finally {
                this.Mutex_CreditLocalAmt_CreditCurExRate = false;
            }
        }
    }

    private void reCalRate() {
        CurrencyInfo curencyInfo = (CurrencyInfo)this.prmtCreditCurrency.getValue();
        CurrencyInfo curencyInfoHead = (CurrencyInfo)this.combCurrency.getSelectedItem();
        if (curencyInfo == null || curencyInfoHead == null) {
            return;
        }
        if (!curencyInfo.getId().toString().equals(curencyInfoHead.getId().toString()) && this.txtCreditLocalAmt.getBigDecimalValue() != null && this.txtAmount.getBigDecimalValue() != null && this.txtAmount.getBigDecimalValue().compareTo(Constants.ZERO) != 0) {
            this.txtCreditCurExRate.setValue((Object)this.txtCreditLocalAmt.getBigDecimalValue().divide(this.txtAmount.getBigDecimalValue(), this.txtCreditCurExRate.getPrecision(), 4));
        }
    }

    private BigDecimal getLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtLocalCurExRate.getBigDecimalValue();
        if (bdAmount != null && bdLocalExRate != null) {
            return bdAmount.multiply(bdLocalExRate);
        }
        return Constants.ZERO;
    }

    @Override
    protected void combCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.combCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        if (this.combCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.combCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtDiscountAccrual.setPrecision(currency.getPrecision());
            CompanyOrgUnitInfo company = this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                BillRediscountOutInfo info = (BillRediscountOutInfo)this.getDataObject();
                if (info != null) {
                    CurrencyInfo baseCurrency = company.getBaseCurrency();
                    if (baseCurrency == null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("baseCurrency.*"));
                        sic.add(new SelectorItemInfo("baseCurrency.id"));
                        sic.add(new SelectorItemInfo("baseCurrency.number"));
                        sic.add(new SelectorItemInfo("baseCurrency.name"));
                        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sic);
                        baseCurrency = company.getBaseCurrency();
                    }
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)company, (CurrencyInfo)currency, (CurrencyInfo)baseCurrency, (Date)info.getBizDate(), null);
                }
            }
            catch (EASBizException e1) {
                FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)this.CURRENT_COMPANY.getBaseCurrency());
                throw e1;
            }
            try {
                this.calcCreditLimitExRate();
            }
            catch (EASBizException e1) {
                this.combCurrency.setSelectedItem(null);
                throw e1;
            }
            if (currency.getId().equals((Object)this.baseCurrency.getId())) {
                this.txtLocalCurExRate.setPrecision(2);
                this.txtCreditCurExRate.setPrecision(2);
            } else {
                this.txtCreditCurExRate.setValue(null);
            }
            this.txtAmountLocalCur.setValue((Object)this.getLocalAmount());
            if (FinUtils.isBaseCurrency((CurrencyInfo)currency, (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
                this.txtLocalCurExRate.setEnabled(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
            }
        }
        if (this.prmtCreditCurrency.getData() != null) {
            boolean isSamaCur = false;
            CurrencyInfo reditCurrency = (CurrencyInfo)this.prmtCreditCurrency.getData();
            isSamaCur = currency.getId().equals((Object)reditCurrency.getId());
            this.txtCreditCurExRate.setEnabled(!isSamaCur);
            this.txtCreditLocalAmt.setEnabled(!isSamaCur);
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.txtAmount_dataChanged(e);
        BigDecimal bAmount = (BigDecimal)e.getNewValue();
        if (bAmount != null && this.txtLocalCurExRate.getValue() != null) {
            BigDecimal exRate = (BigDecimal)this.txtLocalCurExRate.getValue();
            bAmount = bAmount.multiply(exRate);
            this.txtAmountLocalCur.setValue((Object)bAmount.setScale(2, 4));
        }
        if (this.prmtCreditLimit.getValue() != null) {
            this.reCreditLocalAmt();
        }
        if (this.prmtCreditLimit.getValue() != null && !this.isLoadFieldsing) {
            this.showChooseFinProUI();
        }
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.txtLocalCurExRate_dataChanged(e);
        BigDecimal exRate = (BigDecimal)e.getNewValue();
        if (exRate != null && this.txtAmount.getBigDecimalValue() != null) {
            BigDecimal bAmount = this.txtAmount.getBigDecimalValue();
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            bAmount = bAmount.multiply(exRate);
            this.txtAmountLocalCur.setValue((Object)bAmount.setScale(2, 4));
        }
    }

    @Override
    protected void txtYearDiscountRate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.txtYearDiscountRate_dataChanged(e);
        BigDecimal yearRate = (BigDecimal)e.getNewValue();
        if (yearRate == null) {
            return;
        }
        if (yearRate.compareTo(new BigDecimal(100)) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"YearRateArea"));
            this.txtYearDiscountRate.setValue((Object)Constants.ZERO);
            this.txtYearDiscountRate.requestFocus();
            SysUtil.abort();
        }
        DateUtil dateh = new DateUtil();
        int days = 0;
        int count = this.kdtBillEntry.getRowCount();
        if (count > 0) {
            IRow row = this.kdtBillEntry.getRow(count - 1);
            BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
            BigDecimal yearDiscRate = this.txtYearDiscountRate.getBigDecimalValue();
            Date bizDate = (Date)this.pkBizDate.getValue();
            Date endDate = (Date)this.pkEndDate.getValue();
            if (totalAmount != null && yearDiscRate != null && !bizDate.after(endDate)) {
                days = DateUtil.getDiffDays((Date)bizDate, (Date)endDate) - 1;
                BigDecimal discountAccrual = totalAmount.multiply(yearDiscRate).multiply(new BigDecimal(days));
                discountAccrual = discountAccrual.divide(new BigDecimal(36000), 2);
                CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
                this.txtDiscountAccrual.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, discountAccrual));
            }
        }
    }

    @Override
    protected void prmtRediscountIn_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtRediscountIn_dataChanged(e);
        FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)false);
        this.chkIsInCredit.setSelected(false);
        this.prmtCreditLimit.setData(null);
        this.prmtCreditCurrency.setData(null);
        this.txtCreditCurExRate.setValue(null);
        this.txtRemainAmount.setValue(null);
    }

    @Override
    protected void txtDiscountAccrual_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.txtDiscountAccrual_dataChanged(e);
        int count = this.kdtBillEntry.getRowCount();
        BigDecimal disAccrual = (BigDecimal)e.getNewValue();
        if (count > 0) {
            IRow row = this.kdtBillEntry.getRow(count - 1);
            BigDecimal totalAmount = (BigDecimal)row.getCell("Amount").getValue();
            if (disAccrual != null && totalAmount != null) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
                this.txtAmount.setValue((Object)IbtHelper.subBigDecimalPrc(currencyInfo, totalAmount.subtract(disAccrual)));
            }
        }
    }

    @Override
    public void actionTDPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPreview_actionPerformed(e);
        if (this.editData.getId() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"TDPrintforEdit"));
            SysUtil.abort();
        }
        List idList = this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryName());
        appHlp.printPreview("/FM/IBT/BILLREDISCOUNTOUT", (Object)data, (Component)((Object)this));
    }

    private IMetaDataPK getTDQueryName() {
        return new MetaDataPK("com.kingdee.eas.fm.ibt.app.BillRediscountOutTDQuery");
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        if (this.editData.getId() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"TDPrintforEdit"));
            SysUtil.abort();
        }
        List idList = this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryName());
        appHlp.print("/FM/IBT/BILLREDISCOUNTOUT", (Object)data, (Component)((Object)this));
    }
}

