/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.ibt.client.AbstractBillRediscountOutFilterUI;
import com.kingdee.eas.fm.ibt.client.BillRediscountOutParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class BillRediscountOutFilterUI
extends AbstractBillRediscountOutFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BillRediscountOutFilterUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    private boolean isSetParam = false;
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";

    protected void init() throws Exception {
        super.init();
        this.pkEndDate.setValue((Object)new Date());
        this.pkBizDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        FinUtils.initCurrencyComboBox((KDComboBox)this.combCurrency);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)company.getBaseCurrency());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        BillRediscountOutParam para = new BillRediscountOutParam();
        if (this.combCurrency.getSelectedItem() != null) {
            para.setCurrencyId(((CurrencyInfo)this.combCurrency.getSelectedItem()).getId().toString());
        }
        para.setCurrencyName((String)AccessHelper.getCboAttribute((KDComboBox)this.combCurrency, (String)"name"));
        para.setBizDate(DateTimeUtils.truncateDate((Date)this.pkBizDate.getSqlDate()));
        para.setEndDate(DateTimeUtils.truncateDate((Date)this.pkEndDate.getSqlDate()));
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof BillRediscountOutParam)) {
            return;
        }
        this.isSetParam = true;
        BillRediscountOutParam filterParam = (BillRediscountOutParam)param;
        String currencyId = filterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.pkBizDate.setValue((Object)filterParam.getBizDate());
        this.pkEndDate.setValue((Object)filterParam.getEndDate());
        this.isSetParam = false;
    }

    public void clear() {
        super.clear();
        this.pkEndDate.setValue((Object)new Date());
        this.pkBizDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)currency);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.pkBizDate, (String)"NoDate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.pkEndDate, (String)"NoDate");
        return super.verify();
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkBizDate_dataChanged(e);
        if (this.isSetParam) {
            return;
        }
        Date bizDate = null;
        Date endDate = null;
        bizDate = DateTimeUtils.truncateDate((Date)this.pkBizDate.getSqlDate());
        endDate = DateTimeUtils.truncateDate((Date)this.pkEndDate.getSqlDate());
        if (bizDate != null && endDate != null && bizDate.after(endDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerFilterStartDataMustBeforeEnd"));
            this.pkBizDate.setValue((Object)endDate);
            this.pkBizDate.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkEndDate_dataChanged(e);
        if (this.isSetParam) {
            return;
        }
        Date bizDate = null;
        Date endDate = null;
        bizDate = DateTimeUtils.truncateDate((Date)this.pkBizDate.getSqlDate());
        endDate = DateTimeUtils.truncateDate((Date)this.pkEndDate.getSqlDate());
        if (bizDate != null && endDate != null && bizDate.after(endDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerFilterEndDataMustAfterStart"));
            this.pkEndDate.setValue((Object)bizDate);
            this.pkEndDate.requestFocus();
            SysUtil.abort();
        }
    }

    protected Class getParamClass() {
        return BillRediscountOutParam.class;
    }
}

