/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.BillRediscountReturnInEntryFactory;
import com.kingdee.eas.fm.ibt.BillRediscountReturnInEntryInfo;
import com.kingdee.eas.fm.ibt.BillRediscountReturnInFactory;
import com.kingdee.eas.fm.ibt.BillRediscountReturnInInfo;
import com.kingdee.eas.fm.ibt.client.AbstractBillRediscountReturnInEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BillRediscountReturnInEditUI
extends AbstractBillRediscountReturnInEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BillRediscountReturnInEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";
    private boolean isCreateFromEntInnerBorReturnIn = false;
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    private boolean isInitNumber = false;
    private boolean isCreateFromEntRepayment = false;
    CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private double amount = 0.0;
    private BigDecimal parAmount;
    private CurrencyInfo currInfo = null;
    private int x = 2;
    private int y = 2;
    private int z = 2;
    private final String fileName = "/FM/IBT/BILLREDRETIN";

    public BillRediscountReturnInEditUI() throws Exception {
        this.initsetPrecision();
    }

    public void initsetPrecision() {
        if (this.prmtCurrency.getValue() != null) {
            try {
                this.currInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(((CurrencyInfo)this.prmtCurrency.getValue()).getId()));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            if (this.currInfo != null) {
                int p;
                this.x = p = this.currInfo.getPrecision();
                this.txtAmount.setPrecision(p);
                this.txtAmountLocalCur.setPrecision(2);
                if (this.prmtCurrency.getData() != null) {
                    CurrencyInfo curInfo = this.company.getBaseCurrency();
                    if (!curInfo.getId().equals((Object)this.currInfo.getId())) {
                        try {
                            ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.company, (CurrencyInfo)this.currInfo, (CurrencyInfo)curInfo, (Date)DateUtil.getDayBegin());
                            this.txtLocalCurExRate.setPrecision(exchangeRateInfo.getPrecision());
                            this.y = exchangeRateInfo.getPrecision();
                        }
                        catch (FinBizException e) {
                            this.handleException((Exception)((Object)e));
                        }
                        catch (EASBizException e) {
                            this.handleException((Exception)((Object)e));
                        }
                        catch (BOSException e) {
                            this.handleException((Exception)((Object)e));
                        }
                    } else {
                        this.txtLocalCurExRate.setPrecision(2);
                    }
                }
            }
        }
        if (this.company != null) {
            CurrencyInfo ctl = null;
            try {
                ctl = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId().toString()));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            if (ctl != null) {
                this.txtAmountLocalCur.setPrecision(ctl.getPrecision());
                this.z = ctl.getPrecision();
            }
        }
    }

    private static FinancingBillInfo getFinancingBill(String id) throws EASBizException, BOSException {
        SelectorItemCollection selectors = BillRediscountReturnInEditUI.getFinBillSelector();
        return (FinancingBillInfo)EJBAccessFactory.createRemoteInstance().getEntityInfo(id, selectors);
    }

    protected void initOldData(IObjectValue dataObject) {
        BillRediscountReturnInInfo info = (BillRediscountReturnInInfo)dataObject;
        if (info.getSourceBillId() != null && !"".equals(info.getSourceBillId())) {
            try {
                FinancingBillInfo finBillInfo = BillRediscountReturnInEditUI.getFinancingBill(info.getSourceBillId());
                info.setNumber(finBillInfo.getNumber());
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        super.initOldData(dataObject);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.oprtState)) {
            this.actionCreateFrom.setEnabled(true);
        } else {
            this.actionCreateFrom.setEnabled(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isRequired()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
    }

    private static SelectorItemCollection getFinBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("Type.id"));
        selector.add(new SelectorItemInfo("Type.number"));
        selector.add(new SelectorItemInfo("Type.name"));
        selector.add(new SelectorItemInfo("Currency.id"));
        selector.add(new SelectorItemInfo("Currency.number"));
        selector.add(new SelectorItemInfo("Currency.name"));
        selector.add(new SelectorItemInfo("Currency.precison"));
        selector.add(new SelectorItemInfo("Currency.*"));
        selector.add(new SelectorItemInfo("GaranteeType.id"));
        selector.add(new SelectorItemInfo("GaranteeType.number"));
        selector.add(new SelectorItemInfo("GaranteeType.name"));
        selector.add(new SelectorItemInfo("Institution.id"));
        selector.add(new SelectorItemInfo("Institution.number"));
        selector.add(new SelectorItemInfo("Institution.name"));
        selector.add(new SelectorItemInfo("Institution.BankAreaType"));
        selector.add(new SelectorItemInfo("assureBill.*"));
        selector.add(new SelectorItemInfo("assCurrency.*"));
        selector.add("*");
        return selector;
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtRediscountIn, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void onLoad() throws Exception {
        Object iPermission;
        FSClientHelper.checkClearingHouseCompany();
        this.prmtRediscountIn.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.initF7Filter();
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        this.prmtRediscountInBank.setSelectorCollection(sic);
        this.prmtRediscountInBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            String i = "0";
            if (this.CURRENT_COMPANY.getAccountBank() != null) {
                i = this.CURRENT_COMPANY.getAccountBank().isIsClosed() ? "0" : "1";
            }
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)i));
        }
        vi.setFilter(filter);
        this.prmtRediscountInBank.setEntityViewInfo(vi);
        this.kDTEntry.checkParsed();
        this.formatElements();
        this.stopElements();
        this.txtLocalCurExRate.setEnabled(false);
        if (this.company != null && "ADDNEW".equals(this.oprtState)) {
            iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), "fin_Repayment_addnew");
        }
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        if (this.getUIContext().get("InitDataObject") != null) {
            iPermission = (BillRediscountReturnInInfo)this.getUIContext().get("InitDataObject");
        }
        super.onLoad();
        BillRediscountReturnInInfo objectValue = new BillRediscountReturnInInfo();
        this.prmtCreator.setValue((Object)((UserInfo)SysContext.getSysContext().getCurrentUser()));
        this.initsetPrecision();
        if (this.editData.getEntry().get(0) != null) {
            this.loadEntrysBill();
        }
    }

    private void loadEntrysBill() {
        this.kDTEntry.removeRows(false);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setNumberFormat(BillRediscountReturnInEditUI.getNumberFtm(this.y));
        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes ssa = Styles.getEmptySA();
        ssa.setNumberFormat(BillRediscountReturnInEditUI.getNumberFtm(this.x));
        ssa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes saa = Styles.getEmptySA();
        saa.setNumberFormat(BillRediscountReturnInEditUI.getNumberFtm(this.z));
        saa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        BigDecimal total = new BigDecimal(String.valueOf(0));
        Iterator iter = this.editData.getEntry().iterator();
        while (iter.hasNext()) {
            BillRediscountReturnInEntryInfo billRediscountInfo = (BillRediscountReturnInEntryInfo)iter.next();
            try {
                billRediscountInfo = BillRediscountReturnInEntryFactory.getRemoteInstance().getBillRediscountReturnInEntryInfo((IObjectPK)new ObjectUuidPK(billRediscountInfo.getId()), this.getBillRediscSelector());
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            IRow row = this.kDTEntry.addRow();
            row.getCell("number").setValue((Object)billRediscountInfo.getNumber());
            row.getCell("currency").setValue((Object)billRediscountInfo.getCurrency());
            row.getCell("Amount").setValue((Object)billRediscountInfo.getAmount());
            row.getCell("Amount").setStyleAttributes(ssa);
            if (billRediscountInfo.getNumber().equals(EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean"))) {
                this.txtAmount.setValue((Object)billRediscountInfo.getAmount());
            }
            row.getCell("endDate").setValue((Object)billRediscountInfo.getDate());
            row.getCell("rate").setValue((Object)billRediscountInfo.getRate());
            row.getCell("rate").setStyleAttributes(sa);
            row.getCell("AmountLocalCur").setValue((Object)billRediscountInfo.getAmountLocalCur());
            row.getCell("AmountLocalCur").setStyleAttributes(saa);
            total = total.add(billRediscountInfo.getAmountLocalCur());
            if (row.getCell("number").getValue().toString() != EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean")) continue;
            row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            row.getStyleAttributes().setLocked(true);
        }
    }

    public void formatElements() {
        this.txtAmount.setHorizontalAlignment(4);
        BillRediscountReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        this.txtLocalCurExRate.setHorizontalAlignment(4);
        BillRediscountReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtLocalCurExRate);
        this.txtAmountLocalCur.setHorizontalAlignment(4);
        BillRediscountReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtAmountLocalCur);
        this.pkReturnDate.setValue((Object)DateUtil.getDayBegin());
    }

    public void stopElements() {
        this.comboRediscountType.setEnabled(false);
        this.prmtRediscountIn.setEnabled(false);
        this.txtAmount.setEnabled(false);
        this.prmtReturnCompany.setEnabled(false);
        this.txtLocalCurExRate.setEnabled(false);
        this.prmtCurrency.setEnabled(false);
        this.pkEndDate.setEnabled(false);
        this.kDTEntry.setEnabled(false);
        this.prmtAuditor.setEnabled(false);
        this.prmtCreator.setEnabled(false);
        this.txtAmountLocalCur.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.btnSave.setVisible(false);
    }

    public boolean checkElements() {
        if (this.pkReturnDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillRetpkReturnDate"));
            return false;
        }
        if (this.comboRediscountType.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillRetRediscountType"));
            return false;
        }
        if (this.prmtRediscountIn.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillRetRediscountIn"));
            return false;
        }
        if (this.prmtReturnCompany.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillRetReturnCompany"));
            return false;
        }
        if (this.prmtCurrency.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"Currency"));
            return false;
        }
        if (this.txtAmount.getText() == null || this.txtAmount.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillRetAmount"));
            return false;
        }
        if (this.txtLocalCurExRate.getText() == null || this.txtLocalCurExRate.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"LocalCurExRate"));
            return false;
        }
        if (this.txtAmountLocalCur.getText() == null || this.txtAmountLocalCur.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"AmountLocalCur"));
            return false;
        }
        if (this.pkEndDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillRetEndDate"));
            return false;
        }
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        if (this.isBotp()) {
            if (this.isCreateFromEntRepayment) {
                return;
            }
            this.comboRediscountType.setSelectedItem((Object)this.editData.getRediscountType());
            this.prmtRediscountIn.setValue((Object)this.editData.getRediscountIn());
            this.prmtReturnCompany.setValue((Object)this.editData.getReturnCompany());
            this.pkReturnDate.setValue((Object)DateUtil.getDayBegin());
            this.txtAmount.setValue((Object)this.editData.getAmount());
            if (this.editData.getAmount() != null) {
                this.amount = this.editData.getAmount().doubleValue();
            }
            this.prmtCurrency.setValue((Object)this.editData.getCurrency());
            this.txtLocalCurExRate.setValue((Object)this.editData.getLocalCurExRate());
            this.setDetachData();
            this.initsetPrecision();
            this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            Map dateMap = null;
            Date bizDate = null;
            Date endDate = null;
            try {
                dateMap = BillRediscountReturnInFactory.getRemoteInstance().getOldBillData(this.editData.getSourceBillId());
                if (dateMap != null) {
                    bizDate = (Date)dateMap.get("bizDate");
                    endDate = (Date)dateMap.get("endDate");
                    if (endDate != null) {
                        this.pkEndDate.setValue((Object)endDate);
                    }
                    if (dateMap.get("balance") != null) {
                        this.amount = Double.parseDouble(dateMap.get("balance").toString());
                        this.txtAmount.setValue(dateMap.get("balance"));
                    }
                }
                if (bizDate != null && endDate != null && (this.pkReturnDate.getSqlDate().before(bizDate) || this.pkReturnDate.getSqlDate().after(endDate))) {
                    this.pkReturnDate.setValue((Object)bizDate);
                    this.abort();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            Map map = null;
            try {
                map = BillRediscountReturnInFactory.getRemoteInstance().getOldCridit(this.editData.getSourceBillId());
            }
            catch (Exception e) {
                this.handleException(e);
            }
            if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtLocalCurExRate.getText() != null && this.txtLocalCurExRate.getText().trim().length() != 0) {
                double txtac = this.txtAmount.getBigDecimalValue().doubleValue() * this.txtLocalCurExRate.getBigDecimalValue().doubleValue();
                this.txtAmountLocalCur.setText(BillRediscountReturnInEditUI.doubleToStr(txtac, this.x));
                this.txtAmountLocalCur.setValue((Object)new BigDecimal(txtac));
            }
            this.storeFields();
        }
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.storeFields();
        this.setDetachData();
        this.initOldData((IObjectValue)this.editData);
        this.txtAmount.setValue((Object)this.parAmount);
        if (this.editData.getCurrency() != null) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            CurrencyInfo curInfo = this.editData.getCurrency();
            if (FinUtils.isBaseCurrency((CurrencyInfo)curInfo, (CompanyOrgUnitInfo)company)) {
                this.txtLocalCurExRate.setEnabled(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
            }
            curInfo = company.getBaseCurrency();
            if (this.currInfo != null && curInfo != null && !this.currInfo.getId().equals((Object)curInfo.getId())) {
                try {
                    ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)company, (CurrencyInfo)this.currInfo, (CurrencyInfo)curInfo, (Date)new Date());
                    this.txtLocalCurExRate.setPrecision(exchangeRateInfo.getPrecision());
                }
                catch (FinBizException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
        }
        if (this.editData.getCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString(), (FmRpcCacheInfo)this.rpcCacheInfo);
        }
        this.txtNumber.setEnabled(true);
    }

    public void createFromEntRepayment_actionPerformed(ActionEvent e) throws Exception {
        this.isCreateFromEntRepayment = true;
        FilterInfo filterInfo = new FilterInfo();
        HashMap<String, FilterInfo> ctx = new HashMap<String, FilterInfo>();
        ctx.put("DefaultQueryFilter", filterInfo);
        this.getBillEdit().createFrom(null, ctx);
    }

    public static String doubleToStr(double d, int fNumber) {
        if (fNumber < 0) {
            fNumber = 0;
        }
        String pattern = null;
        switch (fNumber) {
            case 0: {
                pattern = "#0";
                break;
            }
            default: {
                pattern = "#0.";
                StringBuffer b = new StringBuffer(pattern);
                for (int i = 0; i < fNumber; ++i) {
                    b.append('#');
                }
                pattern = b.toString();
            }
        }
        DecimalFormat formatter = new DecimalFormat();
        formatter.applyPattern(pattern);
        String value = formatter.format(d);
        return value;
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLocalCurExRate_dataChanged(e);
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtLocalCurExRate.getText() != null && this.txtLocalCurExRate.getText().trim().length() != 0) {
            double txtac = this.txtAmount.getBigDecimalValue().doubleValue() * this.txtLocalCurExRate.getBigDecimalValue().doubleValue();
            this.txtAmountLocalCur.setText(BillRediscountReturnInEditUI.doubleToStr(txtac, this.x));
            this.txtAmountLocalCur.setValue((Object)new BigDecimal(txtac));
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkElements()) {
            super.verifyData();
            double amountValue = this.txtAmount.getBigDecimalValue().doubleValue();
            String billID = this.editData.getSourceBillId();
            super.actionSubmit_actionPerformed(e);
            double balance = this.amount - amountValue;
            BillRediscountReturnInFactory.getRemoteInstance().turnWriteBalance(billID, balance);
            BillRediscountReturnInFactory.getRemoteInstance().turnWriteReceivableBill(billID);
        }
        this.clearElements();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.amount = 0.0;
        this.txtAmount.setValue(null);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void initEnCurrency() {
        KDBizPromptBox prmtEnCurrency = new KDBizPromptBox();
        ExtendParser parserCurrency = new ExtendParser(prmtEnCurrency);
        prmtEnCurrency.setCommitParser((IParser)parserCurrency);
        prmtEnCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        prmtEnCurrency.setVisible(true);
        prmtEnCurrency.setRequired(true);
        prmtEnCurrency.setEditable(true);
        prmtEnCurrency.setDisplayFormat("$name$");
        prmtEnCurrency.setEditFormat("$number$");
        prmtEnCurrency.setCommitFormat("$number$");
        prmtEnCurrency.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prmtEnCurrency));
        ObjectValueRender avrCurrency = new ObjectValueRender();
        avrCurrency.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kDTEntry.getColumn("currency").setRenderer((IBasicRender)avrCurrency);
        this.kDTEntry.getColumn("currency").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtEnCurrency));
    }

    public void setDetachData() {
        this.kDTEntry.removeRows();
        if (this.editData.getSourceBillId() != null) {
            String billNumber = this.editData.getSourceBillId().toString();
            List dataList = null;
            try {
                dataList = BillRediscountReturnInFactory.getRemoteInstance().getDetachList(billNumber);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            Map mData = new HashMap();
            for (int i = 0; i < dataList.size(); ++i) {
                Map dataMap = (Map)dataList.get(i);
                if (dataMap.get("billNumber") != null && dataMap.get("billNumber").equals(EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean"))) {
                    mData = dataMap;
                    continue;
                }
                IRow iRow = this.fillRow(dataMap, true);
            }
            if (mData != null) {
                IRow row = this.fillRow(mData, false);
                StyleAttributes sa = Styles.getEmptySA();
                sa.setBackground(new Color(0xF6F6B6));
                row.setStyleAttributes(sa);
            }
            this.refreshFootROw(this.kDTEntry);
        }
    }

    private IRow fillRow(Map dataMap, boolean flag) {
        Object baseNumberFormat = null;
        StyleAttributes sa = Styles.getEmptySA();
        sa.setNumberFormat(BillRediscountReturnInEditUI.getNumberFtm(this.y));
        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes ssa = Styles.getEmptySA();
        ssa.setNumberFormat(BillRediscountReturnInEditUI.getNumberFtm(this.x));
        ssa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes saa = Styles.getEmptySA();
        saa.setNumberFormat(BillRediscountReturnInEditUI.getNumberFtm(this.z));
        saa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IRow row = this.kDTEntry.addRow();
        if (dataMap.get("billNumber") != null) {
            row.getCell("number").setValue(dataMap.get("billNumber"));
        }
        this.initEnCurrency();
        if (dataMap.get("currency") != null) {
            try {
                row.getCell("currency").setValue((Object)CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)dataMap.get("currency").toString()))));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (UuidException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        if (dataMap.get("billFaceAmount") != null) {
            row.getCell("Amount").setValue((Object)new BigDecimal(dataMap.get("billFaceAmount").toString()));
        }
        row.getCell("Amount").setStyleAttributes(ssa);
        if (!flag) {
            this.parAmount = (BigDecimal)dataMap.get("billFaceAmount");
        }
        if (dataMap.get("endDate") != null) {
            row.getCell("endDate").setValue((Object)((Date)dataMap.get("endDate")));
        }
        if (dataMap.get("rate") != null) {
            row.getCell("rate").setValue((Object)new BigDecimal(dataMap.get("rate").toString()));
        }
        row.getCell("rate").setStyleAttributes(sa);
        if (dataMap.get("amountLocalCur") != null) {
            row.getCell("AmountLocalCur").setValue((Object)new BigDecimal(dataMap.get("amountLocalCur").toString()));
        }
        row.getCell("AmountLocalCur").setStyleAttributes(saa);
        return row;
    }

    public static String getNumberFtm(int len) {
        StringBuffer numberFormate = new StringBuffer("##,###,###,###,###,##0.");
        for (int i = 0; i < len; ++i) {
            numberFormate.append("0");
        }
        return numberFormate.toString();
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.txtAmount.setValue(null);
        this.isCreateFromEntInnerBorReturnIn = false;
        IBTPBillEdit billEdit = this.getBillEdit();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TargetBillType", "-");
        map.put("fromRepayment", "fromRepayment");
        billEdit.createFrom(null, map);
        this.setDetachData();
        this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    private boolean isBotp() {
        int status;
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        return this.getUIContext().get("BOTPViewStatus") instanceof Integer && (status = ((Integer)this.getUIContext().get("BOTPViewStatus")).intValue()) == 1;
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionSendingMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendingMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actionViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSignature_actionPerformed(e);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBdgBalance_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BillRediscountReturnInFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        BillRediscountReturnInInfo objectValue = new BillRediscountReturnInInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        return objectValue;
    }

    protected void applyDefaultValue(IObjectValue vo) {
        super.applyDefaultValue(vo);
    }

    @Override
    protected void pkReturnDate_dataChanged(DataChangeEvent e) throws Exception {
        Map dateMap = null;
        Date bizDate = null;
        Date endDate = null;
        try {
            if (this.editData.getSourceBillId() != null) {
                dateMap = BillRediscountReturnInFactory.getRemoteInstance().getOldBillData(this.editData.getSourceBillId());
                if (dateMap != null) {
                    bizDate = (Date)dateMap.get("bizDate");
                    endDate = (Date)dateMap.get("endDate");
                }
                if (this.pkReturnDate.getSqlDate().before(bizDate) || this.pkReturnDate.getSqlDate().after(endDate)) {
                    if (!this.isFirstOnload()) {
                        this.pkReturnDate.setValue((Object)bizDate);
                    }
                    this.abort();
                }
            }
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.amount != 0.0 && this.txtAmount.getBigDecimalValue().doubleValue() > this.amount) {
            this.txtAmount.setValue((Object)new BigDecimal(this.amount));
            this.abort();
        }
        this.pkReturnDate_dataChanged(e);
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtLocalCurExRate.getText() != null && this.txtLocalCurExRate.getText().trim().length() != 0) {
            double txtac = this.txtAmount.getBigDecimalValue().doubleValue() * this.txtLocalCurExRate.getBigDecimalValue().doubleValue();
            this.txtAmountLocalCur.setText(BillRediscountReturnInEditUI.doubleToStr(txtac, this.x));
        }
        super.txtAmount_dataChanged(e);
    }

    public static void initCurrencyField(BasicFormattedTextField txt) {
        txt.setHorizontalAlignment(4);
        if (txt instanceof KDFormattedTextField) {
            KDFormattedTextField ftTxt = (KDFormattedTextField)txt;
            ftTxt.setDataType(BigDecimal.class);
            ftTxt.setRemoveingZeroInDispaly(false);
            ftTxt.setRemoveingZeroInEdit(true);
        } else if (txt instanceof KDNumberTextField) {
            KDNumberTextField numText = (KDNumberTextField)txt;
            numText.setDataType(BigDecimal.class);
            numText.setRemoveingZeroInDispaly(false);
            numText.setRemoveingZeroInEdit(true);
        }
    }

    protected SelectorItemCollection getBillRediscSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("localCurExRate"));
        sic.add(new SelectorItemInfo("amountLocalCur"));
        return sic;
    }

    @Override
    public void actionTDPri_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPri_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = (ArrayList)this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.print("/FM/IBT/BILLREDRETIN", (Object)data, (Component)((Object)this));
    }

    private IMetaDataPK getTDQueryName() {
        return new MetaDataPK("com.kingdee.eas.fm.ibt.app.BillRediscountReturnInF7Query");
    }

    @Override
    public void actionTDPriView_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPriView_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = (ArrayList)this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.printPreview("/FM/IBT/BILLREDRETIN", (Object)data, (Component)((Object)this));
    }

    public void clearElements() {
        this.txtRemark.setText(null);
        this.txtNumber.setText(null);
        this.txtAmount.setText(null);
        this.txtReturnBank.setText(null);
        this.txtAmountLocalCur.setText(null);
        this.prmtRediscountInBank.setValue(null);
        this.pkEndDate.setValue(null);
        this.amount = 0.0;
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }
}

