/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.BillRediscountReturnOutCollection;
import com.kingdee.eas.fm.ibt.BillRediscountReturnOutFactory;
import com.kingdee.eas.fm.ibt.BillRediscountReturnOutInfo;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.IBillRediscountReturnOut;
import com.kingdee.eas.fm.ibt.client.AbstractBillRediscountReturnOutListUI;
import com.kingdee.eas.fm.ibt.client.BillRediscountReturnFilterParam;
import com.kingdee.eas.fm.ibt.client.BillRediscountReturnOutEditUI;
import com.kingdee.eas.fm.ibt.client.BillRediscountReturnOutFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillRediscountReturnOutListUI
extends AbstractBillRediscountReturnOutListUI {
    private static final Logger logger = CoreUIObject.getLogger(BillRediscountReturnOutListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";
    private BillRediscountReturnOutFilterUI filterReturnOut;
    private String selectID = null;
    private final String fileName = "/FM/IBT/BILLREDRETOUT";

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
        super.onLoad();
        this.actionEdit.setEnabled(false);
        this.btnVoucher.setVisible(true);
        this.btnVoucher.setEnabled(true);
        this.btnCreateTo.setVisible(false);
        this.traceDownFormat();
    }

    public void traceDownFormat() {
        if (this.getUIContext().get("hidenBar") != null && this.getUIContext().get("hidenBar").equals("hiden")) {
            this.menuBiz.setVisible(false);
            this.menuEdit.setVisible(false);
            this.menuTool.setVisible(false);
            this.menuWorkFlow.setVisible(false);
            this.menuFile.setVisible(true);
            this.menuView.setVisible(true);
            this.btnView.setVisible(true);
            this.menuItemAddNew.setVisible(false);
            this.MenuItemAttachment.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.btnAntiAudit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.btnRefresh.setVisible(false);
            this.btnAttachment.setVisible(false);
            this.btnAuditResult.setVisible(false);
            this.btnCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.btnCopyTo.setVisible(false);
            this.btnCreateTo.setVisible(false);
            this.btnDelVoucher.setVisible(false);
            this.btnEdit.setVisible(false);
            this.btnPageSetup.setVisible(false);
            this.btnWorkFlowG.setVisible(false);
            this.btnQuery.setVisible(false);
            this.btnTDPri.setVisible(false);
            this.btnTDPriView.setVisible(false);
            this.btnLocate.setVisible(false);
            this.btnAudit.setVisible(false);
            this.btnVoucher.setVisible(false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BillRediscountReturnOutFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getSelectManager().size() > 0) {
            if (this.getSelectedFieldValues("isVoucher").get(0).equals("true")) {
                this.actionVoucher.setEnabled(false);
            } else {
                this.actionVoucher.setEnabled(true);
            }
        }
        super.tblMain_tableSelectChanged(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedIdValues().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CheckSelectEmpty"));
            this.abort();
        }
        if (this.getSelectedIdValues().size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CheckSelectAll"));
            this.abort();
        }
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        BillRediscountReturnOutInfo info = (BillRediscountReturnOutInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
        String sourceBillId = info.getSourceBillId().toString();
        if (info.getBillType() == BillTypeEnum.Audit) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CheckAuditDel"));
            this.abort();
        } else {
            Map mapData = BillRediscountReturnOutFactory.getRemoteInstance().getOldCridit(sourceBillId);
            super.actionRemove_actionPerformed(e);
            if (mapData.get("balance") != null) {
                BigDecimal returnAmount = info.getAmount();
                BigDecimal balance = new BigDecimal(mapData.get("balance").toString()).add(returnAmount);
                BillRediscountReturnOutFactory.getRemoteInstance().turnWriteBalance(sourceBillId, balance);
            }
            if (sourceBillId != null) {
                BillRediscountReturnOutFactory.getRemoteInstance().turnWriteReceivableBill(sourceBillId, false);
            }
            if (info.getCreditLimit() != null) {
                String creditId = info.getCreditLimit().getId().toString();
                BillRediscountReturnOutFactory.getRemoteInstance().reduceQuantum(info.getCreditLocalAmt(), info.getBalance(), creditId, sourceBillId);
            }
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyTo_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.selectID = this.getSelectedKeyValue();
        this.checkCanVoucher(0);
        super.actionVoucher_actionPerformed(e);
        if (this.selectID == this.getSelectedKeyValue()) {
            this.btnVoucher.setEnabled(false);
        }
    }

    private void checkCanVoucher(int type) throws Exception {
        this.checkSelected();
        BillRediscountReturnOutInfo BillReturnOutInfo = BillRediscountReturnOutFactory.getRemoteInstance().getBillRediscountReturnOutInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (BillReturnOutInfo.getBillType() != null && BillReturnOutInfo.getBillType() != BillTypeEnum.Audit) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"OnlyAuditCantoVoucher"));
            this.abort();
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionSendSmsMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendSmsMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actoinViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actoinViewSignature_actionPerformed(e);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBdgBalance_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        BillRediscountReturnOutInfo objectValue = new BillRediscountReturnOutInfo();
        return objectValue;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterReturnOut == null) {
            this.filterReturnOut = new BillRediscountReturnOutFilterUI();
        }
        return this.filterReturnOut;
    }

    protected String getEditUIName() {
        return BillRediscountReturnOutEditUI.class.getName();
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        BillRediscountReturnOutCollection col = this.getLoanColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            BillRediscountReturnOutInfo info = col.get(i);
            if (this.getSelectedFieldValues("isVoucher").get(0).equals("true")) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerToVoucherNoAnitAudit"));
                this.abort();
            }
            if (info.getBillType() == BillTypeEnum.Submit) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SubmitBillnoAntiAudit"));
                this.abort();
            }
            if (FinHelper.hasDeferRecordOfLoan((String)info.getId().toString()) && FinHelper.hasIntRecordOfLoan((String)info.getId().toString()) && FinHelper.hasRepaymentOfLoan((String)info.getId().toString())) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"10_BillRediscountReturnInListUI"));
            this.abort();
        }
        BillRediscountReturnOutFactory.getRemoteInstance().batchAntiAudit(idSet);
        this.showMsg(e);
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        String id = this.getSelectedKeyValue();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        String[] ids = idList.toArray(new String[idList.size()]);
        IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
        String[] idsInProcess = service2.checkBizObjInWfProcess(ids);
        if (idsInProcess != null && idsInProcess.length > 0) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        HashSet idSet = new HashSet(idList);
        BillRediscountReturnOutCollection col = this.getLoanColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            BillRediscountReturnOutInfo info = col.get(i);
            if (info.getBillType() != BillTypeEnum.Audit) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"ThisIsAudited"));
            this.abort();
        }
        BillRediscountReturnOutFactory.getRemoteInstance().batchAudit(idSet);
        this.showMsg(e);
        IBillRediscountReturnOut BillReturnOut = BillRediscountReturnOutFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BillRediscountReturnOutInfo billInfo = BillReturnOut.getBillRediscountReturnOutInfo((IObjectPK)pk);
        if (BillTypeEnum.Submit.equals((Object)billInfo.getBillType())) {
            BillReturnOut.audit((IObjectPK)pk);
            this.refreshList();
            SysUtil.abort();
        }
    }

    protected BillRediscountReturnOutCollection getLoanColl(Set idSet) throws BOSException, Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return ((IBillRediscountReturnOut)this.getBizInterface()).getBillRediscountReturnOutCollection(evi);
    }

    private void showMsg(ActionEvent e) throws Exception {
        this.refresh(e);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            BillRediscountReturnFilterParam param = (BillRediscountReturnFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyId());
            String[] columns = new String[]{"Amount", "AmountLocalCur"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void actionTDPri_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPri_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.print("/FM/IBT/BILLREDRETOUT", (Object)data, (Component)((Object)this));
    }

    private IMetaDataPK getTDQueryName() {
        return new MetaDataPK("com.kingdee.eas.fm.ibt.app.BillRediscountReturnOutF7Query");
    }

    @Override
    public void actionTDPriView_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPriView_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.printPreview("/FM/IBT/BILLREDRETOUT", (Object)data, (Component)((Object)this));
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell(this.getCurrencyIdColName()).getValue();
            if (currencyId == null) continue;
            FMClientHelper.setNumberFormat((IRow)row, (String)"Amount", (String)currencyId);
        }
    }

    protected String getCurrencyIdColName() {
        return "currencyID";
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            BillRediscountReturnOutListUI.this.setListUITable(BillRediscountReturnOutListUI.this.tblMain, e);
        }
    }
}

