/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.CreditAssetsReturnInFactory;
import com.kingdee.eas.fm.ibt.CreditAssetsReturnInInfo;
import com.kingdee.eas.fm.ibt.client.AbstractCreditAssetsReturnInEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditAssetsReturnInEditUI
extends AbstractCreditAssetsReturnInEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditAssetsReturnInEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";
    CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private boolean isInitNumber = false;
    private boolean isCreateFromEntInnerBorReturnIn = false;
    private boolean isCreateFromEntRepayment = false;
    private double amount = 0.0;
    private final String fileName = "/FM/IBT/CREDITASSETSRETURNIN";

    public CreditAssetsReturnInEditUI() throws Exception {
        this.initsetPrecision();
    }

    public void initsetPrecision() {
        if (this.prmtCurrency.getValue() != null) {
            CurrencyInfo currInfo = null;
            try {
                currInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(((CurrencyInfo)this.prmtCurrency.getValue()).getId()));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            if (currInfo != null) {
                int p = currInfo.getPrecision();
                this.txtAmount.setPrecision(p);
                this.txtLocalCurExRate.setPrecision(p);
                this.txtAmountLocalCur.setPrecision(p);
                this.txtMainRateAggregate.setPrecision(p);
                this.txtAccrual.setPrecision(p);
                if (this.prmtCurrency.getValue() != null) {
                    CurrencyInfo curInfo = this.company.getBaseCurrency();
                    if (!curInfo.getId().equals((Object)currInfo.getId())) {
                        try {
                            ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.company, (CurrencyInfo)currInfo, (CurrencyInfo)curInfo, (Date)DateUtil.getDayBegin());
                            this.txtLocalCurExRate.setPrecision(exchangeRateInfo.getPrecision());
                        }
                        catch (FinBizException e) {
                            this.handleException((Exception)((Object)e));
                        }
                        catch (EASBizException e) {
                            this.handleException((Exception)((Object)e));
                        }
                        catch (BOSException e) {
                            this.handleException((Exception)((Object)e));
                        }
                    } else {
                        this.txtLocalCurExRate.setPrecision(2);
                    }
                }
            }
        }
        if (this.company != null) {
            CurrencyInfo ctl = null;
            try {
                ctl = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId().toString()));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            if (ctl != null) {
                this.txtAmountLocalCur.setPrecision(ctl.getPrecision());
            }
        }
    }

    private static FinancingBillInfo getFinancingBill(String id) throws EASBizException, BOSException {
        SelectorItemCollection selectors = CreditAssetsReturnInEditUI.getFinBillSelector();
        return (FinancingBillInfo)EJBAccessFactory.createRemoteInstance().getEntityInfo(id, selectors);
    }

    protected void initOldData(IObjectValue dataObject) {
        CreditAssetsReturnInInfo info = (CreditAssetsReturnInInfo)dataObject;
        if (info.getSourceBillId() != null && !"".equals(info.getSourceBillId())) {
            try {
                FinancingBillInfo finBillInfo = CreditAssetsReturnInEditUI.getFinancingBill(info.getSourceBillId());
                info.setNumber(finBillInfo.getNumber());
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        super.initOldData(dataObject);
    }

    private static SelectorItemCollection getFinBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("Type.id"));
        selector.add(new SelectorItemInfo("Type.number"));
        selector.add(new SelectorItemInfo("Type.name"));
        selector.add(new SelectorItemInfo("Currency.id"));
        selector.add(new SelectorItemInfo("Currency.number"));
        selector.add(new SelectorItemInfo("Currency.name"));
        selector.add(new SelectorItemInfo("GaranteeType.id"));
        selector.add(new SelectorItemInfo("GaranteeType.number"));
        selector.add(new SelectorItemInfo("GaranteeType.name"));
        selector.add(new SelectorItemInfo("Institution.id"));
        selector.add(new SelectorItemInfo("Institution.number"));
        selector.add(new SelectorItemInfo("Institution.name"));
        selector.add(new SelectorItemInfo("Institution.BankAreaType"));
        selector.add(new SelectorItemInfo("assureBill.*"));
        selector.add(new SelectorItemInfo("assCurrency.*"));
        selector.add("*");
        return selector;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.oprtState)) {
            this.actionCreateFrom.setEnabled(true);
        } else {
            this.actionCreateFrom.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        Object iPermission;
        FSClientHelper.checkClearingHouseCompany();
        this.initF7Filter();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        this.prmtBuyInBank.setSelectorCollection(sic);
        this.prmtBuyInBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            String i = "0";
            if (this.company.getAccountBank() != null) {
                i = this.company.getAccountBank().isIsClosed() ? "0" : "1";
            }
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)i));
        }
        vi.setFilter(filter);
        this.prmtBuyInBank.setEntityViewInfo(vi);
        if (this.company != null && "ADDNEW".equals(this.oprtState)) {
            iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), "fin_Repayment_addnew");
        }
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        if (this.getUIContext().get("InitDataObject") != null) {
            iPermission = (CreditAssetsReturnInInfo)this.getUIContext().get("InitDataObject");
        }
        this.formatElements();
        this.stopElements();
        this.txtAmount.setPrecision(2);
        super.onLoad();
        CreditAssetsReturnInInfo objectValue = new CreditAssetsReturnInInfo();
        this.prmtCreator.setValue((Object)((UserInfo)SysContext.getSysContext().getCurrentUser()));
        this.initsetPrecision();
        this.txtYearRate.setRemoveingZeroInDispaly(false);
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBargainor, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void formatElements() {
        this.txtAmount.setHorizontalAlignment(4);
        CreditAssetsReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        this.txtLocalCurExRate.setHorizontalAlignment(4);
        CreditAssetsReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtLocalCurExRate);
        this.txtAmountLocalCur.setHorizontalAlignment(4);
        CreditAssetsReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtAmountLocalCur);
        this.txtYearRate.setHorizontalAlignment(4);
        CreditAssetsReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtYearRate);
        this.txtAccrual.setHorizontalAlignment(4);
        CreditAssetsReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtAccrual);
        this.txtMainRateAggregate.setHorizontalAlignment(4);
        CreditAssetsReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtMainRateAggregate);
        this.pkReturnDate.setValue((Object)DateUtil.getDayBegin());
    }

    public void stopElements() {
        this.comboTransferMode.setEnabled(false);
        this.prmtAlienee.setEnabled(false);
        this.prmtBargainor.setEnabled(false);
        this.txtLocalCurExRate.setEnabled(false);
        this.prmtCurrency.setEnabled(false);
        this.pkConferReturnDate.setEnabled(false);
        this.txtCreditName.setEnabled(false);
        this.prmtAuditor.setEnabled(false);
        this.prmtCreator.setEnabled(false);
        this.txtAmountLocalCur.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.txtYearRate.setEnabled(false);
        this.txtMainRateAggregate.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.btnSave.setVisible(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isRequired()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
    }

    public boolean checkElements() {
        if (this.pkReturnDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillRetpkReturnDate"));
            return false;
        }
        if (this.comboTransferMode.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditRetTransferMode"));
            return false;
        }
        if (this.prmtAlienee.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditRetAlienee"));
            return false;
        }
        if (this.prmtBargainor.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillRetReturnCompany"));
            return false;
        }
        if (this.prmtCurrency.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"Currency"));
            return false;
        }
        if (this.txtAmount.getText() == null || this.txtAmount.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BillRetAmount"));
            return false;
        }
        if (this.txtLocalCurExRate.getText() == null || this.txtLocalCurExRate.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"LocalCurExRate"));
            return false;
        }
        if (this.txtAmountLocalCur.getText() == null || this.txtAmountLocalCur.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"AmountLocalCur"));
            return false;
        }
        if (this.pkConferReturnDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditRetConferDate"));
            return false;
        }
        return true;
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtAmount.getBigDecimalValue() == null) {
            return;
        }
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.amount != 0.0 && this.txtAmount.getBigDecimalValue().doubleValue() > this.amount) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditRetBigAmount"));
            this.txtAmount.setValue((Object)new BigDecimal(this.amount));
            this.abort();
        }
        if (this.editData.getIssueDate() != null && this.pkReturnDate.getSqlDate() != null) {
            int day = CreditAssetsReturnInEditUI.getDiffDays(this.editData.getIssueDate(), this.pkReturnDate.getSqlDate());
            double accrual = this.txtAmount.getBigDecimalValue().doubleValue() * this.txtYearRate.getBigDecimalValue().doubleValue() * (double)(day - 1) / 36000.0;
            this.txtAccrual.setText(CreditAssetsReturnInEditUI.doubleToStr(accrual, 2));
            this.txtAccrual.setValue((Object)new BigDecimal(CreditAssetsReturnInEditUI.doubleToStr(accrual, 2)));
        }
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtLocalCurExRate.getText() != null && this.txtLocalCurExRate.getText().trim().length() != 0) {
            double txtac = this.txtAmount.getBigDecimalValue().doubleValue() * this.txtLocalCurExRate.getBigDecimalValue().doubleValue();
            this.txtAmountLocalCur.setText(CreditAssetsReturnInEditUI.doubleToStr(txtac, 2));
        }
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtAccrual.getText() != null && this.txtAccrual.getText().trim().length() != 0) {
            double txtaccr = this.txtAmount.getBigDecimalValue().doubleValue() + this.txtAccrual.getBigDecimalValue().doubleValue();
            this.txtMainRateAggregate.setText(CreditAssetsReturnInEditUI.doubleToStr(txtaccr, 2));
            this.txtMainRateAggregate.setValue((Object)new BigDecimal(txtaccr));
        }
        super.txtAmount_dataChanged(e);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkElements()) {
            this.verify(e);
            this.editData.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
            CreditAssetsReturnInFactory.getRemoteInstance().checkNumberDup(null, (CoreBillBaseInfo)this.editData);
            this.storeFields();
            double amt = this.txtAmount.getBigDecimalValue().doubleValue();
            String billID = this.editData.getSourceBillId();
            super.actionSubmit_actionPerformed(e);
            double balance = this.amount - amt;
            CreditAssetsReturnInFactory.getRemoteInstance().turnWriteBalance(billID, balance);
        }
        this.clearElements();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.amount = 0.0;
        this.txtAmount.setValue(null);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    @Override
    protected void pkReturnDate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isFirstOnload()) {
            Map dateMap = null;
            Date bizDate = null;
            Date endDate = null;
            try {
                if (this.editData.getSourceBillId() != null) {
                    dateMap = CreditAssetsReturnInFactory.getRemoteInstance().getOldBillData(this.editData.getSourceBillId());
                    if (dateMap != null && this.editData.getIssueDate() != null) {
                        bizDate = this.editData.getIssueDate();
                        endDate = (Date)dateMap.get("endDate");
                    }
                    if (this.pkReturnDate.getSqlDate().before(bizDate) || this.pkReturnDate.getSqlDate().after(endDate)) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditRetBigDate"));
                        this.pkReturnDate.setValue((Object)bizDate);
                        this.abort();
                    }
                }
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            if (this.txtYearRate.getValue() != null) {
                double yearRate = Double.parseDouble(this.txtYearRate.getValue().toString());
                this.txtYearRate.setPrecision(4);
                if (this.editData.getIssueDate() != null && this.pkReturnDate.getSqlDate() != null) {
                    int day = CreditAssetsReturnInEditUI.getDiffDays(this.editData.getIssueDate(), this.pkReturnDate.getSqlDate());
                    double accrual = Double.parseDouble(this.editData.getAmount().toString()) * yearRate * (double)(day - 1) / 36000.0;
                    this.txtAccrual.setText(CreditAssetsReturnInEditUI.doubleToStr(accrual, 2));
                    this.txtAccrual.setValue((Object)new BigDecimal(CreditAssetsReturnInEditUI.doubleToStr(accrual, 2)));
                }
            }
            if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtAccrual.getText() != null && this.txtAccrual.getText().trim().length() != 0) {
                double txtaccr = this.txtAmount.getBigDecimalValue().doubleValue() + this.txtAccrual.getBigDecimalValue().doubleValue();
                this.txtMainRateAggregate.setText(CreditAssetsReturnInEditUI.doubleToStr(txtaccr, 2));
                this.txtMainRateAggregate.setValue((Object)new BigDecimal(txtaccr));
            }
        }
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.amount != 0.0 && this.txtAmount.getBigDecimalValue().doubleValue() > this.amount) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditRetBigAmount"));
            this.txtAmount.setValue((Object)new BigDecimal(this.amount));
            this.abort();
        }
        this.pkReturnDate_dataChanged(e);
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtLocalCurExRate.getText() != null && this.txtLocalCurExRate.getText().trim().length() != 0) {
            double txtac = this.txtAmount.getBigDecimalValue().doubleValue() * this.txtLocalCurExRate.getBigDecimalValue().doubleValue();
            this.txtAmountLocalCur.setText(CreditAssetsReturnInEditUI.doubleToStr(txtac, 2));
        }
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtAccrual.getText() != null && this.txtAccrual.getText().trim().length() != 0) {
            double txtaccr = this.txtAmount.getBigDecimalValue().doubleValue() + this.txtAccrual.getBigDecimalValue().doubleValue();
            this.txtMainRateAggregate.setText(CreditAssetsReturnInEditUI.doubleToStr(txtaccr, 2));
            this.txtMainRateAggregate.setValue((Object)new BigDecimal(txtaccr));
        }
        super.txtLocalCurExRate_dataChanged(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.txtAmount.setValue(null);
        this.isCreateFromEntInnerBorReturnIn = false;
        IBTPBillEdit billEdit = this.getBillEdit();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TargetBillType", "-");
        map.put("fromRepayment", "fromRepayment");
        billEdit.createFrom(null, map);
        this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionSendingMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendingMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actionViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSignature_actionPerformed(e);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBdgBalance_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CreditAssetsReturnInFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        CreditAssetsReturnInInfo objectValue = new CreditAssetsReturnInInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        return objectValue;
    }

    public static void initCurrencyField(BasicFormattedTextField txt) {
        txt.setHorizontalAlignment(4);
        if (txt instanceof KDFormattedTextField) {
            KDFormattedTextField ftTxt = (KDFormattedTextField)txt;
            ftTxt.setDataType(BigDecimal.class);
            ftTxt.setRemoveingZeroInDispaly(false);
            ftTxt.setRemoveingZeroInEdit(true);
        } else if (txt instanceof KDNumberTextField) {
            KDNumberTextField numText = (KDNumberTextField)txt;
            numText.setDataType(BigDecimal.class);
            numText.setRemoveingZeroInDispaly(false);
            numText.setRemoveingZeroInEdit(true);
        }
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    public void loadFields() {
        if (this.isBotp() && !this.isCreateFromEntRepayment) {
            this.comboTransferMode.setSelectedItem((Object)this.editData.getBillType());
            this.prmtAlienee.setValue((Object)this.editData.getTransferIn());
            this.prmtBargainor.setValue((Object)this.editData.getTransferOut());
            this.pkReturnDate.setValue((Object)DateUtil.getDayBegin());
            this.pkConferReturnDate.setValue((Object)this.editData.getConferReturnDate());
            this.pkConferReturnDate.setValue((Object)this.editData.getIssueDate());
            this.txtYearRate.setValue((Object)this.editData.getYearRate());
            this.prmtCurrency.setValue((Object)this.editData.getCurrency());
            this.txtLocalCurExRate.setValue((Object)this.editData.getLocalCurExRate());
            if (this.editData.getCreditName() != null) {
                this.txtCreditName.setText(this.editData.getCreditName());
            }
            this.initsetPrecision();
            CreditLimitInfo clInfo = null;
            if (this.editData.getCreditLimit() != null) {
                String pk = this.editData.getCreditLimit().getId().toString();
                ObjectStringPK ibpk = new ObjectStringPK(pk);
                try {
                    clInfo = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo((IObjectPK)ibpk, this.getSelectors());
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
            this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            Map dateMap = null;
            Date bizDate = null;
            Date endDate = null;
            try {
                dateMap = CreditAssetsReturnInFactory.getRemoteInstance().getOldBillData(this.editData.getSourceBillId());
                if (dateMap != null && this.editData.getIssueDate() != null) {
                    bizDate = this.editData.getIssueDate();
                    endDate = (Date)dateMap.get("endDate");
                    if (dateMap.get("balance") != null) {
                        this.amount = Double.parseDouble(dateMap.get("balance").toString());
                        this.txtAmount.setValue(dateMap.get("balance"));
                    }
                }
                if (bizDate != null && endDate != null && (this.pkReturnDate.getSqlDate().before(bizDate) || this.pkReturnDate.getSqlDate().after(endDate))) {
                    this.pkReturnDate.setValue((Object)bizDate);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            Map map = null;
            try {
                map = CreditAssetsReturnInFactory.getRemoteInstance().getOldCridit(this.editData.getSourceBillId());
            }
            catch (Exception e) {
                this.handleException(e);
            }
            if (map.size() != 0) {
                if (map.get("balance") != null) {
                    this.amount = Double.parseDouble(map.get("balance").toString());
                }
                this.txtAmount.setValue((Object)new Double(this.amount));
                double yearRate = Double.parseDouble(map.get("yearRate").toString());
                this.txtYearRate.setValue(map.get("yearRate"));
                this.txtYearRate.setPrecision(4);
                if (this.editData.getIssueDate() != null && this.pkReturnDate.getSqlDate() != null) {
                    int day = CreditAssetsReturnInEditUI.getDiffDays(this.editData.getIssueDate(), this.pkReturnDate.getSqlDate());
                    double accrual = this.amount * yearRate * (double)(day - 1) / 36000.0;
                    this.txtAccrual.setText(CreditAssetsReturnInEditUI.doubleToStr(accrual, 2));
                    this.txtAccrual.setValue((Object)new BigDecimal(CreditAssetsReturnInEditUI.doubleToStr(accrual, 2)));
                }
            }
            if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtLocalCurExRate.getText() != null && this.txtLocalCurExRate.getText().trim().length() != 0) {
                double txtac = this.txtAmount.getBigDecimalValue().doubleValue() * this.txtLocalCurExRate.getBigDecimalValue().doubleValue();
                this.txtAmountLocalCur.setText(CreditAssetsReturnInEditUI.doubleToStr(txtac, 2));
                this.txtAmountLocalCur.setValue((Object)new BigDecimal(txtac));
            }
            if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtAccrual.getText() != null && this.txtAccrual.getText().trim().length() != 0) {
                double txtaccr = this.txtAmount.getBigDecimalValue().doubleValue() + this.txtAccrual.getBigDecimalValue().doubleValue();
                this.txtMainRateAggregate.setText(CreditAssetsReturnInEditUI.doubleToStr(txtaccr, 2));
                this.txtMainRateAggregate.setValue((Object)new BigDecimal(txtaccr));
            }
            this.storeFields();
        }
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        if (this.editData.getSourceBillId() != null) {
            FinancingBillInfo info = null;
            try {
                info = CreditAssetsReturnInEditUI.getFinancingBill(this.editData.getSourceBillId());
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (this.editData.getCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString(), (FmRpcCacheInfo)this.rpcCacheInfo);
        }
        this.txtNumber.setEnabled(true);
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue() + 1;
        return days;
    }

    public void createFromEntRepayment_actionPerformed(ActionEvent e) throws Exception {
        this.isCreateFromEntRepayment = true;
        FilterInfo filterInfo = new FilterInfo();
        HashMap<String, FilterInfo> ctx = new HashMap<String, FilterInfo>();
        ctx.put("DefaultQueryFilter", filterInfo);
        this.getBillEdit().createFrom(null, ctx);
    }

    private boolean isBotp() {
        int status;
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        return this.getUIContext().get("BOTPViewStatus") instanceof Integer && (status = ((Integer)this.getUIContext().get("BOTPViewStatus")).intValue()) == 1;
    }

    protected void applyDefaultValue(IObjectValue vo) {
    }

    public static String doubleToStr(double d, int fNumber) {
        if (fNumber < 0) {
            fNumber = 0;
        }
        String pattern = null;
        switch (fNumber) {
            case 0: {
                pattern = "#0";
                break;
            }
            default: {
                pattern = "#0.";
                StringBuffer b = new StringBuffer(pattern);
                for (int i = 0; i < fNumber; ++i) {
                    b.append('#');
                }
                pattern = b.toString();
            }
        }
        DecimalFormat formatter = new DecimalFormat();
        formatter.applyPattern(pattern);
        String value = formatter.format(d);
        return value;
    }

    @Override
    public void actionTDPri_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPri_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = (ArrayList)this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.print("/FM/IBT/CREDITASSETSRETURNIN", (Object)data, (Component)((Object)this));
    }

    private IMetaDataPK getTDQueryName() {
        return new MetaDataPK("com.kingdee.eas.fm.ibt.app.CreditAssetsReturnInQuery");
    }

    @Override
    public void actionTDPriView_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPriView_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = (ArrayList)this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.printPreview("/FM/IBT/CREDITASSETSRETURNIN", (Object)data, (Component)((Object)this));
    }

    @Override
    protected void txtAccrual_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() != 0 && this.txtAccrual.getText() != null && this.txtAccrual.getText().trim().length() != 0) {
            double txtaccr = this.txtAmount.getBigDecimalValue().doubleValue() + this.txtAccrual.getBigDecimalValue().doubleValue();
            this.txtMainRateAggregate.setText(CreditAssetsReturnInEditUI.doubleToStr(txtaccr, 2));
            this.txtMainRateAggregate.setValue((Object)new BigDecimal(txtaccr));
        }
        super.txtAccrual_dataChanged(e);
    }

    public void clearElements() {
        this.txtNumber.setText(null);
        this.txtNumber.setEnabled(true);
        this.txtCreditName.setText(null);
        this.txtAmount.setText(null);
        this.txtAccrual.setText(null);
        this.txtMainRateAggregate.setText(null);
        this.txtAmountLocalCur.setText(null);
        this.txtAverageOutBank.setText(null);
        this.prmtBuyInBank.setValue(null);
        this.txtRemark.setText(null);
    }
}

