/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferInFactory;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferInInfo;
import com.kingdee.eas.fm.ibt.TransferModeEnum;
import com.kingdee.eas.fm.ibt.TransferTypeEnum;
import com.kingdee.eas.fm.ibt.client.AbstractCreditAssetsTransferInEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class CreditAssetsTransferInEditUI
extends AbstractCreditAssetsTransferInEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditAssetsTransferInEditUI.class);
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    private boolean isOnLoadFinished = false;
    private boolean isSubmit = false;
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";
    private final String fileName = "/FM/IBT/CREDITASSETSTRANSFERIN";

    public CreditAssetsTransferInEditUI() throws Exception {
        FinUtils.initCurrencyComboBox((KDComboBox)this.combCurrency);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!BillTypeEnum.Audit.equals((Object)this.editData.getBillType())) {
            this.editData.setBillType(BillTypeEnum.Submit);
        }
        if (TransferModeEnum.Monopoly.equals(this.comboTransferMode.getSelectedItem())) {
            this.editData.setBalance(new BigDecimal(0));
        } else {
            this.editData.setBalance(this.txtAmount.getBigDecimalValue());
        }
        this.isSubmit = true;
        super.actionSubmit_actionPerformed(e);
        this.isSubmit = false;
        this.txtYearRate.setRemoveingZeroInDispaly(false);
    }

    protected IObjectValue createNewData() {
        CreditAssetsTransferInInfo info = new CreditAssetsTransferInInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setBizDate(DateUtil.getDayBegin());
        info.setCurrency(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
        info.setIssueDate(DateUtil.getDayBegin());
        info.setExpiredDate(DateUtil.getDayBegin());
        info.setTransferMode((TransferModeEnum)((Object)this.comboTransferMode.getItemAt(0)));
        info.setTransferType((TransferTypeEnum)((Object)this.comboTransferType.getItemAt(0)));
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        info.setTransferIn(currentCompany);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CreditAssetsTransferInFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        FSClientHelper.checkClearingHouseCompany();
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.getUIContext().get("company") != null) {
            this.CURRENT_COMPANY = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.isOnLoadFinished = true;
        this.initF7Filter();
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.combCurrency.getSelectedItem();
            int p = currencyInfo.getPrecision();
            CreditAssetsTransferInInfo info = (CreditAssetsTransferInInfo)this.getDataObject();
            if (info != null) {
                CurrencyInfo baseCurrency = this.CURRENT_COMPANY.getBaseCurrency();
                if (baseCurrency == null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("baseCurrency.*"));
                    sic.add(new SelectorItemInfo("baseCurrency.id"));
                    sic.add(new SelectorItemInfo("baseCurrency.number"));
                    sic.add(new SelectorItemInfo("baseCurrency.name"));
                    this.CURRENT_COMPANY = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.CURRENT_COMPANY.getId()), sic);
                    baseCurrency = this.CURRENT_COMPANY.getBaseCurrency();
                }
                ExchangeRateInfo exchangeRateInfo = FMHelper.getExRateInfo((CurrencyInfo)currencyInfo, (CurrencyInfo)baseCurrency, (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (Date)info.getBizDate());
                if (currencyInfo != null && baseCurrency != null && !currencyInfo.getId().equals((Object)baseCurrency.getId())) {
                    this.txtLocalCurExRate.setPrecision(exchangeRateInfo.getPrecision());
                    this.txtAmountLocalCur.setPrecision(baseCurrency.getPrecision());
                } else {
                    this.txtLocalCurExRate.setPrecision(2);
                }
            }
            this.txtAmount.setPrecision(p);
            this.txtIntendingAccrual.setPrecision(p);
            this.txtYearRate.setPrecision(4);
        } else {
            this.txtLocalCurExRate.setPrecision(2);
            this.txtAmount.setPrecision(2);
            this.txtIntendingAccrual.setPrecision(2);
            this.txtYearRate.setPrecision(4);
        }
        this.txtAmountLocalCur.setPrecision(2);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLocalCurExRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmountLocalCur);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtIntendingAccrual);
        this.txtAmount.setNegatived(false);
        this.txtLocalCurExRate.setNegatived(false);
        this.txtAmountLocalCur.setNegatived(false);
        this.txtIntendingAccrual.setNegatived(false);
        this.txtYearRate.setNegatived(false);
        this.txtYearRate.setRemoveingZeroInDispaly(false);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmountLocalCur.setHorizontalAlignment(4);
        this.txtIntendingAccrual.setHorizontalAlignment(4);
        this.txtYearRate.setHorizontalAlignment(4);
        this.txtLocalCurExRate.setHorizontalAlignment(4);
        this.prmtTransferOut.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        EntityViewInfo viOut = new EntityViewInfo();
        FilterInfo filterOut = new FilterInfo();
        filterOut.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        viOut.setFilter(filterOut);
        this.prmtTransferOut.setEntityViewInfo(viOut);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        this.prmtTransferInBank.setSelectorCollection(sic);
        this.prmtTransferInBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.CURRENT_COMPANY != null && this.CURRENT_COMPANY.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.CURRENT_COMPANY.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        vi.setFilter(filter);
        this.prmtTransferInBank.setEntityViewInfo(vi);
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtTransferOut, null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void loadFields() {
        FinUtils.noActionOnSetDefault((KDComboBox)this.combCurrency, (Object)this.editData.getCurrency());
        if (this.editData.getCurrency() == this.baseCurrency) {
            this.editData.setLocalCurExRate(new BigDecimal(1));
        }
        if (this.editData.getLocalCurExRate() != null && this.editData.getLocalCurExRate().compareTo(Constants.ZERO) > 0) {
            this.txtLocalCurExRate.setValue((Object)this.editData.getLocalCurExRate());
        }
        if (FinUtils.isBaseCurrency((CurrencyInfo)this.editData.getCurrency(), (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
            this.txtLocalCurExRate.setEditable(false);
        } else {
            this.txtLocalCurExRate.setEditable(true);
        }
        if (this.editData.getCompany() == null) {
            this.editData.setCompany(this.CURRENT_COMPANY);
        }
        super.loadFields();
        this.editData.setBalance(this.txtAmount.getBigDecimalValue());
        this.editData.setInstitution((BankInfo)this.prmtTransferOut.getValue());
        this.editData.setIssueDate((Date)this.pkIssueDate.getValue());
        this.editData.setExpiredDate((Date)this.pkExpiredDate.getValue());
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString(), (FmRpcCacheInfo)this.rpcCacheInfo);
        this.txtAmount.setPrecision(2);
        this.txtIntendingAccrual.setPrecision(2);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtTransferIn);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtTransferOut);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtAssetsName);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkExpiredDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.combCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLocalCurExRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmountLocalCur);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtYearRate);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
    }

    @Override
    protected void combCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        if (this.combCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.combCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtIntendingAccrual.setPrecision(currency.getPrecision());
            CompanyOrgUnitInfo company = this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                CreditAssetsTransferInInfo info = (CreditAssetsTransferInInfo)this.getDataObject();
                if (info != null) {
                    CurrencyInfo baseCurrency = company.getBaseCurrency();
                    if (baseCurrency == null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("baseCurrency.*"));
                        sic.add(new SelectorItemInfo("baseCurrency.id"));
                        sic.add(new SelectorItemInfo("baseCurrency.number"));
                        sic.add(new SelectorItemInfo("baseCurrency.name"));
                        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sic);
                        baseCurrency = company.getBaseCurrency();
                    }
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)company, (CurrencyInfo)currency, (CurrencyInfo)baseCurrency, (Date)info.getBizDate(), null);
                }
            }
            catch (EASBizException e1) {
                FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)this.CURRENT_COMPANY.getBaseCurrency());
                throw e1;
            }
            if (currency.getId().equals((Object)this.baseCurrency.getId())) {
                this.txtLocalCurExRate.setPrecision(2);
            }
            this.txtAmountLocalCur.setValue((Object)this.getLocalAmount());
            if (FinUtils.isBaseCurrency((CurrencyInfo)currency, (CompanyOrgUnitInfo)this.CURRENT_COMPANY)) {
                this.txtLocalCurExRate.setEnabled(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
            }
        }
    }

    private BigDecimal getLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtLocalCurExRate.getBigDecimalValue();
        if (bdAmount != null && bdLocalExRate != null) {
            return bdAmount.multiply(bdLocalExRate);
        }
        return Constants.ZERO;
    }

    @Override
    protected void pkExpiredDate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.pkExpiredDate_dataChanged(e);
        DateUtil dateh = new DateUtil();
        int days = 0;
        Date issueDate = (Date)this.pkIssueDate.getValue();
        Date expiredDate = (Date)this.pkExpiredDate.getValue();
        if (issueDate != null && expiredDate != null) {
            if (issueDate.after(expiredDate)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditEndDateNoBeforeStart"));
                this.pkExpiredDate.setValue((Object)issueDate);
                SysUtil.abort();
            }
            days = DateUtil.getDiffDays((Date)issueDate, (Date)expiredDate) - 1;
            BigDecimal bAmount = this.txtAmount.getBigDecimalValue();
            BigDecimal yearRate = this.txtYearRate.getBigDecimalValue();
            if (bAmount != null && yearRate != null) {
                BigDecimal inteAccrual = bAmount.multiply(yearRate).multiply(new BigDecimal(days));
                inteAccrual = inteAccrual.divide(new BigDecimal(36000), 2);
                this.txtIntendingAccrual.setValue((Object)inteAccrual);
            }
        }
    }

    @Override
    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        if (this.isSubmit) {
            return;
        }
        super.pkIssueDate_dataChanged(e);
        DateUtil dateh = new DateUtil();
        int days = 0;
        Date issueDate = (Date)this.pkIssueDate.getValue();
        Date expiredDate = (Date)this.pkExpiredDate.getValue();
        if (issueDate != null && expiredDate != null) {
            if (issueDate.after(expiredDate)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditStartDateNoAfterEnd"));
                this.pkIssueDate.setValue((Object)expiredDate);
                SysUtil.abort();
            }
            days = DateUtil.getDiffDays((Date)issueDate, (Date)expiredDate) - 1;
            BigDecimal bAmount = this.txtAmount.getBigDecimalValue();
            BigDecimal yearRate = this.txtYearRate.getBigDecimalValue();
            if (bAmount != null && yearRate != null) {
                BigDecimal inteAccrual = bAmount.multiply(yearRate).multiply(new BigDecimal(days));
                inteAccrual = inteAccrual.divide(new BigDecimal(36000), 2);
                this.txtIntendingAccrual.setValue((Object)inteAccrual);
            }
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.txtAmount_dataChanged(e);
        BigDecimal amount = (BigDecimal)e.getNewValue();
        BigDecimal localCurExRate = (BigDecimal)this.txtLocalCurExRate.getValue();
        if (amount != null && localCurExRate != null) {
            this.txtAmountLocalCur.setValue((Object)amount.multiply(localCurExRate));
        }
        Date startDate = (Date)this.pkIssueDate.getValue();
        Date endDate = (Date)this.pkExpiredDate.getValue();
        BigDecimal yearRate = this.txtYearRate.getBigDecimalValue();
        DateUtil dateh = new DateUtil();
        int days = 0;
        if (startDate != null && endDate != null && yearRate != null && amount != null) {
            days = DateUtil.getDiffDays((Date)startDate, (Date)endDate) - 1;
            BigDecimal inteAccrual = amount.multiply(yearRate).multiply(new BigDecimal(days));
            inteAccrual = inteAccrual.divide(new BigDecimal(36000), 2);
            this.txtIntendingAccrual.setValue((Object)inteAccrual);
        }
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLocalCurExRate_dataChanged(e);
        BigDecimal exRate = (BigDecimal)e.getNewValue();
        if (exRate != null && this.txtAmount.getBigDecimalValue() != null) {
            BigDecimal bAmount = this.txtAmount.getBigDecimalValue();
            this.txtAmountLocalCur.setValue((Object)bAmount.multiply(exRate));
        }
    }

    @Override
    protected void txtYearRate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnLoadFinished) {
            return;
        }
        super.txtYearRate_dataChanged(e);
        BigDecimal yearRate = (BigDecimal)e.getNewValue();
        if (yearRate == null) {
            return;
        }
        if (yearRate.compareTo(new BigDecimal(100)) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"YearRateArea"));
            this.txtYearRate.setValue((Object)Constants.ZERO);
            this.txtYearRate.requestFocus();
            SysUtil.abort();
        }
        int days = 0;
        Date startDate = (Date)this.pkIssueDate.getValue();
        Date endDate = (Date)this.pkExpiredDate.getValue();
        BigDecimal bAmount = this.txtAmount.getBigDecimalValue();
        DateUtil dateh = new DateUtil();
        if (startDate != null && endDate != null && !startDate.after(endDate) && bAmount != null) {
            days = DateUtil.getDiffDays((Date)startDate, (Date)endDate) - 1;
            BigDecimal inteAccrual = bAmount.multiply(yearRate).multiply(new BigDecimal(days));
            inteAccrual = inteAccrual.divide(new BigDecimal(36000), 2);
            this.txtIntendingAccrual.setValue((Object)inteAccrual);
        }
    }

    @Override
    public void actionTDPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPreview_actionPerformed(e);
        if (this.editData.getId() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"TDPrintforEdit"));
            SysUtil.abort();
        }
        List idList = this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryName());
        appHlp.printPreview("/FM/IBT/CREDITASSETSTRANSFERIN", (Object)data, (Component)((Object)this));
    }

    private IMetaDataPK getTDQueryName() {
        return new MetaDataPK("com.kingdee.eas.fm.ibt.app.CreditAssetsTransferInTDQuery");
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        if (this.editData.getId() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"TDPrintforEdit"));
            SysUtil.abort();
        }
        List idList = this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryName());
        appHlp.print("/FM/IBT/CREDITASSETSTRANSFERIN", (Object)data, (Component)((Object)this));
    }
}

