/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.ibt.client.AbstractCreditAssetsTransferInFilterUI;
import com.kingdee.eas.fm.ibt.client.CreditAssetsTransferInParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class CreditAssetsTransferInFilterUI
extends AbstractCreditAssetsTransferInFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditAssetsTransferInFilterUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    private boolean isSetParam = false;
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    @Override
    protected void pkExpiredDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkExpiredDate_dataChanged(e);
        if (this.isSetParam) {
            return;
        }
        Date startDate = null;
        Date endDate = null;
        startDate = DateTimeUtils.truncateDate((Date)this.pkIssueDate.getSqlDate());
        endDate = DateTimeUtils.truncateDate((Date)this.pkExpiredDate.getSqlDate());
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerFilterEndDataMustAfterStart"));
            this.pkExpiredDate.setValue((Object)startDate);
            this.pkExpiredDate.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkIssueDate_dataChanged(e);
        if (this.isSetParam) {
            return;
        }
        Date startDate = null;
        Date endDate = null;
        startDate = DateTimeUtils.truncateDate((Date)this.pkIssueDate.getSqlDate());
        endDate = DateTimeUtils.truncateDate((Date)this.pkExpiredDate.getSqlDate());
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerFilterStartDataMustBeforeEnd"));
            this.pkIssueDate.setValue((Object)endDate);
            this.pkIssueDate.requestFocus();
            SysUtil.abort();
        }
    }

    public void clear() {
        super.clear();
        this.pkExpiredDate.setValue((Object)new Date());
        this.pkIssueDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)currency);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void init() throws Exception {
        super.init();
        this.pkExpiredDate.setValue((Object)new Date());
        this.pkIssueDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        FinUtils.initCurrencyComboBox((KDComboBox)this.combCurrency);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)company.getBaseCurrency());
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.pkIssueDate, (String)"NoDate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.pkExpiredDate, (String)"NoDate");
        return super.verify();
    }

    public Object getParam() {
        CreditAssetsTransferInParam para = new CreditAssetsTransferInParam();
        if (this.combCurrency.getSelectedItem() != null) {
            para.setCurrencyId(((CurrencyInfo)this.combCurrency.getSelectedItem()).getId().toString());
        }
        para.setCurrencyName((String)AccessHelper.getCboAttribute((KDComboBox)this.combCurrency, (String)"name"));
        para.setIssueDate(DateTimeUtils.truncateDate((Date)this.pkIssueDate.getSqlDate()));
        para.setExpiredDate(DateTimeUtils.truncateDate((Date)this.pkExpiredDate.getSqlDate()));
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof CreditAssetsTransferInParam)) {
            return;
        }
        this.isSetParam = true;
        CreditAssetsTransferInParam filterParam = (CreditAssetsTransferInParam)param;
        String currencyId = filterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.pkIssueDate.setValue((Object)filterParam.getIssueDate());
        this.pkExpiredDate.setValue((Object)filterParam.getExpiredDate());
        this.isSetParam = false;
    }

    protected Class getParamClass() {
        return CreditAssetsTransferInParam.class;
    }
}

