/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.CreditAssetsReturnInInfo;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferInFactory;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferInInfo;
import com.kingdee.eas.fm.ibt.ICreditAssetsTransferIn;
import com.kingdee.eas.fm.ibt.client.AbstractCreditAssetsTransferInListUI;
import com.kingdee.eas.fm.ibt.client.CreditAssetsTransferInEditUI;
import com.kingdee.eas.fm.ibt.client.CreditAssetsTransferInFilterUI;
import com.kingdee.eas.fm.ibt.client.CreditAssetsTransferInParam;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditAssetsTransferInListUI
extends AbstractCreditAssetsTransferInListUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditAssetsTransferInListUI.class);
    private CreditAssetsTransferInFilterUI filterUI = null;
    public FillListener fillListener = new FillListener();
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";
    private final String fileName = "/FM/IBT/CREDITASSETSTRANSFERIN";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getSelectManager().size() > 0) {
            if (this.getSelectedFieldValues("fiVouchered").get(0).equals("true")) {
                this.actionVoucher.setEnabled(false);
            } else {
                this.actionVoucher.setEnabled(true);
            }
        }
        super.tblMain_tableSelectChanged(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        CreditAssetsTransferInInfo info = CreditAssetsTransferInFactory.getRemoteInstance().getCreditAssetsTransferInInfo((IObjectPK)new ObjectStringPK(id));
        if (info.getBillType() == BillTypeEnum.Audit) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerAuditNoChange"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ICreditAssetsTransferIn CreditAssetsTransfer2 = CreditAssetsTransferInFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CreditAssetsTransferInInfo info = CreditAssetsTransfer2.getCreditAssetsTransferInInfo((IObjectPK)pk);
        if (BillTypeEnum.Audit.equals((Object)info.getBillType())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerAuditNoDel"));
            SysUtil.abort();
        }
        if (CreditAssetsTransfer2.isRelatCreditReturn(id.toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditRelationOtherBill"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        String id;
        if (this.getSelectedIdValues().size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditSameTimeNoReturn"));
            this.abort();
        }
        if ((id = this.getSelectedKeyValue()) != null) {
            CreditAssetsTransferInInfo info = CreditAssetsTransferInFactory.getRemoteInstance().getCreditAssetsTransferInInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getBillType().equals((Object)BillTypeEnum.Submit)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerUnAuditNoOperate"));
                this.abort();
            }
            if (Double.parseDouble(info.getBalance().toString()) <= 0.0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditBalanceIsZeroNoReturn"));
                this.abort();
            } else {
                FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new CreditAssetsTransferInInfo().getBOSType().toString(), (String)new CreditAssetsReturnInInfo().getBOSType().toString(), (String)id);
            }
        }
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanVoucher(0);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ICreditAssetsTransferIn CreditAssetsTransferIn2 = CreditAssetsTransferInFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CreditAssetsTransferInInfo info = CreditAssetsTransferIn2.getCreditAssetsTransferInInfo((IObjectPK)pk);
        if (!BillTypeEnum.Audit.equals((Object)info.getBillType())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"OnlyAuditCantoVoucher"));
            SysUtil.abort();
        }
        super.actionVoucher_actionPerformed(e);
    }

    private void checkCanVoucher(int type) throws Exception {
        this.checkSelected();
        CreditAssetsTransferInInfo CreditInInfo = CreditAssetsTransferInFactory.getRemoteInstance().getCreditAssetsTransferInInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (0 == type ? CreditInInfo.isHistoryBill() : 1 == type && CreditInInfo.isHistoryBill()) {
            throw new LoanException(LoanException.CHLOANISNOTVOUCHER);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CreditAssetsTransferInFilterUI();
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return CreditAssetsTransferInEditUI.class.getName();
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CreditAssetsTransferInParam param = (CreditAssetsTransferInParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyId());
            String[] columns = new String[]{"Amount", "intendingAccrual"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
            FMClientHelper.setNumberFormat((IRow)row, (String)"AmountLocalCur", (String)company.getBaseCurrency().getId().toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CreditAssetsTransferInFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        FSClientHelper.checkClearingHouseCompany();
        this.checkBizUnit();
        this.tblMain.getColumn("LocalCurExRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("yearRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("LocalCurExRate").getStyleAttributes().setNumberFormat("#,###.0000");
        this.tblMain.getColumn("yearRate").getStyleAttributes().setNumberFormat("%r{##0.0000!}f");
        this.btnCreateTo.setVisible(true);
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnVoucher.setVisible(false);
            this.btnDelVoucher.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionAnitAudit_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList voucheredList = this.getSelectedFieldValues("fiVouchered");
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (i = 0; i < selectRows.length; ++i) {
            String id;
            ICell cell = this.tblMain.getRow(selectRows[i]).getCell("fiVouchered");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (cell.getValue() == null || (id = cell.getValue().toString()) == null) continue;
            voucheredList.add(id);
        }
        for (i = 0; i < idList.size(); ++i) {
            String id = idList.get(i).toString();
            ICreditAssetsTransferIn creditAssetsTransferIn = CreditAssetsTransferInFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            CreditAssetsTransferInInfo info = creditAssetsTransferIn.getCreditAssetsTransferInInfo((IObjectPK)pk);
            IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
            if (BillTypeEnum.Audit.equals((Object)info.getBillType())) {
                if (!voucheredList.get(i).equals("true")) {
                    if (!iBTPManager.ifHaveDestBills(id.toString())) {
                        creditAssetsTransferIn.anitAudit((IObjectPK)pk);
                        this.refreshList();
                        continue;
                    }
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CreditRelationReturnIsNoAnitAudit"));
                    SysUtil.abort();
                    continue;
                }
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerToVoucherNoAnitAudit"));
                SysUtil.abort();
                continue;
            }
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"AuditMustBeAnitAudit"));
            SysUtil.abort();
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SuccessAnitAudit"));
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        CreditAssetsTransferInInfo info;
        ObjectUuidPK pk;
        ICreditAssetsTransferIn creditAssetsTransferIn;
        String id;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        for (int i = 0; i < idList.size(); ++i) {
            id = idList.get(i).toString();
            creditAssetsTransferIn = CreditAssetsTransferInFactory.getRemoteInstance();
            info = creditAssetsTransferIn.getCreditAssetsTransferInInfo((IObjectPK)(pk = new ObjectUuidPK(id)));
            if (BillTypeEnum.Audit.equals((Object)info.getBillType())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"ThisIsAudited"));
                SysUtil.abort();
            }
            if (!BillTypeEnum.Submit.equals((Object)info.getBillType())) continue;
            creditAssetsTransferIn.audit((IObjectPK)pk);
            this.refreshList();
        }
        for (int j = 0; j < idList.size(); ++j) {
            id = idList.get(j).toString();
            creditAssetsTransferIn = CreditAssetsTransferInFactory.getRemoteInstance();
            info = creditAssetsTransferIn.getCreditAssetsTransferInInfo((IObjectPK)(pk = new ObjectUuidPK(id)));
            if (BillTypeEnum.Audit.equals((Object)info.getBillType())) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"AuditMustBeSubmit"));
            SysUtil.abort();
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SuccessAudit"));
    }

    @Override
    public void actionTDPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPreview_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.printPreview("/FM/IBT/CREDITASSETSTRANSFERIN", (Object)data, (Component)((Object)this));
    }

    private IMetaDataPK getTDQueryName() {
        return new MetaDataPK("com.kingdee.eas.fm.ibt.app.CreditAssetsTransferInTDQuery");
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.print("/FM/IBT/CREDITASSETSTRANSFERIN", (Object)data, (Component)((Object)this));
    }

    private FilterInfo getBillCanbeReceived() {
        FilterInfo f = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            Map btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            String targetBillType = (String)btpeditparameter.get("TargetBillType");
            f.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
        }
        return f;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("transferIn.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("IssueDate"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        return sic;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("fromRepayment") != null && ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("fromRepayment").toString().equals("fromRepayment")) {
            filter.getFilterItems().add(new FilterItemInfo("transferIn.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null || e.getLastRow() == -1) {
                return;
            }
            CreditAssetsTransferInListUI.this.tblMain.checkParsed();
            IRow row = null;
            String currencyId = null;
            CompanyOrgUnitInfo companyInfo = null;
            try {
                companyInfo = FSHelper.getCHCompanyInfo(null);
            }
            catch (EASBizException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            catch (BOSException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = CreditAssetsTransferInListUI.this.tblMain.getRow(i);
                currencyId = (String)row.getCell("Currency.id").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"Amount", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"Balance", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"intendingAccrual", (String)currencyId);
                }
                if (companyInfo == null || companyInfo.getBaseCurrency() == null) continue;
                String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)"AmountLocalCur", (String)baseCurrency);
            }
        }
    }
}

