/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditUsageFactory;
import com.kingdee.eas.fm.fin.CreditUsageInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.InnerBorrowingReturnInFactory;
import com.kingdee.eas.fm.ibt.InnerBorrowingReturnInInfo;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingInInfo;
import com.kingdee.eas.fm.ibt.client.AbstractInnerBorrowingReturnInEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InnerBorrowingReturnInEditUI
extends AbstractInnerBorrowingReturnInEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerBorrowingReturnInEditUI.class);
    CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private boolean isCreateFromEntInnerBorReturnIn = false;
    private boolean isInitNumber = false;
    private double ccer = 0.0;
    private Date startDate = null;
    private BigDecimal freturnBalance = null;
    private static final String resourcePath1 = "com.kingdee.eas.fm.fs.FSClientResource";
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";
    private FinancingBillInfo finBillInfo;
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    private BigDecimal amount = Constants.ZERO;
    private BigDecimal balance = Constants.ZERO;
    private boolean isCreateFromEntRepayment = false;
    private final String fileName = "/FM/IBT/INNERBORROWINGRETURNIN";

    public InnerBorrowingReturnInEditUI() throws Exception {
        this.initsetPrecision();
    }

    public void initsetPrecision() {
        if (this.prmtCurrency.getValue() != null) {
            CurrencyInfo currInfo = null;
            try {
                currInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(((CurrencyInfo)this.prmtCurrency.getValue()).getId()));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            if (currInfo != null) {
                int p = currInfo.getPrecision();
                this.txtReturnAmount.setPrecision(p);
                this.txtLocalCurExRate.setPrecision(p);
                this.txtAmountLocalCur.setPrecision(p);
                this.txtAccrual.setPrecision(p);
                this.txtMainRateAggregate.setPrecision(p);
                this.txtYearRate.setPrecision(4);
                this.txtCreditCurExRate.setPrecision(p);
                this.txtCreditLocalAmt.setPrecision(p);
                if (this.prmtCurrency.getValue() != null) {
                    CurrencyInfo curInfo = this.company.getBaseCurrency();
                    if (!curInfo.getId().equals((Object)currInfo.getId())) {
                        try {
                            ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.company, (CurrencyInfo)currInfo, (CurrencyInfo)curInfo, (Date)DateUtil.getDayBegin());
                            this.txtLocalCurExRate.setPrecision(exchangeRateInfo.getPrecision());
                            this.txtCreditCurExRate.setPrecision(exchangeRateInfo.getPrecision());
                        }
                        catch (FinBizException e) {
                            this.handleException((Exception)((Object)e));
                        }
                        catch (EASBizException e) {
                            this.handleException((Exception)((Object)e));
                        }
                        catch (BOSException e) {
                            this.handleException((Exception)((Object)e));
                        }
                    } else {
                        this.txtLocalCurExRate.setPrecision(2);
                    }
                }
            }
        }
        if (this.prmtCreditCurrency.getValue() != null) {
            this.txtCreditLocalAmt.setPrecision(((CurrencyInfo)this.prmtCreditCurrency.getValue()).getPrecision());
        }
        if (this.company != null) {
            CurrencyInfo ctl = null;
            try {
                ctl = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId().toString()));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            if (ctl != null) {
                this.txtAmountLocalCur.setPrecision(ctl.getPrecision());
            }
        }
    }

    private static FinancingBillInfo getFinancingBill(String id) throws EASBizException, BOSException {
        SelectorItemCollection selectors = InnerBorrowingReturnInEditUI.getFinBillSelector();
        return (FinancingBillInfo)EJBAccessFactory.createRemoteInstance().getEntityInfo(id, selectors);
    }

    private static SelectorItemCollection getFinBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("Type.id"));
        selector.add(new SelectorItemInfo("Type.number"));
        selector.add(new SelectorItemInfo("Type.name"));
        selector.add(new SelectorItemInfo("Currency.id"));
        selector.add(new SelectorItemInfo("Currency.number"));
        selector.add(new SelectorItemInfo("Currency.name"));
        selector.add(new SelectorItemInfo("CreditCurrency.id"));
        selector.add(new SelectorItemInfo("CreditCurrency.number"));
        selector.add(new SelectorItemInfo("CreditCurrency.name"));
        selector.add(new SelectorItemInfo("GaranteeType.id"));
        selector.add(new SelectorItemInfo("GaranteeType.number"));
        selector.add(new SelectorItemInfo("GaranteeType.name"));
        selector.add(new SelectorItemInfo("CreditLimit.id"));
        selector.add(new SelectorItemInfo("CreditLimit.number"));
        selector.add(new SelectorItemInfo("CreditLimit.name"));
        selector.add(new SelectorItemInfo("Institution.id"));
        selector.add(new SelectorItemInfo("Institution.number"));
        selector.add(new SelectorItemInfo("Institution.name"));
        selector.add(new SelectorItemInfo("Institution.BankAreaType"));
        selector.add(new SelectorItemInfo("CreditLimit.Property"));
        selector.add(new SelectorItemInfo("assureBill.*"));
        selector.add(new SelectorItemInfo("assCurrency.*"));
        selector.add("*");
        return selector;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.oprtState)) {
            this.actionCreateFrom.setEnabled(true);
        } else {
            this.actionCreateFrom.setEnabled(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isRequired()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
    }

    public void onLoad() throws Exception {
        Object iPermission;
        FSClientHelper.checkClearingHouseCompany();
        this.initF7Filter();
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        this.prmtBorrowingInBank.setSelectorCollection(sic);
        this.prmtBorrowingInBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.CURRENT_COMPANY != null && this.CURRENT_COMPANY.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.CURRENT_COMPANY.getId().toString()));
            String i = "0";
            if (this.CURRENT_COMPANY.getAccountBank() != null) {
                i = this.CURRENT_COMPANY.getAccountBank().isIsClosed() ? "0" : "1";
            }
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)i));
        }
        vi.setFilter(filter);
        this.prmtBorrowingInBank.setEntityViewInfo(vi);
        if (this.company != null && "ADDNEW".equals(this.oprtState)) {
            iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), "fin_Repayment_addnew");
        }
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        if (this.getUIContext().get("InitDataObject") != null) {
            iPermission = (InnerBorrowingReturnInInfo)this.getUIContext().get("InitDataObject");
        }
        this.stopElements();
        this.txtLocalCurExRate.setEnabled(false);
        this.txtReturnAmount.setPrecision(2);
        super.onLoad();
        InnerBorrowingReturnInInfo objectValue = new InnerBorrowingReturnInInfo();
        this.prmtCreator.setValue((Object)((UserInfo)SysContext.getSysContext().getCurrentUser()));
        this.initsetPrecision();
        this.txtYearRate.setRemoveingZeroInDispaly(false);
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBorrowingOut, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void stopElements() {
        this.comboBorrowingType.setEnabled(false);
        this.prmtBorrowingIn.setEnabled(false);
        this.prmtBorrowingOut.setEnabled(false);
        this.prmtCurrency.setEnabled(false);
        this.prmtCreditLimit.setEnabled(false);
        this.txtAmountLocalCur.setEnabled(false);
        this.txtMainRateAggregate.setEnabled(false);
        this.prmtCreditCurrency.setEnabled(false);
        this.txtCreditCurExRate.setEnabled(false);
        this.txtCreditLocalAmt.setEnabled(false);
        this.txtBalance.setEnabled(false);
        this.prmtCreator.setEnabled(false);
        this.prmtAuditor.setEnabled(false);
        this.txtYearRate.setEditable(false);
        this.txtLocalCurExRate.setHorizontalAlignment(4);
        InnerBorrowingReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtLocalCurExRate);
        this.txtReturnAmount.setHorizontalAlignment(4);
        InnerBorrowingReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtReturnAmount);
        this.txtAmountLocalCur.setHorizontalAlignment(4);
        InnerBorrowingReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtAmountLocalCur);
        this.txtAccrual.setHorizontalAlignment(4);
        InnerBorrowingReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtAccrual);
        this.txtMainRateAggregate.setHorizontalAlignment(4);
        InnerBorrowingReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtMainRateAggregate);
        this.txtCreditCurExRate.setHorizontalAlignment(4);
        InnerBorrowingReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtCreditCurExRate);
        this.txtCreditLocalAmt.setHorizontalAlignment(4);
        InnerBorrowingReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtCreditLocalAmt);
        this.txtBalance.setHorizontalAlignment(4);
        this.txtBalance.setPrecision(2);
        InnerBorrowingReturnInEditUI.initCurrencyField((BasicFormattedTextField)this.txtBalance);
        this.txtYearRate.setHorizontalAlignment(4);
        this.txtYearRate.setPrecision(4);
        this.btnCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.pkReturnDate.setValue((Object)DateUtil.getDayBegin());
        this.chkIsInCredit.setEnabled(false);
        this.actionCopy.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.btnRemove.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    public boolean checkElements() {
        if (this.pkReturnDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerRetreturnDate"));
            return false;
        }
        if (this.comboBorrowingType.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerBorType"));
            return false;
        }
        if (this.prmtBorrowingIn.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerRetBorrowingIn"));
            return false;
        }
        if (this.prmtBorrowingOut.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerRetBorrowingOut"));
            return false;
        }
        if (this.prmtCurrency.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"Currency"));
            return false;
        }
        if (this.txtReturnAmount.getText() == null || this.txtReturnAmount.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerRetReturnAmount"));
            return false;
        }
        if (this.txtLocalCurExRate.getText() == null || this.txtLocalCurExRate.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"LocalCurExRate"));
            return false;
        }
        if (this.txtAmountLocalCur.getText() == null || this.txtAmountLocalCur.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"AmountLocalCur"));
            return false;
        }
        if (this.txtMainRateAggregate.getText() == null || this.txtMainRateAggregate.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"MainRateAggregate"));
            return false;
        }
        if (this.txtAccrual.getText() == null || this.txtAccrual.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"Accrual"));
            return false;
        }
        if (this.prmtCreator.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"Creator"));
            return false;
        }
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        boolean isIncredit = false;
        String innerPK = null;
        if (this.checkElements()) {
            this.verify(e);
            if (this.chkIsInCredit.isSelected()) {
                this.chkIsInCredit.setSelected(false);
                this.editData.setIsInCredit(false);
                isIncredit = true;
            }
            this.editData.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
            InnerBorrowingReturnInFactory.getRemoteInstance().checkNumberDup(null, (CoreBillBaseInfo)this.editData);
            this.storeFields();
            BigDecimal returnAmountValue = this.txtReturnAmount.getBigDecimalValue();
            String billID = this.editData.getSourceBillId();
            innerPK = this.editData.getId().toString();
            BigDecimal creditAmt = this.editData.getCreditLocalAmt();
            BigDecimal creditBalance = this.editData.getBalance();
            CreditLimitInfo crditLimit = this.editData.getCreditLimit();
            super.actionSubmit_actionPerformed(e);
            BigDecimal balance = this.amount.subtract(returnAmountValue);
            InnerBorrowingReturnInFactory.getRemoteInstance().turnWriteBln(billID, balance);
            if (creditAmt != null && creditBalance != null && crditLimit != null) {
                InnerBorrowingReturnInFactory.getRemoteInstance().returnQuantum(creditAmt, creditBalance, crditLimit.getId().toString(), billID);
            }
            if (isIncredit) {
                InnerBorrowingReturnInFactory.getRemoteInstance().setIsInCredit(innerPK, "1");
            }
            this.clearElements();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.amount = Constants.ZERO;
        this.txtReturnAmount.setValue(null);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.isCreateFromEntInnerBorReturnIn = false;
        IBTPBillEdit billEdit = this.getBillEdit();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TargetBillType", "-");
        map.put("fromRepayment", "fromRepayment");
        billEdit.createFrom(null, map);
        this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        if (this.editData.getCurrency() != null) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            CurrencyInfo curInfo = this.editData.getCurrency();
            if (FinUtils.isBaseCurrency((CurrencyInfo)curInfo, (CompanyOrgUnitInfo)company)) {
                this.txtLocalCurExRate.setEnabled(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
            }
        }
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0 && this.txtLocalCurExRate.getText() != null && this.txtLocalCurExRate.getText().trim().length() != 0) {
            double txtac = this.txtReturnAmount.getBigDecimalValue().doubleValue() * this.txtLocalCurExRate.getBigDecimalValue().doubleValue();
            this.txtAmountLocalCur.setText(InnerBorrowingReturnInEditUI.doubleToStr(txtac, 2));
            this.txtAmountLocalCur.setValue((Object)new BigDecimal(txtac));
        }
        super.txtLocalCurExRate_dataChanged(e);
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionSendingMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendingMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actionViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSignature_actionPerformed(e);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBdgBalance_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return InnerBorrowingReturnInFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        InnerBorrowingReturnInInfo objectValue = new InnerBorrowingReturnInInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        return objectValue;
    }

    @Override
    protected void txtAccrual_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0 && this.txtAccrual.getText() != null && this.txtAccrual.getText().trim().length() != 0) {
            double txtaccr = this.txtReturnAmount.getBigDecimalValue().doubleValue() + this.txtAccrual.getBigDecimalValue().doubleValue();
            this.txtMainRateAggregate.setText(InnerBorrowingReturnInEditUI.doubleToStr(txtaccr, 2));
            this.txtMainRateAggregate.setValue((Object)new BigDecimal(txtaccr));
        }
        super.txtAccrual_dataChanged(e);
    }

    @Override
    protected void txtReturnAmount_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0 && this.amount.compareTo(Constants.ZERO) != 0 && this.txtReturnAmount.getBigDecimalValue().compareTo(this.amount) > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerRettxtReturnAmount"));
            this.txtReturnAmount.setValue((Object)this.amount);
            this.abort();
        }
        this.pkReturnDate_dataChanged(e);
        Date startDate = null;
        try {
            startDate = InnerBorrowingReturnInFactory.getRemoteInstance().getOldBillData(this.editData.getSourceBillId());
        }
        catch (BOSException ex) {
            this.handleException((Exception)((Object)ex));
        }
        if (startDate != null && this.txtYearRate.getBigDecimalValue() != null) {
            int day = InnerBorrowingReturnInEditUI.getDiffDays(startDate, this.pkReturnDate.getSqlDate());
            double accrual = Double.parseDouble(this.txtReturnAmount.getBigDecimalValue().toString()) * this.txtYearRate.getBigDecimalValue().doubleValue() * (double)(day - 1) / 36000.0;
            this.txtAccrual.setText(InnerBorrowingReturnInEditUI.doubleToStr(accrual, 2));
            this.txtAccrual.setValue((Object)new BigDecimal(InnerBorrowingReturnInEditUI.doubleToStr(accrual, 2)));
        }
        if (this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0 && this.txtLocalCurExRate.getText() != null && this.txtLocalCurExRate.getText().trim().length() != 0) {
            double txtac = this.txtReturnAmount.getBigDecimalValue().doubleValue() * this.txtLocalCurExRate.getBigDecimalValue().doubleValue();
            this.txtAmountLocalCur.setText(InnerBorrowingReturnInEditUI.doubleToStr(txtac, 2));
            this.txtAmountLocalCur.setValue((Object)new BigDecimal(txtac));
        }
        if (this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0 && this.txtAccrual.getText() != null && this.txtAccrual.getText().trim().length() != 0) {
            double txtaccr = this.txtReturnAmount.getBigDecimalValue().doubleValue() + this.txtAccrual.getBigDecimalValue().doubleValue();
            this.txtMainRateAggregate.setText(InnerBorrowingReturnInEditUI.doubleToStr(txtaccr, 2));
            this.txtMainRateAggregate.setValue((Object)new BigDecimal(txtaccr));
        }
        this.accountCrdLimAmt();
        this.editData.setAmount(this.txtReturnAmount.getBigDecimalValue());
        super.txtReturnAmount_dataChanged(e);
    }

    public static String doubleToStr(double d, int fNumber) {
        if (fNumber < 0) {
            fNumber = 0;
        }
        String pattern = null;
        switch (fNumber) {
            case 0: {
                pattern = "#0";
                break;
            }
            default: {
                pattern = "#0.";
                StringBuffer b = new StringBuffer(pattern);
                for (int i = 0; i < fNumber; ++i) {
                    b.append('#');
                }
                pattern = b.toString();
            }
        }
        DecimalFormat formatter = new DecimalFormat();
        formatter.applyPattern(pattern);
        String value = formatter.format(d);
        return value;
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    public void loadFields() {
        if (this.isBotp() && !this.isCreateFromEntRepayment) {
            this.comboBorrowingType.setSelectedItem((Object)this.editData.getBorrowingType());
            this.prmtBorrowingIn.setValue((Object)this.editData.getBorrowingIn());
            this.prmtBorrowingOut.setValue((Object)this.editData.getBorrowingOut());
            this.pkReturnDate.setValue((Object)DateUtil.getDayBegin());
            this.kdDateStart.setValue((Object)this.editData.getStartDate());
            this.prmtCurrency.setValue((Object)this.editData.getCurrency());
            this.txtLocalCurExRate.setValue((Object)this.editData.getLocalCurExRate());
            this.editData.setAmount(new BigDecimal(0));
            this.initsetPrecision();
            CreditLimitInfo clInfo = null;
            if (this.editData.getCreditLimit() != null) {
                String pk = this.editData.getCreditLimit().getId().toString();
                ObjectStringPK ibpk = new ObjectStringPK(pk);
                try {
                    clInfo = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo((IObjectPK)ibpk, this.getSelectors());
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
            this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            try {
                this.startDate = InnerBorrowingReturnInFactory.getRemoteInstance().getOldBillData(this.editData.getSourceBillId());
            }
            catch (Exception e) {
                this.handleException(e);
            }
            Map map = null;
            try {
                map = InnerBorrowingReturnInFactory.getRemoteInstance().getOldCridit(this.editData.getSourceBillId());
            }
            catch (Exception e) {
                this.handleException(e);
            }
            if (map.size() != 0) {
                if (map.get("balance") != null) {
                    this.amount = new BigDecimal(map.get("balance").toString());
                }
                if ("1".equals(map.get("isInCredit"))) {
                    this.chkIsInCredit.setSelected(true);
                }
                if (map.get("creditUsage") != null) {
                    try {
                        CreditUsageInfo cui = CreditUsageFactory.getRemoteInstance().getCreditUsageInfo((IObjectPK)new ObjectStringPK(map.get("creditUsage").toString()));
                        clInfo.setCreditUsage(cui);
                    }
                    catch (EASBizException e) {
                        this.handleException((Exception)((Object)e));
                    }
                    catch (BOSException e) {
                        this.handleException((Exception)((Object)e));
                    }
                }
                if (map.get("shareType") != null) {
                    ShareTypeEnum st = null;
                    if (map.get("shareType").equals("1")) {
                        st = ShareTypeEnum.SHARE;
                    }
                    if (map.get("shareType").equals("2")) {
                        st = ShareTypeEnum.ASSIGN;
                    }
                    if (map.get("shareType").equals("3")) {
                        st = ShareTypeEnum.PRIVATE;
                    }
                    clInfo.setShareType(st);
                }
                this.txtReturnAmount.setValue((Object)this.amount);
                double yearRate = Double.parseDouble(map.get("yearRate").toString());
                this.txtYearRate.setValue(map.get("yearRate"));
                this.txtYearRate.setPrecision(4);
                int day = InnerBorrowingReturnInEditUI.getDiffDays(this.startDate, this.pkReturnDate.getSqlDate());
                double accrual = this.amount.doubleValue() * yearRate * (double)(day - 1) / 36000.0;
                this.txtAccrual.setText(InnerBorrowingReturnInEditUI.doubleToStr(accrual, 2));
                this.txtAccrual.setValue((Object)new BigDecimal(InnerBorrowingReturnInEditUI.doubleToStr(accrual, 2)));
            }
            if (clInfo != null && clInfo.getId() != null) {
                try {
                    if (this.editData.getSourceBillId() != null) {
                        this.freturnBalance = InnerBorrowingReturnInFactory.getRemoteInstance().optionLimitAmt(clInfo.getId().toString(), this.editData.getSourceBillId());
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            if (clInfo != null) {
                this.prmtCreditLimit.setData((Object)clInfo);
                this.prmtCreditCurrency.setData((Object)clInfo.getCurrency());
                this.txtCreditCurExRate.setValue((Object)this.editData.getCreditCurExRate());
                this.txtBalance.setValue((Object)clInfo.getBalance());
            } else {
                this.prmtCreditLimit.setValue(null);
                this.prmtCreditCurrency.setValue(null);
                this.txtCreditCurExRate.setText(null);
                this.txtCreditCurExRate.setValue(null);
                this.txtCreditLocalAmt.setText(null);
                this.txtCreditLocalAmt.setValue(null);
                this.chkIsInCredit.setSelected(false);
            }
            this.accountCrdLimAmt();
            if (this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0 && this.txtLocalCurExRate.getText() != null && this.txtLocalCurExRate.getText().trim().length() != 0) {
                double txtac = this.txtReturnAmount.getBigDecimalValue().doubleValue() * this.txtLocalCurExRate.getBigDecimalValue().doubleValue();
                this.txtAmountLocalCur.setText(InnerBorrowingReturnInEditUI.doubleToStr(txtac, 2));
                this.txtAmountLocalCur.setValue((Object)new BigDecimal(txtac));
            }
            this.editData.setAmount(this.txtReturnAmount.getBigDecimalValue());
            if (this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0 && this.txtAccrual.getText() != null && this.txtAccrual.getText().trim().length() != 0) {
                double txtaccr = this.txtReturnAmount.getBigDecimalValue().doubleValue() + this.txtAccrual.getBigDecimalValue().doubleValue();
                this.txtMainRateAggregate.setText(InnerBorrowingReturnInEditUI.doubleToStr(txtaccr, 2));
                this.txtMainRateAggregate.setValue((Object)new BigDecimal(txtaccr));
            }
            if (this.prmtCreditLimit.getData() != null) {
                boolean isSamaCur = false;
                CurrencyInfo bCur = (CurrencyInfo)this.prmtCurrency.getData();
                CurrencyInfo cCur = this.editData.getCreditCurrency();
                if (bCur != null && cCur != null) {
                    isSamaCur = bCur.getId().equals((Object)cCur.getId());
                    this.txtCreditCurExRate.setEnabled(!isSamaCur);
                    this.txtBalance.setEnabled(!isSamaCur);
                }
            }
            this.storeFields();
        }
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        if (this.editData.getSourceBillId() != null) {
            FinancingBillInfo info = null;
            try {
                info = InnerBorrowingReturnInEditUI.getFinancingBill(this.editData.getSourceBillId());
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        if (this.finBillInfo == null || !(this.finBillInfo instanceof InnerFinancingBorrowingInInfo)) {
            // empty if block
        }
        if (this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0) {
            this.storeFields();
        }
        this.initOldData((IObjectValue)this.editData);
        if (this.editData.getCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString(), (FmRpcCacheInfo)this.rpcCacheInfo);
        }
        this.txtNumber.setEnabled(true);
        if (this.editData.getCurrency() != null) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            CurrencyInfo curInfo = this.editData.getCurrency();
            if (FinUtils.isBaseCurrency((CurrencyInfo)curInfo, (CompanyOrgUnitInfo)company)) {
                this.txtLocalCurExRate.setEnabled(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
            }
        }
        if (this.prmtCreditLimit.getData() != null) {
            this.chkIsInCredit.setSelected(true);
        }
    }

    public void createFromEntRepayment_actionPerformed(ActionEvent e) throws Exception {
        this.isCreateFromEntRepayment = true;
        FilterInfo filterInfo = new FilterInfo();
        HashMap<String, FilterInfo> ctx = new HashMap<String, FilterInfo>();
        ctx.put("DefaultQueryFilter", filterInfo);
        this.getBillEdit().createFrom(null, ctx);
    }

    private boolean isBotp() {
        int status;
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        return this.getUIContext().get("BOTPViewStatus") instanceof Integer && (status = ((Integer)this.getUIContext().get("BOTPViewStatus")).intValue()) == 1;
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue() + 1;
        return days;
    }

    protected void initOldData(IObjectValue dataObject) {
        InnerBorrowingReturnInInfo info = (InnerBorrowingReturnInInfo)dataObject;
        if (info.getSourceBillId() != null && !"".equals(info.getSourceBillId())) {
            try {
                FinancingBillInfo finBillInfo = InnerBorrowingReturnInEditUI.getFinancingBill(info.getSourceBillId());
                info.setNumber(finBillInfo.getNumber());
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        super.initOldData(dataObject);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    @Override
    protected void pkReturnDate_dataChanged(DataChangeEvent e) throws Exception {
        Date startDate = null;
        try {
            startDate = InnerBorrowingReturnInFactory.getRemoteInstance().getOldBillData(this.editData.getSourceBillId());
        }
        catch (BOSException ex) {
            this.handleException((Exception)((Object)ex));
        }
        if (startDate != null && this.pkReturnDate.getSqlDate().before(startDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"ReturnDateAfterbizDate"));
            this.pkReturnDate.setValue((Object)DateUtil.getDayBegin());
            this.abort();
        }
        Map map = null;
        try {
            map = InnerBorrowingReturnInFactory.getRemoteInstance().getOldCridit(this.editData.getSourceBillId());
        }
        catch (BOSException ex) {
            this.handleException((Exception)((Object)ex));
        }
        if (map.size() != 0) {
            if (map.get("balance") != null) {
                this.amount = new BigDecimal(map.get("balance").toString());
            }
            double yearRate = Double.parseDouble(map.get("yearRate").toString());
            this.txtYearRate.setValue(map.get("yearRate"));
            this.txtYearRate.setPrecision(4);
            int day = InnerBorrowingReturnInEditUI.getDiffDays(startDate, this.pkReturnDate.getSqlDate());
            if (this.txtReturnAmount.getBigDecimalValue() != null) {
                double accrual = Double.parseDouble(this.txtReturnAmount.getBigDecimalValue().toString()) * yearRate * (double)(day - 1) / 36000.0;
                this.txtAccrual.setText(InnerBorrowingReturnInEditUI.doubleToStr(accrual, 2));
                this.txtAccrual.setValue((Object)new BigDecimal(InnerBorrowingReturnInEditUI.doubleToStr(accrual, 2)));
            }
        }
        if (this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0 && this.txtAccrual.getText() != null && this.txtAccrual.getText().trim().length() != 0) {
            double txtaccr = this.txtReturnAmount.getBigDecimalValue().doubleValue() + this.txtAccrual.getBigDecimalValue().doubleValue();
            this.txtMainRateAggregate.setValue((Object)new BigDecimal(txtaccr));
        }
    }

    @Override
    protected void prmtCreditLimit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCreditLimit.getData() != null) {
            boolean isSamaCur = false;
            CurrencyInfo bCur = (CurrencyInfo)this.prmtCurrency.getData();
            CurrencyInfo cCur = this.editData.getCreditCurrency();
            if (bCur != null && cCur != null) {
                isSamaCur = bCur.getId().equals((Object)cCur.getId());
                this.txtCreditCurExRate.setEnabled(!isSamaCur);
                this.txtBalance.setEnabled(!isSamaCur);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Creditlimit.number"));
        sic.add(new SelectorItemInfo("Creditlimit.balance"));
        return sic;
    }

    public static void initCurrencyField(BasicFormattedTextField txt) {
        txt.setHorizontalAlignment(4);
        if (txt instanceof KDFormattedTextField) {
            KDFormattedTextField ftTxt = (KDFormattedTextField)txt;
            ftTxt.setDataType(BigDecimal.class);
            ftTxt.setRemoveingZeroInDispaly(false);
            ftTxt.setRemoveingZeroInEdit(true);
        } else if (txt instanceof KDNumberTextField) {
            KDNumberTextField numText = (KDNumberTextField)txt;
            numText.setDataType(BigDecimal.class);
            numText.setRemoveingZeroInDispaly(false);
            numText.setRemoveingZeroInEdit(true);
        }
    }

    public void clearElements() {
        this.txtRemark.setText(null);
        this.txtNumber.setText(null);
        this.prmtBorrowingInBank.setText(null);
        this.txtBorrowingOutBank.setText(null);
        this.txtYearRate.setText(null);
        this.txtReturnAmount.setText(null);
        this.txtAccrual.setText(null);
        this.txtAmountLocalCur.setText(null);
        this.txtMainRateAggregate.setText(null);
        this.prmtCreditLimit.setValue(null);
        this.prmtCreditCurrency.setValue(null);
        this.txtCreditCurExRate.setValue(null);
        this.txtCreditLocalAmt.setValue(null);
        this.txtBalance.setValue(null);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void actionTDPri_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPri_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = (ArrayList)this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.print("/FM/IBT/INNERBORROWINGRETURNIN", (Object)data, (Component)((Object)this));
    }

    private IMetaDataPK getTDQueryName() {
        return new MetaDataPK("com.kingdee.eas.fm.ibt.app.InnerBorrowingReturnInQuery");
    }

    @Override
    public void actionTDPriView_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPriView_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = (ArrayList)this.getSelectedIdForPrint();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.printPreview("/FM/IBT/INNERBORROWINGRETURNIN", (Object)data, (Component)((Object)this));
    }

    @Override
    protected void txtCreditCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtCreditCurExRate_dataChanged(e);
        this.accountCrdLimAmt();
    }

    public void accountCrdLimAmt() {
        double creAmt = 0.0;
        if (this.txtCreditCurExRate.getText() != null && this.txtCreditCurExRate.getBigDecimalValue() != null && this.txtReturnAmount.getText() != null && this.txtReturnAmount.getText().trim().length() != 0) {
            if (this.freturnBalance != null && this.amount.compareTo(this.txtReturnAmount.getBigDecimalValue()) == 0) {
                creAmt = this.txtCreditCurExRate.getBigDecimalValue().doubleValue() * this.amount.doubleValue();
                if (creAmt - this.freturnBalance.doubleValue() > 0.0) {
                    creAmt = this.freturnBalance.doubleValue();
                }
                if (this.amount.compareTo(this.txtReturnAmount.getBigDecimalValue()) == 0) {
                    creAmt = this.freturnBalance.doubleValue();
                }
            } else {
                creAmt = this.txtCreditCurExRate.getBigDecimalValue().doubleValue() * this.txtReturnAmount.getBigDecimalValue().doubleValue();
                if (this.freturnBalance != null && creAmt - this.freturnBalance.doubleValue() > 0.0) {
                    creAmt = this.freturnBalance.doubleValue();
                }
            }
            this.txtCreditLocalAmt.setText(InnerBorrowingReturnInEditUI.doubleToStr(creAmt, 2));
            this.txtCreditLocalAmt.setValue((Object)new BigDecimal(creAmt));
        }
    }
}

